' Summary: blobs.bas
' The BLOBS window manager
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

' Todo: documentation
'

' IPC calls
'$include once: 'mos.bi'
' Mutex
'$include once: 'x86.bi'
' Graphics interfaces
'$include once: 'mos/gfx.bi'
' Blobs interface
'$include once: 'mos/blobs.bi'

Type ViewportType
    x1 As Long
    x2 As Long
    y1 As Long
    y2 As Long
    cx As Long
    cy As Long
    Title As String

End Type

Dim Shared Viewports() As ViewportType
Dim Shared ViewportCount As Long

Dim Shared GateDemangle() As Long
Dim Shared maxgate As Long

Dim Shared gfxhandler As Sub()
Dim Shared gate As Long

Declare Sub handlerstub()
Declare Sub handler CDecl(ByVal f as Long, ByVal x As Long, ByVal y As Long, ByVal z As Long)
Declare Sub subhandlerstub()
Declare Sub subhandler (ByVal f As Long, ByVal x As Long, ByVal y As Long, ByVal z As Long)
Declare Sub ModMain CDecl Alias "main"()


Sub ModMain CDecl Alias "main" ()

    Dim aspace As Long

    Dim stub As Sub()
    Dim index As Long
    Dim result As Long

    ' initialize internals
    Redim Viewports(0)
    ViewportCount = 0

    ' acquire graphics driver
    gate = 0
    While gate = 0
        gate = RouteFind(PORTNAME("GFX0"))
    Wend
    aspace = gatelookup(gate, @gfxhandler)



    ' clear screen
    Dim x as long, y as long, xcopy as Long, ycopy as Long
    For x = 0 to 79
    For y = 0 to 24
        xcopy = x
        ycopy = y
        Call Localipccall (gfxhandler, MANGLE(GFX_SETCHAR, gate), xcopy, ycopy, Asc("."))
    Next y
    Next x

    ' create interface
    stub = @handlerstub
    gate = gatealloc(stub)
    index = 0
    result = 1
    while result <> 0
        result = routealloc(gate, PORTNAME("UIS" + Str(index)))
        index = index + 1
    Wend

    Call Localipccall (gfxhandler, MANGLE(GFX_SETCHAR, gate), 1, 1, result + asc("0"))

    ' loop forever
    While 1=1
    Wend

End Sub

Sub handler CDecl (ByVal f As Long, ByVal x As Long, ByVal y As Long, ByVal z As Long)
    Static Entrylock = 0

    While TaS(Entrylock) <> 0

    Wend

    Select Case (f \ 65536)
        Case BLOBS_CREATEWINDOW
            f = -1
            Dim Scanline As Long
            Dim lspace As Long
            Dim rspace As Long
            Dim objcheck As Long

            Dim lx1 As Long
            Dim lx2 As Long
            Dim ly1 As Long
            Dim ly2 As Long

            Dim gate As Long
            Dim stub As Sub()

            lspace = 0
            rspace = 0
            For Scanline = -1 to 26
                lspace = lspace + 1
                rspace = rspace + 1
                For objcheck = 0 to ViewportCount - 1
                    if Scanline >= Viewports(objcheck).y1 and Scanline <= Viewports(objcheck).y2 then
                        if x + 2 > Viewports(objcheck).x1 then lspace = 0
                        if 80-x < Viewports(objcheck).x2 then rspace = 0
                    end if
                Next objcheck
                if lspace = y + 2 then
                    stub = @subhandlerstub
                    f = gatealloc(stub)
                    if f > maxgate then
                        maxgate = f
                        redim preserve GateDemangle( maxgate \ 4 )
                    end if

                    GateDemangle(f \ 4) = ViewportCount

                    Viewports(Viewportcount).y1 = Scanline - y - 1
                    Viewports(Viewportcount).y2 = Scanline
                    Viewports(Viewportcount).x1 = -1
                    Viewports(Viewportcount).x2 = x

                    Viewports(Viewportcount).cx = Viewports(Viewportcount).x1 + 1
                    Viewports(Viewportcount).cy = Viewports(Viewportcount).y1 + 1

                    For lx1 = Viewports(Viewportcount).x1 + 1 To Viewports(Viewportcount).x2 - 1
                    For ly1 = Viewports(Viewportcount).y1 + 1 To Viewports(Viewportcount).y2 - 1
                        lx2 = lx1
                        ly2 = ly1
                        Call Localipccall (gfxhandler, MANGLE(GFX_SETCHAR, gate), lx2, ly2, asc(" "))
                    Next ly1
                    Next lx1

                    ViewportCount = ViewportCount + 1
                    Redim Preserve Viewports(ViewportCount)

                    Exit For
                ElseIf rspace = y + 2 then
                    stub = @subhandlerstub
                    f = gatealloc(stub)
                    if f > maxgate then
                        maxgate = f
                        redim preserve GateDemangle( maxgate / 4 )
                    end if

                    GateDemangle(f \ 4) = ViewportCount

                    Viewports(Viewportcount).y1 = Scanline - y - 1
                    Viewports(Viewportcount).y2 = Scanline
                    Viewports(Viewportcount).x1 = 79 - x
                    Viewports(Viewportcount).x2 = 81

                    Viewports(Viewportcount).cx = Viewports(viewportcount).x1 + 1
                    Viewports(Viewportcount).cy = Viewports(viewportcount).y1 + 1

                    For lx1 = Viewports(Viewportcount).x1 + 1 To Viewports(Viewportcount).x2 - 1
                    For ly1 = Viewports(Viewportcount).y1 + 1 To Viewports(Viewportcount).y2 - 1
                        lx2 = lx1
                        ly2 = ly1
                        Call Localipccall (gfxhandler, MANGLE(GFX_SETCHAR, gate), lx2, ly2, asc(" "))
                    Next ly1
                    Next lx1

                    ViewportCount = ViewportCount + 1
                    Redim Preserve Viewports(ViewportCount)

                    Exit For
                End if
            Next Scanline
            if f = 0 Then f = -1

        Case BLOBS_WINDOWDIMENSIONS
                    'Call Localipccall (gfxhandler, MANGLE(GFX_PRINTCHAR, gate), 1, 1, asc("0") + Viewports(x).cy)

        Case Else
            f = -1


            ' fill me in
    End Select

    TaC(Entrylock)
End Sub

Sub handlerstub()
    Call ipccdeclconv(@handler)
End Sub

Sub subhandler (ByVal f As Long, ByVal x As Long, ByVal y As Long, ByVal z As Long)
    Dim viewporttarget as long

    viewporttarget = GateDemangle((f and &HFFFF) \ 4)

    Select Case (f \ 65536)
        Case BLOBS_SETPIXEL
            Call Localipccall (gfxhandler, MANGLE(GFX_SETPIXEL, gate), Viewports(viewporttarget).x1 + 1 + x, Viewports(viewporttarget).y1 + 1 + y, z)

        Case BLOBS_PRINTCHAR
            If x = 13 Then
                Viewports(viewporttarget).cx = Viewports(viewporttarget).x1 + 1
            ElseIf x = 10 Then
                Viewports(viewporttarget).cy = Viewports(viewporttarget).cy + 1
            Else
                lx1 = Viewports(viewporttarget).cx
                ly1 = Viewports(viewporttarget).cy
                Call Localipccall (gfxhandler, MANGLE(GFX_SETCHAR, gate), lx1, ly1, x)
                Viewports(viewporttarget).cx = Viewports(viewporttarget).cx + 1
            End If

            If Viewports(viewporttarget).cx = Viewports(viewporttarget).x2 Then
                Viewports(viewporttarget).cx = Viewports(viewporttarget).x1 + 1
                Viewports(viewporttarget).cy = Viewports(viewporttarget).cy + 1
            End if
            If Viewports(viewporttarget).cy = Viewports(viewporttarget).y2 Then
                Viewports(viewporttarget).cy = Viewports(viewporttarget).y1 + 1
            End If

        Case BLOBS_SETCHAR
            Call Localipccall (gfxhandler, MANGLE(GFX_SETCHAR, gate), Viewports(viewporttarget).x1 + 1 + x, Viewports(viewporttarget).y1 + 1 + y, z)

        Case Else
            f = -1
    End Select
End Sub

Sub subhandlerstub()
    Call ipccdeclconv(@subhandler)
End Sub