' Summary: isapnp.bas
' Controls Plug-and-play ISA devices
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "x86.bi"
#include "mos.bi"
#include "mos/isapnp.bi"

Dim Shared isapnp_current_read_port As Integer

Dim Shared IsaPnpMagic(0 to 33) As Unsigned Byte = _
      { 0, 0,                     _
        &H6A,&HB5,&HDA,&HED,&HF6,&HFB,&H7D,&HBE,  _
        &HDF,&H6F,&H37,&H1B,&H0D,&H86,&HC3,&H61,  _
        &HB0,&H58,&H2C,&H16,&H8B,&H45,&HA2,&HD1,  _
        &HE8,&H74,&H3A,&H9D,&HCE,&HE7,&H73,&H39 }



' Function: ISAPNP_WriteMagic
' Write the initiation key to the ISA device
'
' in:
'     none
'
' out:
'     none
'
Sub ISAPNP_WriteMagic()
    Dim i as long
    For i = 0 to 33
        outportb(ISAPNP_ADDRESS_PORT, IsaPnpMagic(i))
    Next i
End Sub



Function ISAPNP_OpenDefaultPorts() As Integer
    PortAlloc ISAPNP_ADDRESS_PORT, 1
    PortAlloc ISAPNP_WRITE_PORT, 1

    Function = -1
End Function



Sub ISAPNP_WriteReadAddress(address As Integer)
    outportb ISAPNP_ADDRESS_PORT, &H00
    outportb ISAPNP_WRITE_PORT, Cubyte(address \ 4)
    isapnp_current_read_port = address Or 3
End Sub



Sub ISAPNP_SerialIsolation(info() As Byte)
    outportb ISAPNP_ADDRESS_PORT, &H01

    Dim i1 as integer, i2 as integer, d as integer, success as integer, delay as integer
    Dim rb as unsigned byte, pair as integer
    for i1 = 1 to 9
        d = 0
        for i2 = 0 to 7
            for delay = 0 to 10000
            next delay
            rb = inportb(isapnp_current_read_port)
            pair = Cint(rb) and &HFF
            for delay = 0 to 10000
            next delay
            rb = inportb(isapnp_current_read_port)
            pair = pair * 256 + (Cint(rb) and &HFF)
            for delay = 0 to 10000
            next delay

            d = d \ 2
            if pair = &H55AA then d = d + &H80
        next i2
        info(i1) = d and &HFF
    next i1

End Sub

Sub ISAPNP_WriteControl(cb As Byte)
    outportb ISAPNP_ADDRESS_PORT, &H02
    outportb ISAPNP_WRITE_PORT, cb
End Sub

Sub ISAPNP_ResetDevices()
    outportb ISAPNP_ADDRESS_PORT, &H03
    outportb ISAPNP_WRITE_PORT, &H05

    Dim lp as long
    for lp = 0 to 1000000
    next lp
End Sub

Sub ISAPNP_Wake(csn As Byte)
    outportb ISAPNP_ADDRESS_PORT, &H03
    outportb ISAPNP_WRITE_PORT, csn
End Sub

Sub ISAPNP_WriteCSN(csn As Byte)
    outportb ISAPNP_ADDRESS_PORT, &H06
    outportb ISAPNP_WRITE_PORT, csn
End Sub

Function ISAPNP_Checksum(info() as byte) As Integer

End Function
