' Summary: pci_type1.bas
' PCI Configuration Method 1 functions
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "x86.bi"

' interface.
' About the PCI configuration 1
' poke the address to &HCF8, then read or write data from &HCFC
'
' glitches.
' QEMU allows odd addresses and odd reads, VirtualPC aligns to dword reads. Hence there is
' no such thing as a "standard" for partial reads and some paranoid shifting logic is needed :(
'


' Function: PCI_type1_readbyte
' Grabs a byte from PCI configuration space using configuration method 1
'
' In:
'     Bus - The PCI Bus index
'     Device - The Device index of the bus
'     Func - The subfunction of the device
'     Offset - The base address to read from
'
' Out:
'     Return - The byte read from PCI
'
Function PCI_type1_readbyte(ByVal Bus As Unsigned Integer, ByVal Device As Unsigned Integer, ByVal Func As Unsigned Integer, ByVal Offset As Unsigned Integer) As Unsigned Byte
    Dim addr As Unsigned Integer
    Dim info As Unsigned Integer
    addr = ((Offset And &HFC&)) Or _
           ((Func And &H7&) * 256&) Or _
           ((Device And &H1F&) * 2048&) Or _
           ((Bus And &HFF&) * 65536&) Or _
           &H80000000
    outportd(&HCF8, addr)
    info = inportd(&HCFC)
    Select case (Offset And &H3)
        Case 0
            Function = CByte(info And &H000000FF&)
        Case 1
            Function = CByte((info And &H0000FF00&) \ 256&)
        Case 2
            Function = CByte((info And &H00FF0000&) \ 65536&)
        Case 3
            Function = CByte((info And &HFF000000&) \ (256&*65536&))
    End Select
End Function

' Function: PCI_type1_readword
' Grabs a 2-byte word from PCI configuration space using configuration method 1
'
' In:
'     Bus - The PCI Bus index
'     Device - The Device index of the bus
'     Func - The subfunction of the device
'     Offset - The base address to read from
'
' Out:
'     Return - The word read from PCI
'
Function PCI_type1_readword(ByVal Bus As Unsigned Integer, ByVal Device As Unsigned Integer, ByVal Func As Unsigned Integer, ByVal Offset As Unsigned Integer) As Unsigned Short
    Dim addr As Unsigned Integer
    Dim info As Unsigned Integer
    addr = ((Offset And &HFC&)) Or _
           ((Func And &H7&) * 256&) Or _
           ((Device And &H1F&) * 2048&) Or _
           ((Bus And &HFF&) * 65536&) Or _
           &H80000000
    outportd(&HCF8, addr)
    info = inportd(&HCFC)
    If (Offset and &H2) = &H2 Then
        Function = info \ 65536&
    Else
        Function = info And &H0000FFFF&
    End If
End Function


' Function: PCI_type1_readdword
' Grabs a 4-byte doubleword from PCI configuration space using configuration method 1
'
' In:
'     Bus - The PCI Bus index
'     Device - The Device index of the bus
'     Func - The subfunction of the device
'     Offset - The base address to read from
'
' Out:
'     Return - The doubleword read from PCI
'
Function PCI_type1_readdword(ByVal Bus As Unsigned Integer, ByVal Device As Unsigned Integer, ByVal Func As Unsigned Integer, ByVal Offset As Unsigned Integer) As Unsigned Integer
    Dim addr As Unsigned Integer
    addr = ((Offset And &HFC&)) Or _
           ((Func And &H7&) * 256&) Or _
           ((Device And &H1F&) * 2048&) Or _
           ((Bus And &HFF&) * 65536&) Or _
           &H80000000
    outportd(&HCF8, addr)
    Function = inportd(&HCFC)
End Function



' Function: PCI_type1_writedword
' Grabs a 4-byte doubleword from PCI configuration space using configuration method 1
'
' In:
'     Bus - The PCI Bus index
'     Device - The Device index of the bus
'     Func - The subfunction of the device
'     Offset - The base address to read from
'     Value - The value to write
'
' Out:
'     None
'
Sub PCI_type1_writedword(ByVal Bus As Unsigned Integer, ByVal Device As Unsigned Integer, ByVal Func As Unsigned Integer, ByVal Offset As Unsigned Integer, Value As Unsigned Integer)
    Dim addr As Unsigned Integer
    addr = ((Offset And &HFC&)) Or _
           ((Func And &H7&) * 256&) Or _
           ((Device And &H1F&) * 2048&) Or _
           ((Bus And &HFF&) * 65536&) Or _
           &H80000000
    outportd(&HCF8, addr)
    outportd(&HCFC, Value)
End Sub
