' Summary: pci_util.bas
' PCI Utility Functions
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "x86.bi"
#include "mos/pci.bi"

' Function: PCI_bar_readaddress
' Returns the address contained in a specific Base Address Register
'
' In:
'     Bus - The PCI Bus index
'     Device - The Device index of the bus
'     Func - The subfunction of the device
'     Bar - The base address register to read
'
' Out:
'     Return - The offset for the current BAR
'
Function PCI_bar_readaddress(ByVal Bus As Unsigned Integer, ByVal Device As Unsigned Integer, ByVal Func As Unsigned Integer, ByVal Bar As Unsigned Integer) As Unsigned Integer
    If Bar > 5 Then
        Function = 0
        Exit Function
    End If

    Function = PCI_type1_readdword(Bus, Device, Func, &H10 + 4 * Bar) And &HFFFFFFF0
End Function

' Function: PCI_bar_readmask
' Returns the size mask for the selected Base Address Register
'
' In:
'     Bus - The PCI Bus index
'     Device - The Device index of the bus
'     Func - The subfunction of the device
'     Bar - The base address register to read
'
' Out:
'     Return - The offset for the current BAR
'
Function PCI_bar_readmask(ByVal Bus As Unsigned Integer, ByVal Device As Unsigned Integer, ByVal Func As Unsigned Integer, ByVal Bar As Unsigned Integer) As Unsigned Integer
    If Bar > 5 Then
        Function = 0
        Exit Function
    End If

    Dim Address As Unsigned Integer
    
    Address = PCI_type1_readdword(Bus, Device, Func, &H10 + 4 * Bar)
    
    PCI_type1_writedword(Bus, Device, Func, &H10 + 4 * Bar, &HFFFFFFFF)
    Function = PCI_type1_readdword(Bus, Device, Func, &H10 + 4 * Bar)
    
    PCI_type1_writedword(Bus, Device, Func, &H10 + 4 * Bar, Address)
End Function