' Summary: pciserv.bas
' PCI Driver Service
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos.bi"
#include "mos/drivercom.bi"
#include "mos/pci.bi"
#include "mos/devmgr.bi"

Declare Function TraceBus(ByVal busno As Integer, ByVal nodeno As Integer) As Integer
Declare Function TraceDev(ByVal busno As Integer, ByVal devno As Integer, ByVal funcno As Integer, ByVal nodeno As Integer) As Integer
Declare Function AddNode(ByVal node As Integer, ByRef nodename As String) As Integer

Declare Function hex4(ByVal v As Integer) As String
Declare Function hex2(ByVal v As Byte) As String

Sub modmain CDecl Alias "main" ()

    ' Allocate port ranges
    allocateiobitmap(0, &HD00, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HCF8, 8)

    ' Init communication port
    drv_setname(DRIVER_BUS, 3)
    Yield

    TraceBus 0, 0

End Sub

Function TraceBus(ByVal busno As Integer, ByVal nodeno As Integer) As Integer
    Dim mynode As Integer = AddNode(nodeno, "PCI #" & busno)

    Dim devno As Integer
    For devno = 0 To 31
        Dim vendid As Integer, devid As Integer
        vendid = PCI_type1_readword(busno, devno, 0, 0)
        devid = PCI_type1_readword(busno, devno, 0, 2)

        If vendid <> 0 And vendid <> &HFFFF Then
            ' Valid device

            Dim ht As Integer
            ht = PCI_type1_readbyte(busno, devno, 0, &H0E)
            If (ht And &H80) = &H80 Then
                ' Multifunction dev
                Dim funcnode As Integer
                funcnode = AddNode(mynode, "PCI #" & hex$(busno) & "." & hex$(devno))
                Dim funcno As Integer
                For funcno = 0 to 7
                    TraceDev(busno, devno, funcno, funcnode)
                Next funcno
            Else
                TraceDev(busno, devno, 0, mynode)
                'Dim newnode As Integer
                'newnode = AddNode(mynode, "PCI " & hex$(vendid) & ":" & hex$(devid))
                'If (ht And &H7F) = &H1 Then
                '    ' PCI bridge
                '    Dim sb As Byte
                '    sb = PCI_type1_readbyte(busno, devno, 0, &H19)
                '    TraceBus(sb, newnode)
                'End if
            End If
        End If
    Next devno

    Function = 0
End Function

Function TraceDev(ByVal busno As Integer, ByVal devno As Integer, ByVal funcno As Integer, ByVal nodeno As Integer) As Integer
    Dim vendid As Integer, devid As Integer, headertype As Byte, newnode As Integer
    Dim class1 As Byte, class2 as Byte, class3 as Byte

    vendid = PCI_type1_readword(busno, devno, funcno, 0)
    devid = PCI_type1_readword(busno, devno, funcno, 2)

    If vendid = 0 Or vendid = &HFFFF Then
        Function = 0
        Exit Function
    End If

    headertype = PCI_type1_readbyte(busno, devno, funcno, &H0E)
    class1 = PCI_type1_readbyte(busno, devno, funcno, &H0B)
    class2 = PCI_type1_readbyte(busno, devno, funcno, &H0A)
    class3 = PCI_type1_readbyte(busno, devno, funcno, &H09)


    newnode = AddNode(nodeno, "PCI " & hex4(vendid) & ":" & hex4(devid) & " " & hex2(class1) & ":" & hex2(class2) & ":" & hex2(class3) )
    Dim devloc As String
    ' Fixme: command ID is a dword, not a byte, and is going to change.
    devloc = "        PCI " & hex2(busno) & ":" & hex2(devno) & ":" & hex2(funcno)
    Dim msgp As Byte Ptr
    msgp = *CPtr(Byte Ptr Ptr, @devloc)

    Cptr(Integer Ptr, msgp)[0] = DEVMGRCOMMANDS_SETLOCATION
    Cptr(Integer Ptr, msgp)[1] = newnode
    drv_sendmessage(DRIVER_MGR * &H10000, Len(devloc), msgp)

    If (headertype And &H7F) = &H1 Then
        ' PCI bridge
        Dim sb As Byte
        sb = PCI_type1_readbyte(busno, devno, 0, &H19)
        If sb <> busno Then 
		TraceBus(sb, newnode)
	End If
    End if


    Function = 0
End Function

Function AddNode(ByVal node As Integer, ByRef nodename As String) As Integer
    Dim message(0 to 1) As Integer
    message(0) = DEVMGRCOMMANDS_ADD
    message(1) = node
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(message(0)) )  )

    While drv_peekmessage() = 0
        Yield
    Wend

    drv_readmessage(CPtr(Byte Ptr, @(message(0)) ) )
    Function = message(0)

    Dim ws As String
    ws = "        " & nodename
    Dim bp As Byte Ptr
    bp = *Cptr(Byte Ptr Ptr, @ws)
    Cptr(Integer Ptr, bp)[0] = DEVMGRCOMMANDS_SETNAME
    Cptr(Integer Ptr, bp)[1] = message(0)
    drv_sendmessage(DRIVER_MGR * &H10000, len(ws), bp)

End Function

Function hex2(ByVal v As Byte) As String
    Dim s As String
    s = hex$(v)
    If Len(s) = 1 Then s = "0" & s
    Function = s
End Function

Function hex4(ByVal v As Integer) As String
    Dim s As String
    s = hex$(v)
    While Len(s) < 4
        s = "0" & s
    Wend
    Function = s
End Function
