' Summary: serial_io.bas
' Contains writing routines for the serial port
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "x86.bi"
#include "mos/serial.bi"

Sub InitSerialPort CDecl Alias "InitSerialPort" (ByVal Port As Short)
	outportb(Port + SER_IER, &H00)    '    Disable all interrupts
	outportb(Port + SER_LCR, &H80)    '    Enable DLAB (set baud rate divisor)
	outportb(Port + SER_DIV_LO, &H0C) '    Set divisor to 12 (lo byte) 9600 baud
	outportb(Port + SER_DIV_HI, &H00) '                      (hi byte)
	outportb(Port + SER_LCR, &H03)    '    8 bits, no parity, one stop bit
	outportb(Port + SER_FCR, &HC7)    '    Enable FIFO, clear them, with 14-byte threshold
	outportb(Port + SER_MCR, &H07)    '    IRQs disabled, RTS/DSR set, OUT1 enabled
End Sub

Sub WriteSerial CDecl Alias "WriteSerial" (ByVal Port As Short, ByVal b As Unsigned Byte)
    Dim d as Byte
    Do
        d = inportb(Port + SER_LSR)
    Loop while (d And &H20) = 0

    outportb(Port, b)
End Sub

Sub WriteSerialBlock CDecl Alias "WriteSerialBlock" (ByVal Port As Short, ByVal bytes As Byte Ptr, ByVal length As Integer)
    Dim index As Integer
    For index = 0 to length - 1
        Dim d as Byte
        Do
            d = inportb(Port + SER_LSR)
        Loop while (d And &H20) = 0

        outportb(Port, bytes[index])
    Next index
End Sub

Function PollSerial CDecl Alias "PollSerial" (ByVal Port As Short) As Integer
    Dim d as Byte
    d = inportb(port + SER_LSR)
    Function = d And 1
End Function

Function ReadSerial CDecl Alias "ReadSerial" (ByVal Port As Short) As Byte
    Dim d as Byte
    Do
        d = inportb(port + SER_LSR) And 1
    Loop Until d = 1
    Function = inportb(port)
End Function
