;
; Summary: elf-runtime.asm
; *The C Runtime module for MOS programs*
;

SECTION .text

extern main
global _start

;
; Function: _start
; Default program entry point
;
; Prepares and calls the main function
;
; in:
;     (none)
;
; out:
;     (none)
;
; destroyed:
;     all non-stack registers
;

%include "inc_syscall.asm"
extern _PDCLIB_heaptop
extern _PDCLIB_actualtop

extern __ctors_start
extern __ctors_end
extern __dtors_start
extern __dtors_end

                    ; initialize cpu state
_start:		        kernel GetCpuInfo
                    AND AL, 1
                    JZ .skipfpu
                    FNINIT                      ; empty FPU state - the kernel does NOT do this for us
.skipfpu:

                    ; do some memory management
                    MOV EDI, 0x10000000 - 4096  ; 256M for stack expansion?
.trynextaddr:       MOV EBX, 4096               ; right now, allocate 4k for a stack
                    kernel BlockAlloc           ; call the kernel
                    OR EBX, EBX                 ; test the result
                    JNZ .done                   ; if the allocated size isnt zero we're done
                    ADD EDI, 0x1000000          ; basically, we probe for a heap base here
                    JMP .trynextaddr            ; retry
.done:              ADD EDI, EBX                ; get a page for the stack
                    MOV ESP, EDI                ; Create an stack
                    SUB ESP, 4                  ; point it to the end of the just allocated memory
                    MOV [_PDCLIB_heaptop], EDI	; set the next boundary as the base for libc malloc
                    MOV [_PDCLIB_actualtop], EDI;


                    ; constructors
.ctors:             MOV ECX, __ctors_end        ; get ctors end location
                    MOV EDI, __ctors_start      ; get ctors start location
                    SUB ECX, EDI                ; get the ctors count
                    SHR ECX, 2                  ; shift out dword
                    OR ECX, ECX                 ; compare to zero
                    JZ .ctorsdone               ; if no ctors, skip the next section
.morectors:         PUSH ECX                    ; store ecx
                    CALL [EDI]                  ; call the constructor
                    ADD EDI, 4                  ; get the next constructor's address
                    POP ECX                     ; restore ecx
                    DEC ECX                     ; decrement ctor count
                    JNZ .morectors              ; loop until all ctors have been called
.ctorsdone:


                    CALL main                   ; continue with application
                    JMP $                       ; right now, loop forever

SECTION .data
    lstack: TIMES 256 DD 0
    lstacktop: