/************************************************************************
    Summary: elf-test.c
    *The ELF loader test module*
 ************************************************************************/

#include <mos.h>
#include <x86.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

const char * vbuffer = (char *) 0xB8000;
char * vram = (char *) 0xA0000000;

const char mostext[4] = "MOS";

void cpu_divtest(unsigned int * flagsa, unsigned int * flagsb);

int calls = 0;
int lastkey = 0;

void b_main(char * vram);

void handlerstub();
void handler(int param1, int param2, int param3, int param4);

int main(void)
{
    memmap(0x8000 / 4096, (void *) vram, (void *) vbuffer);
    float alpha = 1.0f;
    int dummyalpha = 0;
    //float valf1 = 106.99f;

    int gate = gatealloc( &handlerstub );
    routealloc( gate, PORTNAME("DBG0") );

    int starttick = gettimerticks();
    int done = 0;
    int row = -3;
    int rowseg = 0;
    int delta, lp;

    unsigned int div_zeroset;
    unsigned int div_maxset;
    unsigned int div_set, div_cleared;
    unsigned int div_maintained, div_toggled;

    cpu_divtest(&div_zeroset, &div_maxset);

    div_zeroset &= 0x8D5;
    div_maxset &= 0x8D5;
    div_set = div_maxset & div_zeroset;
    div_cleared = (0x8D5 - (div_maxset | div_zeroset)) & 0x8D5;
    div_maintained = (0x8D5 - div_zeroset) & div_maxset;
    div_toggled = 0x8D5 - (div_set | div_cleared | div_maintained);


    while(!done)
    {
        while (gettimerticks() <= starttick);

        if (rowseg == 0) delta = 2;
        else if (rowseg == 2) delta = 1;
        else delta = 0;

        for (lp = rowseg; lp < 80; lp += 4)
        {
            if ((row + delta) < 0 || (row + delta) > 25) break;
            if (row+delta != 0)  vram[2 * lp + 160 * (row+delta-1)  ] = ' ' ;
            if (row+delta != 0)  vram[2 * lp + 160 * (row+delta-1)+1] = 0x7f;
            if (row+delta != 25) vram[2 * lp + 160 * (row+delta  )  ] = 'X' ;
            if (row+delta != 25) vram[2 * lp + 160 * (row+delta  )+1] = 0x02;

            if (row+delta == 14 && rowseg == 0)
               vram[80 + 160 * 13] = mostext[0];
            if (row+delta == 14 && rowseg == 1)
               vram[82 + 160 * 13] = mostext[1];
            if (row+delta == 14 && rowseg == 2)
               vram[84 + 160 * 13] = mostext[2];

        }
        rowseg++;
        if (rowseg == 4)
        {
            rowseg = 0;
            row++;
        }
        if (row == 50) row--;
        starttick += 2;

        alpha++;
        if (alpha >= 10.0f) alpha = 0.0f;

        dummyalpha = (int) alpha;
        vram[158] = '0' + (char) dummyalpha;
        vram[159] = 0x70;

        b_main(vram);

        char buf[128];


        lp = sprintf(buf, "testing: %d IPC requests received. Last scancode: %x.", calls, lastkey );
        while (lp > 0)
        {
            lp--;
            vram[160+2*lp] = buf[lp];
            vram[160+2*lp+1] = 0x0f;
        }

        lp = sprintf(buf, "CPU DIVtest signature: %x / %x / %x / %x (%x,%x)", div_set, div_cleared, div_maintained, div_toggled, div_zeroset, div_maxset );
        while (lp > 0)
        {
            lp--;
            vram[480+2*lp] = buf[lp];
            vram[480+2*lp+1] = 0x0f;
        }


    }

    return(0);
}

void handlerstub(void)
{
    ipccdeclconv(&handler);
}

void handler(int param1, int param2, int param3, int param4)
{
    calls++;
    lastkey = param2;
}
