' Summary: bgatest.bas
' Bochs Graphics Adapter test code
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'


#include "mos.bi"
#include "x86.bi"
#include "mos/pci.bi"
#include "mos/bga_regs.bi"

Declare Sub ModMain CDecl Alias "main"()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
Declare Sub ClearCon (vram As Byte Ptr)

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Sub ModMain CDecl Alias "main"()

    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(32, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))

    PortAlloc(&HCF8, 8)
    PortAlloc(BGA_INDEX_PORT, 4)

    InitKeyboard

    ClearCon cram

    PrintString "BGA test program", cram, 0

    Dim version as Unsigned Short
    version = BGA_Read(bga_regs.INDEX_ID)
    PrintString "Version info: 0x" & hex$(version), cram, 160

    If version < &HB0C0 Or version > &HB0C9 Then
        PrintString "BGA not found", cram, 320
        Exit Sub
    End If

    Dim testver As Unsigned Short
    Dim vs As String
    Dim myversion As Byte
    vs = ""
    myversion = 0

    'Former can detect and fix bad configs, but it makes bochs panic
    'For testver = &HB0C0 to &HB0C9
    For testver = &HB0C0 to version
        BGA_Write(bga_regs.INDEX_ID, testver)
        If BGA_Read(bga_regs.INDEX_ID) = testver Then
            vs = vs & " " & (testver - &HB0C0)
            if testver = &HB0C4 then myversion = 1
        Else
            Exit For
        End If
    Next testver
    PrintString "Supported emulations:" & vs, cram, 320

    If myversion = 0 then
        PrintString "Emulation B0C4 not supported", cram, 480
        PrintString "Please download the latest version of Bochs", cram, 640
        Exit Sub
    End If
    BGA_Write(bga_regs.INDEX_ID, &HB0C4)

    ReadKey

    Const LFB_ADDRESS = &HE0000000

    Dim retval As Integer
    Asm
            XCHG EBX, EBX
    End Asm
    retval = ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, LFB_ADDRESS))
    If retval <> 0 then
        PrintString "MM Registration failed", cram, 480
        Exit Sub
    End if

    retval = BlockAllocPhysL(1, CPtr(Byte Ptr, LFB_ADDRESS), CPtr(Byte Ptr, LFB_ADDRESS))
    If retval <> 1 then
        PrintString "Failed mapping 4M", cram, 480
        Exit Sub
    End if

    ReadKey

    'disable CRTC
    BGA_Write(bga_regs.INDEX_ENABLE, 0)
    'write regs
    BGA_Write(bga_regs.INDEX_XRES, 800)
    BGA_Write(bga_regs.INDEX_YRES, 600)
    BGA_Write(bga_regs.INDEX_BPP, 32)
    'enable CRTC
    BGA_Write(bga_regs.INDEX_ENABLE, bga_regs_enable.BGA_OUTPUT_ENABLED Or bga_regs_enable.BGA_LFB_ENABLED)

    ReadKey

    Dim lfb As Unsigned Byte Ptr
    lfb = CPtr(Unsigned Byte Ptr, LFB_ADDRESS)

    dim y as integer, x as integer
    dim offset as integer
    Dim b1 as byte
    Dim b2 as byte
    Dim b3 as byte
    for y = 0 to 599
        b1 = y \ 3
        for x = 0 to 799
            b2 = x \ 4
            b3 = 255 - ((x + y) \ 6)

            lfb[offset] = b1
            lfb[offset+1] = b2
            lfb[offset+2] = b3

            offset = offset + 4
        next x
    next y


    While 1 = 1
    Wend

End Sub


' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Public Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + offset] = ch
        vram[lp * 2 - 1 + offset] = 7
    Next lp
End Sub


Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub
