' Summary: giotest.bas
' GIO protocol test code
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purporses
'

#include "mos/drivercom.bi"
#include "mos.bi"

#include "mos/driver.bi"
#include "mos/block.bi"

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Sub modmain CDecl Alias "main"()

    Dim devaddr As Integer

    drv_setname(0,1)

    Dim vram As Byte Ptr
    vram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(8, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))

    Dim drvindex As Integer
    drvindex = 1
    While devaddr = 0

        Dim msgdata() As Integer
        Redim msgdata(2)
        msgdata(0) = 2
        msgdata(1) = drvindex
        drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msgdata(0))) )

        While drv_peekmessage() = 0
            Yield
        Wend

        Dim rv As Integer
        rv = drv_peekmessage()
        Dim rs As String
        rs = space$(rv)
        drv_readmessage(  *CPtr(Byte Ptr Ptr, @rs))

        If (rv > 1) Then
            msgdata(0) = 8
            msgdata(1) = drvindex
            drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msgdata(0))) )
            While drv_peekmessage() = 0
                Yield
            Wend
            drv_readmessage( CPtr(Byte Ptr, @(msgdata(0))))

            If msgdata(0) <> 0 Then
                devaddr = msgdata(0)

                ' query for the graphics2 interface
                msgdata(0) = SYSCOMMAND_QUERYINTERFACES
                drv_sendmessage(devaddr, 4, CPtr(Byte Ptr, @(msgdata(0))) )
                While drv_peekmessage() = 0
                    Yield
                Wend
                rv = drv_peekmessage()
                Redim msgdata((rv + 3) \ 4)
                drv_readmessage(CPtr(Byte Ptr, @(msgdata(0))))

                ' test if we can use it
                Dim ok as Integer, lp as Integer
                ok = 0
                For lp = 0 To (rv \ 4) - 1
                    If msgdata(lp) = INTERFACE_BLOCK Then ok = 1
                Next lp
                If ok = 0 Then
                    devaddr = 0
                    drvindex = drvindex + 1
                End If
            Else
                drvindex = drvindex + 1
            End If
        Else
            '*Cptr(Byte Ptr, &HB1BA00 + drvindex) = 0
            drvindex = 1
        End If

    Wend

    Dim msgdata(0 to 4) as integer
    msgdata(0) = BLOCKCOMMAND_GEOM
    drv_sendmessage(devaddr, 4, CPtr(Byte Ptr, @(msgdata(0))) )

    While drv_peekmessage() = 0
        Yield
    Wend
    drv_readmessage( CPtr(Byte Ptr, @(msgdata(0))))

    InitKeyboard

    Dim block As Integer
    block = 0
    While 1 = 1

        msgdata(0) = BLOCKCOMMAND_READ  ' read
        'msgdata(1) = 0                  ' map 0 (untranslated)
        msgdata(1) = 1                  ' map 1 (should be first partition found)
        msgdata(2) = block              ' starting block
        msgdata(3) = 1                  ' block count
        drv_sendmessage(devaddr, 16, CPtr(Byte Ptr, @(msgdata(0))) )

        While drv_peekmessage() = 0
            Yield
        Wend

        Dim getbytes() As Byte
        redim getbytes(512+16)
        drv_readmessage(@getbytes(0))

        Dim lp as Integer, b as Byte
        For lp = 0 to 80 * 25 * 2
            vram[lp] = &H00
        Next lp

        Dim x as Integer, y as Integer
        For lp = 0 to 511
            b = getbytes(lp+16)
            y = lp \ 64 + 16
            x = (lp Mod 64)
            vram[2 * x + 160 * y + 0] = b
            vram[2 * x + 160 * y + 1] = &H07

            y = lp \ 32
            x = (lp Mod 32) + (80-32)
            vram[2 * x + 160 * y + 0] = &HB1
            vram[2 * x + 160 * y + 1] = b
        Next lp

        ReadKey
        block = block + 1

    Wend
End Sub
