' Summary: giotest.bas
' GIO protocol test code
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purporses
'

#include "mos/drivercom.bi"
#include "mos.bi"
#include "x86.bi"

#include "mos/driver.bi"
#include "mos/block.bi"
#include "mos/event.bi"
#include "mos/channel.bi"
#include "mos/devmgr.bi"

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Sub showbyte(ByVal b As Integer)
    outportb(&HE9, b)
End Sub

Sub showstring(ByRef s As String)
    Dim lp As Integer
    For lp = 1 to len(s) 
        showbyte(asc(mid$(s, lp, 1)))
    Next lp
End Sub

Type BrowserListener Extends MCChannelListener
    DeviceCount As Integer    

    Declare Constructor()
    
    Declare Function HandleQueryResult(ByVal sender As Integer, ByVal length As Integer, ByVal contents As Byte Ptr) As Integer
    Declare Sub BeginQuery    
End Type

Function BrowserListener_HandleQueryResult(ByVal listener As MCChannelListener Ptr, ByVal sender As Integer, ByVal length As Integer, ByVal contents As Byte Ptr) As Integer
    Function = CPtr(BrowserListener Ptr, listener)->HandleQueryResult(sender, length, contents)
End Function

Constructor BrowserListener
    SetHandler DEVMGRCOMMANDS_CONNECTIVITY_ACK, @BrowserListener_HandleQueryResult
    BeginQuery        
End Constructor

Function BrowserListener.HandleQueryResult(ByVal sender As Integer, ByVal length As Integer, ByVal contents As Byte Ptr) As Integer
    Function = 0
End Function



Sub BrowserListener.BeginQuery
    Dim msg(2) as integer
    msg(0) = DEVMGRCOMMANDS_CONNECTIVITY_REQ
    msg(1) = DeviceCount + 1
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(msg(0))))
End Sub


Sub modmain CDecl Alias "main"()

    Dim devaddr As Integer

    drv_setname(0,1)

    Dim vram As Byte Ptr
    ' VGA
    vram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(8, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))    
    ' Bochs debugger
    portalloc(&HE9, 1)

    Dim listener As BrowserListener Ptr
    listener = New BrowserListener()
    
    InitKeyboard
    
    listener->Start()

    
End Sub
