' Summary: verite2k.bas
' Testing module for Verite V2x00 graphics stuff
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "../gfx/vga_io.bi"
#include "../gfx/vgasignal.bi"
#include "../gfx/verite/verite.bi"
#include "mos.bi"
#include "x86.bi"
#include "mos/pci.bi"

Declare Sub ModMain Cdecl Alias "main" ()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
Declare Function GetYesNo () As Integer
Declare Function ReadKB () as Integer
Declare Sub ClearCon (vram As Byte Ptr)
Declare Function Cirrus_PCIProbe(ByRef base_lfb As Long, ByRef base_pio As Integer) As Long

Declare Sub WriteLfbString(lfb As Byte Ptr, s as String, offset as Long)
Declare Sub PutPixel(vram As Byte Ptr, x As Long, y As Long, col As Long, bpp As Byte, pitch As Long)
Declare Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
Declare Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
Declare Sub WriteConioString(vram As Byte Ptr, s as String, font() As Byte, row As Long, column As Long, col As Long, bpp as Byte, vw As Long)
Declare Sub RenderTest(vram as Byte Ptr, w as long, h as long, bpp as byte, vw as long)

Declare Sub TestCirrus(crtmodel As Long, lfb As Long, portbase As Long)

Declare Function malloc Cdecl Alias "malloc" (byval bytes as long) as Byte Ptr
Declare Sub free Cdecl Alias "free" (byval pointer as Byte Ptr)

Declare Sub syncb(port As Integer, value as Unsigned Byte)
Declare Sub syncd(port As Integer, value as Integer)

Public Sub ModMain Cdecl Alias "main" ()
    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    Dim bios As Byte Ptr
    Dim vaddress as Byte Ptr

    vaddress = CPtr(Byte Ptr, &HA0000)
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    bios = CPtr(Byte Ptr, &HC0000)

    blockallocphys(64, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    PortAlloc(&HCF8, 8)
    PortAlloc(&H3C0, 32)
    PortAlloc(&H60, 2)

    Dim lfb as Integer
    Dim portbase as Integer
    Dim chiptype as Integer
    Dim chipsubtype as Integer
    Dim bioshash as Integer
    Dim lp as Integer
    Dim devname As String

    ClearCon cram
    PrintString "BASIC For teh win (>O.O)>", cram, 25 * 80 - 27

    PrintString "Cirrus test program", cram, 0
    PrintString "Searching PCI device list for a Cirrus board...", cram, 80

    chiptype = Cirrus_PCIProbe(lfb, portbase)
    PrintString "Hashing BIOS...", cram, 160
    bioshash = 0
    for lp = 0 to 32767
        bioshash = bioshash + ((16381 * lp + 1) * CLng(bios[lp]))
    next lp
    PrintString "Probe result: " + hex$(chiptype), cram, 240
    If chiptype = 0 Then
        PrintString "Probe for a legacy Cirrus graphics device? (Y/N)", cram, 320
        If GetYesNo() = 1 Then
            chiptype = 1
	    portbase = 0
            lfb = &HA0000
	End If
    End If

    If chiptype <> 0 Then

        PrintString "LFB Address: 0x" + hex$(lfb), cram, 480
        PrintString "Port Base: 0x" + hex$(portbase), cram, 560

        PrintString "Press Y to start the test at your hardware's peril", cram, 720
        PrintString "Press N to skip this test", cram, 800

        If GetYesNo() = 1 Then
            TestCirrus(chiptype, lfb, portbase)
        End If

        ClearCon cram
        PrintString "Test Ended. Please hit the power or the reset button", cram, 0

    Else
        PrintString "No Cirrus board found", cram, 320
        PrintString "Test Ended. Please hit the power or the reset button", cram, 400
    End if
    While 1 = 1

    Wend

End Sub

Public Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + 2 * offset] = ch
        vram[lp * 2 - 1 + 2 * offset] = 7
    Next lp

End Sub

Public Function GetYesNo () As Integer
    ' Y = &H15
    ' N = &H31

    Dim status As Integer = -1
    Dim key As Integer
    While status = -1
        key = ReadKB
        if key = &H15 then status = 1
        if key = &H31 then status = 0
    Wend
    GetYesNo = status
End Function

Public Function ReadKB () as Integer
    Dim temp as Unsigned Byte
    Dim key as Unsigned Byte
    Dim breakexit as Unsigned Byte = 0
    Dim done as Unsigned Byte = 0
    Dim isescaped as Unsigned Byte = 0
    While done = 0
        key = inportb(&H60)
        temp = inportb(&H61)
        outportb(&H61,temp Or  &H80)    'disable
        outportb(&H61,temp And &H7F)    'and reenable
        If key = &HE0 Then
            isescaped = &H80
        ElseIf key > &H80 Then
            If key = breakexit Then
                done = 1
            Else
                breakexit = 0
                isescaped = 0
            End If
        Else
            breakexit = key or &H80
            ReadKB = key or isescaped
        End If
    Wend
End Function

Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub

Public Function Cirrus_PCIProbe(ByRef base_lfb As Long, ByRef base_pio As Integer) As Long

    base_lfb = 0
    base_pio = 0

    Dim lp as long, bus as long, dev as long, fn as long
    Dim lastdevice as Unsigned Short
    Dim mybus as long, mydev as long, myfn as long
    Dim vendor as Unsigned Short, myvendor as unsigned short
    Dim device as Unsigned Short, mydevice as unsigned short
    Dim cldev as Unsigned Short

    mybus = -1
    cldev = &HFFFF
    lastdevice = &HFFFF
    lp = 0
    For bus = 0 to 2
        For dev = 0 to 31
            For fn = 0 to 7
                vendor = PCI_type1_readword(bus, dev, fn, 0)
                device = PCI_type1_readword(bus, dev, fn, 2)
                If vendor = &H1163 And device = &H2000 Then
                    mybus = bus
                    mydev = dev
                    myfn = fn
                    myvendor = vendor
                    mydevice = device
                    exit for
                ElseIf vendor = &H1163 Then
                    cldev = device
                End If
            Next fn
        Next dev
    Next bus

    if mybus = -1 Then
        function = 0
        exit function
    end if

    Dim bar as Unsigned Long, barmask As Unsigned Long

    For lp = 5 to 0 step -1
        barmask = PCI_bar_readmask(mybus,mydev,myfn, lp)
        bar = PCI_bar_readaddress(mybus,mydev,myfn, lp)

        If bar = 0 then

        Elseif (barmask and &H1) = 1 Then
            base_pio = bar and &HFFF8&
        Elseif ((barmask and &HFFFF0) = 0) And (base_lfb = 0) then
            base_lfb = bar
        Else
            'mmiobase = bar
        End If
    Next lp

    function = mydevice

End Function

Sub PutPixel(vram As Byte Ptr, x As Long, y As Long, col As Long, bpp As Byte, pitch As Long)
    Dim offset As Long
    Select case bpp
        Case 4
            Dim temp as Byte
            offset = x \ 2 + y * pitch
            If (x And &H1) = 1 Then
                temp = vram[offset] and &HF
                vram[offset] = temp + 16 * (col and &HF)
            Else
                temp = vram[offset] and &HF0
                vram[offset] = temp + (col and &HF)
            End If

        Case 8
            offset = x + y * pitch
            vram[offset] = CByte(col)

        Case 16
            offset = 2 * (x + pitch * y)
            Dim mempos as Short Ptr
            mempos = CPtr(Short Ptr, @vram[offset])
            mempos[0] = CShort(col)

        Case 32
            offset = 4 * (x + pitch * y)
            Dim mempos as Long Ptr
            mempos = CPtr(Long Ptr, @vram[offset])
            mempos[0] = col

    End Select
End Sub

Sub WriteLfbString(lfb As Byte Ptr, s as String, offset as Long)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        lfb[lp * 8 - 8 + 8 * offset] = ch
        lfb[lp * 8 - 7 + 8 * offset] = &H1F
    Next lp
End Sub

Sub WriteConioString(vram As Byte Ptr, s as String, font() As Byte, row As Long, column As Long, col As Long, bpp as Byte, vw As Long)
    WriteGfxString vram, s, @font(0), column * 8, row * 16, col, bpp, vw
End Sub

Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
    Dim lp as long
    For lp = 1 to len(s)
        WriteGfxChar vram, asc(mid$(s,lp,1)), font, x + 8 * (lp - 1), y, col, bpp, vw
    next lp
End Sub
Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
    dim lp as long
    Dim fontbyte as byte
    For lp = 0 to 15
        fontbyte = font[32 * ch + lp]
        if (fontbyte and &H01) = &H01 then PutPixel vram, x + 7, y + lp, col, bpp, vw
        if (fontbyte and &H02) = &H02 then PutPixel vram, x + 6, y + lp, col, bpp, vw
        if (fontbyte and &H04) = &H04 then PutPixel vram, x + 5, y + lp, col, bpp, vw
        if (fontbyte and &H08) = &H08 then PutPixel vram, x + 4, y + lp, col, bpp, vw
        if (fontbyte and &H10) = &H10 then PutPixel vram, x + 3, y + lp, col, bpp, vw
        if (fontbyte and &H20) = &H20 then PutPixel vram, x + 2, y + lp, col, bpp, vw
        if (fontbyte and &H40) = &H40 then PutPixel vram, x + 1, y + lp, col, bpp, vw
        if (fontbyte and &H80) = &H80 then PutPixel vram, x + 0, y + lp, col, bpp, vw
    Next lp
End Sub

Sub RenderTest(vram as Byte Ptr, w as long, h as long, bpp as byte, vw as long)
    Dim lpx as long, lpy as long
    For lpx = 1 To w - 1 Step 2
        PutPixel vram, lpx, 0, 9, bpp, vw
        PutPixel vram, lpx, 1, 9, bpp, vw
        If lpx mod 10 = 9 then
            PutPixel vram, lpx, 2, 9, bpp, vw
        End If
        If lpx mod 40 = 39 then
            PutPixel vram, lpx, 3, 9, bpp, vw
        End If
        PutPixel vram, lpx, h-1, 9, bpp, vw
        PutPixel vram, lpx, h-2, 9, bpp, vw
    Next lpx
    For lpy = 1 To h - 1 Step 2
        PutPixel vram, 0, lpy, 9, bpp, vw
        PutPixel vram, 1, lpy, 9, bpp, vw

        PutPixel vram, w-1, lpy, 9, bpp, vw
        PutPixel vram, w-2, lpy, 9, bpp, vw

        If lpy mod 10 = 9 then
            PutPixel vram, w-3, lpy, 9, bpp, vw
        End If
        If lpy mod 40 = 39 then
            PutPixel vram, w-4, lpy, 9, bpp, vw
        End If
    Next lpy
End Sub

' Function: TestCirrus
' runs the test suite for the Cirrus Logic graphics cards
'
' Parameters:
'     board_model   - the board type. equals the four digits in CL-GDxxxx
'     lfb           - address of the framebuffer in memory
'     portbase      - the base I/O port for the Verite registers
'
Sub TestCirrus(board_model As Long, lfb As Long, portbase As Long)
    Dim vaddress as Byte Ptr
    Dim vram as Byte Ptr

    Dim lp as long, lp2 As Long
    Dim ws as String, ws2 as String

    Dim fontdata() As Byte
    Dim font As Byte Ptr

    ' claim board-specific addresses
    if lfb = &HA0000 Then
        vram = CPtr(Byte Ptr, lfb)
    Else
        vaddress = CPtr(Byte Ptr, lfb)
        vram = CPtr(Byte Ptr, &HB0000000)

        ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), vaddress)
        BlockAllocPhysL(1, vram, vaddress)
    End If

    Dim cram As Byte Ptr
    cram = CPtr(Byte Ptr, &HB8000)
    ClearCon cram
    PrintString "Test Started", cram, 0

    ReadKB
    
    portalloc &H3B0, &H30

    For lp = 0 to 255
        Dim b as Byte
        b = Read3D4(lp)
	ws = ws + hex$(b) + " "
	If (lp mod 16) = 15 Then
            PrintString ws, cram, 80 * (lp \ 16) + 80
	    ws = ""
	End If
    Next lp

    For lp = 0 to 255
        Dim b as Byte
	b = Read3C4(lp)
	ws = ws + hex$(b) + " "
	If (lp mod 16) = 15 Then
            PrintString ws, cram, 80*(lp \ 16) + 17 * 80 
	    ws = ""
	End If
    Next lp

    ReadKB

    'portalloc portbase, &H100

End Sub

Sub syncd(port As Integer, value as Integer)
    Dim rv as Integer
    do
        rv = inportd(port)
    loop while rv <> value
End Sub

Sub syncb(port As Integer, value as Unsigned Byte)
    Dim rv as Unsigned Byte
    do
        rv = inportb(port)
    loop while rv <> value
End Sub

