' Summary: dbglog.bas
' An output driver sending all data to the serial port (ideal for debugging graphics code)
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos.bi"
#include "mos/drivercom.bi"
#include "mos/serial.bi"

Dim Shared com1_port As Short
Declare Sub handlemessage(size as integer)



Sub modmain CDecl Alias "main" ()

    blockallocphys(1, CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, &H0))
    dim bda as short ptr, size As Integer
    bda = CPtr(short ptr, &H400)
    com1_port = bda[0]
    blockdealloc(CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, &HFFF))

    If com1_port > 0 Then
        allocateiobitmap(com1_port, com1_port + 8, CPtr(Byte Ptr, &HFFFFFFFF))
        portalloc(com1_port, 8)
        InitSerialPort(com1_port)
        WriteSerial(com1_port, asc("!"))
        WriteSerialBlock(com1_port, CPtr(Byte Ptr, @"System logger on serial port"), 28)
    End if

    drv_setname(DRIVER_MGR, 4)
    While 1 = 1
        size = drv_peekmessage()
        if (size > 0) then
           handlemessage(size)
        else
           Yield
        end if
    Wend
End Sub

Sub handlemessage(size as integer)
    Dim msgdata() As Integer
    redim msgdata(size \ 4 + 1)

    Dim src As Integer
    src = drv_readmessage(  CPtr(Byte Ptr, @(msgdata(0)) )  )

    If (size < 8) Then Exit Sub

    Select Case msgdata(0)
        Case 0

        Case Else

    End Select

End Sub