
#include "x86.bi"
#include "mos.bi"

Declare Sub InitSerialPort(Port As Short)
Declare Sub WriteSerial(Port As Short, b as Unsigned Byte)
Declare Sub PrintString(s as string, row as integer, colour as Byte)

Const SER_DATA = 0
Const SER_DIV_LO = 0
Const SER_DIV_HI = 1
Const SER_IER = 1
Const SER_IIR = 2
Const SER_FCR = 2
Const SER_LCR = 3
Const SER_MCR = 4
Const SER_LSR = 5
Const SER_MSR = 6
Const SER_SCRATCH = 7


Public Sub ModMain CDecl Alias "main" ()

    Dim r as byte, d as byte
    Dim com1_in as integer, com1_out as integer
    Dim com2_in as integer, com2_out as integer
    Dim com1_port As integer, com2_port as integer

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    blockallocphys(8, CPtr(Byte Ptr, &HB8000), CPtr(Byte Ptr, &HB8000))
    blockallocphys(1, CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, &H0))
    dim bda as short ptr
    bda = CPtr(short ptr, &H400)
    com1_port = bda[0]
    com2_port = bda[1]

    portalloc(com1_port, 8)
    portalloc(com2_port, 8)


    PrintString "Starting serial test (8n1, 9600 baud)", 1, 7
    if com1_port > 0 then InitSerialPort(com1_port)
    PrintString "COM1 initialized (0x" & hex$(com1_port) & ")", 2, 7
    if com2_port > 0 then InitSerialPort(com2_port)
    PrintString "COM2 initialized (0x" & hex$(com2_port) & ")", 3, 7
    While 1 = 1
        if com1_port > 0 then
            r = inportb(com1_port + SER_LSR)
            If (r And &H20) <> 0 then
                outportb(com1_port, 65)
                com1_out = com1_out + 1
                PrintString "COM1 out: " & com1_out & " bytes", 5, 7
            End If
            If (r And &H01) <> 0 then
                d = inportb(com1_port)
                com1_in = com1_in + 1
                PrintString "COM1 in: " & com1_in & " bytes (0x" & hex$(d) & ") ", 6, 7
            End If
        End If

        If com2_port > 0 then
            r = inportb(com2_port + SER_LSR)
            If (r And &H20) <> 0 then
                outportb(com2_port, 66)
                com2_out = com2_out + 1
                PrintString "COM2 out: " & com2_out & " bytes", 7, 7
            End If
            If (r And &H01) <> 0 then
                d = inportb(com2_port)
                com2_in = com2_in + 1
                PrintString "COM2 in: " & com2_in & " bytes (0x" & hex$(d) & ") ", 8, 7
            End If
        End If
        Yield
    Wend

End Sub

Sub InitSerialPort(Port As Short)
	outportb(Port + SER_IER, &H00)    '    Disable all interrupts
	outportb(Port + SER_LCR, &H80)    '    Enable DLAB (set baud rate divisor)
	outportb(Port + SER_DIV_LO, &H0C) '    Set divisor to 12 (lo byte) 9600 baud
	outportb(Port + SER_DIV_HI, &H00) '                      (hi byte)
	outportb(Port + SER_LCR, &H03)    '    8 bits, no parity, one stop bit
	outportb(Port + SER_FCR, &HC7)    '    Enable FIFO, clear them, with 14-byte threshold
	outportb(Port + SER_MCR, &H07)    '    IRQs disabled, RTS/DSR set, OUT1 enabled
End Sub

Sub WriteSerial(Port As Short, b As Unsigned Byte)
    Dim d as Byte
    Do
        d = inportb(Port + 5)
    Loop while (d And &H20) = 0

    outportb(Port, b)
End Sub

Sub PrintString(s as string, row as integer, colour as Byte)
    Dim vram As Byte Ptr
    Dim lp As Integer
    vram = CPTr(Byte Ptr, &HB8000)

    For lp = 1 to Len(s)
        vram[160*(row-1) + 2*(lp-1)] = asc(mid$(s,lp,1))
        vram[160*(row-1) + 2*(lp-1)+1] = colour
    Next lp

End Sub
