' Summary: fstest.bas
' GIO protocol test code
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purporses
'

#include "mos/drivercom.bi"
#include "mos.bi"

#include "mos/driver.bi"
#include "mos/block.bi"

#include "fsdriver.bi"
#include "rawvgatk.bi"

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Type TestListener Extends FSClientListener

End Type

Sub modmain CDecl Alias "main"()

    Dim devaddr As Integer
    Dim handler As TestListener Ptr

    drv_setname(0,1)

    Dim vram As Byte Ptr
    vram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(8, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    
    cram = CPtr(Byte Ptr, &HB8000)

    ClearScreen
    
    PrintString("Finding FS", 160)
    
    Dim devid As Integer
    devid = mos_finddev(INTERFACE_FILENAME)
    Dim channel As Byte Ptr
    channel = CPtr(Byte Ptr, devid)
    
    PrintString("FS found at message port 0x" & hex$(devid), 160)
    
    handler = New TestListener
    
    FSDriver_mount(channel, 0)

    While 1 = 1
        Yield
    Wend
    
End Sub
