' Summary: gfxdemo.bas
' Graphics Demonstration Code
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purporses
'

#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos.bi"
#include "x86.bi"

#include "mos/gfx.bi"

#include "GL/gl.bi"
#include "GL/mgl.bi"

#include "libgfx/error.bi"
#include "libgfx/ast.bi"
#include "libgfx/template.bi"

extern font0 alias "font8x8_0000" As Unsigned Byte

Declare Sub SetGenericResolution (ByVal connector as Integer)
Declare Function GetEngineDepth (ByVal engine As Integer) As Integer

Declare Sub DrawCharacter(ByVal character As Integer, ByVal X as integer, ByVal Y as integer, ByVal colour As Integer)
Declare Sub DrawString(ByRef text As String, ByVal X As Integer, ByVal Y As Integer, ByVal colour As Integer)

Declare Function ReadKey() As Byte
Declare Function ReadKeyboard() As Unsigned Byte
Declare Sub InitKeyboard()

Declare Sub FixPalette(ByVal selengine As Integer, ByVal bpp As Integer)

Sub modmain CDecl Alias "main"()

    Dim gfxaddr As Integer

    drv_setname(0,1)

    gfxaddr = mos_finddev(INTERFACE_GRAPHICS2)
    
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))

    Dim context As Integer
    context = mglContextInit(gfxaddr)
    If context = 0 Then Exit Sub

    '*CPtr(Byte Ptr, &H30000 + mglGetConnectorState(0, GFX_PROP_CONNECTOR_TYPE)) = 0

    Dim enginecount As Integer
    Dim connectorcount As Integer
    mglOpen(enginecount, connectorcount)

    ' disable output
    mglSetConnectorState(0, GFX_PROP_ENABLE, 0)
    ' determine best engine
    
    Dim firstengine As Integer, lastengine As Integer, unused As Integer
    'mglGetConnectorRange(0, GFX_PROP_INPUT)    
    'mglGetLastRangeEntry(0, @firstengine, @lastengine, @unused)
    'If unused <> 1 then
    '    ' handle bug
    'End If    
    firstengine = 0
    lastengine = enginecount - 1
    
    Dim bestbpp As Integer = 0
    Dim lp As Integer
    For lp = firstengine To lastengine
        Dim ebpp As Integer
        ebpp = GetEngineDepth(lp)
        If (ebpp > bestbpp) Then
            mglSetConnectorState(0, GFX_PROP_INPUT, lp)
            bestbpp = ebpp
        End If
    Next lp
    
    ' configure output and enable
    SetGenericResolution(0)    
    mglSetConnectorState(0, GFX_PROP_ENABLE, 1)
    'exit sub    

    ' get display info
    Dim selengine As Integer
    selengine = mglGetConnectorState(0, GFX_PROP_INPUT) ' get the selected engine, avoiding setting bugs
    Dim dspw As Integer
    Dim dsph As Integer
    
    dsph = mglGetEngineState(selengine, GFX_PROP_UNIT_HEIGHT)
    dspw = mglGetEngineState(selengine, GFX_PROP_UNIT_WIDTH)
    If (dsph <= 0) Or (dspw <= 0) Then
        ' handle bug
        dsph = 1
        dspw = 1
    End If
    
    dsph = mglGetEngineState(selengine, GFX_PROP_HEIGHT) / dsph
    dspw = mglGetEngineState(selengine, GFX_PROP_WIDTH) / dspw
    
    If (dsph <= 0 Or dspw <= 0) Then
        ' handle bug
        dsph = 240
        dspw = 320
    End If
    
    Dim bpp as Integer
    bpp = GetEngineDepth(selengine)
    Dim selcolor as Integer
    If bpp = 4 then
        selcolor = 15
    ElseIf bpp = 8 Then
        selcolor = &H92
    Else
        selcolor = 127
    End If
    
    fixpalette(selengine, bpp)

    glBindBufferUDI(GL_BUFFER_2D, mglGetEngineState(selengine, GFX_PROP_BUFFER))    

    glClearColor 1, 0, 0, 0
    glClear GL_COLOR_BUFFER_BIT

    glBegin GL_TRIANGLES
    glColor4f(0,1,0,1)
    glVertex3f -1,-1, 1
    glColor4f(0,0,1,1)
    glVertex3f  1,-1, 1
    glColor4f(0,1,1,1)
    glVertex3f  1, 1, 1

    'glColor4f(1,0,1,1)
    'glVertex3f -1,-1, 1
    'glVertex3f  1, 1, 1
    'glVertex3f  1,-1, 1
    glEnd

    Dim s as string
    s = chr$(1) & chr$(2) & chr$(3) & chr$(4) & chr$(5) & chr$(6) & chr$(7) & "\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\n\n\n\n\n\n\n\n\n\n\n"
    'glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, len(s), 1, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, *(Cptr(Byte Ptr Ptr, @s)))

    'dim ucs As WString * 32
    'ucs = "Pretty Greek: \u03C0\u03C1"

    Dim fo() as Byte
    redim fo(64)
    Dim lpx as integer, lpy as integer
    Dim fd As Unsigned Byte Ptr
    fd = @font0

    For lp = 0 to 575
        for lpx = 0 to 7
            for lpy = 0 to 7
                fo(lpx + 8 * lpy) = ((fd[8*lp+lpy] SHR lpx) And 1) * selcolor
            next lpy
        next lpx
        glTexSubImage2D(GL_BUFFER_2D, 0, 8 * (lp mod 32), 24 + 8 * (lp \ 32), 8, 8, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, @(fo(0)))
    Next lp

    mglSwapBuffer 0    
    
    ' FIXME: io bitmap does not get physically allocated    
    InitKeyboard

    Dim desiredengine As Integer
    desiredengine = selengine
    ReadKey

    While 1 = 1
        glDisable GL_SCISSOR_TEST
        glClearColor 0, 0.15, 0.35, 0
        glClear GL_COLOR_BUFFER_BIT

        glScissor 10, 10, 25, 25
        glEnable GL_SCISSOR_TEST
        glClearColor 0.75, 0.05, 0.15, 0
        glClear GL_COLOR_BUFFER_BIT

        glDisable GL_SCISSOR_TEST
        DrawString "Pipeline: " & desiredengine & "  ", 8, 8, selcolor
        s = s & *libgfx_errormsg & "! "
        DrawString s, 8, 24, selcolor
        s = ""

        mglSwapBuffer 0
        Yield

        Dim update As Integer
        update = 0
        While update = 0

            Dim keyindex as integer
            keyindex = readkeyboard

            Update = 1

            Select Case keyindex
                Case &H4D, &HCD
                    desiredengine = desiredengine + 1
                    If desiredengine > lastengine Then desiredengine = 0
                    LibGFX_reseterror

                Case &H4B, &HCB
                    desiredengine = desiredengine - 1
                    If desiredengine < 0 Then desiredengine = lastengine
                    LibGFX_reseterror

                Case &H1C
                    mglSetConnectorState(0, GFX_PROP_ENABLE, 0)
                    mglSetConnectorState(0, GFX_PROP_INPUT, desiredengine)
                    mglSetConnectorState(0, GFX_PROP_ENABLE, 1)
                    mglSetEngineState(desiredengine, GFX_PROP_TRANSLATEX, 0)
                    mglSetEngineState(desiredengine, GFX_PROP_TRANSLATEY, 0)
                    bpp = GetEngineDepth(desiredengine)
                    FixPalette desiredengine, bpp
                    glBindBufferUDI(GL_BUFFER_2D, mglGetEngineState(desiredengine, GFX_PROP_BUFFER))
                    selengine = desiredengine
                    If bpp = 4 then
                        selcolor = 15   'BGRI format
                    ElseIf bpp = 8 Then
                        selcolor = &H92 'B2G3R3 format
                    Else
                        selcolor = 127  'intensity
                    End If
                    LibGFX_reseterror

                Case &H17
                    Dim tempmap as AST_RawOpcodeMap Ptr
                    Dim temptree As AST_Node Ptr
                    tempmap = LibGFX_retrievemap(desiredengine)
                    temptree = LibGFX_BuildTree(tempmap)
                    LibGFX_UnfoldMad temptree
                    LibGFX_TreeSubstOffset temptree
                    LibGFX_TreeSubstFramebuffer temptree
                    If LibGFX_MatchPackedFramebuffer(temptree) <> CPtr(Byte Ptr, 0) Then
                        s = "lfb"
                    Else
                        s = space$(608 / 8)
                        s = left$(s, LibGFX_printnode(temptree, *Cptr(Byte Ptr Ptr, @s), 608/8))
                    End If
                    LibGFX_deletemap tempmap
                    LibGFX_freenode temptree

                Case &H14
                    mglSetEngineState(selengine, GFX_PROP_TRANSLATEX, 16)
                    mglSetEngineState(selengine, GFX_PROP_TRANSLATEY, 16)
                    Yield
                    update = 0


                Case Else
                    update = 0

            End Select
            Yield
        Wend

    Wend

End Sub

Sub SetGenericResolution (ByVal connector as Integer)
    Dim signal As Integer, protocol As Integer
    signal = mglGetConnectorState(connector, GFX_PROP_SIGNAL)
    protocol = mglGetConnectorState(connector, GFX_PROP_CONNECTOR_TYPE)

    if (signal = GFX_SIGNAL_RGBHV And protocol = GFX_CONNECTOR_VGA) _
    Or (signal = GFX_SIGNAL_RGBHV And protocol = GFX_CONNECTOR_DVI) Then
        'set VGA standard 640x480 timing
        mglSetConnectorState(0, GFX_PROP_DOT_CLOCK, 25000)
        mglSetConnectorState(0, GFX_PROP_WIDTH, 640)
        mglSetConnectorState(0, GFX_PROP_HEIGHT, 480)
        mglSetConnectorState(0, GFX_PROP_VGA_H_FRONT_PORCH, 40)
        mglSetConnectorState(0, GFX_PROP_VGA_H_BACK_PORCH, 24)
        mglSetConnectorState(0, GFX_PROP_VGA_H_SYNC, 96)
        mglSetConnectorState(0, GFX_PROP_VGA_V_FRONT_PORCH, 10)
        mglSetConnectorState(0, GFX_PROP_VGA_V_BACK_PORCH, 33)
        mglSetConnectorState(0, GFX_PROP_VGA_V_SYNC, 2)
    ElseIf signal = GFX_SIGNAL_INTEGRATED Then
        'integrated display, default to 640x480 for now
        mglSetConnectorState(0, GFX_PROP_WIDTH, 640)
        mglSetConnectorState(0, GFX_PROP_HEIGHT, 480)
    End if
End Sub

Function GetEngineDepth (ByVal engine As Integer) As Integer
    dim sw As Integer, sh As Integer, sb As Integer
    sw = mglGetEngineState(engine, GFX_PROP_STORE_WIDTH)
    sh = mglGetEngineState(engine, GFX_PROP_STORE_HEIGHT)
    sb = mglGetEngineState(engine, GFX_PROP_STORE_BITS)

    Function = 0 ' filter broken engines
    If sw = 0 Then Exit Function
    If sh = 0 Then Exit Function

    Function = -1 ' filter tile engines
    if mglGetEngineState(engine, GFX_PROP_SOURCE_WIDTH) <> 1 Then Exit Function
    if mglGetEngineState(engine, GFX_PROP_SOURCE_HEIGHT) <> 1 Then Exit Function

    Function = sb \ (sw * sh) ' divide bits per block by the block's size (for 16-color and YUV modes)
End Function

Sub DrawCharacter(ByVal character As Integer, ByVal X as integer, ByVal Y as integer, ByVal colour As Integer)
    Dim fo(0 to 63) as Byte
    Dim lpx as integer, lpy as integer
    Dim fd As Unsigned Byte Ptr
    fd = @font0

    for lpx = 0 to 7
        for lpy = 0 to 7
            fo(lpx + 8 * lpy) = ((fd[8*character+lpy] SHR lpx) And 1) * colour
        next lpy
    next lpx
    glTexSubImage2D(GL_BUFFER_2D, 0, X, Y, 8, 8, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, @(fo(0)))
End Sub

Sub DrawString(ByRef text As String, ByVal X As Integer, ByVal Y As Integer, ByVal colour As Integer)
    Dim lp As Integer, length As Integer, xcoord As Integer
    length = len(text)
    xcoord = X
    For lp = 1 to length
        DrawCharacter asc(mid$(text, lp, 1)), xcoord, Y, colour
        xcoord = xcoord + 8
    Next lp
End Sub

Sub FixPalette(ByVal selengine As Integer, ByVal bpp As Integer)
    Dim pallette As Integer
    pallette = mglGetEngineState(selengine, GFX_PROP_PALETTE)
    If pallette <> 0 Then
        glBindBufferUDI(GL_BUFFER_2D, pallette)
        Dim rs As String
        rs = ""
        
        If bpp = 4 Then
            ' IRGB format

            rs = chr$(0)   +chr$(0)   + chr$(0)    +  chr$(0)   +chr$(0)   +chr$(&HAA)  +  chr$(0)   +chr$(&HAA)+chr$(0)     +  chr$(0)   +chr$(&HAA)+chr$(&HAA) + _
                 chr$(&HAA)+chr$(0)   + chr$(0)    +  chr$(&HAA)+chr$(0)   +chr$(&HAA)  +  chr$(&HAA)+chr$(&HAA)+chr$(0)     +  chr$(&HAA)+chr$(&HAA)+chr$(&HAA) + _
                 chr$(&H55)+chr$(&H55)+chr$(&H55)  +  chr$(&H55)+chr$(&H55)+chr$(&HFF)  +  chr$(&H55)+chr$(&HFF)+chr$(&H55)  +  chr$(&H55)+chr$(&HFF)+chr$(&HFF) + _
                 chr$(&HFF)+chr$(&H55)+chr$(&H55)  +  chr$(&HFF)+chr$(&H55)+chr$(&HFF)  +  chr$(&HFF)+chr$(&HFF)+chr$(&H55)  +  chr$(&HFF)+chr$(&HFF)+chr$(&HFF)

            glTexSubImage2D(GL_BUFFER_2D, 0, 0, 0, 16, 1, GL_RGB, GL_UNSIGNED_BYTE, *Cptr(Byte Ptr Ptr, @rs))
        Else
            Dim lp As Integer
            For lp = 0 to 255
                ' fixme: assumes 256-entry DAC
                Dim cr as Integer, cg as Integer, cb as Integer
                cr = (lp And &HE0) SHR 5
                cg = (lp And &H1C) SHR 2
                cb = (lp And &H03)
    
                cr = (255 * cr) \ 7
                cg = (255 * cg) \ 7
                cb = (255 * cb) \ 3
    
                rs = rs + chr$(cr) + chr$(cg) + chr$(cb)
                
                If (lp Mod 16) = 15 Then
                    glTexSubImage2D(GL_BUFFER_2D, 0, lp - 15, 0, 16, 1, GL_RGB, GL_UNSIGNED_BYTE, *Cptr(Byte Ptr Ptr, @rs))
                    rs = ""
                End If
            Next lp
        End If
    End If
End Sub
