' Summary: gfxtest.bas
' Test graphics mode and rendering stuff
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos.bi"
#include "mos/drivercom.bi"
#include "mos/gfx.bi"
#include "GL/gl.bi"

Declare Sub _gl_setoutput CDecl Alias "_gl_setoutput"(ByVal buffer As Byte Ptr, ByVal w As Integer, ByVal h As Integer, ByVal pitch As Integer)
Declare Sub _gl_inittextures CDecl Alias "_gl_inittextures" ()

Declare Sub PushCube

Sub modmain CDecl Alias "main"()

    drv_setname(0, &HB1FF)

    Dim i As Integer
    ' Fixme: really ugly
    For i = 0 To 100
        Yield
    Next i

    Dim m(0 to 4) as Integer
    Dim rr as single
    rr = 60
    m(0) = GFXCOMMAND_SETLINEARMODE
    m(1) = 640
    m(2) = 480
    m(3) = PF_R8G8B8X8
    m(4) = *CPtr(Integer Ptr, @rr)

    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, &HE0000000))
    BlockAllocPhysL(1, CPtr(Byte Ptr, &H60000000), CPtr(Byte Ptr, &HE0000000))

    drv_sendmessage(DRIVER_VO * &H10000 + 1, 20, CPtr(Byte Ptr, @(m(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    drv_readmessage(CPtr(Byte Ptr, @(m(0))) )

    '*CPtr(Integer Ptr,&H60006100) = &H0080FF80

    _gl_setoutput(CPtr(Byte Ptr,&H60000000), 640, 480, 640*4)
    _gl_inittextures

    glViewport(0,0,640,480)
    glScissor(50,50,540,380)

    '*CPtr(Integer Ptr,&H60006120) = &H0080FF80

    glClearColor(0,0,0.25,0)
    '*CPtr(Integer Ptr,&H60006140) = &H0080FF80

    glClear(GL_COLOR_BUFFER_BIT)
    '*CPtr(Integer Ptr,&H60006160) = &H0080FF80

    Dim colors() As Unsigned Byte
    redim colors(1024)

    Dim lpx As Integer, lpy As Integer, p As Single
    for lpy = 0 to 15
    for lpx = 0 to 15
        p = 4 * cos(3.14 * CSng(lpx) / 8) + 7.5
        p = (lpy - p) * (lpy - p) * 16
        if p > 255 then p = 255
        colors(4 * lpx + 16*4*lpy + 0) = 255
        colors(4 * lpx + 16*4*lpy + 1) = p
        colors(4 * lpx + 16*4*lpy + 2) = 0
        colors(4 * lpx + 16*4*lpy + 3) = 0
    next lpx
    next lpy

    glTexImage2D(GL_TEXTURE_2D, 0, 4, 16, 16, 0, GL_RGBA, GL_UNSIGNED_BYTE, CPtr(Byte Ptr, @(colors(0)) ) )

    glLoadIdentity
    'glRotatef(50, 0, 0, 1)
    'glTranslatef(200, 20, 0)

    glMatrixMode(GL_PROJECTION)
'    glLoadIdentity
    glFrustum(-0.64,0.64,-0.48,0.48,0.5,10)
    glMatrixMode(GL_MODELVIEW)

    glDisable(GL_TEXTURE_2D)
    glEnable(GL_SCISSOR_TEST)
    glEnable(GL_CULL_FACE)
    glColor3f(1,0,0)
    glBegin(GL_TRIANGLES)
        glColor3f(1,0,0)
        glVertex3f(-1, 1, -1)
        glColor3f(0,1,0)
        glVertex3f(0, -1, -1)
        glColor3f(0,0,1)
        glVertex3f(-1, -1, -1)

        glColor3f(1,0,0)
        glVertex3f(1, 1, -1)
        glColor3f(0,1,0)
        glVertex3f(0, -1, -1)
        glColor3f(0,0,1)
        glVertex3f(1, -1, -1)

        glColor3f(1,0,0)
        glVertex3f(0.8, 1, -1)
        glColor3f(0,1,0)
        glVertex3f(-0.8, 1, -1)
        glColor3f(0,0,1)
        glVertex3f(0, -0.6, -1)
    glEnd

    glEnable(GL_TEXTURE_2D)
    glDisable(GL_SCISSOR_TEST)
    glDisable(GL_CULL_FACE)

    glTranslatef(0,0,-4)
    glRotatef(-45,0,1,0)
    glRotatef(45,1,0,0)
    PushCube

    glLoadIdentity
    glTranslatef(5,5,-9)
    glRotatef(-65,0,1,0)
    glRotatef(60,1,0,0)
    PushCube

    glLoadIdentity
    glTranslatef(-4,3,-7)
    glRotatef(-35,0,1,0)
    glRotatef(70,1,0,0)
    PushCube

    glLoadIdentity
    glTranslatef(-1,-6,-9)
    glRotatef(-40,0,1,0)
    glRotatef(30,1,0,0)
    PushCube

End Sub

Sub PushCube

    glColor3f(1,1,1)
    glEnable(GL_TEXTURE_2D)
    glBegin(GL_TRIANGLES)
        glTexCoord2f(0,0)
        glVertex3f(1, 1, 1)
        glTexCoord2f(2,0)
        glVertex3f(1, -1, 1)
        glTexCoord2f(0,2)
        glVertex3f(-1, 1, 1)

        glTexCoord2f(2,0)
        glVertex3f(1, -1, 1)
        glTexCoord2f(0,2)
        glVertex3f(-1, 1, 1)
        glTexCoord2f(2,2)
        glVertex3f(-1, -1, 1)
    glEnd

    glDisable(GL_TEXTURE_2D)
    glBegin(GL_TRIANGLES)
        glColor3f(1,0,0)
        glVertex3f(1, -1, 1)
        glColor3f(0,1,0)
        glVertex3f(1, 1, 1)
        glColor3f(0,0,1)
        glVertex3f(1, -1, -1)

        glColor3f(0,1,0)
        glVertex3f(1, 1, 1)
        glColor3f(0,0,1)
        glVertex3f(1, -1, -1)
        glColor3f(1,1,1)
        glVertex3f(1, 1, -1)
    glEnd

    glColor3f(0.5,0.2,1)
    glBegin(GL_TRIANGLES)
        glVertex3f(1, 1, 1)
        glVertex3f(-1, 1, 1)
        glVertex3f(1, 1, -1)

        glVertex3f(-1, 1, 1)
        glVertex3f(1, 1, -1)
        glVertex3f(-1, 1, -1)
    glEnd
End Sub