' Summary: hwbrowse.bas
' Text-based Hardware Browser
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "mos.bi"
#include "mos/drivercom.bi"

Declare Sub PrintString (s As String, offset as long = 0, colour as byte = &H17)
Declare Sub ClearScreen()
Declare Sub DrawWindow(sx as integer, sy as integer, w as integer, h as integer, colour As Byte)

Declare Sub MainWindow()

Declare Function ReadKey() As Byte
Declare Function ReadKeyboard () As Unsigned Byte
Declare Sub InitKeyboard()

Dim Shared cram As Byte Ptr

Sub modmain CDecl Alias "main" ()

    cram = CPtr(Byte Ptr, &HB8000)
    BlockAllocPhys(8, cram, cram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    InitKeyboard()

    ClearScreen

    DrawWindow(25, 12, 30, 1, &H1F)
    PrintString "Connecting to device manager", 12 * 160 + 52, CByte(&H9F)

    Yield

    Dim rv as integer

    drv_setname(0, &Hbeef)
    Dim i(0 to 1) As Integer

    ' test device create
    'i(0) = &H53494350
    'i(1) = &H20565245
    'drv_sendmessage(DRIVER_MGR * &H10000 + 2, 8, CPtr(Byte Ptr, @(i(0))) )
    'rv = 0
    'while rv = 0
    '    Yield
    '    rv = drv_peekmessage()
    'wend
    'drv_readmessage(CPtr(Byte Ptr, @(i(0)) ))

    ' Send initial browse command
    i(0) = 1
    i(1) = 0
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(i(0))) )


    rv = 0
    while rv = 0
        Yield
        rv = drv_peekmessage()
    wend

    ClearScreen
    PrintString "MOS Hardware Browser", 24 * 160, &H0E
    Yield
    MainWindow

End Sub

Sub MainWindow()
    Dim nodenumber As Integer
    nodenumber = 0

    While 1 = 1


        DrawWindow 2, 2, 30, 20, &H1E
        Dim msgsize As Integer

        msgsize = drv_peekmessage()
        Dim nodes() As Integer
        ReDim nodes(msgsize \ 4 + 1)

        drv_readmessage(CPtr(Byte Ptr, @(nodes(0)) ))

        Dim icount As Integer
        Dim ipos As Integer

        PrintString "Device " & nodenumber, 2 * 160 + 3 * 2, &H1F

        PrintString Chr$(16), 6 * 160 + 3 * 2, &H1D
        icount = nodes(0)
        for ipos = 1 to icount
            Dim i(0 to 1) as Integer
            i(0) = 2
            i(1) = nodes(ipos)
            drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(i(0))) )

            Dim rs As String
            Dim isize As Integer
            isize = 0
            While isize = 0
                isize = drv_peekmessage()
                If isize = 0 then Yield
            Wend
            rs = space$(isize)
            Dim myptr As Byte Ptr
            myptr = *CPtr(Byte Ptr Ptr, @rs)
            drv_readmessage(myptr)

            PrintString "(" & nodes(ipos) & ") " & rs, (6 + ipos) * 160 + 10, &H1E
        next ipos
        ipos = 0

        PrintString "Home", 4 * 160 + 5 * 2, &H1E
        PrintString "Refresh", 5 * 160 + 5 * 2, &H1E
        PrintString "Properties", 6 * 160 + 5 * 2, &H1E

        Dim curnumber As Integer
        curnumber = nodenumber
        While curnumber = nodenumber
            Dim keyindex As Integer
            Yield
            keyindex = ReadKeyboard
            Select Case keyindex
                Case &H1C
                    If ipos = -2 Then
                        nodenumber = 0
                        curnumber = -1
                    ElseIf ipos = -1 Then
                        curnumber = -1
                    ElseIf ipos > 0 Then
                        nodenumber = nodes(ipos)
                        curnumber = -1
                    Else

                    End If
                    'PrintString str$(curnumber) & " " & str$(nodenumber) & "   ", 23 * 160 + 120, &H07

                Case &H48
                    PrintString Chr$(32), (6+ipos) * 160 + 3 * 2, &H1D
                    if ipos = -2 then
                        ipos = icount
                    else
                        ipos = ipos - 1
                    end if
                    PrintString Chr$(16), (6+ipos) * 160 + 3 * 2, &H1D

                Case &H50
                    PrintString Chr$(32), (6+ipos) * 160 + 3 * 2, &H1D
                    if ipos = icount then
                        ipos = -2
                    else
                        ipos = ipos + 1
                    end if
                    PrintString Chr$(16), (6+ipos) * 160 + 3 * 2, &H1D

                Case 0
                Case Else
                    PrintString Hex$(keyindex) & "  ", 24 * 160 + 120, &H07
            End Select
        Wend

        Redim nodes(2)
        nodes(0) = 1
        nodes(1) = nodenumber
        drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(nodes(0))) )

        While drv_peekmessage() = 0
            Yield
        Wend

    Wend

End Sub




' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Sub PrintString (s As String, offset as long = 0, colour as byte = &H17)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        cram[lp * 2 - 2 + offset] = ch
        cram[lp * 2 - 1 + offset] = colour
    Next lp
End Sub

Sub ClearScreen()
    Dim lp As Long
    For lp = 0 to 160 * 25 - 1 Step 2
        cram[lp] = 32
        cram[lp+1] = &H07
    Next lp
End Sub

Sub DrawWindow(sx as integer, sy as integer, w as integer, h as integer, colour As Byte)
    Dim lpx as long
    Dim lpy as long

    for lpy = sy - 1 to sy + h
    for lpx = sx - 1 to sx + w
        cram[2*lpx + 160*lpy] = 0
        cram[2*lpx + 160*lpy + 1] = colour
    next lpx
    next lpy

    for lpx = sx to sx + w
        cram[2*lpx + 160 * (sy - 1)] = CByte(&HCD)
        cram[2*lpx + 160 * (sy+h)] = CByte(&HCD)
    next lpx
    for lpy = sy to sy + h
        cram[2*sx-2   + 160 * lpy] = CByte(&HBA)
        cram[2*sx+2*w + 160 * lpy] = CByte(&HBA)
    next lpy

    cram[2 * sx + 160 * sy - 162] = CByte(&HC9)
    cram[2 * (sx+w) + 160 * sy - 160] = CByte(&HBB)
    cram[2 * sx + 160 * (sy+h) - 2] = CByte(&HC8)
    cram[2 * (sx+w) + 160 * (sy+h)] = CByte(&HBC)

End Sub
