' Summary: igma.bas
' Testing module for Intel GMCH (965)
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "../gfx/vga_io.bi"
#include "mos.bi"
#include "x86.bi"
#include "mos/pci.bi"

Declare Sub ModMain Cdecl Alias "main" ()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
Declare Function GetYesNo () As Integer
Declare Function ReadKB () as Integer
Declare Sub ClearCon (vram As Byte Ptr)
Declare Function MCH_PCIProbe(ByRef base_lfb As Long, ByRef base_pio As Integer, ByRef mmiobase As Long, ByRef pci_bus As Integer, ByRef pci_dev As Integer, ByRef pci_fn As Integer) As Long
Declare Function GMA_PCIProbe(ByRef base_lfb As Long, ByRef base_pio As Integer, ByRef mmiobase As Long, ByRef pci_bus As Integer, ByRef pci_dev As Integer, ByRef pci_fn As Integer) As Long

Declare Sub WriteLfbString(lfb As Byte Ptr, s as String, offset as Long)
Declare Sub PutPixel(vram As Byte Ptr, x As Long, y As Long, col As Long, bpp As Byte, pitch As Long)
Declare Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
Declare Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
Declare Sub WriteConioString(vram As Byte Ptr, s as String, font() As Byte, row As Long, column As Long, col As Long, bpp as Byte, vw As Long)
Declare Sub RenderTest(vram as Byte Ptr, w as long, h as long, bpp as byte, vw as long)

Declare Function OverrideGraphics(board_model As Long, portbase As Long, mmiobase As Long, pci_bus As Integer, pci_dev As Integer, pci_fn As Integer) As Integer
Declare Sub TestGMA(board_model As Long, board_version As Long, lfb As Long, portbase As Long, mmiobase As Long, pci_bus As Integer, pci_dev As Integer, pci_fn As Integer)


Public Sub ModMain Cdecl Alias "main" ()
    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    Dim bios As Byte Ptr
    Dim vaddress as Byte Ptr

    vaddress = CPtr(Byte Ptr, &HA0000)
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    bios = CPtr(Byte Ptr, &HC0000)

    '*cptr(Byte Ptr, &HE11000A) = 0

    blockallocphys(64, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    PortAlloc(&HCF8, 8)
    PortAlloc(&H3C0, 32)
    PortAlloc(&H60, 2)

    Dim lfb as Long
    Dim portbase as Long
    Dim mmiobase as Long

    Dim chiptype as Long
    Dim chipsubtype as Long
    Dim bioshash as Long
    Dim lp as Long
    Dim devname As String

    ClearCon cram
    PrintString "BASIC For teh win (>O.O)>", cram, 25 * 80 - 27

    PrintString "Intel GMCH/GMA test program", cram, 0
    PrintString "Searching PCI device list for a compatible intel chipset...", cram, 80

    Dim mchbus As Integer, mchdev As Integer, mchfn As Integer

    chiptype = MCH_PCIProbe(lfb, portbase, mmiobase, mchbus, mchdev, mchfn)
    PrintString "Hashing BIOS...", cram, 160
    bioshash = 0
    for lp = 0 to 32767
        bioshash = bioshash + ((16381 * lp + 1) * CLng(bios[lp]))
    next lp
    PrintString "Probe 1 result: " + hex$(chiptype), cram, 240
    If chiptype > 0 Then

        Select case chiptype

            Case &H1130
                devname = "[815] 82815 CHB/MCH"
                chipsubtype = 815
            Case &H2578
                devname = "[875] 82875 MCH"
                chipsubtype = 875
            Case &H2580
                devname = "[91x] 82915G/P/GV/GL/PL or 82910GL MCH"
                chipsubtype = 915
            Case &H2578
                devname = "[925] 82925X/82925XE MCH"
                chipsubtype = 925
            Case &H2770
                devname = "[945] 82945G/GZ/P/PL MCH"
                chipsubtype = 945
            Case &H2774
                devname = "[955] 82955X MCH"
                chipsubtype = 955
            Case &H277C
                devname = "[975] 82975X MCH"
                chipsubtype = 975
            Case &H27A0
                devname = "[945] Mobile 945 MCH"
                chipsubtype = 945
            Case &H27AC
                devname = "[945] Mobile 945GME MCH"
                chipsubtype = 945
            Case &H2970
                devname = "[946] 82946GZ/PL/GL MCH"
                chipsubtype = 946
            Case &H2990
                devname = "[963] 82Q963/82Q965 MCH"
                chipsubtype = 963
            Case &H29A0
                devname = "[965] 82P965/82G965 MCH"
                chipsubtype = 965
            Case &H2A00
                devname = "[960] Mobile 965/960 MCH"
                chipsubtype = 960
            Case &H2A10
                devname = "[960] Mobile 965/960 MCH"
                chipsubtype = 960
            Case &H7120
                devname = "[810] 82810 GMCH"
                chipsubtype = 810
            Case &H7122
                devname = "[810] 82810 DC-100 GMCH"
                chipsubtype = 810
            Case &H7124
                devname = "[810] 82810E DC-133 GMCH"
                chipsubtype = 810

            Case Else
                devname = "Unknown (0x" + hex$(chiptype) + ")"
                chipsubtype = 800

        End Select

        PrintString "Chipset Model: " + devname, cram, 400

        PrintString "Port Base:   0x" + hex$(portbase), cram, 480
        PrintString "MMIO Base:   0x" + hex$(mmiobase), cram, 560

        PrintString "Enable GMA if disabled? (Y/N)", cram, 640

        If GetYesNo() = 1 Then
            OverrideGraphics(chipsubtype, portbase, mmiobase, mchbus, mchdev, mchfn)
        End If
        ReadKB
    End If


    Dim d2f0 As Integer, d2f1 As Integer, gmabus As Integer, gmadev As Integer, gmafn As Integer

    d2f0 = PCI_type1_readword(0, 2, 0, 2)
    d2f1 = PCI_type1_readword(0, 2, 1, 2)

    chiptype = GMA_PCIProbe(lfb, portbase, mmiobase, gmabus, gmadev, gmafn)
    PrintString "Probe 2 result: " + hex$(chiptype) + " (0x" + hex$(d2f0) + ", 0x" + hex$(d2f1) + ")", cram, 800

    if chiptype > 0 Then

        Select case chiptype
            Case &H2772
                devname = "[945] 82945G/GZ Integrated Graphics"
                chipsubtype = 945
            Case &H2776
                devname = "[945] 82945G/GZ Integrated Graphics"
                chipsubtype = 945
            Case &H27A2
                devname = "[940] Mobile 945/943/940 Integrated Graphics"
                chipsubtype = 940
            Case &H27AE
                devname = "[945] Mobile 945GME Integrated Graphics"
                chipsubtype = 945

            Case Else
                devname = "Unknown (0x" + hex$(chiptype) + ")"
                chipsubtype = 800

        End Select

        PrintString "GMA Model: " + devname, cram, 880

        PrintString "Port Base:   0x" + hex$(portbase), cram, 960
        PrintString "MMIO Base:   0x" + hex$(mmiobase), cram, 1040
        PrintString "LFB Base:    0x" + hex$(lfb), cram, 1120

        PrintString "Press Y to start the test at your hardware's peril", cram, 1200
        PrintString "Press N to skip this test", cram, 1280

        If GetYesNo() = 1 Then
            TestGMA(chiptype, chipsubtype, lfb, portbase, mmiobase, gmabus, gmadev, gmafn)
        End If

        ReadKB

        ClearCon cram
        PrintString "Test Ended. Please hit the power or the reset button", cram, 0

        ClearCon cram
        PrintString "Test Ended. Please hit the power or the reset button", cram, 0

    Else
        PrintString "No intel chipset found", cram, 880
        PrintString "Test Ended. Please hit the power or the reset button", cram, 960
    End if
    While 1 = 1

    Wend

End Sub

Public Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + 2 * offset] = ch
        vram[lp * 2 - 1 + 2 * offset] = 7
    Next lp

End Sub

Public Function GetYesNo () As Integer
    ' Y = &H15
    ' N = &H31

    Dim status As Integer = -1
    Dim key As Integer
    While status = -1
        key = ReadKB
        if key = &H15 then status = 1
        if key = &H31 then status = 0
    Wend
    GetYesNo = status
End Function

Public Function ReadKB () as Integer
    Dim temp as Unsigned Byte
    Dim key as Unsigned Byte
    Dim breakexit as Unsigned Byte = 0
    Dim done as Unsigned Byte = 0
    Dim isescaped as Unsigned Byte = 0
    While done = 0
        key = inportb(&H60)
        temp = inportb(&H61)
        outportb(&H61,temp Or  &H80)    'disable
        outportb(&H61,temp And &H7F)    'and reenable
        If key = &HE0 Then
            isescaped = &H80
        ElseIf key > &H80 Then
            If key = breakexit Then
                done = 1
            Else
                breakexit = 0
                isescaped = 0
            End If
        Else
            breakexit = key or &H80
            ReadKB = key or isescaped
        End If
    Wend
End Function

Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub

Function MCH_PCIProbe(ByRef base_lfb As Long, ByRef base_pio As Integer, ByRef mmiobase As Long, ByRef pci_bus As Integer, ByRef pci_dev As Integer, ByRef pci_fn As Integer) As Long

    base_lfb = 0
    base_pio = 0

    Dim lp as long, bus as long, dev as long, fn as long
    Dim lastdevice as Unsigned Short
    Dim mybus as long, mydev as long, myfn as long
    Dim vendor as Unsigned Short, myvendor as unsigned short
    Dim device as Unsigned Short, mydevice as unsigned short
    Dim atidev as Unsigned Short

    mybus = -1
    atidev = &HFFFF
    lastdevice = &HFFFF
    lp = 0
    For bus = 0 to 2
        For dev = 0 to 31
            For fn = 0 to 7
                vendor = PCI_type1_readword(bus, dev, fn, 0)
                device = PCI_type1_readword(bus, dev, fn, 2)
                If vendor = &H8086 And (   _
                        device = &H2770 Or _
                        device = &H2774 Or _
                        device = &H27A0 Or _
                        device = &H27AC Or _
                        device = &H2970 Or _
                        device = &H2990 Or _
                        device = &H29A0 Or _
                        device = &H2A00 Or _
                        device = &H2A10 Or _
                        device = &H7120 Or _
                        device = &H7122 Or _
                        device = &H7124 Or _
                        device = &H1130 Or _
                        device = &H2580 Or _
                        device = &H2584 Or _
                        device = &H2578 )  Then
                    mybus = bus
                    mydev = dev
                    myfn = fn
                    pci_bus = bus
                    pci_dev = dev
                    pci_fn = fn
                    myvendor = vendor
                    mydevice = device
                    exit for
                End If
            Next fn
        Next dev
    Next bus

    if mybus = -1 Then
        function = -1
        exit function
    end if

    Dim bar as Unsigned Long, barmask As Unsigned Long

    For lp = 5 to 0 step -1
        barmask = PCI_bar_readmask(mybus,mydev,myfn, lp)
        bar = PCI_bar_readaddress(mybus,mydev,myfn, lp)

        If bar = 0 then

        Elseif (barmask and &H1) = 1 Then
            base_pio = bar and &HFFF8&
        Elseif ((barmask and &HFFFF0) = 0) And (base_lfb = 0) then
            base_lfb = bar
        Else
            mmiobase = bar
        End If
    Next lp

    function = mydevice

End Function

Function OverrideGraphics(board_model As Long, portbase As Long, mmiobase As Long, pci_bus As Integer, pci_dev As Integer, pci_fn As Integer) As Integer
    Dim cram As Byte Ptr
    cram = CPtr(Byte Ptr, &HB8000)

    Dim msg As String

    Function = 0

    Select Case board_model
        Case 945
            msg = "i945 - "
            msg = msg & " GCC: 0x" & hex$(PCI_type1_readword(pci_bus, pci_dev, pci_fn, &H52))
            msg = msg & " DEVEN: 0x" & hex$(PCI_type1_readdword(pci_bus, pci_dev, pci_fn, &H54))
            msg = msg & " SMRAM: 0x" & hex$(PCI_type1_readbyte(pci_bus, pci_dev, pci_fn, &H9D))

            Dim deven as Long, gcc As Long
            deven = PCI_type1_readdword(pci_bus, pci_dev, pci_fn, &H54)
            deven = deven or &H00000018
            PCI_type1_writedword(pci_bus, pci_dev, pci_fn, &H54, deven)

            gcc = PCI_type1_readword(pci_bus, pci_dev, pci_fn, &H52)
            gcc = gcc And &HFFFFFFFE
            PCI_type1_writedword(pci_bus, pci_dev, pci_fn, &H50, gcc * &H10000)

            msg = msg & " GCC2: 0x" & hex$(PCI_type1_readword(pci_bus, pci_dev, pci_fn, &H52))
            msg = msg & " DEVEN2: 0x" & hex$(PCI_type1_readdword(pci_bus, pci_dev, pci_fn, &H54))
            msg = msg & " SMRAM2: 0x" & hex$(PCI_type1_readbyte(pci_bus, pci_dev, pci_fn, &H9D))

            ' 02 03 1A
            PrintString msg, cram, 720

        Case Else
            PrintString "(G)MCH unsupported", cram, 720
    End Select

End Function

Public Function GMA_PCIProbe(ByRef base_lfb As Long, ByRef base_pio As Integer, ByRef mmiobase As Long, ByRef pci_bus As Integer, ByRef pci_dev As Integer, ByRef pci_fn As Integer) As Long

    base_lfb = 0
    base_pio = 0

    Dim lp as long, bus as long, dev as long, fn as long
    Dim lastdevice as Unsigned Short
    Dim mybus as long, mydev as long, myfn as long
    Dim vendor as Unsigned Short, myvendor as unsigned short
    Dim device as Unsigned Short, mydevice as unsigned short
    Dim atidev as Unsigned Short

    mybus = -1
    atidev = &HFFFF
    lastdevice = &HFFFF
    lp = 0
    For bus = 0 to 2
        For dev = 0 to 31
            For fn = 0 to 7
                vendor = PCI_type1_readword(bus, dev, fn, 0)
                device = PCI_type1_readword(bus, dev, fn, 2)
                If vendor = &H8086 And (   _
                        device = &H2772 Or _
                        device = &H2776 Or _
                        device = &H27A2 Or _
                        device = &H27AE )  Then
                    mybus = bus
                    mydev = dev
                    myfn = fn
                    pci_bus = bus
                    pci_dev = dev
                    pci_fn = fn
                    myvendor = vendor
                    mydevice = device
                    exit for
                End If
            Next fn
        Next dev
    Next bus

    if mybus = -1 Then
        function = -1
        exit function
    end if

    Dim bar as Unsigned Long, barmask As Unsigned Long

    For lp = 5 to 0 step -1
        barmask = PCI_bar_readmask(mybus,mydev,myfn, lp)
        bar = PCI_bar_readaddress(mybus,mydev,myfn, lp)

        If bar = 0 then

        Elseif (barmask and &H1) = 1 Then
            base_pio = bar and &HFFF8&
        Elseif ((barmask and &HFFFF0) = 0) And (base_lfb = 0) then
            base_lfb = bar
        Else
            mmiobase = bar
        End If
    Next lp

    function = mydevice

End Function

Sub PutPixel(vram As Byte Ptr, x As Long, y As Long, col As Long, bpp As Byte, pitch As Long)
    Dim offset As Long
    Select case bpp
        Case 4
            Dim temp as Byte
            offset = x \ 2 + y * pitch
            If (x And &H1) = 1 Then
                temp = vram[offset] and &HF
                vram[offset] = temp + 16 * (col and &HF)
            Else
                temp = vram[offset] and &HF0
                vram[offset] = temp + (col and &HF)
            End If

        Case 8
            offset = x + y * pitch
            vram[offset] = CByte(col)

        Case 16
            offset = 2 * x + pitch
            Dim mempos as Short Ptr
            mempos = CPtr(Short Ptr, @vram[offset])
            mempos[0] = CShort(col)

        Case 32
            offset = 4 * x + pitch
            Dim mempos as Long Ptr
            mempos = CPtr(Long Ptr, @vram[offset])
            mempos[0] = col

    End Select
End Sub

Sub WriteLfbString(lfb As Byte Ptr, s as String, offset as Long)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        lfb[lp * 8 - 8 + 8 * offset] = ch
        lfb[lp * 8 - 7 + 8 * offset] = &H1F
    Next lp
End Sub

Sub WriteConioString(vram As Byte Ptr, s as String, font() As Byte, row As Long, column As Long, col As Long, bpp as Byte, vw As Long)
    WriteGfxString vram, s, @font(0), column * 8, row * 16, col, bpp, vw
End Sub

Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
    Dim lp as long
    For lp = 1 to len(s)
        WriteGfxChar vram, asc(mid$(s,lp,1)), font, x + 8 * (lp - 1), y, col, bpp, vw
    next lp
End Sub
Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
    dim lp as long
    Dim fontbyte as byte
    For lp = 0 to 15
        fontbyte = font[32 * ch + lp]
        if (fontbyte and &H01) = &H01 then PutPixel vram, x + 7, y + lp, col, bpp, vw
        if (fontbyte and &H02) = &H02 then PutPixel vram, x + 6, y + lp, col, bpp, vw
        if (fontbyte and &H04) = &H04 then PutPixel vram, x + 5, y + lp, col, bpp, vw
        if (fontbyte and &H08) = &H08 then PutPixel vram, x + 4, y + lp, col, bpp, vw
        if (fontbyte and &H10) = &H10 then PutPixel vram, x + 3, y + lp, col, bpp, vw
        if (fontbyte and &H20) = &H20 then PutPixel vram, x + 2, y + lp, col, bpp, vw
        if (fontbyte and &H40) = &H40 then PutPixel vram, x + 1, y + lp, col, bpp, vw
        if (fontbyte and &H80) = &H80 then PutPixel vram, x + 0, y + lp, col, bpp, vw
    Next lp
End Sub

Sub RenderTest(vram as Byte Ptr, w as long, h as long, bpp as byte, vw as long)
    Dim lpx as long, lpy as long
    For lpx = 1 To w - 1 Step 2
        PutPixel vram, lpx, 0, 9, bpp, vw
        PutPixel vram, lpx, 1, 9, bpp, vw
        If lpx mod 10 = 9 then
            PutPixel vram, lpx, 2, 9, bpp, vw
        End If
        If lpx mod 40 = 39 then
            PutPixel vram, lpx, 3, 9, bpp, vw
        End If
        PutPixel vram, lpx, h-1, 9, bpp, vw
        PutPixel vram, lpx, h-2, 9, bpp, vw
    Next lpx
    For lpy = 1 To h - 1 Step 2
        PutPixel vram, 0, lpy, 9, bpp, vw
        PutPixel vram, 1, lpy, 9, bpp, vw

        PutPixel vram, w-1, lpy, 9, bpp, vw
        PutPixel vram, w-2, lpy, 9, bpp, vw

        If lpy mod 10 = 9 then
            PutPixel vram, w-3, lpy, 9, bpp, vw
        End If
        If lpy mod 40 = 39 then
            PutPixel vram, w-4, lpy, 9, bpp, vw
        End If
    Next lpy
End Sub


Sub TestGMA(board_model As Long, board_version As Long, lfb As Long, portbase As Long, mmiobase As Long, pci_bus As Integer, pci_dev As Integer, pci_fn As Integer)
    Dim vaddress as Byte Ptr
    Dim vram as Unsigned Byte Ptr
    Dim mmio As Unsigned Integer Ptr

    Dim lp as long
    Dim ws as String, ws2 as String

    Dim cram As Byte Ptr
    cram = CPtr(Byte Ptr, &HB8000)

    ' claim board-specific addresses

    vram = CPtr(Unsigned Byte Ptr, &HB0000000)
    mmio = CPtr(Unsigned Integer Ptr, &HB8000000)

    PrintString "1", cram, 60

    vaddress = CPtr(Byte Ptr, mmiobase)
    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), vaddress)
    PrintString "4", cram, 66
    BlockAllocPhysL(1, CPtr(Byte Ptr, mmio), vaddress)
    PrintString "5", cram, 68

    vaddress = CPtr(Byte Ptr, lfb)
    'ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), vaddress)
    PrintString "2", cram, 62
    BlockAllocPhysL(1, CPtr(Byte Ptr, vram), vaddress)
    PrintString "3", cram, 64

    portalloc portbase, &H100
    PrintString "6", cram, 70

    mmio = CPtr(Unsigned Integer Ptr, &HB8000000 + (mmiobase and &H003FF000))

    PrintString "7", cram, 72

    ReadKB

    ClearCon cram

    PrintString "PIPEACONF: 0x" & hex$(mmio[&H70008 \ 4]) &", PIPEBCONF: 0x" & hex$(mmio[&H71008 \ 4]), cram, 0
    PrintString "PIPEASTAT: 0x" & hex$(mmio[&H70024 \ 4]) &", PIPEBSTAT: 0x" & hex$(mmio[&H71024 \ 4]), cram, 80
    PrintString "PIPEAFPIX: 0x" & hex$(mmio[&H70044 \ 4]) &", PIPEBFPIX: 0x" & hex$(mmio[&H71044 \ 4]), cram, 160
    PrintString "DSPACNTR: 0x"  & hex$(mmio[&H70180 \ 4]) &", DSPBCNTR: 0x"  & hex$(mmio[&H71180 \ 4]), cram, 240

    PrintString "VGACNTRL: 0x" & hex$(mmio[&H71400 \ 4]), cram, 320
    PrintString "DSPALINOFF: 0x"  & hex$(mmio[&H70184 \ 4]) & ", DSPBLINOFF: 0x"  & hex$(mmio[&H71184 \ 4]), cram, 400

    PrintString "HTOTAL_A: 0x" & hex$(mmio[&H60000 \ 4]) &", HTOTAL_B: 0x" & hex$(mmio[&H61000 \ 4]), cram, 480
    PrintString "HBLANK_A: 0x" & hex$(mmio[&H60004 \ 4]) &", HBLANK_B: 0x" & hex$(mmio[&H61004 \ 4]), cram, 560
    PrintString "HSYNC_A: 0x"  & hex$(mmio[&H60008 \ 4]) &", HSYNC_B: 0x"  & hex$(mmio[&H61008 \ 4]), cram, 640
    PrintString "VTOTAL_A: 0x" & hex$(mmio[&H6000C \ 4]) &", VTOTAL_B: 0x" & hex$(mmio[&H6100C \ 4]), cram, 720
    PrintString "VBLANK_A: 0x" & hex$(mmio[&H60010 \ 4]) &", VBLANK_B: 0x" & hex$(mmio[&H61010 \ 4]), cram, 800
    PrintString "VSYNC_A: 0x"  & hex$(mmio[&H60014 \ 4]) &", VSYNC_B: 0x"  & hex$(mmio[&H61014 \ 4]), cram, 880


    ' Try to move the display
    ReadKB
    mmio[&H70184 \ 4] = mmio[&H70184 \ 4] + 512
    mmio[&H71184 \ 4] = mmio[&H71184 \ 4] + 512
    ReadKB
    mmio[&H70184 \ 4] = mmio[&H70184 \ 4] - 512
    mmio[&H71184 \ 4] = mmio[&H71184 \ 4] - 512
    ReadKB

    ' disable VGA mode
    mmio[&H71400 \ 4] = mmio[&H71400 \ 4] Or &H80000000
    ReadKB

    ' enable plane A and B
    mmio[&H70180 \ 4] = mmio[&H70180 \ 4] Or &H80000000
    mmio[&H71180 \ 4] = mmio[&H71180 \ 4] Or &H80000000
    ReadKB

    ' fill framebuffer
    For lp = 0 to 1024*1024 step 12
       vram[lp] = 255
    Next lp
    ReadKB

    ' ring setup
    mmio[&H2030 \ 4] = 0 ' ring head - at offset 0
    mmio[&H2034 \ 4] = 0 ' ring tail - at offset 0
    mmio[&H2038 \ 4] = 0 ' ring base - at the start of vram
    mmio[&H203C \ 4] = 1 ' ring control - 4k buffer size, no reporting, enabled
    ReadKB

    ' test commands
    vram[0] = 1
    vram[1] = 0
    vram[2] = &H04
    vram[3] = &H61
    vram[4] = 1
    vram[5] = 0
    vram[6] = &H04
    vram[7] = &H61
    mmio[&H2034 \ 4] = 8 ' ring tail - at offset 8
    ReadKB
    while (mmio[&H2030 \ 4] = 0)
    wend
    For lp = 0 to 1024*1024 step 12
       vram[lp] = 128
    Next lp
    ReadKB


End Sub
