' Summary: mach64_clockdsp.bas
' Mach64 clock idiocy. Here be dragons.
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos.bi"
#include "x86.bi"
#include "mos/mach64_id.bi"

' external stuff we need
Declare Function ReadKey() As Byte
Declare Sub WriteGfxString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)

' this stuff
Declare Sub WriteSolidString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub Mach64_ClockAndDspTweaker(vram As Byte Ptr, portbase as long)
Declare Function Mach64_SetPixClock(Portbase as Long, hz As Long) As Long

Declare Function Mach64_GetClockFrequency(portbase As Long) as Long
Declare Function Mach64_ReadIntegratedClock(portbase As Long, reg As Long) As Unsigned Byte
Declare Sub Mach64_WriteIntegratedClock(portbase As Long, reg As Long, value As Unsigned Byte)

Sub Mach64_ClockAndDspTweaker(vram As Byte Ptr, portbase as long)
    Dim keypress As Byte
    Dim done as byte

    Dim dsp_on As Integer, dsp_off As Integer, dsp_prec As Integer, dsp_xclks As Integer, dsp_latency As Integer
    Dim pll_refdiv As unsigned byte, mclk_fb_div as unsigned byte, vclk0_fb_div as unsigned byte, vclk_postdiv as unsigned byte
    Dim pll_ext_cntl As Unsigned Byte, pll_gen_cntl As Unsigned Byte, pll_vclk_cntl As Unsigned Byte, baseclock As Integer
    Dim xclk_post_div As Unsigned Byte, xclk_ref_div As Unsigned Byte, vclk_index As Unsigned Byte


    Dim retval as long

    retval = inportd(portbase + Mach64_regs.DSP_CONFIG)
    dsp_xclks = retval and &H0000FFFF
    dsp_latency = (retval and &H000F0000) / &H10000
    dsp_prec = (retval and &H00F00000) / &H100000

    retval = inportd(portbase + Mach64_regs.DSP_ON_OFF)
    dsp_on = (retval and &HFFFF0000) / &H10000
    dsp_off = (retval and &HFFFF)

    vclk_index = 0 'inportb(portbase + Mach64_regs.CLOCK_CNTL) And &H03

    pll_refdiv = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.PLL_REF_DIV)
    mclk_fb_div = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.MCLK_FB_DIV)
    vclk_postdiv = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.VCLK_POST_DIV)
    vclk0_fb_div = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.VCLK0_FB_DIV + vclk_index)

    pll_ext_cntl = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.PLL_EXT_CNTL)
    pll_gen_cntl = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.PLL_GEN_CNTL)
    pll_vclk_cntl = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.PLL_VCLK_CNTL)

    xclk_post_div = pll_ext_cntl and &H07
	xclk_ref_div = 1

    baseclock = Mach64_GetClockFrequency(portbase)

    WriteSolidString(vram, "Base clock " & baseclock & " Hz  ", 200, 200, &HC0C080, 32, 640)

    done = 0

    While done = 0
        WriteSolidString(vram, "DSP xclks: 0x" & hex$(dsp_xclks) & "  ", 10, 220, &HC0C080, 32, 640)
        WriteSolidString(vram, "DSP latency: 0x" & hex$(dsp_latency) & "  ", 10, 240, &HC0C080, 32, 640)
        WriteSolidString(vram, "DSP precision: 0x" & hex$(dsp_prec) & "  ", 10, 260, &HC0C080, 32, 640)
        WriteSolidString(vram, "DSP on: 0x" & hex$(dsp_on) & "  ", 10, 280, &HC0C080, 32, 640)
        WriteSolidString(vram, "DSP off: 0x" & hex$(dsp_off) & "  ", 10, 300, &HC0C080, 32, 640)
        WriteSolidString(vram, "PLL ref div: 0x" & hex$(pll_refdiv) & "  ", 10, 320, &HC0C080, 32, 640)
        WriteSolidString(vram, "MCLK fb div: 0x" & hex$(mclk_fb_div) & "  ", 10, 340, &HC0C080, 32, 640)
        WriteSolidString(vram, "VCLK postdiv: 0x" & hex$(vclk_postdiv) & "  ", 10, 360, &HC0C080, 32, 640)
        WriteSolidString(vram, "VCLK fb div: 0x" & hex$(vclk0_fb_div) & "  ", 10, 380, &HC0C080, 32, 640)
        WriteSolidString(vram, "PLL control 1: 0x" & hex$(pll_gen_cntl) & "  ", 10, 400, &HC0C080, 32, 640)
        WriteSolidString(vram, "PLL control 2: 0x" & hex$(pll_ext_cntl) & "  ", 10, 420, &HC0C080, 32, 640)
        WriteSolidString(vram, "VCLK control: 0x" & hex$(pll_vclk_cntl) & "  ", 10, 440, &HC0C080, 32, 640)
        WriteSolidString(vram, "VCLK index: 0x" & hex$(vclk_index) & "  ", 10, 460, &HC0C080, 32, 640)

        keypress = ReadKey()
        WriteSolidString(vram, "Keycode: " & hex$(keypress), 10, 200, 7, 32, 640)

        Select Case keypress

            ' down row
            Case &H41
                if dsp_xclks > 7 then dsp_xclks = dsp_xclks - 8
            Case &H53
                if dsp_latency > 0 then dsp_latency = dsp_latency - 1
            Case &H44
                if dsp_prec > 0 then dsp_prec = dsp_prec - 1
            Case &H46
                if dsp_on > 7 then dsp_on = dsp_on - 8
            Case &H47
                if dsp_off > 7 then dsp_off = dsp_off - 8


            ' up row
            Case &H51
                if dsp_xclks < &H7FF0 then dsp_xclks = dsp_xclks + 8
            Case &H57
                if dsp_latency < 15 then dsp_latency = dsp_latency + 1
            Case &H45
                if dsp_prec < 15 then dsp_prec = dsp_prec + 1
            Case &H52
                if dsp_on < &H7FF0 then dsp_on = dsp_on + 8
            Case &H54
                if dsp_off < &H7ff0 then dsp_off = dsp_off + 8


            ' L: guess
            Case &H4C
                Dim dsp_fifo_size As Integer, mem_maxrasdelay As Unsigned Integer, mem_pagefaultdelay As Unsigned Integer, mem_cntl As Unsigned Integer
                dsp_fifo_size = 24
                mem_cntl = inportd(portbase + Mach64_regs.MEM_CNTL)
                mem_maxrasdelay = ((mem_cntl and &H300) \ 256&) + _
                                  ((mem_cntl and &H70000) \ 65536&) + 2 + 3

                mem_pagefaultdelay = ((mem_cntl and &H300) \ 256&) + _
                                     ((mem_cntl and &HC00) \ 1024&) + _
                                     ((mem_cntl and &H1000) \ 4096&) + 2 + 5

                WriteSolidString(vram, "fifo: " & dsp_fifo_size & " RAS: " & mem_maxrasdelay & " PFD:" & mem_pagefaultdelay & "  ", 320, 220, 7, 8, 640)

                Dim vclk_postdiv_real As Unsigned Integer, ras_multiplier As Unsigned Integer, ras_divider As Unsigned Integer

                vclk_postdiv_real = 1 shl ((vclk_postdiv shr (2 * vclk_index)) And &H3)
                if vclk_postdiv = 4 then vclk_postdiv_real = 3

                ras_multiplier = mem_maxrasdelay
                ras_divider = 1

                WriteSolidString(vram, "vclk real: " & vclk_postdiv_real & " ras mult: " & ras_multiplier & " div:" & ras_divider & "  ", 320, 240, &HC0C080, 8, 640)

                Dim multiplier As Unsigned Integer, divider As Unsigned Integer
                multiplier = mclk_fb_div * vclk_postdiv_real
                divider = vclk0_fb_div * xclk_ref_div '* iif(bpp >=8 , (bpp \ 4), 1)

                WriteSolidString(vram, "mult: " & multiplier & " div: " & divider & "  ", 320, 260, &HC0C080, 32, 640)

                while ((multiplier Or divider) And 1) = 0
                	multiplier = multiplier \ 2
	                divider = divider \ 2
	            wend

                WriteSolidString(vram, "mult: " & multiplier & " div: " & divider & "  ", 320, 280, &HC0C080, 32, 640)

	            Dim vshift_a As Unsigned Integer
	            vshift_a = 4 - xclk_post_div

                ' dsp precision
	            Dim temp As unsigned integer, temp_a As unsigned integer
                temp = ((multiplier * dsp_fifo_size) Shl vshift_a) \ divider
                temp_a = temp
                dsp_prec = -5
                do while temp > 0
                    dsp_prec = dsp_prec + 1
	                temp = temp \ 2
	                if dsp_prec = 7 then exit do
	            loop
                if (dsp_prec < 0) then dsp_prec = 0

                WriteSolidString(vram, "vshift1: " & vshift_a & " temp: " & temp_a & " precision:" & dsp_prec, 320, 300, &HC0C080, 32, 640)

                ' dsp width
                Dim vshift As Unsigned Integer, xshift As Unsigned Integer
                xshift = 6 - dsp_prec
                vshift = vshift_a + xshift
                dsp_xclks = ((multiplier Shl (vshift + 5)) + divider) \ divider
                WriteSolidString(vram, "vshift2: " & vshift & " xshift: " & xshift & " DspX:" & dsp_xclks & "  ", 320, 320, &HC0C080, 32, 640)

                ' dsp off
                dsp_off = ((multiplier * (dsp_fifo_size - 1)) Shl vshift) \ divider _
                          - (1 Shl (vshift - xshift))
                WriteSolidString(vram, "dsp off: " & dsp_off & "  ", 320, 340, &HC0C080, 8, 640)

                ' dsp on
                dsp_on = ((multiplier Shl vshift) + divider) \ divider
                temp = ((ras_multiplier Shl xshift) + ras_divider) \ ras_divider
                if (dsp_on < temp) then dsp_on = temp

                dsp_on = dsp_on + (temp * 2) + (mem_pagefaultdelay Shl xshift)
                temp = ((1 Shl (7 - dsp_prec)) - 1) \ 2
                dsp_on = ((dsp_on + temp) \ (temp + 1)) * (temp + 1)

                if (dsp_on >= ((dsp_off \ (temp + 1)) * (temp + 1))) then
                    dsp_on = dsp_off - (multiplier Shl vshift) \ divider
                    dsp_on = (dsp_on \ (temp + 1)) * (temp + 1)
                End if

                WriteSolidString(vram, "dsp on: " & dsp_on & "  ", 320, 360, &HC0C080, 8, 640)

            Case &H4B ' K: hack values

                dsp_prec = 6
                dsp_xclks = 512
                dsp_on = 34
                dsp_off = 30
                dsp_latency = 6

                'dsp_prec = 5
                'dsp_xclks = 5
                'dsp_on = 1
                'dsp_off = 3
                'dsp_latency = 6

        End Select

        retval = dsp_xclks Or (dsp_latency * &H10000) Or (dsp_prec * &H100000)
        outportd(portbase + Mach64_regs.DSP_CONFIG, retval)
        retval = dsp_off Or (dsp_on * &H10000)
        outportd(portbase + Mach64_regs.DSP_ON_OFF, retval)
    Wend

End Sub

Sub WriteSolidString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
    Dim lx as long, ly as long, xsize as long, offset as long
    xsize = len(s) * mode
    for ly = 0 to 15
        offset = ((y+ly) * vw + x) * mode \ 8
        for lx = 0 to xsize - 1
            vram[offset] = 0
            offset = offset + 1
        next lx
    next ly
    WriteGfxString(vram, s, x, y, col, mode, vw)
End Sub

Function Mach64_ReadIntegratedClock(portbase As Long, reg As Long) As Unsigned Byte
    Outportb(portbase + Mach64_regs.CLOCK_CNTL_ADDR, reg * 4)
    Function = inportb(portbase + Mach64_regs.CLOCK_CNTL_DATA)
End Function

Sub Mach64_WriteIntegratedClock(portbase As Long, reg As Long, value As Unsigned Byte)
    outportb(portbase + Mach64_regs.CLOCK_CNTL_ADDR, reg * 4 + 2) ' start cycle
    outportb(portbase + Mach64_regs.CLOCK_CNTL_DATA, value)
    outportb(portbase + Mach64_regs.CLOCK_CNTL_ADDR, reg * 4)     ' complete cycle
End Sub

Sub WriteClock(hz As Long, hf As Long, bpp As long)

End Sub


Function Mach64_SetPixClock(Portbase as Long, hz As Long) As Long


    '        XTAL * premult * FBdiv
    ' Clk = ------------------------
    '        PLL_REF_DIV * POST_DIV

    ' for the default setup:
    ' PLL_REF_DIV = 31 (32?)
    ' XTAL = 14318180 (constant)
    ' FBdiv = 0xDA (218) (must be 128-255)
    ' premult = 2 (for pixel clock)
    ' clk = 6242726480 / (pll*post)
    ' clk = 123Hz(Vfreq)*800(HT)*524(VT) = 51561600
    ' PLL REF * post = 121
    ' POST_DIV = 8 (register reads 0xff!)

    ' postdiv is mysterious (maybe bitfield for each 4 vclks, 2 bits each, 4th option -> postdiv=4?)
    ' ignoring postdiv does not work -> PLL_REF should not be touched and FBdiv does not have enough range
    ' of its own to set the appropriate modes (60Hz -> fb < 128 or post_div -> 8)

    ' postdiv = 4 (0x3 from 1,2,3,4, and not 1,2,4,8)
    ' fbdiv = 0xda = 218
    ' (xtal * 218) / (31*4) ~ 25MHz !


End Function

Function Mach64_GetClockFrequency(portbase As Long) as Long
    Dim clock As Long
    Function = 14318180      '14.32MHz default

    'pll_block.PCLK_max_freq/100
    'par->pll_limits.pll_max = 230

    'There seem to be two possible base frequencies - check if the clock has been preconfigured to match the faster clock
    Dim divider As Unsigned Byte
    divider = Mach64_ReadIntegratedClock(portbase, Mach64_clock_regs.PLL_REF_DIV)
    if divider = 0 then
        Function = clock
        exit function
    end if

    dim d1 As Long, d2 As Long
    d1 = 510 * 14 / divider - 230
    d2 = 510 * 29 / divider - 230
    If d2 * d2 < d1 * d1 Then
        clock = 29498928
    End If

    Function = clock
End Function
