' Summary: mach64test.bas
' Mach64 poking stuff
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos.bi"
#include "x86.bi"
#include "mos/pci.bi"
#include "mos/mach64_id.bi"

Declare Sub ModMain CDecl Alias "main"()
Declare Sub PrintString (ByRef s As String, ByVal vram As Byte Ptr, ByVal offset as long = 0)
Declare Sub ClearCon (ByVal vram As Byte Ptr)
Declare Function is_mach64(ByVal vendor as unsigned short, ByVal device as unsigned short) As Byte
Declare Sub cheapdelay()

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Declare Sub TestWithRageIICDump(portbase As Long)
Declare Sub TestWithRageProDump(portbase As Long)
Declare Sub TestWithCustomRegs(portbase As Long)
Declare Sub TestWithModifiedDump(portbase As Long)
Declare Sub UpgradeTo32bpp(portbase As Integer)

Declare Sub Mach64_ClockAndDspTweaker(vram As Byte Ptr, portbase as long)

Declare Sub mmio_write(mmio As Unsigned Byte Ptr, reg as integer, value as unsigned integer)
Declare Function mmio_read(mmio As Unsigned Byte Ptr, reg as integer) As unsigned integer

Declare Sub Mach64_WriteIntegratedClock(portbase As Long, reg As Long, value As Unsigned Byte)
Declare Function Mach64_ReadIntegratedClock(portbase As Long, reg As Long) As Unsigned Byte

Declare Sub WriteGfxString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode As Byte, vw As Long)

Declare Sub Mach64_Bitblt(mmio As Unsigned Byte Ptr, xsrc as long, ysrc as long, xs as long, ys as long, xdst as long, ydst as long)

Dim Shared font() As Unsigned Byte

Sub ModMain CDecl Alias "main"()

    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(32, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    PortAlloc(&HCF8, 8)

    'ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, &H40000000))
    ' Todo: Causes an oops, work todo in kernel land.
    'BlockAllocPhysL(1, CPtr(Byte Ptr, &H40000000), CPtr(Byte Ptr, &H40000000))

    ClearCon cram

    Printstring "Checking devices...", cram, 0

    InitKeyboard

    Dim lp as long, bus as long, dev as long, fn as long
    Dim lastdevice as Unsigned Short
    Dim mybus as long, mydev as long, myfn as long
    Dim vendor as Unsigned Short, myvendor as unsigned short
    Dim device as Unsigned Short, mydevice as unsigned short
    Dim atidev as Unsigned Short

    mybus = -1
    atidev = &HFFFF
    lastdevice = &HFFFF
    lp = 0
    For bus = 0 to 2
        For dev = 0 to 31
            For fn = 0 to 7
                vendor = PCI_type1_readword(bus, dev, fn, 0)
                device = PCI_type1_readword(bus, dev, fn, 2)
                If is_mach64(vendor, device) Then
                    mybus = bus
                    mydev = dev
                    myfn = fn
                    myvendor = vendor
                    mydevice = device
                    exit for
                ElseIf vendor = &H1002 Then
                    atidev = device
                End If
            Next fn
        Next dev
    Next bus

    If mybus = -1 then
        if atidev <> &HFFFF Then
            PrintString "unknown ATI chip found: 0x" & hex$(atidev), cram, 160
    Else
            PrintString "No Mach64 compatible chip found", cram, 160
    End if
        Exit Sub
    End if
    PrintString "Mach64 found on device " & mybus & ":" & mydev & ":" & myfn, cram, 160

    PrintString "PCI ID: 0x" & hex$(myvendor) & ":0x" & hex$(mydevice), cram, 320

    Dim bar as Unsigned Long, barmask As Unsigned Long
    Dim portbase as long
    Dim mmiobase as long
    Dim framebuffer as Long
    framebuffer = 0

    For lp = 5 to 0 step -1
        barmask = PCI_bar_readmask(mybus,mydev,myfn, lp)
        bar = PCI_bar_readaddress(mybus,mydev,myfn, lp)
        printstring "Bar " & lp & ": 0x" & hex$(barmask) & " @ 0x" & hex$(bar), cram, (3+lp) * 160
        If bar = 0 then

        Elseif (barmask and &H1) = 1 Then
            portbase = bar and &HFFF8&
        Elseif ((barmask and &HFFFF0) = 0) And (framebuffer = 0) then
            framebuffer = bar
        Else
            mmiobase = bar
        End If
    Next lp

    PrintString "Port offset: 0x" & hex$(CInt(portbase)) & " MMIO: 0x" & hex$(CInt(mmiobase)), cram, 9 * 160
    PrintString "LFB offset: 0x" & hex$(CInt(framebuffer)), cram, 10 * 160

    If portbase = 0 Then Exit Sub
    if framebuffer = 0 then Exit Sub
    If mmiobase = 0 then Exit Sub

    Dim lfb as unsigned byte ptr
    Dim ioctl as unsigned byte ptr
    lfb = CPtr(Unsigned byte ptr, &HF0000000)
    ioctl = CPtr(Unsigned byte ptr, &HE0000000)

    portalloc(portbase, &H100)
    PrintString ".", cram, 1600
    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, framebuffer))
    PrintString ".", cram, 1602
    'AllocatePageTable(CPtr(Byte Ptr, &HD0000000), CPtr(&HFFFFFFFF))
    BlockAllocPhysL(1, CPtr(Byte Ptr, &HF0000000), CPtr(Byte Ptr, framebuffer))
    BlockAllocPhysL(1, CPtr(Byte Ptr, &HE0000000), CPtr(Byte Ptr, mmiobase))
    'BlockAllocPhysL(1, CPtr(Byte Ptr, framebuffer), CPtr(Byte Ptr, lfb))
    PrintString ".", cram, 1604

    ' correct offset for mapping more than 4k
    ioctl = ioctl + (mmiobase And &H3FFFFF)

    'lfb[0] = 77
    'lfb[1] = 78
    'lfb[2] = 79
    'lfb[3] = 80
    PrintString ".", cram, 1606

    Dim offpitch As Unsigned Integer, memctl As Unsigned Integer, genctl As Unsigned Integer
    Dim dacctl As Unsigned Integer, busctl As Unsigned Integer
    offpitch = inportd(portbase + mach64_regs.CRTC_OFF_PITCH)
    genctl = inportd(portbase + mach64_regs.CRTC_GEN_CNTL)
    memctl = inportd(portbase + mach64_regs.MEM_CNTL)
    dacctl = inportd(portbase + mach64_regs.DAC_CNTL)
    busctl = inportd(portbase + mach64_regs.BUS_CNTL)
    PrintString "Off/pitch reg: 0x" & hex(offpitch), cram, 11 * 160
    PrintString "General control reg: 0x" & hex(genctl), cram, 12 * 160
    PrintString "Memory control reg: 0x" & hex(memctl), cram, 13 * 160
    PrintString "RAMDAC control reg: 0x" & hex(dacctl), cram, 14 * 160
    PrintString "Bus control reg: 0x" & hex(busctl), cram, 15 * 160

    '                        1       8  9      15  16     23  24     31
    ' gen_cntl = 02410200 -> 0000 0000  0100 0000  1000 0010  0100 0000

    ReadKey

    PrintString "...", cram, 16*160
    cheapdelay
    PrintString "...", cram, 17*160
    
    Dim accs As String
    Dim accbyte As Unsigned Byte
    for lp = 0 to 31
        'accbyte = Mach64_ReadIntegratedClock(portbase, lp)
        accs = accs & "0x"
        if len(hex$(accbyte)) = 1 then accs = accs & "0"
        accs = accs & hex$(accbyte) & " "

        If lp = 15 then printstring accs, cram, 18 * 160
        If lp = 31 then printstring accs, cram, 18 * 160
    next lp

    ReadKey

    TestWithCustomRegs(portbase)
    'TestWithModifiedDump(portbase)
    'TestWithRageproDump(portbase)

    ReadKey

    redim font(8196)
    For lp = 0 to 8195
        font(lp) = lfb[4*lp+2]
    Next lp

    for lp = &H0 to &HFFFFF
        lfb[lp] = 0
        'lfb[lp] = (lp And &H3) + &H14
    next lp

    ' horizontal ruler
    for lp = 0 to 638 Step 2
        lfb[lp] = 1
        lfb[lp+1] = 0
        lfb[lp+640] = 1
        lfb[lp+641] = 0
        if (lp and &H3F) = 0 then
            lfb[lp+1280] = 1
            lfb[lp+1281] = 0
            lfb[lp+1920] = 1
            lfb[lp+1921] = 0
        end if
    next lp

    ' vertical ruler
    for lp = 0 to 478 Step 2
        lfb[640*lp] = 1
        lfb[640*lp+1] = 1
        lfb[640*lp+640] = 0
        lfb[640*lp+641] = 0
        if (lp and &H3F) = 0 then
            lfb[640*lp+2] = 1
            lfb[640*lp+3] = 1
            lfb[640*lp+642] = 0
            lfb[640*lp+643] = 0
        end if
    next lp

    ' test pattern
    dim lp2 as integer
    for lp = 10 to 470 step 10
        for lp2 = 10 to 480 - lp step 10
            lfb[640*lp+lp2] = 1
            lfb[640*lp+lp2+1] = 1
            lfb[640*lp+lp2-1] = 1
            lfb[640*lp+lp2+640] = 1
            lfb[640*lp+lp2-640] = 1
        next lp2
    next lp

    WriteGfxString lfb, "Mach64 test rendering", 50, 50, 7, 8, 640

    ReadKey

    'for lp = 0 to 255
    '    ioctl[lp] = 0
    'next lp


    ' magic bit to enable MMIO access
    'outportd(portbase + Mach64_regs.BUS_CNTL, inportd(portbase + Mach64_regs.BUS_CNTL) Or Mach64_bus_cntl.BUS_APER_REG_DIS)

    mmio_write(ioctl, Mach64_regs.OVR_WID_TOP_BOTTOM, &H80008)
    mmio_write(ioctl, Mach64_regs.OVR_WID_LEFT_RIGHT, &H10001)
    WriteGfxString lfb, "IOCTL tested", 50, 66, 7, 8, 640
    ReadKey

    mmio_write(ioctl, Mach64_regs.OVR_WID_TOP_BOTTOM, 0)
    mmio_write(ioctl, Mach64_regs.OVR_WID_LEFT_RIGHT, 0)
    WriteGfxString lfb, "x2", 154, 66, 7, 8, 640
    ReadKey

    ' preload DSP hacK setting
    lp = 512 Or (6 * &H10000) Or (6 * &H100000)
    outportd(portbase + Mach64_regs.DSP_CONFIG, lp)
    lp = 30 Or (34 * &H10000)
    outportd(portbase + Mach64_regs.DSP_ON_OFF, lp)

    ReadKey

    Dim prevvalue As Unsigned Integer
    ' reset GUI accelerator
    prevvalue = inportd(portbase + Mach64_regs.GEN_TEST_CNTL)
    prevvalue = prevvalue And (Not Mach64_gen_test_cntl.GEN_GUI_EN)
    outportd(portbase + Mach64_regs.GEN_TEST_CNTL, prevvalue)
    prevvalue = prevvalue Or Mach64_gen_test_cntl.GEN_GUI_EN
    outportd(portbase + Mach64_regs.GEN_TEST_CNTL, prevvalue)

    ' reset error status
    prevvalue = inportd(portbase + Mach64_regs.BUS_CNTL)
    prevvalue = prevvalue Or Mach64_bus_cntl.BUS_FIFO_ERR_ACK Or Mach64_bus_cntl.BUS_HOST_ERR_ACK
    outportd(portbase + Mach64_regs.BUS_CNTL, prevvalue)

    WriteGfxString lfb, "GUI accelerator reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)), 50, 82, 7, 8, 640
    ReadKey

    mmio_write(ioctl, Mach64_regs.MEM_VGA_WP_SEL, &H10000)
    mmio_write(ioctl, Mach64_regs.MEM_VGA_RP_SEL, &H10000)

    mmio_write(ioctl, Mach64_regs.CONTEXT_MASK, &HFFFFFFFF)
    mmio_write(ioctl, Mach64_regs.DST_OFF_PITCH, &H400000 * (640/8))
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 0)
    mmio_write(ioctl, Mach64_regs.DST_HEIGHT, 0)
    mmio_write(ioctl, Mach64_regs.DST_BRES_ERR, 0)
    mmio_write(ioctl, Mach64_regs.DST_BRES_INC, 0)
    mmio_write(ioctl, Mach64_regs.DST_BRES_DEC, 0)


    WriteGfxString lfb, "DST regs reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)) & " Pitch reg: 0x" & hex$(mmio_read(ioctl, Mach64_regs.DST_OFF_PITCH)), 50, 98, 7, 8, 640
    ReadKey

    mmio_write(ioctl, Mach64_regs.SRC_OFF_PITCH, &H400000 * (640/8))
    mmio_write(ioctl, Mach64_regs.SRC_Y_X, 0)
    mmio_write(ioctl, Mach64_regs.SRC_HEIGHT1_WIDTH1, 1)
    mmio_write(ioctl, Mach64_regs.SRC_Y_X_START, 0)
    mmio_write(ioctl, Mach64_regs.SRC_HEIGHT2_WIDTH2, 1)
    mmio_write(ioctl, Mach64_regs.SRC_CNTL, &H10)

    WriteGfxString lfb, "SRC regs reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)) & " Pitch reg: 0x" & hex$(mmio_read(ioctl, Mach64_regs.SRC_OFF_PITCH)), 50, 114, 7, 8, 640
    ReadKey

    mmio_write(ioctl, Mach64_regs.HOST_CNTL, 0)
    mmio_write(ioctl, Mach64_regs.PAT_REG0, 0)
    mmio_write(ioctl, Mach64_regs.PAT_REG1, 0)
    mmio_write(ioctl, Mach64_regs.PAT_CNTL, 0)
    WriteGfxString lfb, "Pattern regs reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)) & " Pitch reg: 0x" & hex$(mmio_read(ioctl, Mach64_regs.SRC_OFF_PITCH)), 50, 130, 7, 8, 640
    ReadKey

    mmio_write(ioctl, Mach64_regs.SC_LEFT, 0)
    mmio_write(ioctl, Mach64_regs.SC_TOP, 0)
    mmio_write(ioctl, Mach64_regs.SC_BOTTOM, 480-1)
    mmio_write(ioctl, Mach64_regs.SC_RIGHT, 640-1)
    WriteGfxString lfb, "Scissor regs reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)) & " Pitch reg: 0x" & hex$(mmio_read(ioctl, Mach64_regs.SRC_OFF_PITCH)), 50, 146, 7, 8, 640
    ReadKey

    mmio_write(ioctl, Mach64_regs.DP_BKGD_CLR, 0)
    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &HFFFFFFFF)
    mmio_write(ioctl, Mach64_regs.DP_WRITE_MASK, &HFFFFFFFF)
    mmio_write(ioctl, Mach64_regs.DP_MIX, &H00070003)
    mmio_write(ioctl, Mach64_regs.DP_SRC, &H100)
    mmio_write(ioctl, Mach64_regs.DP_CHAIN_MASK, &H8080)
    mmio_write(ioctl, Mach64_regs.DP_PIX_WIDTH, &H222) ' 8/8/8/0

    WriteGfxString lfb, "DP regs reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)) & " Pitch reg: 0x" & hex$(mmio_read(ioctl, Mach64_regs.SRC_OFF_PITCH)), 50, 162, 7, 8, 640
    ReadKey

    Mach64_BitBlt(ioctl, 82, 82, 40, 16, 540, 20)
    Mach64_BitBlt(ioctl, 82, 82, 40, 16, 590, 40)
    Mach64_BitBlt(ioctl, 82, 82, 40, 16, 550, 50)

    WriteGfxString lfb, "Blit started. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)), 50, 178, 7, 8, 640
    ReadKey

    UpgradeTo32bpp(portbase)
    ReadKey
    WriteGfxString lfb, "32-bit mode", 0, 0, &HFFFFFFFF, 32, 640*4

    For lp = 0 to 640 * 480 * 4 - 1
        lfb[lp] = 0
        'lfb[lp] = (lp And &H3) + &H14
    next lp

    ' horizontal ruler
    for lp = 0 to 638 Step 2
        lfb[4*lp] = 192
        lfb[4*lp+4*640] = 192
        if (lp and &H3F) = 0 then
            lfb[4*lp+0*640] = 255
            lfb[4*lp+4*640] = 255
            lfb[4*lp+8*640] = 255
        end if
    next lp

    ' vertical ruler
    for lp = 0 to 478 Step 2
        lfb[4*640*lp] = 192
        lfb[4*640*lp+4] = 192
        if (lp and &H3F) = 0 then
            lfb[4*640*lp] = 255
            lfb[4*640*lp+4] = 255
            lfb[4*640*lp+8] = 255
            lfb[4*640*lp+12] = 255
        end if
    next lp

    ' test pattern
    for lp = 10 to 470 step 10
        for lp2 = 10 to 480 - lp step 10
            lfb[4*(640*lp+lp2)] = 255
            lfb[4*(640*lp+lp2+1)] = 192
            lfb[4*(640*lp+lp2-1)] = 192
            lfb[4*(640*lp+lp2+640)] = 192
            lfb[4*(640*lp+lp2-640)] = 192
        next lp2
    next lp

    ReadKey

    ' as a nasty surprise, the Mach64 uses the VGA palette as a Gamma LUT. Let's fix the colour mess.
    for lp = 0 to 255
        outportb(portbase + mach64_regs.DAC_W_INDEX, lp)
        outportb(portbase + mach64_regs.DAC_DATA, lp SHR 2)
        outportb(portbase + mach64_regs.DAC_DATA, lp SHR 2)
        outportb(portbase + mach64_regs.DAC_DATA, lp SHR 2)
    next lp

    ReadKey
    
    lp = &H278 Or (6 * &H10000) Or (4 * &H100000)
    outportd(portbase + Mach64_regs.DSP_CONFIG, lp)
    lp = &H56 Or (&H4A * &H10000)
    outportd(portbase + Mach64_regs.DSP_ON_OFF, lp)

    ReadKey

    mmio_write(ioctl, Mach64_regs.DP_PIX_WIDTH, &H60060666) ' 32/32/32/32/32 (disagrees with vgadoc)

    Mach64_BitBlt(ioctl, 82, 82, 64, 64, 540, 20)
    
    ReadKey
    
    mmio_write(ioctl, &H01FC, &H000000C0)
    cheapdelay
    mmio_write(ioctl, &H0704, &H00000000)
    cheapdelay
    mmio_write(ioctl, &H01FC, &H00000000)
    cheapdelay

    WriteGfxString lfb, "3D engine reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)), 50, 50, &H00FF00, 32, 640

    ReadKey

    Mach64_BitBlt(ioctl, 82, 82, 64, 64, 440, 40)

    ReadKey

    mmio_write(ioctl, Mach64_regs.DP_BKGD_CLR, &H00FFFF00)
    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H0000FFFF)
    mmio_write(ioctl, Mach64_regs.DP_WRITE_MASK, &HFFFFFFFF)
    mmio_write(ioctl, Mach64_regs.DP_MIX, &H00070003)
    mmio_write(ioctl, Mach64_regs.DP_SRC, &H100) ' colour data = foreground over background

    mmio_write(ioctl, Mach64_regs.DST_Y_X, 200 * &H10000 + 50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_ERR, -2*50 - 200 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_DEC,  2*50 - 2*200 )
    mmio_write(ioctl, Mach64_regs.DST_CNTL, &H00000003 ) 'left-to-right, top-to-bottom, X-major
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 200) ' (0) Major length

    ReadKey

    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H000000FF)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_ERR, -2*50 - 100 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_DEC,  2*50 - 2*100 )
    mmio_write(ioctl, Mach64_regs.DST_CNTL, &H00000006 ) 'right-to-left, top-to-bottom, Y-major
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 100) ' (0) Major length

    ReadKey
    
    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H00005F00)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_ERR, -2*50 - 100 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_DEC,  2*50 - 2*100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_ERR, -2*50 - 100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_DEC,  2*50 - 2*100 )
    mmio_write(ioctl, Mach64_regs.DST_CNTL, &H00000006 ) 'right-to-left, top-to-bottom, Y-major
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 450 * &H10000 + 100 + &H80008000) ' (0) Major length (16) X2 (15) trapezoid (31) line disable

    ReadKey
    
    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H005f0000)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_ERR, -2*50 - 100 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_DEC,  2*50 - 2*100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_ERR, -2*50 - 100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_DEC,  2*50 - 2*100 )
    mmio_write(ioctl, Mach64_regs.DST_CNTL, &H00000006 ) 'right-to-left, top-to-bottom, Y-major
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 450 * &H10000 + 100 + &H00008000) ' (0) Major length (16) X2 (15) trapezoid (31) line disable

    ReadKey
    
    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H005f5f00)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 180 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_ERR, -100 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_DEC, -2*100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_ERR, -100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_DEC, -2*100 )
    mmio_write(ioctl, Mach64_regs.DST_CNTL, &H00002006 ) 'lead right-to-left, top-to-bottom, Y-major, trail left-to-right
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 450 * &H10000 + 100 + &H80008000) ' (0) Major length (16) X2 (15) trapezoid (31) line disable

    ReadKey

    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H00005f5f)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 180 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_ERR, -100 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_DEC, -2*100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_ERR, -100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_DEC, -2*100 )
    mmio_write(ioctl, Mach64_regs.DST_CNTL, &H00006006 ) 'lead right-to-left, top-to-bottom, Y-major, trail left-to-right
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 450 * &H10000 + 100 + &H80008000) ' (0) Major length (16) X2 (15) trapezoid (31) line disable

    ReadKey

    'mmio_write(ioctl, &H01FC, &H80010050) ' SCALE_3D_CNTL = Host FIFO, SRC_ONE and DST_ZERO (alpha blending off), texture disable, ROUND_EN
    'mmio_write(ioctl, Mach64_regs.DP_SRC, &H00000505) ' data source = white/3D/3D
    'mmio_write(ioctl, &H02a8, &H1FFF0000) ' X scissor = off
    'mmio_write(ioctl, &H02b4, &H3FFF0000) ' Y scissor = off
    'mmio_write(ioctl, &H0150, 0) ' alpha test = off
    'mmio_write(ioctl, Mach64_regs.DP_MIX, &H00070007) ' Mix = Source over Source
    'mmio_write(ioctl, &H0148, &H400000 * (640/8)) ' Z pitch = 640 units
    'mmio_write(ioctl, &H014C, 0) ' Z-buffering off
    'mmio_write(ioctl, &H0330, 3) ' trajectory = left->right and top->bottom
    'mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &HFFFFFF) ' foreground/fog colour

    WriteGfxString lfb, "3D regs reset. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)), 50, 66, &H00FF00, 32, 640
    'ReadKey

    ' directfb init sequence
    mmio_write(ioctl, &H01FC, &H000000C0) 'scale3d = reset
    mmio_write(ioctl, Mach64_regs.SRC_CNTL, &H0)
    mmio_write(ioctl, &H014C, 0)
    mmio_write(ioctl, &H03C0, 0) ' red dx
    mmio_write(ioctl, &H03C4, 0) ' red dy
    mmio_write(ioctl, &H03CC, 0) ' green dx
    mmio_write(ioctl, &H03D0, 0) ' green dy
    mmio_write(ioctl, &H03D8, 0) ' blue dx
    mmio_write(ioctl, &H03DC, 0) ' blue dy
    mmio_write(ioctl, &H03F0, 0) ' alpha dx
    mmio_write(ioctl, &H03F4, 0) ' alpha dy
    mmio_write(ioctl, &H01FC, &H00000000) 'scale3d = normal

    ReadKey

    ' directfb scaler enable sequence
    mmio_write(ioctl, &H01FC, &H000100C0) 'scale3d = active
    'mmio_write(ioctl, Mach64_regs.DP_PIX_WIDTH, &H00000600)
    mmio_write(ioctl, Mach64_regs.DP_SRC, &H00000505) ' data source = scaler

    mmio_write(ioctl, &H03C0, 0 )
    mmio_write(ioctl, &H03C8, &H007FFF00 )
    mmio_write(ioctl, &H03CC, 0 )
    mmio_write(ioctl, &H03D4, &H007F00FF )
    mmio_write(ioctl, &H03D8, 0 )
    mmio_write(ioctl, &H03E0, &H007F0000 )
    mmio_write(ioctl, &H03F8, &H007F0000 )

    'cheapdelay
    'mmio_write(ioctl, &H01FC, &H000100C0) 'scale3d = active

    ReadKey

    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H0000ff00)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 180 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_ERR, -100 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_DEC, -2*100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_ERR, -100 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_INC,  2*50 )
    mmio_write(ioctl, Mach64_regs.TRAIL_BRES_DEC, -2*100 )
    mmio_write(ioctl, Mach64_regs.DST_CNTL, &H00006006 ) 'lead right-to-left, top-to-bottom, Y-major, trail left-to-right
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 450 * &H10000 + 100 + &H80008000) ' (0) Major length (16) X2 (15) trapezoid (31) line disable

    WriteGfxString lfb, "Trapezoid Setup. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)), 50, 82, &H00FF00, 32, 640

    ReadKey

    mmio_write(ioctl, &H03C0, &H10000) ' red dx
    mmio_write(ioctl, &H03C4, 0) ' red dy
    mmio_write(ioctl, &H03CC, 0) ' green dx
    mmio_write(ioctl, &H03D0, &H10000) ' green dy
    mmio_write(ioctl, &H03D8, - &H08000) ' blue dx
    mmio_write(ioctl, &H03DC, &H08000) ' blue dy

    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H003f003f)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 180 ) ' gets modified by draw call
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 450 * &H10000 + 100 + &H80008000) ' (0) Major length (16) X2 (15) trapezoid (31) line disable

    ReadKey

    mmio_write(ioctl, &H01FC, &H00000000) 'scale3d = normal
    mmio_write(ioctl, Mach64_regs.SRC_CNTL, &H10)
    mmio_write(ioctl, Mach64_regs.DP_MIX, &H00070003)
    mmio_write(ioctl, Mach64_regs.DP_PIX_WIDTH, &H60060666)
    mmio_write(ioctl, Mach64_regs.DP_SRC, &H100) ' colour data = foreground over background

    mmio_write(ioctl, Mach64_regs.DP_FRGD_CLR, &H003f003f)
    mmio_write(ioctl, Mach64_regs.DST_Y_X, 400 * &H10000 + 180 ) ' gets modified by draw call
    mmio_write(ioctl, Mach64_regs.LEAD_BRES_LNTH, 450 * &H10000 + 100 + &H80008000) ' (0) Major length (16) X2 (15) trapezoid (31) line disable

    ReadKey

    mmio_write(ioctl, Mach64_regs.VERTEX_1_S, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_1_T, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_1_W, &H40000)
    mmio_write(ioctl, Mach64_regs.VERTEX_1_SPEC_ARGB, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_1_Z, &H20000)
    mmio_write(ioctl, Mach64_regs.VERTEX_1_ARGB, &H00FFFF00)
    mmio_write(ioctl, Mach64_regs.VERTEX_1_X_Y, &H00100010)
    mmio_write(ioctl, Mach64_regs.VERTEX_2_S, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_2_T, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_2_W, &H40000)
    mmio_write(ioctl, Mach64_regs.VERTEX_2_SPEC_ARGB, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_2_Z, &H20000)
    mmio_write(ioctl, Mach64_regs.VERTEX_2_ARGB, &HFFFF0000)
    mmio_write(ioctl, Mach64_regs.VERTEX_2_X_Y, &H02000010)
    mmio_write(ioctl, Mach64_regs.VERTEX_3_S, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_3_T, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_3_W, &H40000)
    mmio_write(ioctl, Mach64_regs.VERTEX_3_SPEC_ARGB, 0)
    mmio_write(ioctl, Mach64_regs.VERTEX_3_Z, &H20000)
    mmio_write(ioctl, Mach64_regs.VERTEX_3_ARGB, &H0000FFFF)
    mmio_write(ioctl, Mach64_regs.VERTEX_3_X_Y, &H00100200)

    WriteGfxString lfb, "3D triangle setup. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)), 50, 98, &H00FF00, 32, 640

    ReadKey

    Dim area As Single
    area = ((&H10 - &H200) * (&H10 - &H200) - (&H10 - &H200) * (&H200 - &H10)) / 16
    area = 1/area
    mmio_write(ioctl, Mach64_regs.ONE_OVER_AREA_UC, *CPtr(Integer Ptr, @area))

    WriteGfxString lfb, "Rasterisation Started. FIFO bits: 0x" & hex$(mmio_read(ioctl, Mach64_regs.FIFO_STAT)), 50, 114, &H00FF00, 32, 640

    ReadKey


    Mach64_BitBlt(ioctl, 82, 82, 64, 64, 550, 90)

    ReadKey

    Mach64_ClockAndDspTweaker(lfb, portbase)

    ReadKey

End Sub


' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Public Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + offset] = ch
        vram[lp * 2 - 1 + offset] = 7
    Next lp
End Sub


Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub

Function is_mach64(vendor as unsigned short, device as unsigned short) As Byte
    function = 0
    'if vendor <> &HFFFF then function = 1
    if vendor <> &H1002 then exit function
    if device = RAGE_IIC_1 then function = 1
    if device = RAGE_IIC_2 then function = 1
    if device = RAGE_IIC_3 then function = 1
    if device = RAGE_XL_1 then function = 1
    if device = RAGE_PRO_1 then function = 1
End Function

Sub cheapdelay()
    Dim lp as Long
    For lp = 0 To 6600000
    Next lp
End Sub

Sub TestWithRageIICDump(portbase As Long)
    dim crtcgenctl As Unsigned Integer
    crtcgenctl = &HB010200

    ' kill CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, crtcgenctl and (not Mach64_crtc_gen_cntl.CRTC_EN) )

    ' fill off the registers
    outportd(portbase + &H0, &H4f0067)
    outportd(portbase + &H4, &H270258)
    outportd(portbase + &H8, &H1df01fc)
    outportd(portbase + &Hc, &H2301e0)
    outportd(portbase + &H10, &H3803ff)
    outportd(portbase + &H14, &H14000000)
    outportd(portbase + &H18, &H34)
    'outportd(portbase + &H1c, &Hb010200) ' skip to keep CRTC off
    outportd(portbase + &H20, &H460756)
    outportd(portbase + &H24, &H900714)
    outportd(portbase + &H28, &H0)
    outportd(portbase + &H2c, &H89080000)
    outportd(portbase + &H30, &H0)
    outportd(portbase + &H34, &H0)
    outportd(portbase + &H38, &H0)
    outportd(portbase + &H3c, &H0)
    outportd(portbase + &H40, &H0)
    outportd(portbase + &H44, &H0)
    outportd(portbase + &H48, &H0)
    outportd(portbase + &H4c, &H4500a7d)
    outportd(portbase + &H50, &H53e0789)
    outportd(portbase + &H54, &H0)
    outportd(portbase + &H58, &H0)
    outportd(portbase + &H5c, &H0)
    outportd(portbase + &H60, &H0)
    outportd(portbase + &H64, &Hffffffff)
    outportd(portbase + &H68, &H9600)
    outportd(portbase + &H6c, &H7ff07ff)
    outportd(portbase + &H70, &H200020)
    outportd(portbase + &H74, &H0)
    outportd(portbase + &H78, &H3ffd)
    outportd(portbase + &H7c, &H80000000)
    outportd(portbase + &H80, &H4840400)
    outportd(portbase + &H84, &H800000)
    outportd(portbase + &H88, &H0)
    outportd(portbase + &H8c, &H0)
    outportd(portbase + &H90, &Had0003)
    outportd(portbase + &H94, &H100288)
    outportd(portbase + &H98, &H2200100)
    outportd(portbase + &H9c, &H0)
    outportd(portbase + &Ha0, &H7b330040)
    outportd(portbase + &Ha4, &H0)
    outportd(portbase + &Ha8, &H0)
    outportd(portbase + &Hac, &Hb4000201)
    outportd(portbase + &Hb0, &Hd0401093)
    outportd(portbase + &Hb4, &H10000)
    outportd(portbase + &Hb8, &H10000)
    outportd(portbase + &Hbc, &H0)
    outportd(portbase + &Hc0, &Hff3d00)
    outportd(portbase + &Hc4, &H8701200a)
    outportd(portbase + &Hc8, &H0)
    outportd(portbase + &Hcc, &H0)
    outportd(portbase + &Hd0, &H88)
    outportd(portbase + &Hd4, &H0)
    outportd(portbase + &Hd8, &H0)
    outportd(portbase + &Hdc, &H1042)
    outportd(portbase + &He0, &H3a00475a)
    outportd(portbase + &He4, &Hc0001b)
    outportd(portbase + &He8, &H0)
    outportd(portbase + &Hec, &H800f2eb0)
    outportd(portbase + &Hf0, &Habcd)
    outportd(portbase + &Hf4, &H41)
    outportd(portbase + &Hf8, &H10d1)
    outportd(portbase + &Hfc, &H0)

    ' enable CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, crtcgenctl)
    cheapdelay
End Sub

Sub TestWithRageproDump(portbase As Long)
    dim crtcgenctl As Unsigned Integer
    crtcgenctl = &H3010200

    ' kill CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, crtcgenctl and (not Mach64_crtc_gen_cntl.CRTC_EN) )

    outportd(portbase + &H00, &H4f0063)
    outportd(portbase + &H04, &H2d0352)
    outportd(portbase + &H08, &H1df020c)
    outportd(portbase + &H0c, &H2201e9)
    outportd(portbase + &H10, &H1cd03ff)
    outportd(portbase + &H14, &H14000000)
    outportd(portbase + &H18, &H80000034)
    'outportd(portbase + &H1c, &H3010200)
    outportd(portbase + &H20, &H5a07e8)
    outportd(portbase + &H24, &H3c07a7)
    outportd(portbase + &H28, &H0)
    outportd(portbase + &H2c, &H382848)
    outportd(portbase + &H30, &H0)
    outportd(portbase + &H34, &H202)
    outportd(portbase + &H38, &H0)
    outportd(portbase + &H3c, &Hf0fcb00)
    outportd(portbase + &H40, &H0)
    outportd(portbase + &H44, &H0)
    outportd(portbase + &H48, &H0)
    outportd(portbase + &H4c, &H56007f2)
    outportd(portbase + &H50, &H3f805b5)
    outportd(portbase + &H54, &H0)
    outportd(portbase + &H58, &H0)
    outportd(portbase + &H5c, &H0)
    outportd(portbase + &H60, &H0)
    outportd(portbase + &H64, &Hffffffff)
    outportd(portbase + &H68, &H9600)
    outportd(portbase + &H6c, &H14601ad)
    outportd(portbase + &H70, &H200020)
    outportd(portbase + &H74, &H0)
    outportd(portbase + &H78, &H7fdd)
    outportd(portbase + &H7c, &H803800)
    outportd(portbase + &H80, &H4900400)
    outportd(portbase + &H84, &H0)
    outportd(portbase + &H88, &H0)
    outportd(portbase + &H8c, &H0)
    outportd(portbase + &H90, &H1f0803)
    outportd(portbase + &H94, &H0)
    outportd(portbase + &H98, &H2030000)
    outportd(portbase + &H9c, &H0)
    outportd(portbase + &Ha0, &H7b33a100)
    outportd(portbase + &Ha4, &H0)
    outportd(portbase + &Ha8, &H0)
    outportd(portbase + &Hac, &Hf4000c01)
    outportd(portbase + &Hb0, &H10753a7b)
    outportd(portbase + &Hb4, &H10000)
    outportd(portbase + &Hb8, &H10000)
    outportd(portbase + &Hbc, &H280001ff)
    outportd(portbase + &Hc0, &Hff00ff)
    outportd(portbase + &Hc4, &H701010a)
    outportd(portbase + &Hc8, &H0)
    outportd(portbase + &Hcc, &H0)
    outportd(portbase + &Hd0, &H88)
    outportd(portbase + &Hd4, &H170)
    outportd(portbase + &Hd8, &H0)
    outportd(portbase + &Hdc, &H3b82)
    outportd(portbase + &He0, &H7c004742)
    outportd(portbase + &He4, &H14)
    outportd(portbase + &He8, &H0)
    outportd(portbase + &Hec, &H800faeb0)
    outportd(portbase + &Hf0, &H819f)
    outportd(portbase + &Hf4, &Hc0)
    outportd(portbase + &Hf8, &Hc0c0c0fd)
    outportd(portbase + &Hfc, &H0)

    ' enable CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, crtcgenctl)
    cheapdelay

End Sub

Sub TestWithCustomRegs(portbase As Long)

    Dim prevvalue as unsigned integer
    prevvalue = inportd(portbase + mach64_regs.CRTC_GEN_CNTL)
    'prevvalue = prevvalue and (not &H00000000)
    'prevvalue = prevvalue and (not &HFFF0FFFF)
    'prevvalue = prevvalue or Mach64_crtc_gen_cntl.CRTC_EXT_DISP_EN or Mach64_crtc_gen_cntl.CRTC_VGA_LINEAR Or Mach64_crtc_gen_cntl.CRTC_BPP_8 Or Mach64_crtc_gen_cntl.CRTC_EN
    prevvalue = Mach64_crtc_gen_cntl.CRTC_EXT_DISP_EN Or _
                Mach64_crtc_gen_cntl.CRTC_EN Or _
                Mach64_crtc_gen_cntl.CRTC_VGA_LINEAR Or _
                (prevvalue And Mach64_crtc_gen_cntl.CRTC_FIFO_LWM_MASK) Or _
                Mach64_crtc_gen_cntl.CRTC_BPP_8 Or _
                Mach64_crtc_gen_cntl.CRTC_CNT_EN

    ' kill CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, prevvalue and (not Mach64_crtc_gen_cntl.CRTC_EN) )
    ' set registers

    ' Horizontal timing
    outportd(portbase + mach64_regs.CRTC_H_TOTAL_DISP, ((816/8)-1) + &H10000 * ((640/8)-1) )
    outportd(portbase + mach64_regs.CRTC_H_SYNC_STRT_WID, ((640/8+48/8)-1) + &H10000 * ((96/8)-1) )

    ' Vertical timing (524 lines)
    outportd(portbase + mach64_regs.CRTC_V_TOTAL_DISP, (524-1) + &H10000 * (480-1) )
    outportd(portbase + mach64_regs.CRTC_V_SYNC_STRT_WID, (480+11-1) + &H10000 * (2-1) )

    ' interrupt stuffs
    outportd(portbase + mach64_regs.CRTC_VLINE_CRNT_VLINE, (480+11-1) + &H10000 * 0)

    ' virtual width and offset
    outportd(portbase + mach64_regs.CRTC_OFF_PITCH, &H400000 * 80) ' virtual width = 640 pixels, offset = 0

    ' overscan
    outportd(portbase + mach64_regs.OVR_WID_LEFT_RIGHT, &H10001)
    outportd(portbase + mach64_regs.OVR_WID_TOP_BOTTOM, &H80008)

    ' DAC
    outportb(portbase + mach64_regs.DAC_MASK, &HFF)

    ' values nicked from linux sources - they don't fix the rendering bug
    'outportd(portbase + mach64_regs.DAC_CNTL, &H86010102)
    'outportd(portbase + mach64_regs.BUS_CNTL, &H7b23a040)
    'outportd(portbase + mach64_regs.EXT_MEM_CNTL, _
        'inportd(portbase + mach64_regs.EXT_MEM_CNTL) Or &H5000001 )

    ' values nicked from IIC dump
    'outportd(portbase + mach64_regs.DAC_CNTL,     &H8701200A)
    'outportd(portbase + mach64_regs.BUS_CNTL,     &H7B330040)
    'outportd(portbase + mach64_regs.EXT_MEM_CNTL, &HB4000201)
    'outportd(portbase + mach64_regs.MEM_CNTL,     &HD0401093)

    ' enable CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, prevvalue)
    cheapdelay
End Sub

Sub TestWithModifiedDump(portbase As Long)
    dim crtcgenctl As Unsigned Integer
    crtcgenctl = &HB010200

    ' kill CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, crtcgenctl and (not Mach64_crtc_gen_cntl.CRTC_EN) )

    ' fill off the registers
     outportd(portbase + &H0, &H4f0067)
     outportd(portbase + &H4, &H270258)       ' H sync polarity = 1
     outportd(portbase + &H8, &H1df01fc)
     outportd(portbase + &Hc, &H2301e0)       ' V sync polarity = 1
     outportd(portbase + &H10, &H3803ff)
    outportd(portbase + &H14, &H14000000)
     'outportd(portbase + &H18, &H34)
        'outportd(portbase + &H1c, &Hb010200) ' skip to keep CRTC off
    outportd(portbase + &H20, &H460756)  ' <- required undocumented reg to fix layout
    outportd(portbase + &H24, &H900714)  ' <- required
        'outportd(portbase + &H28, &H0)
      'outportd(portbase + &H2c, &H89080000)
        'outportd(portbase + &H30, &H0)
        'outportd(portbase + &H34, &H0)
        'outportd(portbase + &H38, &H0)
        'outportd(portbase + &H3c, &H0)
        'outportd(portbase + &H40, &H0)
        'outportd(portbase + &H44, &H0)
        'outportd(portbase + &H48, &H0)
      'outportd(portbase + &H4c, &H4500a7d)
       'outportd(portbase + &H50, &H53e0789)
        'outportd(portbase + &H54, &H0)
        'outportd(portbase + &H58, &H0)
        'outportd(portbase + &H5c, &H0)
        'outportd(portbase + &H60, &H0)
       'outportd(portbase + &H64, &Hffffffff)
       'outportd(portbase + &H68, &H9600)
       'outportd(portbase + &H6c, &H7ff07ff)
       'outportd(portbase + &H70, &H200020)
        'outportd(portbase + &H74, &H0)
      'outportd(portbase + &H78, &H3ffd)
      'outportd(portbase + &H7c, &H80000000)
       'outportd(portbase + &H80, &H4840400)
       'outportd(portbase + &H84, &H800000)
        'outportd(portbase + &H88, &H0)
        'outportd(portbase + &H8c, &H0)
    outportd(portbase + &H90, &Had0003)                ' <- this one's needed for screen stability.
        'outportd(portbase + &H94, &H100288)
        'outportd(portbase + &H98, &H2200100)
        'outportd(portbase + &H9c, &H0)
     'outportd(portbase + &Ha0, &H7b330040)              ' bus_cntl sets 08000040
        'outportd(portbase + &Ha4, &H0)
        'outportd(portbase + &Ha8, &H0)
     'outportd(portbase + &Hac, &Hb4000201)
     'outportd(portbase + &Hb0, &Hd0401093)              ' mem_cntl
     'outportd(portbase + &Hb4, &H10000)
     'outportd(portbase + &Hb8, &H10000)
        'outportd(portbase + &Hbc, &H0)
       'outportd(portbase + &Hc0, &Hff3d00)
       'outportd(portbase + &Hc4, &H8701200a)            ' dac_cntl
        'outportd(portbase + &Hc8, &H0)
        'outportd(portbase + &Hcc, &H0)
       'outportd(portbase + &Hd0, &H88)
        'outportd(portbase + &Hd4, &H0)
        'outportd(portbase + &Hd8, &H0)
        'outportd(portbase + &Hdc, &H1042)
       'outportd(portbase + &He0, &H3a00475a)
       'outportd(portbase + &He4, &Hc0001b)
        'outportd(portbase + &He8, &H0)
       'outportd(portbase + &Hec, &H800f2eb0)
        'outportd(portbase + &Hf0, &Habcd)
        'outportd(portbase + &Hf4, &H41)
        'outportd(portbase + &Hf8, &H10d1)
        'outportd(portbase + &Hfc, &H0)

    cheapdelay

    ' delta values with bios image - set fb-div and extended postdiv
    Mach64_WriteIntegratedClock(portbase, VCLK3_FB_DIV, &HDA)
    Mach64_WriteIntegratedClock(portbase, PLL_XCLK_CNTL, &HC1)

    cheapdelay

    ' enable CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, crtcgenctl)
    cheapdelay
End Sub

Sub UpgradeTo32bpp(portbase As Integer)
    Dim prevvalue as unsigned integer
    prevvalue = inportd(portbase + mach64_regs.CRTC_GEN_CNTL)
    'prevvalue = prevvalue and (not &H00000000)
    'prevvalue = prevvalue and (not &HFFF0FFFF)
    'prevvalue = prevvalue or Mach64_crtc_gen_cntl.CRTC_EXT_DISP_EN or Mach64_crtc_gen_cntl.CRTC_VGA_LINEAR Or Mach64_crtc_gen_cntl.CRTC_BPP_8 Or Mach64_crtc_gen_cntl.CRTC_EN
    prevvalue = Mach64_crtc_gen_cntl.CRTC_EXT_DISP_EN Or _
                Mach64_crtc_gen_cntl.CRTC_EN Or _
                Mach64_crtc_gen_cntl.CRTC_VGA_LINEAR Or _
                (prevvalue And Mach64_crtc_gen_cntl.CRTC_FIFO_LWM_MASK) Or _
                Mach64_crtc_gen_cntl.CRTC_BPP_32 Or _
                Mach64_crtc_gen_cntl.CRTC_CNT_EN

    ' kill CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, prevvalue and (not Mach64_crtc_gen_cntl.CRTC_EN) )
    ' set registers

    ' virtual width and offset
    'outportd(portbase + mach64_regs.CRTC_OFF_PITCH, &H400000 * 80) ' virtual width = 640 pixels/80 chars, offset = 0, 4 bytes/pixel

    ' enable CRTC
    outportd(portbase + mach64_regs.CRTC_GEN_CNTL, prevvalue)
    cheapdelay

    ' put the dac into real-color mode
    prevvalue = inportd(portbase + mach64_regs.DAC_CNTL)
    prevvalue = prevvalue and (not &H10)
    outportd(portbase + mach64_regs.DAC_CNTL, prevvalue)

End Sub

Sub mmio_write(mmio As Unsigned Byte Ptr, reg as integer, value as unsigned integer)
    Dim addr As Unsigned Integer Ptr
    addr = CPtr(Unsigned Integer Ptr, mmio + reg + 3072)
    addr[0] = value
End Sub

Function mmio_read(mmio As Unsigned Byte Ptr, reg as integer) As unsigned integer
    Dim addr As Unsigned Integer Ptr
    addr = CPtr(Unsigned Integer Ptr, mmio + reg + 3072)
    Function = addr[0]
End Function


Sub WriteGfxString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
    Dim lp as long
    For lp = 1 to len(s)
        WriteGfxChar vram, asc(mid$(s,lp,1)), x + 8 * (lp - 1), y, col, mode, vw
    next lp
End Sub
Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, x as long, y as long, col as long, mode as Byte, vw as Long)
    dim lp as long
    Dim fontbyte as byte
    For lp = 0 to 15
        fontbyte = font(32 * ch + lp)
        if (fontbyte and &H01) = &H01 then PutPixel vram, x + 7, y + lp, col, mode, vw
        if (fontbyte and &H02) = &H02 then PutPixel vram, x + 6, y + lp, col, mode, vw
        if (fontbyte and &H04) = &H04 then PutPixel vram, x + 5, y + lp, col, mode, vw
        if (fontbyte and &H08) = &H08 then PutPixel vram, x + 4, y + lp, col, mode, vw
        if (fontbyte and &H10) = &H10 then PutPixel vram, x + 3, y + lp, col, mode, vw
        if (fontbyte and &H20) = &H20 then PutPixel vram, x + 2, y + lp, col, mode, vw
        if (fontbyte and &H40) = &H40 then PutPixel vram, x + 1, y + lp, col, mode, vw
        if (fontbyte and &H80) = &H80 then PutPixel vram, x + 0, y + lp, col, mode, vw
    Next lp
End Sub

Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode As Byte, vw As Long)
    Select Case mode
        Case 8
            vram[x + vw * y] = col And &HFF
        Case 32
            CPtr(Long Ptr, vram)[vw*y+x] = col
    End Select
End Sub

Sub Mach64_Bitblt(mmio As Unsigned Byte Ptr, xsrc as long, ysrc as long, xs as long, ys as long, xdst as long, ydst as long)
    mmio_write(mmio, Mach64_regs.DP_SRC, &H300)
    mmio_write(mmio, Mach64_regs.SRC_Y_X, &H10000 * xsrc + ysrc)
    mmio_write(mmio, Mach64_regs.SRC_HEIGHT1_WIDTH1, &H10000 * xs + ys)
    mmio_write(mmio, Mach64_regs.DST_CNTL, &H23) ' LastPel + L2R + T2B
    mmio_write(mmio, Mach64_regs.DST_Y_X, &H10000 * xdst + ydst)
    mmio_write(mmio, Mach64_regs.DST_HEIGHT_WIDTH, &H10000 * xs + ys)
End Sub
