' Summary: quickkey.bas
' Contains a standard AT keyboard driver
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos.bi"
#include "x86.bi"

Declare Function ReadKeyboard () As Unsigned Byte
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

' Variable: buttons
' Stores the up/down values for all of the keys
Dim Shared buttons(0 to 255) As Long

' Variable: keycodes
' Stores the last 64 keyboard events
Dim Shared keycodes(0 to 63) As Long

' Variable: lastkeycounter
' Stores the keypress counter
Dim Shared lastkeycounter As Long

' Variable: LastRead
' Stores the last byte read from the keyboard controller
Dim Shared LastRead As Unsigned Byte

' Variable: Keymap:
' Stores the mapping of keys
Dim Shared Keymap(0 to 255) As Byte = _            ' +0   +1  +2  +3  +4  +5  +6  +7
             {  0, 27, 49, 50, 51, 52, 53, 54, _   ' err esc  1   2   3   4   5   6   	+00
               55, 56, 57, 48,  0,  0,  8,  0, _   '  7   8   9   0  - _ + = bsp tab	+08
               81, 87, 69, 82, 84, 89, 85, 73, _   '  Q   W   E   R   T   Y   U   I	+10
               79, 80,  0,  0, 13,  0, 65, 83, _   '  O   P   [   ]  \n  LCt  A   S	+18
               68, 70, 71, 72, 74, 75, 76,  0, _   '  D   F   G   H   J   K   L   :	+20
                0,  0,  0,  0, 90, 88, 67, 86, _   ' ''   ~  LSh  |   Z   X   C   V	+28
               66, 78, 77,  0,  0,  0,  0,  0, _   '  B   N   M   <   >   ?  RSh	+30
                0, 32,  0,  0,  0,  0,  0,  0, _   ' LAl spb Cap F01 F02 F03 F04 F05	+38
                0,  0,  0,  0,  0,  0,  0,  0, _   ' F06 F07 F08 F09 F10 Num ScL Hom	+40
                0,  0,  0,  0,  0,  0,  0,  0, _   ' Up  PUp K-- Lft K-5 Rgt K-+ End	+48
                0,  0,  0,  0,  0,  0,  0,  0, _   ' Dwn PDn Ins Del Prn     Xtr F11	+50
                0,  0,  0,  0,  0,  0,  0,  0, _   ' F12
                0,  0,  0,  0,  0,  0,  0,  0, _   '
                0,  0,  0,  0,  0,  0,  0,  0  }

Sub InitKeyboard
    ' claim KBC
    PortAlloc &H60, 5

    ' Initialize array

End Sub



' Function: ReadKeyboard
' reads a keypress from the kbc and adjusts the state accordingly
'
' a byte is read and acknowledged, and if it equals e0, another byte
' is read and acked. then the msb of the last byte is set it is a release,
' and if its clear its a press
' the presence of e0 tells us wether it is an extended key or not.
Function ReadKeyboard() As Unsigned Byte

    Dim key as unsigned byte
    Dim temp as unsigned byte
    Dim escaped as byte

    escaped = 0
    key = 0

    ' wait for a keypress
    While Key = LastRead or key = 0
        key = inportb(&H60)                 ' peek at the byte posted by the kbc
        temp = inportb(&H61)                ' acknowledge byte read
        outportb(&H61,temp Or  &H80)        ' by disabling
        outportb(&H61,temp And &H7F)        ' and reenabling
        If key = 0 Or key = lastread Then Yield
    Wend

    If key = &HE0 Then
        key = 0
        escaped = 1                         ' it is escaped
        While Key = LastRead or key = 0     ' repeat the sequence
            key = inportb(&H60)
            temp = inportb(&H61)
            outportb(&H61,temp Or  &H80)
            outportb(&H61,temp And &H7F)
        Wend
    End If

    LastRead = Key

    ReadKeyboard = 0

    ' compute wether it was a keyup or keydown
    If (key and &H80) = &H80 Then
        temp = 0
    Else
        temp = 1
    End If
    if escaped = 1 then
        key = key or &H80
    else
        key = key and &H7f
    end if
    ReadKeyboard = key * temp

    ' adjust keypress
    buttons(key) = temp
    lastkeycounter = lastkeycounter + 1
End Function

' Function: ReadKey
' Waits for a keypress, then returns the associated character.
Function ReadKey() As Byte

    Dim b as byte
    b = 0
    While b = 0 or Keymap(b) = 0
        b = ReadKeyboard
    Wend

    ReadKey = Keymap(b)
End Function
