' Summary: remoteprobe.bas
' Serial hardware experimentation tool
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "mos/serial.bi"
#include "mos.bi"

Type rangemap
    StartAddr As Integer
    Size As Integer
    Bus As Integer
    Rangename As String * 52
End Type

Const SER_BASE As Short = &H2F8

Public Function SerReadLine () As String
    Dim s As String
    Dim done As Integer
    Dim rb as Byte
    done = 0
    While done = 0
        rb = ReadSerial(SER_BASE)
        Select Case rb
            
            Case 13
                If (len(s) > 0) Then
                    WriteSerial(SER_BASE, 13)
                    WriteSerial(SER_BASE, 10)                    
                    done = 1
                End If                
            
            Case 127
                If (len(s) > 0) Then
                    s = left$(s, len(s)-1)
                    WriteSerial(SER_BASE, rb)
                End If
            
            Case 32, 48 To 59, 65 To 90, 97 To 122
                If Len(s) < 76 Then
                    s = s + chr$(rb)
                    WriteSerial(SER_BASE, rb)
                End if
        End Select
    Wend
    
    Function = s

End Function

Public Sub ModMain Cdecl Alias "main" ()

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    Portalloc(SER_BASE, &H8)

    InitSerialPort SER_BASE

    While 1 = 1
        
        Dim s As String
        s = Trim$(SerReadLine)
        Dim lhs as String
        Dim rhs As String
        Dim p1 as Integer
        p1 = instr(s, " ")
        if p1 <= 0 Then
            lhs = s
            rhs = ""
        Else
            lhs = trim$(left$(s, p1))
            rhs = trim$(mid$(s, p1+1))
        End If
        
        Select Case lcase$(lhs)
            Case "wb", "w1"
        
            Case Else
                s = "unknown command " + lhs + " in " + s + chr$(10) + chr$(13)
                WriteSerialBlock(SER_BASE, *CPtr(Byte Ptr Ptr, @s), Len(s))        
        End Select
        
    Wend

End Sub