' Summary: test_pci.bas
' Testing stuff for the PCI bus
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos.bi"
#include "x86.bi"
#include "mos/pci.bi"

Declare Sub ModMain CDecl Alias "main"()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
Declare Sub ClearCon (vram As Byte Ptr)

Sub ModMain CDecl Alias "main"()

    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(32, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    PortAlloc(&HCF8, 8)

    ClearCon cram

    Printstring "PCI test:", cram, 0

    Dim lp as long
    
    For lp = 0 to 31
        Dim vendor as Unsigned Short
        Dim device as Unsigned Short
        vendor = PCI_type1_readword(0, lp, 0, 0)
        device = PCI_type1_readword(0, lp, 0, 2)
        PrintString "0:" & lp & ":0 0x" & hex$(vendor) & ":0x" & hex$(device), cram, 320 + 80 * lp
    Next lp

End Sub


' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Public Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + offset] = ch
        vram[lp * 2 - 1 + offset] = 7
    Next lp
End Sub


Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub