' Summary: testisapnp.bas
' Experimentation code for the ISA Plug-and-play specification
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos/isapnp.bi"
#include "mos.bi"

Declare Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Sub ModMain CDecl Alias "main"()

    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(32, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))

    InitKeyboard

    ISAPNP_OpenDefaultPorts

    ISAPNP_ResetDevices

    ISAPNP_WriteMagic

    PortAlloc &H303, 1
    ISAPNP_WriteReadAddress(&H303)

    Dim Identifier(1 to 9) as byte

    ISAPNP_Wake(0)
    ISAPNP_SerialIsolation(Identifier())
    ISAPNP_WriteCSN(1)

    Dim s as String
    Dim lp as integer
    s = "ID: "
    for lp = 1 to 9
        s = s & hex$(identifier(lp)) & " "
    next lp
    printstring s, cram, 20 * 160

    while 1 = 1

    wend
End Sub

Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + offset] = ch
        vram[lp * 2 - 1 + offset] = 7
    Next lp
End Sub
