' Summary: trio64v.bas
' Trio64 test stuff
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos.bi"
#include "x86.bi"
#include "mos/pci.bi"
#include "../gfx/vga_io.bi"

Declare Sub ModMain CDecl Alias "main"()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
Declare Sub ClearCon (vram As Byte Ptr)
Declare Function is_trio64(vendor as unsigned short, device as unsigned short) As Byte
Declare Sub cheapdelay()

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Declare Sub WriteGfxString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode As Byte, vw As Long)
Declare Sub ReadFont(vram as byte ptr, dumper as byte ptr)
Declare Function PlaneSelect(planeno as long) as unsigned byte

Declare Sub Trio64_BlitFill(x As Integer, y As Integer, w As Integer, h As Integer, colour As Integer)
Declare Sub Trio64_BlitFillSpecial(x As Integer, y As Integer, w As Integer, h As Integer, colour As Integer, op As Integer)
Declare Sub Trio64_Blit(srcx As Integer, srcy As Integer, dstx As Integer, dsty As Integer, w As Integer, h As Integer)
Declare Sub Trio64_BlitKeyed(srcx As Integer, srcy As Integer, dstx As Integer, dsty As Integer, w As Integer, h As Integer, colour As Integer)
Declare Sub Trio64_WaitFifobits(slots As Integer)

Dim Shared font() As Unsigned Byte

' S3 notepad
'
' - Here be dragons. :)
'
' - There are three kinds of dacs possibly installed
'       - Trio64 DAC / TI DAC / IBM DAC
'
' - Blitfills use the current coords as dest.
'     Bitblits use the current coords as source and dest* as destination
'     Documentation is wrong here.
'
' - There's missing 24-bpp modes in the S3 doc.
'
' - The color compare fields in PIX_CNTL are missing.
'       Setting bit 5 breaks key blits
'       Suggestion that there be bits for the compare operation here.



Sub ModMain CDecl Alias "main"()

    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(32, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    PortAlloc(&HCF8, 8)

    'ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, &H40000000))
    ' Todo: Causes an oops, work todo in kernel land.
    'BlockAllocPhysL(1, CPtr(Byte Ptr, &H40000000), CPtr(Byte Ptr, &H40000000))

    ClearCon cram

    Printstring "Checking devices...", cram, 0

    InitKeyboard

    Dim lp as long, bus as long, dev as long, fn as long
    Dim lastdevice as Unsigned Short
    Dim mybus as long, mydev as long, myfn as long
    Dim vendor as Unsigned Short, myvendor as unsigned short
    Dim device as Unsigned Short, mydevice as unsigned short
    Dim s3dev as Unsigned Short

    mybus = -1
    s3dev = &HFFFF
    lastdevice = &HFFFF
    lp = 0
    For bus = 0 to 2
        For dev = 0 to 31
            For fn = 0 to 7
                vendor = PCI_type1_readword(bus, dev, fn, 0)
                device = PCI_type1_readword(bus, dev, fn, 2)
                If is_trio64(vendor, device) Then
                    mybus = bus
                    mydev = dev
                    myfn = fn
                    myvendor = vendor
                    mydevice = device
                    exit for
                ElseIf vendor = &H5333 Then
                    s3dev = device
                End If
            Next fn
        Next dev
    Next bus

    If mybus = -1 then
        if s3dev <> &HFFFF Then
            PrintString "unknown S3 chip found: 0x" & hex$(s3dev), cram, 160
    Else
            PrintString "No trio64 or compatible chip found", cram, 160
    End if
        Exit Sub
    End if
    PrintString "S3 Trio64 found on device " & mybus & ":" & mydev & ":" & myfn, cram, 160

    PrintString "PCI ID: 0x" & hex$(myvendor) & ":0x" & hex$(mydevice), cram, 320

    Dim bar as Unsigned Long, barmask As Unsigned Long
    Dim portbase as long
    Dim mmiobase as long
    Dim framebuffer as Long
    framebuffer = 0

    For lp = 5 to 0 step -1
        barmask = PCI_bar_readmask(mybus,mydev,myfn, lp)
        bar = PCI_bar_readaddress(mybus,mydev,myfn, lp)
        printstring "Bar " & lp & ": 0x" & hex$(barmask) & " @ 0x" & hex$(bar), cram, (3+lp) * 160
        If bar = 0 then

        Elseif (barmask and &H1) = 1 Then
            portbase = bar and &HFFF8&
        Elseif ((barmask and &HFFFF0) = 0) And (framebuffer = 0) then
            framebuffer = bar
        Else
            mmiobase = bar
        End If
    Next lp

    PrintString "LFB offset: 0x" & hex$(framebuffer), cram, 10 * 160

    If framebuffer = 0 then Exit Sub

    Dim lfb as unsigned byte ptr
    lfb = CPtr(Unsigned byte ptr, &HF0000000)

    ' allocate vga+s3 ports
    portalloc(&H3B0, &H30)

    ' allocate framebuffer
    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, framebuffer))
    BlockAllocPhysL(1, CPtr(Byte Ptr, &HF0000000), CPtr(Byte Ptr, framebuffer))

    PrintString "S3 signature: " & hex$(Read3D4(&H30)) & ":" & hex$(Read3D4(&H2E)) & ":" & hex$(Read3D4(&H2F)), cram, 11 * 160

    Dim acc As String, rb As String
    Dim regno As Integer

    ReadKey

    acc = ""
    For regno = 0 to 96
        rb = hex$(Read3D4(regno))
        if len(rb) = 1 then acc = acc & "0"
        acc = acc & rb
        if (regno mod 16) = 0 Then
            PrintString acc, cram, 160 * (12 + regno \ 16)
            acc = ""
        Else
            acc = acc & ":"
        End if
    Next regno

    ReadKey

    redim font(8192)
    ReadFont(vram, CPtr(Byte Ptr, @font(0)))
    VGASet640x480x16Mode
    VGAEnableDisplay
    Write3C4 &H2, &HF
    For regno = 0 to 65535
        vram[regno] = 0
    Next regno
    WriteGfxString vram, "Entered graphics mode", 10, 10, 7, 4, 640
    ReadKey

    ' LFB aperture
    Write3D4(&H58, Read3D4(&H58) Or &H13) ' Enable aperture, select maximum size
    WriteGfxString vram, "LFB Aperture enabled", 10, 30, 7, 4, 640
    ReadKey

    ' Unlock S3 Extended regs
    Write3C4(&H08, &H06) ' PLL lock
    Write3D4(&H38, &H48) ' CR lock #1
    Write3D4(&H39, &HA5) ' CR lock #2
    Write3D4(&H33, Read3D4(&H33) And &HAD) ' VGA lock
    WriteGfxString vram, "Registers unlocked", 10, 50, 7, 4, 640
    ReadKey

    ' Sparse ports - on a PCI device! (Yes really!!! THE **** MORONS!!!!1)
    for regno = &H42E8 to &HE2E8 Step &H400
        portalloc(regno, &H4)
    next regno
    portalloc &H102, 1
    WriteGfxString vram, "Ports requested", 10, 70, 7, 4, 640
    ReadKey


    ' Enhanced mode
    outportb(&H46E8, &H10)
    outportb(&H102, &H1)
    outportb(&H46E8, &H10)

    outportw(&H4AE8, 1)
    Write3D4(&H31, Read3D4(&H31) Or &H09) ' diable bank mode, enable enhanced memory mapping. Effectively unfolds VGA planes
    Write3D4(&H13, 160)                   ' 640 * 2 / 8
    Write3C4 &H2, &HF                     ' all planes enabled
    WriteGfxString lfb, "SVGA Mode enabled", 10, 90, 7, 8, 1280
    ReadKey

    ' enable 16bpp rendering
    Write3D4(&H67, (Read3D4(&H67) And &H0F) Or &H50) ' 16bpp format
    Write3D4(&H3A, &H35) ' Advanced pixel shift mode
    Write3D4(&H43, &H09) ' 64K color mode, double data rate
    WriteGfxString lfb, "16 bit mode", 10, 110, &HAAAA, 16, 1280
    ReadKey

    ' Horizontal Timing
    ' h_total = (768 * 2 / 8) - 1
    Write3D4(&H0, &HC3) ' H.total = 800 (bPP*w/8 - 5)
    Write3D4(&H1, &H9F) ' H.active = 640
    Write3D4(&H2, &HA0) ' H.blank.start = h.total+1
    Write3D4(&H3, &H83) ' H.blank.end = h.active[0..4] | &H80
    Write3D4(&H4, &HA8) ' H.sync.start
    Write3D4(&H5, &H08) ' H.sync.end + H.blank.end[5]
    ' Overflow register
    Write3D4(&H5D, Read3D4(&H5D) And &HC0)

    WriteGfxString lfb, "640 width timing", 10, 130, &HAAAA, 16, 1280
    ReadKey

    ' Bit format stuff
    Write3D4(&H50, (Read3D4(&H50) And &HCF) Or &H10)
    ' Pan / offset stuff
    Write3D4(&H0C, 0)
    Write3D4(&H0D, 0)
    Write3D4(&H08, 0)
    ReadKey

    Dim x As Integer
    Dim y as Integer
    
    For x = 0 to 639
    For y = 0 to 479
        Putpixel(lfb, x, y, &H50 * x + y, 16, 1280)
    Next y
    Next x

    ReadKey
    
    For x = 0 to 639
    For y = 0 to 479
        Putpixel(lfb, x, y, &H1000, 16, 1280)
    Next y
    Next x

    For x = 0 to 639 Step 2
        Putpixel(lfb, x, 0, &HAAAA, 16, 1280)
        Putpixel(lfb, x, 479, &HAAAA, 16, 1280)
        if ((x mod 10) = 0) Then
            Putpixel(lfb, x, 1, &HAAAA, 16, 1280)
            Putpixel(lfb, x, 478, &HAAAA, 16, 1280)
        end if
        if ((x mod 100) = 0) Then
            Putpixel(lfb, x, 2, &HAAAA, 16, 1280)
            Putpixel(lfb, x, 477, &HAAAA, 16, 1280)
        End if
    Next x

    For y = 0 to 479 Step 2
        Putpixel(lfb, 0, y, &HCCCC, 16, 1280)
	Putpixel(lfb, 639, y, &HCCCC, 16, 1280)
	If (y mod 10) = 0 then
	    Putpixel(lfb,638,y,&HCCCC,16,1280)
	    Putpixel(lfb,1,y,&HCCCC,16,1280)
	End if
    Next y

    'ReadKey
    'Write3D4(&H3A, &H35)
    'ReadKey
    'Write3C0(&H33, &H0)
    'ReadKey
    ' Enhanced mode
    'Write3D4(&H3A, Read3D4(&H3A) Or &H10) ' Enhanced shift register -> 8+ bpp
    'Write3D4(&H50, Read3D4(&H50) And &HE7) ' 3-4 = 0-> 4 or 8bpp
    'ReadKey
    'WriteGfxString vram, "Enhanced Mode", 10, 70, 7, 8, 320
    'WriteGfxString lfb, "Enhanced Mode", 10, 70, 7, 8, 320
    'ReadKey

    ReadKey

    For regno = &H42E8 to &HBEE8 step &H400
        Dim v as Integer
        v = inportw(regno)
        WriteGfxString lfb, "0x" & hex$(regno) & " = 0x" & hex$(v), 10, regno \ &H40 - &H100, &HFFFF, 16, 1280
    Next regno

    ReadKey

    For x = 0 to 15
    For y = 0 to 7
         Dim v as integer
	 v = Read3D4(x + 16*y)
	 WriteGfxString(lfb, hex$(v), 200 + 24*x, 10 + 16*y, &HAAAA, 16, 1280)
    next y
    next x

    ReadKey
    ' diff = 10 11 14 15 16 17 39 3A 3B 3C 43 50 53 54 58
    ' later = 45 46 48 4C 4E 4F
    ' undoc = 54

    WriteGfxString(lfb, "#4", 180, 58, &HAAAA, 16, 1280)
    Write3D4(&H43, &H01)
    ReadKey
    Write3D4(&H43, &H08)
    ReadKey

    WriteGfxString(lfb, "#1", 180, 10, &HAAAA, 16, 1280)
    Write3D4(&H10, &HE0)
    Write3D4(&H11, &H83)
    Write3D4(&H14, &H60)
    Write3D4(&H15, &HDF)
    Write3D4(&H16, &H00)
    Write3D4(&H17, &HAB)
    ReadKey

    WriteGfxString(lfb, "#3", 180, 26, &HAAAA, 16, 1280)
    Write3D4(&H39, &HAD)
    Write3D4(&H3A, &H15)
    Write3D4(&H3B, &HBE)
    Write3D4(&H3C, &H68)
    ReadKey

    WriteGfxString(lfb, "#5", 180, 42, &HAAAA, 16, 1280)
    Write3D4(&H50, &H50)
    Write3D4(&H53, &H08)
    Write3D4(&H54, &HF8)
    Write3D4(&H58, &H91)
    ReadKey

    WriteGfxString lfb, "1", 10, 10, &HAAAA, 16, 1280
    outportw(&H42E8, &H800F) ' Reset Engine
    WriteGfxString lfb, "2", 20, 10, &HAAAA, 16, 1280
    CheapDelay
    outportw(&H42E8, &H400F) ' Enable Engine
    WriteGfxString lfb, "3", 30, 10, &HAAAA, 16, 1280

    outportw(&H46E8, 4) ' Enable decoding
    WriteGfxString lfb, "4", 40, 10, &HAAAA, 16, 1280

    outportw(&HBEE8, &H1000) ' Top Scissor
    outportw(&HBEE8, &H2000) ' Left Scissor
    outportw(&HBEE8, &H3000 + 480 - 1) ' Bottom Scissor
    outportw(&HBEE8, &H4000 + 640 - 1) ' Right Scissor
    outportw(&HBEE8, &HD000) ' Misc Control Register - clip inside
    outportw(&HBEE8, &HA000) ' Always use foreground mix, Comparison Equal (undocumented)
    outportw(&HAAE8, &HFFFF) ' Enable writes to all planes
    outportw(&HAEE8, &H0000) ' Do not block reads from any plane
    Do
        regno = inportw(&H9AE8)
        WriteGfxString(lfb, hex$(regno), 100, 20, &HAAAA, 16, 1280)
    Loop while (regno and &HFF) > 0

    Write3D4(&H50, (Read3D4(&H50) And &H3E) Or &H40) ' GE Width = 640

    WriteGfxString lfb, "5", 50, 10, &HAAAA, 16, 1280
    'Trio64_BlitFill(20, 20, 50, 50, &H07FF)
    WriteGfxString lfb, "6", 60, 10, &HAAAA, 16, 1280

    Do
        regno = inportw(&H9AE8)
        WriteGfxString(lfb, hex$(regno), 100, 40, &HAAAA, 16, 1280)
    Loop while (regno and &HFF) > 0

    ReadKey

    'Trio64_BlitFill(160,40, 300, 25, &HC111)
    'Trio64_BlitFill(400,70, 100,200, &H1C11)
    'Trio64_BlitFill(110,100, 40, 60, &H11F1)
    'Trio64_BlitFill(170,10, 10, 300, &H111C)
'
    'Trio64_BlitFillSpecial(130, 120, 450, 20, &HFFFF, 5)   ' xor fill
    'Trio64_BlitFillSpecial(140, 130, 450, 20, &HFF00, &HC) ' and fill

    'Trio64_Blit(10,100, 280,180, 50,50)
    'Trio64_Blit(10,100, 310,250, 50,50)
    'Trio64_Blit(10,100, 250,260, 50,50)

    'Trio64_BlitKeyed(10,100, 370,200, 50,50, &H1000)
    'Trio64_BlitKeyed(10,100, 470,200, 50,50, &HFFFF)

    ReadKey

End Sub


' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Public Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + offset] = ch
        vram[lp * 2 - 1 + offset] = 7
    Next lp
End Sub


Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub

Function is_trio64(vendor as unsigned short, device as unsigned short) As Byte
    function = 0
    if vendor <> &H5333 then exit function
    if device = &H8811 then function = 1
    if device = &H8901 then function = 1
End Function

Sub cheapdelay()
    Dim lp as Long
    For lp = 0 To 6600000
    Next lp
End Sub

Sub WriteGfxString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
    Dim lp as long
    For lp = 1 to len(s)
        WriteGfxChar vram, asc(mid$(s,lp,1)), x + 8 * (lp - 1), y, col, mode, vw
    next lp
End Sub
Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, x as long, y as long, col as long, mode as Byte, vw as Long)
    dim lp as long
    Dim fontbyte as byte
    For lp = 0 to 15
        fontbyte = font(32 * ch + lp)
        if (fontbyte and &H01) = &H01 then PutPixel vram, x + 7, y + lp, col, mode, vw
        if (fontbyte and &H02) = &H02 then PutPixel vram, x + 6, y + lp, col, mode, vw
        if (fontbyte and &H04) = &H04 then PutPixel vram, x + 5, y + lp, col, mode, vw
        if (fontbyte and &H08) = &H08 then PutPixel vram, x + 4, y + lp, col, mode, vw
        if (fontbyte and &H10) = &H10 then PutPixel vram, x + 3, y + lp, col, mode, vw
        if (fontbyte and &H20) = &H20 then PutPixel vram, x + 2, y + lp, col, mode, vw
        if (fontbyte and &H40) = &H40 then PutPixel vram, x + 1, y + lp, col, mode, vw
        if (fontbyte and &H80) = &H80 then PutPixel vram, x + 0, y + lp, col, mode, vw
    Next lp
End Sub

Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode As Byte, vw As Long)
    Select Case mode
        Case 4
            Dim setbyte as Byte
            Dim clearbyte as Byte
            Dim address as Long
            setbyte = PlaneSelect(7-(x Mod 8))
            clearbyte = 255 - setbyte
            address = (x + vw * y) \ 8
            Write3C4 &H2, 1
            Write3CE &H4, 0
            if (col and 1) = 1 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 2
            Write3CE &H4, 1
            if (col and 2) = 2 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 4
            Write3CE &H4, 2
            if (col and 4) = 4 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 8
            Write3CE &H4, 3
            if (col and 8) = 8 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
        Case 7
            Write3C4 &H2, PlaneSelect(x Mod 4)
            vram[(x + vw * y) \ 4] = col And &HFF
        Case 8
            vram[x + vw * y] = col And &HFF
            
        Case 16
            CPtr(Short Ptr, @vram[vw*y])[x] = col And &HFFFF
        Case 32
            CPtr(Long Ptr, @vram[vw*y])[x] = col
    End Select
End Sub

Function PlaneSelect(planeno as long) as unsigned byte
    Select Case planeno
        Case 0
            PlaneSelect = 1
        Case 1
            PlaneSelect = 2
        Case 2
            PlaneSelect = 4
        Case 3
            PlaneSelect = 8
        Case 4
            PlaneSelect = 16
        Case 5
            PlaneSelect = 32
        Case 6
            PlaneSelect = 64
        Case 7
            PlaneSelect = &H80
    End Select
End Function

Sub ReadFont(vram as byte ptr, dumper as byte ptr)
    Dim lp As Long
    VGASet320x200Mode
    VGASetModeX
    Write3CE &H4, &H2
    For lp = 0 To 8191
        dumper[lp] = vram[lp]
    Next lp
End Sub

Sub Trio64_BlitFill(x As Integer, y As Integer, w As Integer, h As Integer, colour As Integer)

    Trio64_WaitFifobits(7)

    ' background mix
    outportw(&HBAE8, &H27) ' SRC = foreground; MIX = SRC

    ' push parameters
    outportw(&H82E8, y)
    outportw(&H86E8, x)
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)
    outportd(&HA6E8, colour)

    ' send command
    outportw(&H9AE8, &H40B1)

End Sub

Sub Trio64_BlitFillSpecial(x As Integer, y As Integer, w As Integer, h As Integer, colour As Integer, op As Integer)

    Trio64_WaitFifobits(7)

    ' background mix
    outportw(&HBAE8, &H20 + op) ' SRC = foreground; MIX = op

    ' push parameters
    outportw(&H82E8, y)
    outportw(&H86E8, x)
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)
    outportd(&HA6E8, colour)

    ' send command
    outportw(&H9AE8, &H40B1)

End Sub

Sub Trio64_Blit(srcx As Integer, srcy As Integer, dstx As Integer, dsty As Integer, w As Integer, h As Integer)

    Trio64_WaitFifobits(3)

    ' Select source bmp
    outportw(&H82E8, srcy)
    outportw(&H86E8, srcx)

    ' background mix
    outportw(&HBAE8, &H67) ' SRC = video memory; MIX = src


    Trio64_WaitFifobits(5)

    ' push parameters
    outportw(&H8AE8, dsty)
    outportw(&H8EE8, dstx)
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)

    ' send command
    outportw(&H9AE8, &HC0B1) ' Send command - BitBlit, X incrementing, Y incrementing, Write enable, Access enable

End Sub

Sub Trio64_BlitKeyed(srcx As Integer, srcy As Integer, dstx As Integer, dsty As Integer, w As Integer, h As Integer, colour As Integer)

    Trio64_WaitFifobits(5)

    ' Set colorkey
    outportw(&HBEE8, &HE100) ' enable keyed blit
    outportd(&HB2E8, colour)

    ' Select source bmp
    outportw(&H82E8, srcy)
    outportw(&H86E8, srcx)

    ' background mix
    outportw(&HBAE8, &H67) ' SRC = video memory; MIX = src

    Trio64_WaitFifobits(6)

    ' Select dest bitmap
    outportw(&H8AE8, dsty)
    outportw(&H8EE8, dstx)

    ' Select bitmap size
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)

    ' send command
    outportw(&H9AE8, &HC0B1) ' Send command - BitBlit, X incrementing, Y incrementing, Write enable, Access enable
    outportw(&HBEE8, &HE000) ' disable keyed blit

End Sub

Sub Trio64_WaitFifobits(slots As Integer)
    Dim reg As Integer
    Dim mybit As Integer

    mybit = (&H100 SHR slots) And &HFF
    Do
        reg = inportw(&H9AE8)
    loop while (reg And mybit)
End Sub
