' Summary: tweak.bi
' Header file for the tweak tool
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#ifndef _tweak_bi_
#define _tweak_bi_

'
' Tech functions
'

Declare Sub DeviceNames(ByRef vendorString As String, ByRef deviceString As String, ByVal vendor As Short, ByVal device As Short)

Type RegisterType
    Address as Long    
    Value as Long    
    Setter As Sub(ByRef register As RegisterType)
    Getter As Sub(ByRef register As RegisterType)
    Index as Short
    Enabled as Byte
    UIType As Byte
    Description As String * 15
End Type

Extern device_lfb As Byte Ptr
Extern device_mmio As Byte Ptr
Extern device_port As Short

Extern reg_listing() As RegisterType
Extern reg_count As Integer

' basic getter-setters
Declare Sub DummyGetter(ByRef register As RegisterType)
Declare Sub ByteGetterAbs(ByRef register As RegisterType)
Declare Sub ByteSetterAbs(ByRef register As RegisterType)
Declare Sub ByteGetterPIO(ByRef register As RegisterType)
Declare Sub ByteSetterPIO(ByRef register As RegisterType)
Declare Sub WordGetterPIO(ByRef register As RegisterType)
Declare Sub WordSetterPIO(ByRef register As RegisterType)
Declare Sub DWordGetterPIO(ByRef register As RegisterType)
Declare Sub DWordSetterPIO(ByRef register As RegisterType)
Declare Sub ByteGetterMMIO(ByRef register As RegisterType)
Declare Sub ByteSetterMMIO(ByRef register As RegisterType)
Declare Sub WordGetterMMIO(ByRef register As RegisterType)
Declare Sub WordSetterMMIO(ByRef register As RegisterType)
Declare Sub DWordGetterMMIO(ByRef register As RegisterType)
Declare Sub DWordSetterMMIO(ByRef register As RegisterType)

Declare Sub ByteGetterIndexedAB(ByRef register As RegisterType)
Declare Sub ByteSetterIndexedAB(ByRef register As RegisterType)
Declare Sub ByteGetter3C0(ByRef register As RegisterType)
Declare Sub ByteSetter3C0(ByRef register As RegisterType)
Declare Sub ByteGetter3C4(ByRef register As RegisterType)
Declare Sub ByteSetter3C4(ByRef register As RegisterType)
Declare Sub SetterVGACrtcEnable(ByRef register As RegisterType)
Declare Sub SetterVGAUnlock(ByRef register As RegisterType)

Declare Sub WordGetterBGA(ByRef register As RegisterType)
Declare Sub WordSetterBGA(ByRef register As RegisterType)
Declare Sub SetterBGADisable(ByRef register As RegisterType)

Declare Sub AddRegister(ByVal Address As Integer, ByVal Index As Short, ByVal Getter As Sub(ByRef reg As RegisterType), ByVal Setter As Sub(ByRef reg As RegisterType), ByVal model As Byte, ByRef Description As String)

Declare Sub Reglist_VGA()
Declare Sub Reglist_BGA()
Declare Sub Reglist_Mach64()

Enum REG_CLASS
    SIZE_8  = &H01
    SIZE_16 = &H02
    SIZE_32 = &H04
    CRT = &H10
    DAC = &H20
    SEQ = &H30
    CLK = &H40   
End Enum

'
' Functionalities
'

Declare Sub TestSettings
Declare Sub CloneSettings(ByVal modeno As Integer)


'
' UI functions
' 

Type UIState
    Row_offset As Integer
    Selected_index As Integer
    
    Charnum As Integer
End Type

Extern TweakUI As UIState

Declare Sub ClearCon (ByVal vram As Byte Ptr)
Declare Sub PrintStringC (ByRef s As String, ByVal vram As Byte Ptr, ByVal x As Integer, ByVal y As Integer, ByVal colour As Byte)
Declare Sub PrintString (ByRef s As String, ByVal vram As Byte Ptr, ByVal offset As Integer)
Declare Sub RenderNum(ByVal number As Integer, ByVal digits As Byte, ByVal selected As Byte, ByVal x As Integer, ByVal y As Integer, ByVal cram As Byte Ptr)
Declare Sub UIEventLoop(ByVal cram As Byte Ptr, ByRef state As UIState)
Declare Function UIModeLoop(ByVal cram As Byte Ptr) As Integer
Declare Sub PushDigit(ByVal digit As Integer, ByRef state As UIState)
Declare Function GetYesNo () As Integer

#endif
