' Summary: tweakdev.bas
' Device access toolkit for tweak
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "./tweak.bi"
#include "mos.bi"
#include "x86.bi"

' register definitions
#include "../gfx/vga_io.bi"
#include "mos/bga_regs.bi"
#include "mos/mach64_id.bi"

Sub DeviceNames(ByRef vendorString As String, ByRef deviceString As String, ByVal vendor As Short, ByVal device As Short)
    
    deviceString = "(unknown)"
    
    Select Case vendor
        Case 0
            vendorString = "(none)"
            deviceString = "(none)"
        Case &HFFFF
            vendorString = "(none)"
            deviceString = "(none)"
    
        Case &H1002
            vendorString = "ATI/AMD"
            if (device = &H4354)    Then deviceString = "Mach64 CT"
            if (device = &H4358)    Then deviceString = "Mach64 CX"
            if (device = &H4554)    Then deviceString = "Mach64 ET"
            
            if (device = &H4654)    Then deviceString = "Mach64 VT (#1)"
            if (device = &H4754)    Then deviceString = "Mach64 GT"
            if (device = &H4758)    Then deviceString = "Mach64 GX"
            if (device = &H4C54)    Then deviceString = "Mach64 LT"
            if (device = &H5654)    Then deviceString = "Mach64 VT (#2)"
            if (device = &H5655)    Then deviceString = "Mach64 VT3"
            if (device = &H5656)    Then deviceString = "Mach64 VT4"

            if (device = &H4742)    Then deviceString = "Mach64 GB 3D Rage Pro AGP 1X/2X" : Reglist_Mach64
            if (device = &H4744)    Then deviceString = "Mach64 GD 3D Rage Pro AGP 1X" : Reglist_Mach64   
            if (device = &H4747)    Then deviceString = "Mach64 GG 3D Rage Pro PCI" : Reglist_Mach64
            if (device = &H4749)    Then deviceString = "Mach64 GI 3D Rage Pro PCI" : Reglist_Mach64
            if (device = &H474C)    Then deviceString = "Mach64 GL 3D Rage XC PCI" : Reglist_Mach64
            if (device = &H474D)    Then deviceString = "Mach64 GM 3D Rage XL AGP2X" : Reglist_Mach64
            if (device = &H474E)    Then deviceString = "Mach64 GN 3D Rage XC AGP" : Reglist_Mach64
            if (device = &H474F)    Then deviceString = "Mach64 GO 3D Rage XL PCI" : Reglist_Mach64
            if (device = &H4750)    Then deviceString = "Mach64 GP 3D Rage Pro GP" : Reglist_Mach64
            if (device = &H4751)    Then deviceString = "Mach64 GQ 3D Rage Pro GQ" : Reglist_Mach64
            if (device = &H4752)    Then deviceString = "Mach64 GR 3D Rage XL PCI" : Reglist_Mach64
            if (device = &H4753)    Then deviceString = "Mach64 GS 3D Rage XC" : Reglist_Mach64
            if (device = &H4755)    Then deviceString = "Mach64 GU 3D Rage II+" : Reglist_Mach64
            if (device = &H4756)    Then deviceString = "Mach64 GV 3D Rage IIC" : Reglist_Mach64
            if (device = &H4757)    Then deviceString = "Mach64 GW 3D Rage IIC AGP" : Reglist_Mach64
            if (device = &H4759)    Then deviceString = "Mach64 GY 3D Rage IIC" : Reglist_Mach64
            if (device = &H475A)    Then deviceString = "Mach64 GZ 3D Rage IIC AGP" : Reglist_Mach64
            if (device = &H4C42)    Then deviceString = "Mach64 LB 3D Rage LT Pro AGP-133" : Reglist_Mach64
            if (device = &H4C44)    Then deviceString = "Mach64 LD 3D Rage LT Pro AGP-66" : Reglist_Mach64
            if (device = &H4C45)    Then deviceString = "Mach64 LE 3D Rage Mobility M3" : Reglist_Mach64
            if (device = &H4C46)    Then deviceString = "Mach64 LF 3D Rage Mobility M3 AGP" : Reglist_Mach64
            if (device = &H4C47)    Then deviceString = "Mach64 LG 3D Rage LT" : Reglist_Mach64
            if (device = &H4C49)    Then deviceString = "Mach64 LI 3D Rage LT Pro" : Reglist_Mach64
        
        Case &H1013
            vendorString = "Cirrus Logic"
            If (device = &H00B8)    Then deviceString = "GD 5446"
        
        Case &H10DE
            vendorString = "nVidia"
            
        Case &H1163
            vendorString = "Rendition"
            if (device = 1)         Then deviceString = "Verite V1000"
            If (device = &H2000)    Then deviceString = "Verite V2x00"
    
        Case &H1234
            vendorString = "(fake)"
            if (device = &H1111)    Then deviceString = "Bochs Graphics Array" : Reglist_BGA
        
        Case &H15AD
            vendorString = "VMWare"
    
        Case &H5333
            vendorString = "S3"
    
        Case &H8086
            vendorString = "Intel"
    
        Case Else
            vendorString = "(unknown)"
            deviceString = "(unknown)"
    
    End Select
End Sub

' dummy
Sub DummyGetter(ByRef register As RegisterType)
    register.value = 0
End Sub

' ISA ports
Sub ByteGetterAbs(ByRef register As RegisterType)
    register.value = inportb(register.address)
End Sub
Sub ByteSetterAbs(ByRef register As RegisterType)
    outportb(register.address, register.value)
End Sub

' PNP ports
Sub ByteGetterPIO(ByRef register As RegisterType)
    register.value = inportb(register.address + device_port)
End Sub
Sub ByteSetterPIO(ByRef register As RegisterType)
    outportb(device_port + register.address, register.value)
End Sub
Sub WordGetterPIO(ByRef register As RegisterType)
    register.value = inportw(register.address + device_port)
End Sub
Sub WordSetterPIO(ByRef register As RegisterType)
    outportw(device_port + register.address, register.value)
End Sub
Sub DWordGetterPIO(ByRef register As RegisterType)
    register.value = inportd(register.address + device_port)
End Sub
Sub DWordSetterPIO(ByRef register As RegisterType)
    outportd(device_port + register.address, register.value)
End Sub

' MMIO ports
Sub ByteGetterMMIO(ByRef register As RegisterType)
    Dim address As Unsigned Byte Ptr
    address = CPtr(Unsigned Byte Ptr, device_mmio + register.address)
    register.value = address[0]
End Sub
Sub ByteSetterMMIO(ByRef register As RegisterType)
    Dim address As Unsigned Byte Ptr
    address = CPtr(Unsigned Byte Ptr, device_mmio + register.address)
    address[0] = register.value
End Sub
Sub DWordGetterMMIO(ByRef register As RegisterType)
    Dim address As Unsigned Integer Ptr
    address = CPtr(Unsigned Integer Ptr, device_mmio + register.address)
    register.value = address[0]
End Sub
Sub DWordSetterMMIO(ByRef register As RegisterType)
    Dim address As Unsigned Integer Ptr
    address = CPtr(Unsigned Integer Ptr, device_mmio + register.address)
    address[0] = register.value
End Sub

' VGA style gadgets
Sub ByteGetterIndexedAB(ByRef register As RegisterType)
    outportb(register.address, register.index)
    register.value = inportb(register.address + 1)
End Sub
Sub ByteSetterIndexedAB(ByRef register As RegisterType)
    outportb(register.address, register.index)
    outportb(register.address + 1, register.value)
End Sub
Sub ByteGetter3C0(ByRef register As RegisterType)
    register.value = Read3C0(register.index)    
    VGAEnableDisplay
End Sub
Sub ByteSetter3C0(ByRef register As RegisterType)
    Write3C0(register.index, register.value)
End Sub
Sub ByteGetter3C4(ByRef register As RegisterType)
    register.value = Read3C4(register.index)    
End Sub
Sub ByteSetter3C4(ByRef register As RegisterType)
    Write3C4(register.index, register.value)
End Sub
Sub ByteGetter3C2(ByRef register As RegisterType)
    register.value = Read3C2
End Sub
Sub ByteSetter3C2(ByRef register As RegisterType)
    Write3C2(register.value)
End Sub
Sub SetterVGACrtcEnable(ByRef register As RegisterType)
    VGAEnableDisplay
End Sub
Sub SetterVGAUnlock(ByRef register As RegisterType)
    VGAUnlockCRTC
End Sub

' BGA gadgets
Sub WordGetterBGA(ByRef register As RegisterType)
    register.value = BGA_Read(register.index)
End Sub
Sub WordSetterBGA(ByRef register As RegisterType)
    BGA_Write(register.index, register.value)
End Sub
Sub SetterBGADisable(ByRef register As RegisterType)
    BGA_Write(INDEX_ENABLE, 0)
End Sub

' Mach64 gadgets
Sub ByteGetterMachCT(ByRef register As RegisterType)
    Dim address As Unsigned Byte Ptr
    address = CPtr(Unsigned Byte Ptr, device_mmio + 3072)
    address[Mach64_Regs.CLOCK_CNTL_ADDR] = (register.index SHL 2) And &HFC
    register.value = address[Mach64_Regs.CLOCK_CNTL_DATA]    
End Sub
Sub ByteSetterMachCT(ByRef register As RegisterType)
    Dim address As Unsigned Byte Ptr
    address = CPtr(Unsigned Byte Ptr, device_mmio + 3072)
    address[Mach64_Regs.CLOCK_CNTL_ADDR] = (register.index SHL 2) Or &H02
    address[Mach64_Regs.CLOCK_CNTL_DATA] = register.value
    address[Mach64_Regs.CLOCK_CNTL_ADDR] = (register.index SHL 2) And &HFC
End Sub
Sub SetterMachCTSuspendPLL(ByRef register As RegisterType)
    Dim address As Unsigned Byte Ptr
    address = CPtr(Unsigned Byte Ptr, device_mmio + 3072)
    address[Mach64_Regs.CLOCK_CNTL_ADDR] = (register.index SHL 2) Or &H02
    address[Mach64_Regs.CLOCK_CNTL_DATA] = register.value
    address[Mach64_Regs.CLOCK_CNTL_ADDR] = (register.index SHL 2) And &HFC
End Sub
Sub SetterMachCTResumePLL(ByRef register As RegisterType)
    Dim address As Unsigned Byte Ptr
    address = CPtr(Unsigned Byte Ptr, device_mmio + 3072)
    address[Mach64_Regs.CLOCK_CNTL_ADDR] = (register.index SHL 2) Or &H02
    address[Mach64_Regs.CLOCK_CNTL_DATA] = register.value
    address[Mach64_Regs.CLOCK_CNTL_ADDR] = (register.index SHL 2) And &HFC
    
    Dim lp As Long
    For lp = 1 to 10000000
    Next lp    
End Sub

' Patterns
Sub Reglist_VGA()
    PortAlloc BGA_INDEX_PORT, 3

    AddRegister 0, 0, @DummyGetter, @SetterVGAUnlock, 1 + REG_CLASS.CLK, "Unlock CRTC"
    AddRegister &H3C0, &H10, @ByteGetter3C0, @ByteSetter3C0, 1 + REG_CLASS.DAC, "Attribute Mode"
    AddRegister &H3C0, &H11, @ByteGetter3C0, @ByteSetter3C0, 1 + REG_CLASS.SEQ, "Overscan"
    AddRegister &H3C0, &H12, @ByteGetter3C0, @ByteSetter3C0, 1 + REG_CLASS.SEQ, "Color Plane"
    AddRegister &H3C0, &H13, @ByteGetter3C0, @ByteSetter3C0, 1 + REG_CLASS.SEQ, "H. Pixel Pan"
    AddRegister &H3C0, &H14, @ByteGetter3C0, @ByteSetter3C0, 1 + REG_CLASS.DAC, "Color Select"

    AddRegister &H3C2, 0, @ByteGetter3C2, @ByteSetter3C2, 1 + REG_CLASS.CLK, "Misc. Output."
        
    AddRegister &H3C4, &H01, @ByteGetter3C4, @ByteSetter3C4, 1 + REG_CLASS.SEQ, "Clocking Mode"
    AddRegister &H3C4, &H02, @ByteGetter3C4, @ByteSetter3C4, 1 + REG_CLASS.SEQ, "Map Mask"
    AddRegister &H3C4, &H03, @ByteGetter3C4, @ByteSetter3C4, 1 + REG_CLASS.SEQ, "Character Map"
    AddRegister &H3C4, &H04, @ByteGetter3C4, @ByteSetter3C4, 1 + REG_CLASS.SEQ, "Seq. Mem. Mode"
    
    AddRegister &H3CE, &H04, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.SEQ, "Read Map"
    AddRegister &H3CE, &H05, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.SEQ, "Graphics Mode"
    AddRegister &H3CE, &H06, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.SEQ, "Misc. Graphics"
    
    AddRegister &H3D4, &H00, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "H. Total"
    AddRegister &H3D4, &H01, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "End H. Display"
    AddRegister &H3D4, &H02, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Start H. Blank"
    AddRegister &H3D4, &H03, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "End H. Blank"
    AddRegister &H3D4, &H04, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Start H.Retrace"
    AddRegister &H3D4, &H05, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "End H.Retrace"
    AddRegister &H3D4, &H06, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "V. Total"
    AddRegister &H3D4, &H07, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Overflow Register"
    AddRegister &H3D4, &H08, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Preset Row Scan"
    AddRegister &H3D4, &H09, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Max. Scan Line"
    AddRegister &H3D4, &H10, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Start V.Retrace"
    AddRegister &H3D4, &H11, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "End V.Retrace"
    AddRegister &H3D4, &H12, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "V. Display End"
    AddRegister &H3D4, &H13, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Offset"
    AddRegister &H3D4, &H14, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Underline Location"
    AddRegister &H3D4, &H15, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Start V. Blank"
    AddRegister &H3D4, &H16, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "End V. Blank"
    AddRegister &H3D4, &H17, @ByteGetterIndexedAB, @ByteSetterIndexedAB, 1 + REG_CLASS.CRT, "Mode Control"
    AddRegister 0, 0, @DummyGetter, @SetterVGACrtcEnable, 1 + REG_CLASS.CLK, "VGA Enable"
End Sub

Sub Reglist_BGA
    AddRegister &H1CE, INDEX_ENABLE,        @DummyGetter,@SetterBGADisable, 2 + REG_CLASS.CLK, "BGA Unlock"
    AddRegister &H1CE, INDEX_ID,            @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.CLK, "BGA Signature"
    AddRegister &H1CE, INDEX_XRES,          @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.CRT, "X Resolution"
    AddRegister &H1CE, INDEX_YRES,          @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.CRT, "Y Resolution"
    AddRegister &H1CE, INDEX_BPP,           @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.DAC, "BPP"    
    AddRegister &H1CE, INDEX_BANK,          @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.SEQ, "Bank"
    AddRegister &H1CE, INDEX_VIRT_WIDTH,    @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.SEQ, "Virt. Width"
    AddRegister &H1CE, INDEX_VIRT_HEIGHT,   @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.SEQ, "Virt. Height"
    AddRegister &H1CE, INDEX_X_OFFSET,      @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.SEQ, "X offset"
    AddRegister &H1CE, INDEX_Y_OFFSET,      @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.SEQ, "Y offset"
    AddRegister &H1CE, INDEX_ENABLE,        @WordGetterBGA, @WordSetterBGA, 2 + REG_CLASS.CLK, "BGA Control"
End Sub

Sub Reglist_Mach64
    ' MMIO aperture starts with 3K nothing followed by the 1K register file. Go question the chip designers (and complain about the DSP when you're at it)
    AddRegister Mach64_Regs.CRTC_H_TOTAL_DISP + 3072,    0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CRT, "M64 H. Total"
    AddRegister Mach64_Regs.CRTC_H_SYNC_STRT_WID + 3072, 0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CRT, "M64 H. Sync"
    AddRegister Mach64_Regs.CRTC_V_TOTAL_DISP + 3072,    0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CRT, "M64 V. Total"
    AddRegister Mach64_Regs.CRTC_V_SYNC_STRT_WID + 3072, 0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CRT, "M64 V. Sync"
    AddRegister Mach64_Regs.CRTC_OFF_PITCH + 3072,       0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.SEQ, "M64 Off/Pitch"
    AddRegister Mach64_Regs.CRTC_GEN_CNTL + 3072,        0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.SEQ, "M64 Control"
    AddRegister Mach64_Regs.DSP_CONFIG + 3072,           0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CLK, "GTCDSP p/ll/xc"
    AddRegister Mach64_Regs.DSP_ON_OFF + 3072,           0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CLK, "GTCDSP on/off"
    AddRegister Mach64_Regs.OVR_WID_LEFT_RIGHT + 3072,   0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CRT, "M64 H.overscan"
    AddRegister Mach64_Regs.OVR_WID_TOP_BOTTOM + 3072,   0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CRT, "M64 V.overscan"
    AddRegister Mach64_Regs.BUS_CNTL + 3072,             0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CLK, "M64 Bus cntl"
    AddRegister Mach64_Regs.EXT_MEM_CNTL + 3072,         0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CLK, "M64 Ext mem"
    AddRegister Mach64_Regs.MEM_CNTL + 3072,             0, @DWordGetterMMIO, @DWordSetterMMIO, 4 + REG_CLASS.CLK, "M64 Mem ctl"
    AddRegister Mach64_Regs.CLOCK_CNTL + 3072,           0, @ByteGetterMMIO,  @ByteSetterMMIO,  4 + REG_CLASS.CLK, "M64 Clock ctl"
    AddRegister 0, Mach64_clock_regs.PLL_REF_DIV          , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL Ref div."
    AddRegister 0, Mach64_clock_regs.PLL_GEN_CNTL         , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL Control"
    AddRegister 0, Mach64_clock_regs.MCLK_FB_DIV          , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL Mem div"
    AddRegister 0, Mach64_clock_regs.PLL_VCLK_CNTL        , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL VCLK ctl"
    AddRegister 0, Mach64_clock_regs.VCLK_POST_DIV        , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "VCLK Postdiv."
    AddRegister 0, Mach64_clock_regs.VCLK0_FB_DIV         , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "V0 FB Divider"
    AddRegister 0, Mach64_clock_regs.VCLK1_FB_DIV         , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "V1 FB Divider"
    AddRegister 0, Mach64_clock_regs.VCLK2_FB_DIV         , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "V2 FB Divider"
    AddRegister 0, Mach64_clock_regs.VCLK3_FB_DIV         , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "V3 FB Divider"
    AddRegister 0, Mach64_clock_regs.PLL_EXT_CNTL         , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL Ext. Ctl."
    AddRegister 0, Mach64_clock_regs.PLL_XCLK_CNTL        , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL XCLK Ctl."
    AddRegister 0, Mach64_clock_regs.DLL_CNTL             , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL DLL Ctl."
    AddRegister 0, Mach64_clock_regs.VFC_CNTL             , @ByteGetterMachCT,@ByteSetterMachCT,1 + REG_CLASS.CLK, "PLL VFC Ctl."
    
End Sub
