'
' Summary: vesaemu.bas
' Vesa test code using x86emu
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos.bi"
#include "x86.bi"
#include "x86emu.bi"

Declare Sub Prepareinterrupt CDecl Alias "prepareinterrupt" (ByVal AX As Integer, ByVal CX As Integer, ByVal BX As Integer)
Declare Sub PrintString(ByRef s as string, ByVal row as integer, ByVal colour as Byte)
Declare Sub DebugString(ByRef s As String)
Declare Sub InitializeEmu()
Declare Sub ClearScreen()
Declare Sub ClearGfx()
Declare Sub PrintVesaStruct()
Declare Sub PrintModeList()
Declare Sub PrintModeStruct()
Declare Sub PrepareLFB()
Declare Sub DiagnoseInterrupts()
Declare Function RunInterrupt(ByVal ax as integer, ByVal cx as integer, ByVal bx as integer) As Byte

Declare Sub SetEntry CDecl Alias "vesaemu_setentry" (ByVal emu As X86EMU Ptr)
Declare Sub EmuSetup CDecl Alias "vesaemu_setup" (ByVal emu As X86EMU Ptr)
Declare Function TrapExit CDecl Alias "vesaemu_trapexit" (ByVal emu As X86EMU Ptr, ByVal intno As Byte, ByVal flags As Integer) As Integer

Declare Sub WriteKBC(ByVal b as Unsigned Byte)



' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Type VESA_INFO Field = 1
    signature As ZString * 4            ' 4 @ 00-03
    version As Short                    ' 2 @ 04-05
    OEMName_off As Unsigned Short       ' 4 @ 06-09
    OEMName_seg As Unsigned Short
    capabilities As Unsigned Integer    ' 4 @ 0A-0D
    modelist_off As Unsigned Short      ' 4 @ 0E-11
    modelist_seg As Unsigned Short
    vmem As Unsigned Short              ' 2 @ 12-13

    revision As Unsigned Short
    vendor_off As Unsigned Short
    vendor_seg As Unsigned Short
    product_off As Unsigned Short
    product_seg As Unsigned Short
    revstr_off As Unsigned Short
    revstr_seg As Unsigned Short
End Type

Type VESA_MODE Field = 1
   modeattributes As Unsigned Short
   winaattributes As Byte
   winbattributes As Byte
   wingranularity As Unsigned Short
   winsize As Unsigned Short
   winasegment As Unsigned Short
   winbsegment As Unsigned Short
   winfuncptr As Integer
   bytesperscanline As Unsigned Short

   ' Mandatory information for VBE 1.2 and above
   xresolution As Unsigned Short
   yresolution As Unsigned Short
   xcharsize As Byte
   ycharsize As Byte
   numberofplanes As Byte
   bitsperpixel As Byte
   numberofbanks As Byte
   memorymodel As Byte
   banksize As Byte
   numberofimagepages As Byte
   reserved1 As Byte

   ' Direct Color fields (required for direct/6 and YUV/7 memory models)
   redmasksize As Byte
   redfieldposition As Byte
   greenmasksize As Byte
   greenfieldposition As Byte
   bluemasksize As Byte
   bluefieldposition As Byte
   rsvdmasksize As Byte
   rsvdfieldposition As Byte
   directcolormodeinfo As Byte

   ' Mandatory information for VBE 2.0 and above
   physbaseptr As Byte Ptr
   offscreenmemoffset As Integer
   offscreenmemsize As Unsigned Short
End Type

Dim Shared SelectedMode As Short
Dim Shared SelectedInfo As VESA_MODE
Dim Shared Simulation As X86EMU Ptr
Dim Shared Success As Integer

Sub ModMain CDecl Alias "main"

    'Yank

    InitializeEmu
    InitKeyboard
    ClearScreen

    'WriteKBC(&HED)
    'WriteKBC(&H02)


    Dim f1 as single
    f1 = 2 / 8


    PrintString "VESA test module (press space to continue)", 1, 7
    ReadKey

    ClearScreen
    DiagnoseInterrupts
    ReadKey

    'WriteKBC(&HED)
    'WriteKBC(&H03)

    ClearScreen
    PrintString "Getting VESA info (press space to continue)", 1, 7
    Dim retval as Byte
    retval = RunInterrupt(&H4F00, 0, 0)

    if retval = 0 then
        PrintVesaStruct
        ReadKey
        ClearScreen
        PrintModeList
        ReadKey
    Else
        PrintString "Error returned " + Str(retval) , 2, 7
    End if

    If SelectedMode <> 0 Then
        outportb(&HE9, asc("X"))
        ClearScreen
        outportb(&HE9, asc("Y"))
	PrintString "Mode information: (press space to continue)", 1, 7
	outportb(&HE9, asc("Z"))
        retval = RunInterrupt(&H4F01, SelectedMode, 0)
        PrintModeStruct
        ReadKey
	ReadKey

        PrepareLFB
        ClearScreen
        PrintString "Ready to switch modes, press space to continue...", 1, 7
        ReadKey

	'Yank

        'retval = RunInterrupt(&H4F02, 0, SelectedMode Or &H4000)
        retval = RunInterrupt(&H4F02, 0, SelectedMode Or &HC000)

        ClearGfx

        'WriteKBC(&HED)
        'WriteKBC(&H02)

    End if

    While 1 = 1
        Yield
    Wend
    
End Sub

Sub InitializeEmu()

    dim vram as Byte Ptr, vbios as Byte Ptr, ivt as Unsigned Byte Ptr
    Dim vmstub as Byte Ptr, ebda As Byte Ptr, pcbios As Byte Ptr

    Dim ebdaoffset As Long

    vram = CPtr(Byte Ptr, &HA0000)
    vbios = CPtr(Byte Ptr, &HC0000)
    ivt = CPtr(Unsigned Byte Ptr, &H1000)
    vmstub = CPtr(Byte Ptr, &H10000)
    pcbios = CPtr(Byte Ptr, &HE0000)

    blockallocphys(32, vram, vram)
    blockallocphys(16, vbios, vbios)
    blockallocphys(1, ivt, CPtr(Byte Ptr, 0))
    blockallocphys(32, pcbios, pcbios)
    blockalloc(1, vmstub)

    ebdaoffset = 16 * CLng(ivt[&H40E]) + 256 * 16 * CLng(ivt[&H40F])
    ebda = CPtr(Byte Ptr, ebdaoffset and &HFF000)
    'blockallocphys((&HA0000 - (ebdaoffset and &HFF000)) \ 4096, ebda, ebda)
    'blockallocphys(16, ebda, ebda)

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(0, &HFFF)

    vmstub[&H800] = ASC("V")
    vmstub[&H801] = ASC("B")
    vmstub[&H802] = ASC("E")
    vmstub[&H803] = ASC("2")
    
    Simulation = x86emu_new(0,0)
    EmuSetup(Simulation)

End Sub

Function RunInterrupt(ByVal ax as integer, ByVal cx as integer, ByVal bx as integer) As Byte

    outportb(&HE9, asc("A"))

    Prepareinterrupt(ax, cx, bx)

    outportb(&HE9, asc("B"))

    'WriteKBC(&HED)
    'WriteKBC(&H00)

    outportb(&HE9, asc("C"))

    SetEntry(Simulation)
    Success = 0

    outportb(&HE9, asc("D"))

    Function = x86emu_run(Simulation, X86EMU_RUN_MAX_INSTR)
 
    if Success = 1 Then Function = 0
    
    'RunInterrupt = success
End Function

Function TrapExit CDecl Alias "vesaemu_trapexit" (ByVal emu As X86EMU Ptr, ByVal intno As Byte, ByVal flags As Integer) As Integer
    Asm
        xchg bx, bx
    End Asm

    If intno = CByte(&HFF) Then
        Success = 1
        x86emu_stop(emu)
        Function = 1
    ElseIf intno = CByte(&HFE) Then
        Success = 1
        x86emu_stop(emu)
        Function = 1
    Else
        Function = 0
    End If

    DebugString "Called interrupt 0x" + hex(intno) + " (0x" + hex(flags) + ") A=0x" + hex$(emu->x86.gen.A) + " B=0x" + hex$(emu->x86.gen.B) + " C=0x" + hex$(emu->x86.gen.C) + " D=0x" + hex$(emu->x86.gen.D) + chr(13) + chr(10)
    PrintString "Called interrupt 0x" + hex(intno) + " (0x" + hex(flags) + ") A=0x" + hex$(emu->x86.gen.A) + " B=0x" + hex$(emu->x86.gen.B) + " C=0x" + hex$(emu->x86.gen.C) + " D=0x" + hex$(emu->x86.gen.D) + ";", 23, &H09
End Function

Function x86vm_inb CDecl Alias "x86vm_inb" (ByVal addr As Unsigned Short) As Unsigned Byte
    Function = inportb(addr)
End Function

Function x86vm_inw CDecl Alias "x86vm_inw" (ByVal addr As Unsigned Short) As Unsigned Short
    Function = inportw(addr)
End Function

Function x86vm_inl CDecl Alias "x86vm_inl" (ByVal addr As Unsigned Short) As Unsigned Integer
    Function = inportd(addr)
End Function

Sub x86vm_outb CDecl Alias "x86vm_outb" (ByVal value As Unsigned Byte, ByVal addr As Unsigned Short)
    if addr <> &HE9 Then 
        DebugString " io[0x" + hex(addr) + "] = byte 0x" + hex$(value) + chr(13) + chr(10)
        PrintString " io[0x" + hex(addr) + "] = byte 0x" + hex$(value) + ";", 24, &H09
    End if
    outportb(addr, value)
End Sub

Sub x86vm_outw CDecl Alias "x86vm_outw" (ByVal value As Unsigned Short, ByVal addr As Unsigned Short)
    DebugString " io[0x" + hex(addr) + "] = word 0x" + hex$(value) + chr(13) + chr(10)
    PrintString " io[0x" + hex(addr) + "] = word 0x" + hex$(value) + ";", 24, &H09
    outportw(addr, value)
End Sub

Sub x86vm_outl CDecl Alias "x86vm_outl" (ByVal value As Unsigned Integer, ByVal addr As Unsigned Short)
    DebugString " io[0x" + hex(addr) + "] = dword 0x" + hex$(value) + chr(13) + chr(10)
    outportd(addr, value)
End Sub

Sub x86vm_memlog CDecl Alias "x86vm_memlog" (ByVal address As Unsigned Integer, ByVal code As Integer)
    If (address <= &H0001FFFF) Then
        PrintString " e mem[0x" + hex$(address) + "] -> " + hex$(code) + ";", 22, &H09
    ElseIf (address <= &H0009FFFF) Then
        PrintString " ? mem[0x" + hex$(address) + "] -> " + hex$(code) + ";", 21, &H09
    ElseIf (address <= &H000BFFFF) Then
        PrintString " v mem[0x" + hex$(address) + "] -> " + hex$(code) + ";", 20, &H09
    ElseIf (address <= &H000FFFFF) Then
        PrintString "   rom[0x" + hex$(address) + "] -> " + hex$(code) + ";", 19, &H09
    Else 
        PrintString "   ems[0x" + hex$(address) + "] -> " + hex$(code) + ";", 18, &H09
    End If    
End Sub

Sub PrintString(ByRef s as string, ByVal row as integer, ByVal colour as Byte)
    Dim vram As Byte Ptr
    Dim lp As Integer
    vram = CPTr(Byte Ptr, &HB8000)

    For lp = 1 to Len(s)
        vram[160*(row-1) + 2*(lp-1)] = asc(mid$(s,lp,1))
        vram[160*(row-1) + 2*(lp-1)+1] = colour
    Next lp

end sub

Sub DebugString(ByRef s As String)
   Dim lp As Integer
   For lp = 1 to Len(s)
       outportb(&HE9, Asc(Mid(s, lp, 1)))
   Next lp   
End Sub

Sub ClearScreen()
    Dim vram As Byte Ptr
    Dim lp As Integer
    vram = CPTr(Byte Ptr, &HB8000)

    For lp = 0 to 80*25 - 1
        vram[2*lp+0] = 32
        vram[2*lp+1] = 7
    Next lp
End Sub

Sub PrintVesaStruct()
    Dim vptr As VESA_INFO Ptr
    Dim vblock As VESA_INFO
    vptr = CPtr(VESA_INFO Ptr, &H10800)
    vblock = vptr[0]

    PrintString "Signature: " & vblock.signature, 2, 7
    PrintString "Version: 0x" & hex$(CInt(vblock.version)), 3, 7
    Dim dptr as Byte Ptr
    Dim lp As Long, c As String

    dptr = CPtr(Byte Ptr, vblock.OEMName_seg * 16 + vblock.OEMName_off)
    If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
        lp = 0
        c = ""
        While dptr[lp] <> 0
            c = c & chr$(dptr[lp])
            lp = lp + 1
        Wend
        PrintString "OEM Name: " & c, 4, 7
    Else
        PrintString "OEM Name: (bad address 0x" & hex$(dptr) & ")", 4, 12
    End If
    'modelist As Byte Ptr                ' 4 @ 0E-11

    PrintString "Caps: " & hex$(CInt(vblock.capabilities)) & " Video RAM: " & (64 * CLng(vblock.vmem)) & "KB" , 5, 7

    If vblock.version >= &H200 Then

        dptr = CPtr(Byte Ptr, vblock.product_seg * 16 + vblock.product_off)
        If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
            lp = 0
            c = ""
            While dptr[lp] <> 0
                c = c & chr$(dptr[lp])
                lp = lp + 1
            Wend
            PrintString "Product Name: " & c, 6, 7
        Else
            PrintString "Product Name: (bad address 0x" & hex$(dptr) & ")", 6, 12
        End If

        dptr = CPtr(Byte Ptr, vblock.vendor_seg * 16 + vblock.vendor_off)
        If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
            lp = 0
            c = ""
            While dptr[lp] <> 0
                c = c & chr$(dptr[lp])
                lp = lp + 1
            Wend
            PrintString "Vendor Name: " & c, 7, 7
        Else
            PrintString "Vendor Name: (bad address 0x" & hex$(dptr) & ")", 7, 12
        End If

        dptr = CPtr(Byte Ptr, vblock.revstr_seg * 16 + vblock.revstr_off)
        If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
            lp = 0
            c = ""
            While dptr[lp] <> 0
                c = c & chr$(dptr[lp])
                lp = lp + 1
            Wend
            PrintString "Revision: " & c, 8, 7
        Else
            PrintString "Revision: (bad address 0x" & hex$(dptr) & ")", 8, 12
        End If

    End If

End Sub

Sub ClearGfx()
    Dim vram AS Unsigned Byte Ptr
    vram = CPtr(Unsigned Byte Ptr, &HA0000)

    Dim x as unsigned integer

    For x = 0 to 65535
        vram[x] = x And &HFF
    Next x
End Sub

Sub PrintModeList
    PrintString "Mode Listing: (press space to continue)", 1, 7

    Dim vptr As VESA_INFO Ptr
    Dim vblock As VESA_INFO
    vptr = CPtr(VESA_INFO Ptr, &H10800)
    vblock = vptr[0]

    If vblock.signature <> "VESA" Then
        PrintString "No mode info - no valid block", 2, 12
        Exit Sub
    End If
    Dim dptr as Short Ptr
    dptr = CPtr(Short Ptr, vblock.modelist_seg * 16 + vblock.modelist_off)

    If Not (((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF))) Then
        PrintString "No mode info - bad address: " & Hex$(dptr) & " (" & hex$(vblock.modelist_seg) & ":" & hex$(vblock.modelist_off) & ")", 2, 12
        Exit Sub
    End if

    PrintString "Valid modes:", 2, 7
    Dim s As String
    Dim lp As Long
    While dptr[lp] > 0
        s = s & "0x" & hex$(dptr[lp]) & " "
        If (lp Mod 10) = 9 Then
            PrintString s, 3 + lp \ 10, 7
            s = ""
        End If
        lp = lp + 1
    Wend
    PrintString s, 3 + lp \ 10, 7
    s = ""

    If dptr[2] > 0 Then SelectedMode = dptr[2]

    PrintString "Testing continues with mode: 0x" & hex$(SelectedMode), 10, 7

End Sub

Sub PrintModeStruct
    Dim vptr As VESA_MODE Ptr
    Dim vblock As VESA_MODE
    vptr = CPtr(VESA_MODE Ptr, &H10800)
    vblock = vptr[0]

    PrintString "Resolution: " & vblock.xresolution & "x" & vblock.yresolution & "x" & vblock.bitsperpixel, 2, 7

    PrintString "Mode Attributes: 0x" & hex$(vblock.modeattributes), 3, 7
    PrintString "Window A @ 0x" & hex$(vblock.winasegment) & " attributes: 0x" & hex$(vblock.winaattributes) & ", Window B @ 0x" & hex$(vblock.winbsegment) & " attributes: 0x" & hex$(vblock.winbattributes), 4, 7
    PrintString "Window granularity: 0x" & hex$(vblock.wingranularity) & " Size: " & vblock.winsize & "KB" & " Functions: 0x" & hex$(vblock.winfuncptr), 5, 7

    PrintString "Stride: " & vblock.bytesperscanline & " Planes: " & vblock.numberofplanes & " Banks: " & vblock.numberofbanks & " @ " & vblock.banksize & "KB", 6, 7
    PrintString "Character Cell: " & vblock.xcharsize & "x" & vblock.ycharsize, 7, 7
    PrintString "Memory Model: 0x" & hex$(vblock.memorymodel) & " Number of image pages: " & vblock.numberofimagepages, 8, 7

    PrintString "LFB Offset: 0x" & hex$(vblock.physbaseptr) & " Offscreen offset: 0x" & hex$(vblock.offscreenmemoffset) & " Offscreen mem: 0x" & vblock.offscreenmemsize & "KB", 9, 7

    SelectedInfo = vblock

End Sub

Sub PrepareLFB
    Dim vramptr As Byte Ptr
    Dim mmap As Byte Ptr

    vramptr = SelectedInfo.physbaseptr
    mmap = CPtr(Byte Ptr, &HE0000000)

    allocatepagetable(mmap, CPtr(Byte Ptr, &HFFFFFFFF))
    'blockallocphys(256, mmap, vramptr)
    blockallocphysl(1, mmap, CPtr(Byte Ptr, &H01000000))
End Sub

Sub WriteKBC(ByVal b as Unsigned Byte)
    Dim o as byte
    o = inportb(&H64)
    While (o and &H02) > 0
        o = inportb(&H64)
    Wend
    outportb(&H60, b)
End Sub

Sub DiagnoseInterrupts()
    Dim ivt as Unsigned Short Ptr
    Dim seg as Unsigned Short
    Dim lp as Integer
    Dim lineno as Integer

    PrintString "Interesting IVT entries: (press space to continue):", 1, 7
    lineno = 1


    For lp = 0 to 255
        ivt = CPtr(Unsigned Short Ptr, 4 * lp + &H1000)
        seg = ivt[1]
        If (seg >= &HC000) and (seg <= &HCFFF) Then
            lineno = lineno + 1
            PrintString "Int 0x" & hex$(lp) & " -> 0x" & hex$(ivt[1]) & ":0x" & hex$(ivt[0]), lineno, 7
        End if
    Next lp
End Sub


' output:
' 000 000 001 000 000 000 000
'  0    1     0    0    0
