
#include "x86emu.h"
#include "x86emu_vm.h"
void vesaemu_setup(x86emu_t *);
void vesaemu_setentry(x86emu_t *);

int vesaemu_trapexit(x86emu_t * emu, uint8_t intno, uint32_t type);

void vesaemu_setup(x86emu_t * emu)
{
    x86emu_reset(emu);

    if (emu->x86.R_SS_LIMIT != 0xffff) x86vm_outb('@', 0xE9);

    x86emu_set_io_perm(emu, 0, 0x1000, X86EMU_PERM_RW);
    x86emu_set_perm(emu, 0, 0x1000, X86EMU_PERM_R);
    x86emu_set_page(emu, 0, (void *)0x1000);

    x86emu_set_perm(emu, 0x10000, 0x10FFF, X86EMU_PERM_RWX);
    x86emu_set_page(emu, 0x10000, (void*)0x10000);

    /*
    x86emu_set_perm(emu, 0xA0000, 0xBFFFF, X86EMU_PERM_RW);
    for (uint32_t ptr = 0xA0000; ptr < 0xBFFFF; ptr += X86EMU_PAGE_SIZE)
    {
        x86emu_set_page(emu, ptr, (void*)ptr);
    }
    */

    x86emu_set_perm(emu, 0xC0000, 0xCFFFF, X86EMU_PERM_RX);
    for (uint32_t ptr = 0xC0000; ptr < 0xCFFFF; ptr += X86EMU_PAGE_SIZE)
    {
        x86emu_set_page(emu, ptr, (void*)ptr);
    }

    x86emu_set_perm(emu, 0xE0000, 0xFFFFF, X86EMU_PERM_RX);
    for (uint32_t ptr = 0xE0000; ptr < 0xFFFFF; ptr += X86EMU_PAGE_SIZE)
    {
        x86emu_set_page(emu, ptr, (void *)ptr);
    }

    x86emu_set_intr_handler(emu, &vesaemu_trapexit);
    
}

void vesaemu_setentry(x86emu_t * emu)
{
    x86emu_reset(emu);
    x86emu_reset_access_stats(emu);
    emu->x86.spc.IP.I32_reg.e_reg = 0;
    x86emu_set_seg_register(emu, emu->x86.R_CS_SEL, 0x1000);
    x86emu_set_seg_register(emu, emu->x86.R_SS_SEL, 0);
    
    emu->max_instr = 1 << 24;
}

