

#include "mos.bi"
#include "x86.bi"

Declare Sub Prepareinterrupt CDecl Alias "prepareinterrupt" (AX As Integer, CX As Integer, BX As Integer)
Declare Sub PrintString(s as string, row as integer, colour as Byte)
Declare Sub InitializeV8086()
Declare Sub ClearScreen()
Declare Sub ClearGfx()
Declare Sub PrintVesaStruct()
Declare Sub PrintModeList()
Declare Sub PrintModeStruct()
Declare Sub PrepareLFB()
Declare Sub DiagnoseInterrupts()
Declare Function RunInterrupt(ax as integer, cx as integer, bx as integer) As Byte


Declare Sub WriteKBC(b as Unsigned Byte)



' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Type VESA_INFO Field = 1
    signature As ZString * 4            ' 4 @ 00-03
    version As Short                    ' 2 @ 04-05
    OEMName_off As Unsigned Short       ' 4 @ 06-09
    OEMName_seg As Unsigned Short
    capabilities As Unsigned Integer    ' 4 @ 0A-0D
    modelist_off As Unsigned Short      ' 4 @ 0E-11
    modelist_seg As Unsigned Short
    vmem As Unsigned Short              ' 2 @ 12-13

    revision As Unsigned Short
    vendor_off As Unsigned Short
    vendor_seg As Unsigned Short
    product_off As Unsigned Short
    product_seg As Unsigned Short
    revstr_off As Unsigned Short
    revstr_seg As Unsigned Short
End Type

Type VESA_MODE Field = 1
   modeattributes As Unsigned Short
   winaattributes As Byte
   winbattributes As Byte
   wingranularity As Unsigned Short
   winsize As Unsigned Short
   winasegment As Unsigned Short
   winbsegment As Unsigned Short
   winfuncptr As Integer
   bytesperscanline As Unsigned Short

   ' Mandatory information for VBE 1.2 and above
   xresolution As Unsigned Short
   yresolution As Unsigned Short
   xcharsize As Byte
   ycharsize As Byte
   numberofplanes As Byte
   bitsperpixel As Byte
   numberofbanks As Byte
   memorymodel As Byte
   banksize As Byte
   numberofimagepages As Byte
   reserved1 As Byte

   ' Direct Color fields (required for direct/6 and YUV/7 memory models)
   redmasksize As Byte
   redfieldposition As Byte
   greenmasksize As Byte
   greenfieldposition As Byte
   bluemasksize As Byte
   bluefieldposition As Byte
   rsvdmasksize As Byte
   rsvdfieldposition As Byte
   directcolormodeinfo As Byte

   ' Mandatory information for VBE 2.0 and above
   physbaseptr As Byte Ptr
   offscreenmemoffset As Integer
   offscreenmemsize As Unsigned Short
End Type

Dim Shared SelectedMode As Short
Dim Shared SelectedInfo As VESA_MODE

Sub ModMain CDecl Alias "main"

    InitializeV8086
    InitKeyboard
    ClearScreen

    WriteKBC(&HED)
    WriteKBC(&H02)


    Dim f1 as single
    f1 = 2 / 8


    PrintString "VESA test module (press space to continue)", 1, 7
    ReadKey

    ClearScreen
    DiagnoseInterrupts
    ReadKey

    WriteKBC(&HED)
    WriteKBC(&H03)

    ClearScreen
    PrintString "Getting VESA info (press space to continue)", 1, 7
    Dim retval as Byte
    retval = RunInterrupt(&H4F00, 0, 0)

    if retval = 1 then
        PrintVesaStruct
        ReadKey
        ClearScreen
        PrintModeList
        ReadKey
    Else
        PrintString "Error returned", 2, 7
    End if

    If SelectedMode <> 0 Then
        ClearScreen
        PrintString "Mode information: (press space to continue)", 1, 7
        retval = RunInterrupt(&H4F01, SelectedMode Or &H4000, 0)
        PrintModeStruct
        ReadKey

        PrepareLFB
        ClearScreen
        PrintString "Ready to switch modes, press space to continue", 1, 7
        ReadKey

        retval = RunInterrupt(&H4F02, 0, SelectedMode Or &H4000)
        'retval = RunInterrupt(&H4F02, 0, SelectedMode)

        ClearGfx

        WriteKBC(&HED)
        WriteKBC(&H02)

    End if

    While 1 = 1
    Wend
End Sub

Sub InitializeV8086()

    dim vram as Byte Ptr, vbios as Byte Ptr, ivt as Unsigned Byte Ptr
    Dim vmstub as Byte Ptr, ebda As Byte Ptr, pcbios As Byte Ptr

    Dim ebdaoffset As Long

    vram = CPtr(Byte Ptr, &HA0000)
    vbios = CPtr(Byte Ptr, &HC0000)
    ivt = CPtr(Unsigned Byte Ptr, &H0)
    vmstub = CPtr(Byte Ptr, &H10000)
    pcbios = CPtr(Byte Ptr, &HE0000)

    blockallocphys(32, vram, vram)
    blockallocphys(16, vbios, vbios)
    blockallocphys(1, ivt, ivt)
    blockallocphys(32, pcbios, pcbios)
    blockalloc(1, vmstub)

    ebdaoffset = 16 * CLng(ivt[&H40E]) + 256 * 16 * CLng(ivt[&H40F])
    ebda = CPtr(Byte Ptr, ebdaoffset and &HFF000)
    blockallocphys((&HA0000 - (ebdaoffset and &HFF000)) \ 4096, ebda, ebda)
    blockallocphys(16, ebda, ebda)

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    allocateirbitmap(CPtr(Byte Ptr, &HFFFFFFFF))
    
    setredirectbits(0, 255, 0)

    vmstub[&H800] = ASC("V")
    vmstub[&H801] = ASC("B")
    vmstub[&H802] = ASC("E")
    vmstub[&H803] = ASC("2")

End Sub

Function RunInterrupt(ax as integer, cx as integer, bx as integer) As Byte
    Prepareinterrupt(ax, cx, bx)

    WriteKBC(&HED)
    WriteKBC(&H00)

    Dim vmdata As mos_v8086data
    vmdata.cs = &H1000
    vmdata.ip = 0
    vmdata.flags = &H202

    Dim vmptr As mos_v8086data Ptr
    vmptr = @vmdata

    Dim done as Byte, success as byte
    done = 0
    success = 0

    Dim ports as string

    while done = 0
        enterv8086(vmptr)

        'PrintString "EnterV8086 returned:", 20, 14
        'PrintString ("CS: 0x" & hex$(vmdata.cs) & " IP: 0x" & hex$(vmdata.ip) & " DX: 0x" & hex$(vmdata.out_port) & " EFLAGS: 0x" & hex$(vmdata.flags) & " Stack: 0x" & hex$(vmdata.out_stack) & "        "), 21, 14
        Dim c as string, lp as Long, p1 as string, p2 as string
        c = ""
        for lp = 0 to 7
            'PrintString ("Stackdump: " & c & "     " & hex$(CLng(vmdata.out_stack) + 2& * lp + 4)) , 22, 14
            if CLng(vmdata.out_stack) + 2& * lp + 4 >= &H11000& Then Exit For
            p1 = hex$(vmdata.out_stack[2*lp+1])
            p2 = hex$(vmdata.out_stack[2*lp+0])
            if len(p1) = 1 then p1 = "0" + p1
            if len(p2) = 1 then p2 = "0" + p2
            c = c + " " + p1 + p2
        next lp
        'PrintString ("Stackdump: " & c) , 22, 14
        c = ""
        dim codedump As Unsigned Byte Ptr
        codedump = CPtr(Unsigned Byte Ptr, 16 * vmdata.cs + vmdata.ip)
        for lp = 0 to 15
            p1 = hex$(codedump[lp])
            if len(p1) = 1 then p1 = "0" + p1
            c = c + " " + p1
        next lp
        'PrintString ("Code: " & c) , 23, 14
        'PrintString ("IO Ports: " & ports) , 24, 14

        if ((codedump[0] >= &HEC) and (codedump[0] <= &HEF)) Or ((codedump[0] = &H66) And (codedump[1] >= &HEC) and (codedump[1] <= &HEF)) Then
            'PrintString "Port I/O", 24
            portalloc(vmdata.out_port, 1)
            portalloc(vmdata.out_port+1, 1)
            portalloc(vmdata.out_port+2, 1)
            portalloc(vmdata.out_port+3, 1)
            ports = hex$(vmdata.out_port) & " " & ports
            'PrintString ("IO Ports A: " & ports) , 24, 14
        elseif ((codedump[0] >= &HE4) and (codedump[0] <= &HE7)) Then
            'PrintString "Port I/O", 24
            portalloc(codedump[1], 1)
            portalloc(codedump[1]+1, 1)
            portalloc(codedump[1]+2, 1)
            portalloc(codedump[1]+3, 1)
            ports = hex$(codedump[1]) & " " & ports
            'PrintString ("IO Ports B: " & ports) , 24, 14
        elseif ((codedump[0] = &H66) And (codedump[1] >= &HE4) and (codedump[1] <= &HE7)) Then
            'PrintString "Port I/O", 24
            portalloc(codedump[2], 1)
            portalloc(codedump[2]+1, 1)
            portalloc(codedump[2]+2, 1)
            portalloc(codedump[2]+3, 1)
            ports = hex$(codedump[2]) & " " & ports
            'PrintString ("IO Ports C: " & ports) , 24, 14
        elseif (codedump[0] = &HCD) and (codedump[1] <= &HFF) then
            PrintString "Success ", 24, 10
            done = 1
            success = 1
            WriteKBC(&HED)
            WriteKBC(&H02)
        else
            PrintString "Bailing ", 24, 12
            WriteKBC(&HED)
            WriteKBC(&H01)
            done = 1
        end if

    Wend
    RunInterrupt = success
End Function

Sub PrintString(s as string, row as integer, colour as Byte)
    Dim vram As Byte Ptr
    Dim lp As Integer
    vram = CPTr(Byte Ptr, &HB8000)

    For lp = 1 to Len(s)
        vram[160*(row-1) + 2*(lp-1)] = asc(mid$(s,lp,1))
        vram[160*(row-1) + 2*(lp-1)+1] = colour
    Next lp

end sub

Sub ClearScreen()
    Dim vram As Byte Ptr
    Dim lp As Integer
    vram = CPTr(Byte Ptr, &HB8000)

    For lp = 0 to 80*25 - 1
        vram[2*lp+0] = 32
        vram[2*lp+1] = 7
    Next lp
End Sub

Sub PrintVesaStruct()
    Dim vptr As VESA_INFO Ptr
    Dim vblock As VESA_INFO
    vptr = CPtr(VESA_INFO Ptr, &H10800)
    vblock = vptr[0]

    PrintString "Signature: " & vblock.signature, 2, 7
    PrintString "Version: 0x" & hex$(vblock.version), 3, 7
    Dim dptr as Byte Ptr
    Dim lp As Long, c As String

    dptr = CPtr(Byte Ptr, vblock.OEMName_seg * 16 + vblock.OEMName_off)
    If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
        lp = 0
        c = ""
        While dptr[lp] <> 0
            c = c & chr$(dptr[lp])
            lp = lp + 1
        Wend
        PrintString "OEM Name: " & c, 4, 7
    Else
        PrintString "OEM Name: (bad address 0x" & hex$(dptr) & ")", 4, 12
    End If
    'modelist As Byte Ptr                ' 4 @ 0E-11

    PrintString "Caps: " & hex$(vblock.capabilities) & " Video RAM: " & (64 * CLng(vblock.vmem)) & "KB" , 5, 7

    If vblock.version >= &H200 Then

        dptr = CPtr(Byte Ptr, vblock.product_seg * 16 + vblock.product_off)
        If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
            lp = 0
            c = ""
            While dptr[lp] <> 0
                c = c & chr$(dptr[lp])
                lp = lp + 1
            Wend
            PrintString "Product Name: " & c, 6, 7
        Else
            PrintString "Product Name: (bad address 0x" & hex$(dptr) & ")", 6, 12
        End If

        dptr = CPtr(Byte Ptr, vblock.vendor_seg * 16 + vblock.vendor_off)
        If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
            lp = 0
            c = ""
            While dptr[lp] <> 0
                c = c & chr$(dptr[lp])
                lp = lp + 1
            Wend
            PrintString "Vendor Name: " & c, 7, 7
        Else
            PrintString "Vendor Name: (bad address 0x" & hex$(dptr) & ")", 7, 12
        End If

        dptr = CPtr(Byte Ptr, vblock.revstr_seg * 16 + vblock.revstr_off)
        If ((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF)) Then
            lp = 0
            c = ""
            While dptr[lp] <> 0
                c = c & chr$(dptr[lp])
                lp = lp + 1
            Wend
            PrintString "Revision: " & c, 8, 7
        Else
            PrintString "Revision: (bad address 0x" & hex$(dptr) & ")", 8, 12
        End If

    End If

End Sub

Sub ClearGfx()
    Dim vram AS Unsigned Byte Ptr
    vram = CPtr(Unsigned Byte Ptr, &HA0000)

    Dim x as unsigned integer

    For x = 0 to 65535
        vram[x] = x And &HFF
    Next x
End Sub

Sub PrintModeList
    PrintString "Mode Listing: (press space to continue)", 1, 7

    Dim vptr As VESA_INFO Ptr
    Dim vblock As VESA_INFO
    vptr = CPtr(VESA_INFO Ptr, &H10800)
    vblock = vptr[0]

    If vblock.signature <> "VESA" Then
        PrintString "No mode info - no valid block", 2, 12
        Exit Sub
    End If
    Dim dptr as Short Ptr
    dptr = CPtr(Short Ptr, vblock.modelist_seg * 16 + vblock.modelist_off)

    If Not (((CInt(dptr) > &HC0000) and (CInt(dptr) <= &HCFFFF)) Or ((CInt(dptr) > &H10800) and (CInt(dptr) <= &H109FF))) Then
        PrintString "No mode info - bad address: " & Hex$(dptr) & " (" & hex$(vblock.modelist_seg) & ":" & hex$(vblock.modelist_off) & ")", 2, 12
        Exit Sub
    End if

    PrintString "Valid modes:", 2, 7
    Dim s As String
    Dim lp As Long
    While dptr[lp] > 0
        s = s & "0x" & hex$(dptr[lp]) & " "
        If (lp Mod 10) = 9 Then
            PrintString s, 3 + lp \ 10, 7
            s = ""
        End If
        lp = lp + 1
    Wend
    PrintString s, 3 + lp \ 10, 7
    s = ""

    If dptr[0] > 0 Then SelectedMode = dptr[0]

    PrintString "Testing continues with mode: 0x" & hex$(SelectedMode), 10, 7

End Sub

Sub PrintModeStruct
    Dim vptr As VESA_MODE Ptr
    Dim vblock As VESA_MODE
    vptr = CPtr(VESA_MODE Ptr, &H10800)
    vblock = vptr[0]

    PrintString "Resolution: " & vblock.xresolution & "x" & vblock.yresolution & "x" & vblock.bitsperpixel, 2, 7

    PrintString "Mode Attributes: 0x" & hex$(vblock.modeattributes), 3, 7
    PrintString "Window A @ 0x" & hex$(vblock.winasegment) & " attributes: 0x" & hex$(vblock.winaattributes) & ", Window B @ 0x" & hex$(vblock.winbsegment) & " attributes: 0x" & hex$(vblock.winbattributes), 4, 7
    PrintString "Window granularity: 0x" & hex$(vblock.wingranularity) & " Size: " & vblock.winsize & "KB" & " Functions: 0x" & hex$(vblock.winfuncptr), 5, 7

    PrintString "Stride: " & vblock.bytesperscanline & " Planes: " & vblock.numberofplanes & " Banks: " & vblock.numberofbanks & " @ " & vblock.banksize & "KB", 6, 7
    PrintString "Character Cell: " & vblock.xcharsize & "x" & vblock.ycharsize, 7, 7
    PrintString "Memory Model: 0x" & hex$(vblock.memorymodel) & " Number of image pages: " & vblock.numberofimagepages, 8, 7

    PrintString "LFB Offset: 0x" & hex$(vblock.physbaseptr) & " Offscreen offset: 0x" & hex$(vblock.offscreenmemoffset) & " Offscreen mem: 0x" & vblock.offscreenmemsize & "KB", 9, 7

    SelectedInfo = vblock

End Sub

Sub PrepareLFB
    Dim vramptr As Byte Ptr
    Dim mmap As Byte Ptr

    vramptr = SelectedInfo.physbaseptr
    mmap = CPtr(Byte Ptr, &HE0000000)

    allocatepagetable(mmap, CPtr(Byte Ptr, &HFFFFFFFF))
    'blockallocphys(256, mmap, vramptr)
    blockallocphysl(1, mmap, CPtr(Byte Ptr, &H01000000))
End Sub

Sub WriteKBC(b as Unsigned Byte)
    Dim o as byte
    o = inportb(&H64)
    While (o and &H02) > 0
        o = inportb(&H64)
    Wend
    outportb(&H60, b)
End Sub

Sub DiagnoseInterrupts()
    Dim ivt as Unsigned Short Ptr
    Dim seg as Unsigned Short
    Dim lp as long
    Dim lineno as long

    PrintString "Interesting IVT entries: (press space to continue):", 1, 7
    lineno = 1

    For lp = 0 to 255
        ivt = CPtr(Unsigned Short Ptr, 4 * lp)
        seg = ivt[1]
        If (seg >= &HC000) and (seg <= &HCFFF) Then
            lineno = lineno + 1
            PrintString "Int 0x" & hex$(lp) & " -> 0x" & hex$(ivt[1]) & ":0x" & hex$(ivt[0]), lineno, 7
        End if
    Next lp
End Sub


' output:
' 000 000 001 000 000 000 000
'  0    1     0    0    0
