' Summary: voodoo1.bas
' 3Dfx VooDoo 1 test code
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos.bi"
#include "x86.bi"
#include "mos/pci.bi"
#include "../gfx/vga_io.bi"
#include "GL/gl.bi"

Declare Sub ModMain CDecl Alias "main"()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
Declare Sub ClearCon (vram As Byte Ptr)
Declare Function is_voodoo1(vendor as unsigned short, device as unsigned short) As Byte
Declare Sub cheapdelay()

' from the keyboard
Declare Function ReadKey() As Byte
Declare Sub InitKeyboard()

Declare Sub WriteGfxString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode As Byte, vw As Long)
Declare Sub ReadFont(vram as byte ptr, dumper as byte ptr)
Declare Function PlaneSelect(planeno as long) as unsigned byte

Declare Sub SST_WaitIdle(mmio As Integer Ptr)
Declare Function SST_ReadDAC(mmio As Integer Ptr, reg As Integer) As Integer
Declare Sub SST_WriteDAC(mmio As Integer Ptr, reg As Integer, value As Integer)

' opengl backend
Declare Sub _gl_setoutput CDecl Alias "_gl_setoutput"(ByVal buffer As Byte Ptr, ByVal w As Integer, ByVal h As Integer, ByVal pitch As Integer)
Declare Sub _gl_inittextures CDecl Alias "_gl_inittextures" ()
Extern voodoo_mmio Alias "voodoo_mmio" as Byte Ptr

Dim Shared font() As Unsigned Byte

' Voodoo notepad



Sub ModMain CDecl Alias "main"()

    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    vram = CPtr(Byte Ptr, &HA0000)
    cram = CPtr(Byte Ptr, &HB8000)
    blockallocphys(32, vram, vram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    PortAlloc(&HCF8, 8)

    'ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, &H40000000))
    ' Todo: Causes an oops, work todo in kernel land.
    'BlockAllocPhysL(1, CPtr(Byte Ptr, &H40000000), CPtr(Byte Ptr, &H40000000))

    ClearCon cram

    Printstring "Checking devices...", cram, 0

    InitKeyboard

    Dim lp as long, bus as long, dev as long, fn as long
    Dim lastdevice as Unsigned Short
    Dim mybus as long, mydev as long, myfn as long
    Dim vendor as Unsigned Short, myvendor as unsigned short
    Dim device as Unsigned Short, mydevice as unsigned short
    Dim vdev as Unsigned Short

    mybus = -1
    vdev = &HFFFF
    lastdevice = &HFFFF
    lp = 0
    For bus = 0 to 2
        For dev = 0 to 31
            For fn = 0 to 7
                vendor = PCI_type1_readword(bus, dev, fn, 0)
                device = PCI_type1_readword(bus, dev, fn, 2)
                If is_voodoo1(vendor, device) Then
                    mybus = bus
                    mydev = dev
                    myfn = fn
                    myvendor = vendor
                    mydevice = device
                    exit for
                ElseIf vendor = &H121A Then
                    vdev = device
                End If
            Next fn
        Next dev
    Next bus

    If mybus = -1 then
        if vdev <> &HFFFF Then
            PrintString "unknown 3Dfx chip found: 0x" & hex$(vdev), cram, 160
    Else
            PrintString "No Voodoo 1 or compatible chip found", cram, 160
    End if
        Exit Sub
    End if
    PrintString "3Dfx VooDoo 1 found on device " & mybus & ":" & mydev & ":" & myfn, cram, 160

    PrintString "PCI ID: 0x" & hex$(myvendor) & ":0x" & hex$(mydevice), cram, 320

    Dim bar as Unsigned Integer, barmask As Unsigned Integer
    Dim portbase as Integer
    Dim mmiobase as Integer
    Dim framebuffer as Integer
    framebuffer = 0

    For lp = 5 to 0 step -1
        barmask = PCI_bar_readmask(mybus,mydev,myfn, lp)
        bar = PCI_bar_readaddress(mybus,mydev,myfn, lp)
        printstring "Bar " & lp & ": 0x" & hex$(barmask) & " @ 0x" & hex$(bar), cram, (3+lp) * 160
        If bar = 0 then

        Elseif (barmask and &H1) = 1 Then
            portbase = bar and &HFFF8&
        Elseif ((barmask and &HFFFF0) = 0) And (framebuffer = 0) then
            framebuffer = bar
        Else
            mmiobase = bar
        End If
    Next lp

    PrintString "MMIO offset: 0x" & hex$(framebuffer), cram, 10 * 160

    If framebuffer = 0 then Exit Sub

    Dim lfb as unsigned Short ptr
    ' spec mentions both 4M and 8M, 4M is correct
    lfb = CPtr(Unsigned Short ptr, &HF0400000)

    ' allocate framebuffer
    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, framebuffer))
    BlockAllocPhysL(4, CPtr(Byte Ptr, &HF0000000), CPtr(Byte Ptr, framebuffer))

    Dim pcicfg As Integer
    pcicfg = PCI_type1_readdword(mybus, mydev, myfn, &H40)
    pcicfg = (pcicfg and &HF8) ' allow us to set bits 0 (config), 1 (fifo), and 2 (dac)
    PCI_type1_writedword(mybus,mydev,myfn,&H40, pcicfg Or 5) ' enable config writes and DAC
    
    Dim mmio as integer ptr
    mmio = CPtr(Integer Ptr, &HF0000000)
    
    mmio[&H214 / 4] = &H0021E1A8 ' Reset
    SST_WaitIdle(mmio)
    ReadKey
    
    SST_WriteDAC(mmio, 6, &H50)

    ' max clock = 50000 (kHz)
    ' clock = Fref * (M+2)/( 2^P * (N+2))
    ' fRef = 14.318 MHz (standard clock)
    ' vco < 250mhz
    ' p = 2 (2^2*50000) < vco
    ' 50000 = (14318 * A) / (4 * B)
    ' 200000/14318 = A/B
    ' A/B = 13.968
    ' B = 3 (N = 1)
    ' A = 42 (M = 40)
    
    SST_WriteDac(mmio, 7, 14)
    lp = SST_ReadDac(mmio, 5)
    
    SST_WriteDac(mmio, 4, 10)
    SST_WriteDac(mmio, 5, 40)
    SST_WriteDac(mmio, 5, 2 * 32 + 1)
    SST_WriteDac(mmio, 4, 14)
    SST_WriteDac(mmio, 7, lp And &HEF)
    
    SST_WriteDac(mmio, 7, 14)
    lp = SST_ReadDac(mmio, 5)
    
    SST_WriteDac(mmio, 4, 0)
    SST_WriteDac(mmio, 5, 40)
    SST_WriteDac(mmio, 5, 3 * 32 + 1)
    SST_WriteDac(mmio, 4, 14)
    SST_WriteDac(mmio, 7, (lp And &HD8) Or &H20)
        
    PCI_type1_writedword(mybus,mydev,myfn,&H40, pcicfg Or 1) ' enable config writes and DAC
    
    mmio[&H208 / 4] = 24 * &H10000 + 16 ' Backporch left=16 top = 24
    ReadKey
    mmio[&H20C / 4] = 480 * &H10000 + 640 ' 640x480
    ReadKey
    mmio[&H210 / 4] = &H00000411 ' fbiInit0
    ReadKey
    mmio[&H220 / 4] = (800-96) * &H10000 + 96 ' hSync
    ReadKey
    mmio[&H224 / 4] = (524-2)  * &H10000 +  2 ' vSync
    ReadKey
    ' To deconfuse: X resolution / 64 -> bits 4..7 (640/64 = 10 = 0xA -> OR with 0x000000A0)
    mmio[&H214 / 4] = &H0021E0A8 ' fbiInit1
    ReadKey
    mmio[&H218 / 4] = &H186000E0 ' fbiInit2 - use fast memory access, enable DRAM refresh
    ReadKey
    mmio[&H21C / 4] = &H00000040 ' fbiInit3 - disable texturing
    ReadKey
    mmio[&H200 / 4] = &H00000002 ' fbiInit4 - disable memory FIFO, enable read-ahead
    ReadKey
    
    PCI_type1_writedword(mybus,mydev,myfn,&H40, pcicfg Or 2) ' lock config writes, enable FIFO
    ReadKey

    mmio[&H118 / 4] = 640
    mmio[&H11C / 4] = 480
    mmio[&H110 / 4] = &H00000201
    ReadKey

    mmio[&H114 / 4] = &H0100 ' bypass graphics pipeline
    ReadKey
    for lp = 0 to 1024 * 480
        lfb[lp] = lp And &HFF&
    next lp
    ReadKey

    mmio[&H128 / 4] = 1 ' SwapBufferCMD
    ReadKey

    mmio[&H12C / 4] = 0 ' BltFill
    ReadKey
    mmio[&H128 / 4] = 1 ' SwapBufferCMD
    ReadKey
    mmio[&H12C / 4] = 0 ' BltFill
    ReadKey
    mmio[&H128 / 4] = 1 ' SwapBufferCMD
    ReadKey
    for lp = 0 to 1024 * 480
        lfb[lp] = lp
    next lp
    ReadKey
    mmio[&H128 / 4] = 1 ' SwapBufferCMD
    
    PrintString "And that's multihead support for you :)   ------>", cram, 14 * 160
    
    ReadKey
    
    mmio[&H10c / 4] = 0 ' disable alphablending
    
    mmio[2] = 100 * 16
    mmio[3] = 100 * 16
    mmio[4] = 400 * 16
    mmio[5] = 200 * 16
    mmio[6] = 300 * 16
    mmio[7] = 400 * 16
    mmio[&H080 / 4] = 0
    
    ReadKey
    
    mmio[2] = 120 * 16
    mmio[3] = 120 * 16
    mmio[4] = 220 * 16
    mmio[5] = 120 * 16
    mmio[6] = 120 * 16
    mmio[7] = 220 * 16
    mmio[8]  = 256 * 4096
    mmio[9]  = 0 * 4096
    mmio[10] = 0 * 4096
    mmio[&H040 / 4] = (256*4096) \ -100
    mmio[&H044 / 4] = (256*4096) \  100
    mmio[&H048 / 4] = 0
    mmio[&H060 / 4] = (256*4096) \ -100
    mmio[&H064 / 4] = 0
    mmio[&H068 / 4] = (256*4096) \  100
    mmio[&H080 / 4] = 0
    
    ReadKey
    
    mmio[&H128 / 4] = 1 ' SwapBufferCMD
    
    ReadKey
    
    ' setup OpenGL
    voodoo_mmio = CPtr(Byte Ptr, mmio)
    _gl_setoutput(CPtr(Byte Ptr,&H60000000), 640, 480, 640*4)
    _gl_inittextures
    glViewport(0,0,640,480)
    glScissor(50,50,540,380)
    
    glLoadIdentity
    
    glMatrixMode(GL_PROJECTION)
    glFrustum(-0.64,0.64,-0.48,0.48,0.5,10)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity

    glDisable(GL_TEXTURE_2D)
    glEnable(GL_SCISSOR_TEST)
    glEnable(GL_CULL_FACE)
    glColor3f(1,0,0)
    glBegin(GL_TRIANGLES)
        glColor3f(1,0,0)
        glVertex3f(-1, 1, -1)
        glColor3f(0,1,0)
        glVertex3f(0, -1, -1)
        glColor3f(0,0,1)
        glVertex3f(-1, -1, -1)

        glColor3f(1,0,0)
        glVertex3f(1, 1, -1)
        glColor3f(0,1,0)
        glVertex3f(0, -1, -1)
        glColor3f(0,0,1)
        glVertex3f(1, -1, -1)

        glColor3f(1,0,0)
        glVertex3f(0.8, 1, -1)
        glColor3f(0,1,0)
        glVertex3f(-0.8, 1, -1)
        glColor3f(0,0,1)
        glVertex3f(0, -0.6, -1)
    glEnd
    
    
    ReadKey
    lfb = CPtr(unsigned short ptr, &HDEADD00D)
    lfb[0] = 0 ' show pagefault on keyboard

End Sub




Sub SST_WaitIdle(mmio As Integer Ptr)
    Dim n as integer
    n = 0
    while n < 5
        If (mmio[0] And &H80) = 0 Then n = n + 1
    wend
End Sub

Function SST_ReadDAC(mmio As Integer Ptr, reg As Integer) As Integer
    mmio[&H22C / 4] = ((reg * &H100) And &H700) + &H800
    SST_WaitIdle(mmio)
    Function = mmio[&H218 / 4]
End Function

Sub SST_WriteDAC(mmio As Integer Ptr, reg As Integer, value As Integer)
    mmio[&H22C / 4] = (reg * &H100) + (value And &HFF)
    SST_WaitIdle(mmio)
End Sub


' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Public Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + offset] = ch
        vram[lp * 2 - 1 + offset] = 7
    Next lp
End Sub


Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub

Function is_voodoo1(vendor as unsigned short, device as unsigned short) As Byte
    function = 0
    if vendor <> &H121A then exit function
    if device = &H0001 then function = 1
End Function

Sub cheapdelay()
    Dim lp as Long
    For lp = 0 To 6600000
    Next lp
End Sub

Sub WriteGfxString(vram as Byte Ptr, s as String, x as long, y as long, col as long, mode as Byte, vw as Long)
    Dim lp as long
    For lp = 1 to len(s)
        WriteGfxChar vram, asc(mid$(s,lp,1)), x + 8 * (lp - 1), y, col, mode, vw
    next lp
End Sub

Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, x as long, y as long, col as long, mode as Byte, vw as Long)
    dim lp as long
    Dim fontbyte as byte
    For lp = 0 to 15
        fontbyte = font(32 * ch + lp)
        if (fontbyte and &H01) = &H01 then PutPixel vram, x + 7, y + lp, col, mode, vw
        if (fontbyte and &H02) = &H02 then PutPixel vram, x + 6, y + lp, col, mode, vw
        if (fontbyte and &H04) = &H04 then PutPixel vram, x + 5, y + lp, col, mode, vw
        if (fontbyte and &H08) = &H08 then PutPixel vram, x + 4, y + lp, col, mode, vw
        if (fontbyte and &H10) = &H10 then PutPixel vram, x + 3, y + lp, col, mode, vw
        if (fontbyte and &H20) = &H20 then PutPixel vram, x + 2, y + lp, col, mode, vw
        if (fontbyte and &H40) = &H40 then PutPixel vram, x + 1, y + lp, col, mode, vw
        if (fontbyte and &H80) = &H80 then PutPixel vram, x + 0, y + lp, col, mode, vw
    Next lp
End Sub

Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode As Byte, vw As Long)
    Select Case mode
        Case 4
            Dim setbyte as Byte
            Dim clearbyte as Byte
            Dim address as Long
            setbyte = PlaneSelect(7-(x Mod 8))
            clearbyte = 255 - setbyte
            address = (x + vw * y) \ 8
            Write3C4 &H2, 1
            Write3CE &H4, 0
            if (col and 1) = 1 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 2
            Write3CE &H4, 1
            if (col and 2) = 2 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 4
            Write3CE &H4, 2
            if (col and 4) = 4 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 8
            Write3CE &H4, 3
            if (col and 8) = 8 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
        Case 7
            Write3C4 &H2, PlaneSelect(x Mod 4)
            vram[(x + vw * y) \ 4] = col And &HFF
        Case 8
            vram[x + vw * y] = col And &HFF
            
        Case 16
            CPtr(Short Ptr, @vram[vw*y])[x] = col And &HFFFF
        Case 32
            CPtr(Long Ptr, @vram[vw*y])[x] = col
    End Select
End Sub

Function PlaneSelect(planeno as long) as unsigned byte
    Select Case planeno
        Case 0
            PlaneSelect = 1
        Case 1
            PlaneSelect = 2
        Case 2
            PlaneSelect = 4
        Case 3
            PlaneSelect = 8
        Case 4
            PlaneSelect = 16
        Case 5
            PlaneSelect = 32
        Case 6
            PlaneSelect = 64
        Case 7
            PlaneSelect = &H80
    End Select
End Function

Sub ReadFont(vram as byte ptr, dumper as byte ptr)
    Dim lp As Long
    VGASet320x200Mode
    VGASetModeX
    Write3CE &H4, &H2
    For lp = 0 To 8191
        dumper[lp] = vram[lp]
    Next lp
End Sub
