' Summary: fat.bas
' Implements support for the FAT12/FAT16/FAT32 filesystem
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "fat.bi"
#include "mos/debugutil.bi"

Constructor FATDriver
    Dim listener as FATListener Ptr
    listener = new FATListener
    listener->mDriver = @This
    This.mListener = listener
    
    mFatCache = Allocate(4096)
    mFatCacheBlocks = 8
    mFatCacheIndices = Allocate(8 * Len(Integer))
End Constructor

Destructor FATDriver
    Dim listener As FATListener Ptr
    listener = CPtr(FATListener Ptr, mListener)
    listener->mDriver = CPtr(FATDriver Ptr, 0)
    listener->Release
End Destructor

Sub FATDriver.Mount(ByVal Channel As Byte Ptr, ByVal request_id As Unsigned Integer)
    If mMountChannel <> 0 Then
        *Cptr(Byte Ptr, 0) = 0
    End If
    ShowString "[fat] mount" + chr$(13) + chr$(10)
    mMountChannel = Channel
    mMountRequest = request_id
    mMountStatus = 0
    
    Blockdriver_Read(mStorageAddress, mStorageMap, 0, 1)

End Sub

Sub FATListener.data(ByVal Channel As Byte Ptr, ByVal map As Unsigned Integer, ByVal start_block As Unsigned Integer, ByRef content As String)
    mDriver->data(Channel, map, start_block, content)     
End Sub

Sub FATDriver.data(ByVal Channel As Byte Ptr, ByVal map As Unsigned Integer, ByVal start_block As Unsigned Integer, ByRef content As String)
    If map = mStorageMap And start_block = 0 Then
        readSuperBlock content
    Else
        ShowString "[fat] stray read " + str$(map) + ":" + Str$(start_block) + chr$(13) + chr$(10)
    End If
End Sub

Sub FATDriver.readSuperBlock(ByRef content As String)
    Dim bytecontent As Byte Ptr
    bytecontent = *CPtr(Byte Ptr Ptr, @content)
    
    Dim bpb As FAT_BPB Ptr
    bpb = CPtr(FAT_BPB Ptr, bytecontent)
    
    Dim size As Integer = bpb->sector_count_16
    If size = 0 Then size = bpb->sector_count_32    
    
    ShowString "[fat] mount " + str$(size * bpb->bytes_per_sector \ (1024 * 1024)) + "MiB, s16: " + hex$(bpb->sector_count_16) + " s32: " + hex$(bpb->sector_count_32) + " bps: " + hex$(bpb->bytes_per_sector) + " spc: " + hex$(bpb->sectors_per_cluster) + chr$(13) + chr(10)

    size = size - bpb->reserved_sectors
    size = size - (bpb->root_entry_count * 32 + bpb->bytes_per_sector - 1) \ bpb->bytes_per_sector    
    Dim approxcluster As Integer
    approxcluster = (size - bpb->sectors_per_fat * bpb->fat_count) \ bpb->sectors_per_cluster ' exact for FAT12/16, somewhat unreliable on FAT32
    
    If approxcluster > 65524 Then ' The limit for FAT16
        Dim fat32 As FAT_BPB_32 Ptr
        fat32 = CPtr(FAT_BPB_32 Ptr, bpb)
        ShowString "[fat] mounting FAT32" + chr$(13) + chr$(10)
        mFatBits = 32
        mRootdiroffset = 0
    Else ' FAT12/16
        Dim fat16 As FAT_BPB_16 Ptr
        fat16 = CPtr(FAT_BPB_16 Ptr, bpb)
        If (approxcluster > 4084) Then        
            ShowString "[fat] mounting FAT16" + chr$(13) + chr$(10)
            mFatBits = 16            
        Else
            ShowString "[fat] mounting FAT12" + chr$(13) + chr$(10)
            mFatBits = 12
        End If
        mFatOffset = bpb->reserved_sectors
        mRootdiroffset = mFatOffset + bpb->sectors_per_fat * bpb->fat_count
        mDataOffset = mRootdiroffset + (bpb->root_entry_count * 32 + bpb->bytes_per_sector - 1) \ bpb->bytes_per_sector
        
        mMountStatus = 2
        FSClient_onMounted mMountChannel, mMountRequest, 0
    End If
    
End Sub

