#include "mos/channel.bi"
#include "blockdriver.bi"
#include "fsdriver.bi"

Type FATDriver Extends FSDriverListener
    mStorageAddress As Integer
    mStorageMap As Integer
    mStorageDevice As Integer
    
    mListener As MCObject Ptr

    mMountChannel As Byte Ptr
    mMountRequest As Unsigned Integer
    mMountStatus As Integer
    mFatBits As Integer
    mFatOffset As Integer
    mDataOffset As Integer
    mRootdirOffset As Integer
    mRootdirCluster As Integer
    
    mFatCache As Byte Ptr
    mFatCacheIndices As Integer Ptr
    mFatCacheBlocks As Integer
    
    Declare Constructor()
    Declare Destructor()
    
    Declare Virtual Sub Mount(ByVal Channel As Byte Ptr, ByVal request_id As Unsigned Integer) Override
    Declare Virtual Sub Data(ByVal Channel As Byte Ptr, ByVal map As Unsigned Integer, ByVal start_block As Unsigned Integer, ByRef content As String)
    
    Declare Sub readSuperBlock(ByRef content As String)
End Type

Type FATListener Extends BlockClientListener
    mDriver As FATDriver Ptr
    
    Declare Virtual Sub Data(ByVal Channel As Byte Ptr, ByVal map As Unsigned Integer, ByVal start_block As Unsigned Integer, ByRef content As String) Override
    
End Type

Type FAT_BPB Field = 1
    Dim jump(2) As Unsigned Byte                ' 0-2
    Dim oem(7) As Unsigned Byte                 ' 3-10
    Dim bytes_per_sector As Unsigned Short      ' 11-12
    Dim sectors_per_cluster As Unsigned Byte    ' 13
    Dim reserved_sectors As Unsigned Short      ' 14-15
    Dim fat_count As Unsigned Byte              ' 16
    Dim root_entry_count As Unsigned Short      ' 17-18
    Dim sector_count_16 As Unsigned Short       ' 19-20
    Dim media_descriptor_type As Unsigned Byte  ' 21
    Dim sectors_per_fat As Unsigned Short       ' 22-23
    Dim sectors_per_track As Unsigned Short     ' 24-25
    Dim head_count As Unsigned Short            ' 26-27
    Dim sectors_hidden As Unsigned Long         ' 28-31
    Dim sector_count_32 As Unsigned Long        ' 32-35
End Type

Type FAT_BPB_32 Field = 1
    bpb As FAT_BPB
End Type

Type FAT_BPB_16 Field = 1
    bpb As FAT_BPB
End Type
