' Summary: fatmain.bas
' Bootstrap for the FAT driver
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "fat.bi"
#include "mos.bi"
#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/driverutil.bi"
#include "../storage/roottrace.bi"
#include "x86.bi"
#include "mos/debugutil.bi"

Sub showbyte(ByVal b As Integer)
    outportb(&HE9, b)
End Sub

Sub showstring(ByRef s As String)
    Dim lp As Integer
    For lp = 0 to Len(s)
        showbyte(asc(mid$(s, lp, 1)))
    Next lp
End Sub

Dim Shared sQueryUtility As MCQueryUtility Ptr

Sub modmain CDecl Alias "main" ()

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HE9, 1)

    ShowString "[fat] initializing driver" + chr$(13) + chr$(10)

    Dim devid As Integer
    devid = DriverInit
    drv_setname(0, 1)

    'ShowString "[fat] 2" + chr$(13) + chr$(10)

    Dim parentid As Integer
    Dim parentaddr As Integer
    If LocateParent(devid, parentid, parentaddr) > 0 Then
        ' Couldn't get parent
	*CPtr(Byte Ptr, &HE0FA1001) = 0
    End If

    'ShowString "[fat] 3" + chr$(13) + chr$(10)

    Dim storageid As Integer
    Dim storageaddr As Integer
    If LocateStorage(devid, storageid, storageaddr) > 0 Then
        *CPtr(Byte Ptr, &HE0FA1002) = 0
    End If

    'ShowString "[fat] 4" + chr$(13) + chr$(10)

    Dim storageid2 As Integer
    Dim mapping As Integer

    If GetStorage(devid, storageid2, mapping) > 0 Then
        *CPtr(Byte Ptr, &HE0FA1003) = 0
    End If

    ShowString "[fat] @" & devid & " parent: " & parentid & "@0x" & hex$(parentaddr) & " storage 1: " & storageid & "@0x" & hex$(storageaddr) & " storage 2: " & storageid2 & ":" & mapping  & chr$(13) & chr$(10)

    Dim driver As FATDriver Ptr
    'ShowString "[fat] 6" + chr$(13) + chr$(10)
    driver = new FATDriver    
    driver->mStorageAddress = storageaddr
    driver->mStorageDevice = storageid
    driver->mStorageMap = mapping
    'ShowString "[fat] 7" + chr$(13) + chr$(10)

    sQueryUtility = new MCQueryUtility
    sQueryUtility->AddInterface(INTERFACE_FILENAME)
    'ShowString "[fat] 8" + chr$(13) + chr$(10)
    sQueryUtility->AnnounceDriver(devid)
    ShowString "[fat] going live" + chr$(13) + chr$(10)

    

    Dim retval As Integer
    retval = mos_eventloop()

    *CPtr(Byte Ptr, &HE0FA10E0 + retval) = 0

    While 1 = 1
        Yield
    Wend

End Sub


