/**
* Summary: fat.c
* The File Allocation Table filesystem driver
*
* Author:
*     Marcel Sondaar
*
* License:
*     <Educational Purposes>
*  
*/

#define UDI_VERSION 0x101
#define UDI_FS_VERSION 0x101
#define UDI_BLOCK_VERSION 0x101

#include <udi.h>
#include <udi_fs.h>
#include <udi_block.h>




#define FAT_BLOCK_META 1
#define BLOCK_OPS_IDX 1

#define FAT_FSRO_META 2
#define FSRO_OPS_IDX 2

static const udi_blockmap_ops_t fat_blockmap_client_ops = 
{
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL
};

static const udi_fs_blockread_provider_ops_t fat_blockread_provider_ops = 
{
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL
};


static const udi_ops_init_t fat_ops_init_list[] = {
    {
        BLOCK_OPS_IDX,        // todo: correct?
        FAT_BLOCK_META,       // meta index [from udiprops.txt]
        0, //UDI_GFX_PROVIDER_OPS_NUM, // todo: correct?
        0,                      // todo: no channel context
        (udi_ops_vector_t *)(void*)&fat_blockmap_client_ops,
        NULL   // todo: op_flags 
    },
    {
        FSRO_OPS_IDX,         // todo: correct?
        FAT_FSRO_META,        // meta index [from udiprops.txt]
        0, //UDI_GFX_PROVIDER_OPS_NUM, // todo: correct?
        0,                      // todo: no channel context
        (udi_ops_vector_t *)(void*)&fat_blockread_provider_ops,
        NULL   // todo: op_flags 
    },
    {
        0,  /* Terminator */
        0,
        0,
        0,
        NULL,
        NULL
    }
};

const udi_init_t udi_init_info = 
{
    NULL,               // todo: primary init
    NULL,               // todo: secondary init
    fat_ops_init_list,
    NULL,               // todo: cb init list
    NULL,               // todo: gcb_init_list
    NULL                // todo: cb_select_list
};

