/** 
 * Summary: hostfile.c
 * File I/O with the host
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <stdio.h>

unsigned int VDisk_HostFile_Size(const char * filename)
{
    FILE * file = fopen(filename, "rb");
    if (!file) return 0;
    int retval = fseek(file, 0, SEEK_END);
    if (retval != 0)
    {
        fclose(file);
	return 0;
    }

    int size = ftell(file);
    fclose(file);
    return (size < 0) ? 0 : size;
}

