' Summary vdiskcmd.bas
' Parsing and handling of commands
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "vdisk.bi"

Declare Sub bochs_puts CDecl Alias "bochs_puts" (ByVal text As Byte Ptr)

Function StringToBString(ByVal chardata As Unsigned Byte Ptr) As String
    Dim s As String
    Dim i As Integer
    While chardata[i] <> 0
        s = s + Chr$(chardata[i])
        i = i + 1
    Wend
    Function = s
End Function

Function VDisk_Command_C(ByVal chardata As Unsigned Byte Ptr) As Integer
    Dim cmd As String
    cmd = StringToBString(chardata)
    Function = VDisk_Command(cmd)
End Function

Sub ErrorString(ByRef text As String)
    Dim textnewline As String
    textnewline = text
    bochs_puts(*CPtr(Byte Ptr Ptr, @textnewline))
End Sub

Function VDisk_Command(ByRef cmd As String) As Integer
    'ErrorString "Parsing: " + cmd
    Dim lhs As String, rhs As String, cmdsplit As Integer
    cmdsplit = instr(cmd, " ")
    If cmdsplit = 0 Then
        lhs = cmd
	rhs = ""
    Else
        lhs = LCase(Left(cmd, cmdsplit - 1))
	rhs = Mid(cmd, cmdsplit + 1)
    End If

    ErrorString "Parsing '" + lhs + "' and '" + rhs + "'"
    
    Select Case lhs
        Case "storage"
            VDisk_StorageCreateFromFile(rhs, "A")
     

        Case "help"
	    ErrorString "available commands: help storage"

        Case Else
	    ErrorString "Unknown command: '" + lhs + "'"
	    
    End Select

    Function = 0
End Function

