' Summary: bga_coref.bas
' Core functionality for the BGA graphics adapter
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos/gfx.bi"
#include "mos/bga_regs.bi"
#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/pci.bi"
#include "mos.bi"
#include "x86.bi"

#include "GL/mgl.bi"
#include "GL/gl.bi"
#include "swgl/glbuffer.bi"
#include "vga/vgatool.bi"
#include "opcodetool.bi"

Declare Function BGA_ConnectorSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
Declare Function BGA_EngineSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
Declare Function BGA_ConnectorGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
Declare Function BGA_EngineGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
Declare Function BGA_ConnectorGetRange CDecl (info As Byte Ptr, ByVal sender As Integer, index As Integer, prop As Integer) As Integer
Declare Function BGA_EngineGetRange CDecl (info As Byte Ptr, ByVal sender As Integer, index As Integer, prop As Integer) As Integer
Declare Function BGA_GLDispatch CDecl(ByVal info as Byte Ptr, ByVal data As Byte Ptr, ByVal length As Integer) As Integer

Declare Sub _gl_inittextures CDecl Alias "_gl_inittextures" ()

Dim Shared BGA_Frontbuffer As Byte Ptr
Dim Shared BGA_Backbuffer As Byte Ptr

Type ConnectorState
    Enabled as Integer
    BitDepth As Integer
    Width As Integer
    Height As Integer
End Type

Dim Shared connector As ConnectorState

Type EngineState
    Enabled As Integer
    Width As Integer
    Height As Integer
    VWidth As Integer
    Xoff As Integer
    Yoff As Integer
    CurOpcode As Integer
    OpcodeMap As UDIOpcodeMap Ptr
End Type

Dim Shared engines(0 to 3) As EngineState

Sub modmain CDecl Alias "main" (argc As Integer, argv As Byte Ptr Ptr)

    '*CPtr(Byte Ptr, &HB8000 + argc) = 0
    allocateiobitmap(BGA_INDEX_PORT, 4, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(BGA_INDEX_PORT, 4)
    portalloc(&HCF8, 8)
    portalloc(&H3C7, 4)

    Dim framebuffer As Byte Ptr
    framebuffer = CPtr(Byte Ptr, &HE0000000)

    _gl_inittextures

    glMatrixMode GL_PROJECTION
    glLoadIdentity
    glMatrixMode GL_MODELVIEW
    glLoadIdentity
    glColor3f 1, 1, 1

    portalloc(&HE9, 1)

    Dim devid As Integer
    devid = DriverInit

    Dim cmdline As String
    cmdline = "[bga " + str$(devid) + "]"

    If BGA_Read(bga_regs.INDEX_ID) >= &HB0C5 Then

        Dim devloc As String
        Dim devmsg(0 to 1) As Integer
        devmsg(0) = 10
        devmsg(1) = devid
        drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(devmsg(0))))

        Dim Location As String
        While Location = ""
            While drv_peekmessage() = 0
                Yield
            Wend

            Dim rs As String
            rs = space$(drv_peekmessage())
            Dim rv As Integer
            rv = drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))
            If rv = DRIVER_MGR * &H10000 Then
                location = rs
            End if
        Wend

        cmdline = cmdline & " [" & location & "]" & chr(13) & chr$(10)

        if left$(location, 4) = "PCI " Then
            ' Todo: replace with a call to pciserv

            Dim bus as integer
            dim dev as integer
            dim dfn as integer
            bus = Valint("&H" & mid$(location,  5, 2))
            dev = Valint("&H" & mid$(location,  8, 2))
            dfn = Valint("&H" & mid$(location, 11, 2))

            Dim bar As Integer
            bar = pci_type1_readdword(bus, dev, dfn, &H10)
            If (Bar <> 0) And ((bar and &H3FFFF0) = 0) Then
                framebuffer = CPtr(Byte Ptr, (bar and &HFFC00000))
            End If
        End If
    End If

    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), framebuffer)
    BlockAllocPhysL(1, CPtr(Byte Ptr, &H60000000), framebuffer)
    BGA_Frontbuffer = CPtr(Byte Ptr, &H60000000)
    BGA_Backbuffer = CPtr(Byte Ptr, &H60000000)

    Dim lp As Integer
    for lp = 1 to len(cmdline)
        outportb(&HE9, asc(mid$(cmdline, lp, 1)))
    next lp

    ' register driver in device manager
    drv_setname(0,1)
    dim msg(0 to 1) As integer
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    engines(0).OpcodeMap = @opcodemap_b8g8r8x8
    engines(1).OpcodeMap = @opcodemap_b5g6r5
    engines(2).OpcodeMap = @opcodemap_b8g8r8
    engines(3).OpcodeMap = @opcodemap_b8g8r8x8

    Dim driver As GFXDRIVER2
    driver.Connectors = 1
    driver.Engines = 4 ' 8bpp, 16bpp, 24bpp, 32bpp
    driver.setconnectorstate = @BGA_ConnectorSetState
    driver.getconnectorstate = @BGA_ConnectorGetState
    driver.getconnectorrange = @BGA_ConnectorGetRange
    driver.setenginestate = @BGA_EngineSetState
    driver.getenginestate = @BGA_EngineGetState
    driver.getenginerange = @BGA_EngineGetRange
    driver.gldispatch = @BGA_GLDispatch

    graphicsmain2(driver, CPtr(Byte Ptr, 0))

    'BGA_SetMode(CPtr(Byte Ptr, 0), 800, 600, PF_R8G8B8X8, 60)

End Sub

Function BGA_ConnectorSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer

    Function = 0
    If index <> 0 Then Exit Function

    Select Case prop
        Case GFX_PROP_ENABLE
            If value = 0 Then
                BGA_Write(bga_regs.INDEX_ENABLE, 0)
                connector.enabled = 0
            Else
            
                Dim engineindex As Integer
                engineindex = (connector.BitDepth \ 8) - 1
            
                BGA_Write(bga_regs.INDEX_X_OFFSET, engines(engineindex).xoff)
                BGA_Write(bga_regs.INDEX_Y_OFFSET, engines(engineindex).yoff)                     
                
                if (BGA_Backbuffer < BGA_frontbuffer) Then BGA_Frontbuffer = BGA_Backbuffer
                BGA_Backbuffer = @(BGA_Frontbuffer[connector.Width * connector.Height * connector.bitdepth / 8])

                _gl_setoutput(BGA_Frontbuffer, connector.Width, connector.Height, connector.Width*connector.BitDepth / 8)
                If (connector.BitDepth = 32) Then
                    _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8x8
                    _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8a8
                ElseIf (connector.BitDepth = 24) Then
                    _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8
                    _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8
                ElseIf (connector.BitDepth = 16) Then
                    _gl_backbuffer->writebuffer = @_gl_writebuffer_r5g6b5
                    _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b5g6r5
                Else
                    ' indexed
                    _gl_backbuffer->writebuffer = @_gl_writebuffer_i8
                    _gl_backbuffer->fillbuffer = @_gl_fillbuffer_i8
                End If

                glViewport(0,0,connector.Width, connector.Height)
                glScissor(0,0,connector.Width, connector.Height)
                
                BGA_Write(bga_regs.INDEX_ENABLE, bga_regs_enable.BGA_OUTPUT_ENABLED Or bga_regs_enable.BGA_LFB_ENABLED)
                connector.enabled = 1                
            End If                      

        Case GFX_PROP_INPUT
            If connector.enabled <> 0 Then Exit Function
            If value < 0 then Exit Function
            If value > 3 then Exit Function
            connector.bitdepth = value * 8 + 8
            BGA_Write(bga_regs.INDEX_BPP, connector.bitdepth)

        Case GFX_PROP_WIDTH
            If connector.enabled <> 0 Then Exit Function
            If value < 32 then value = 32
            If value > 1280 then value = 1280
            value = value - (value mod 16)
            BGA_Write(bga_regs.INDEX_XRES, value)
            connector.Width = value

        Case GFX_PROP_HEIGHT
            If connector.enabled <> 0 Then Exit Function
            If value < 32 then value = 32
            If value > 1024 then value = 1024
            value = value - (value mod 16)
            BGA_Write(bga_regs.INDEX_YRES, value)
            connector.Height = value

    End Select

End Function
Function BGA_ConnectorGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
    Function = 0
    If index <> 0 Then Exit Function

    Select Case prop
        Case GFX_PROP_ENABLE
            Function = connector.Enabled

        Case GFX_PROP_INPUT
            Function = (connector.BitDepth / 8) - 1

        Case GFX_PROP_WIDTH
            Function = connector.Width

        Case GFX_PROP_HEIGHT
            Function = connector.Height

        Case GFX_PROP_SIGNAL:
            Function = GFX_SIGNAL_INTEGRATED

        Case GFX_PROP_CONNECTOR_TYPE
            Function = GFX_CONNECTOR_HIDDEN

    End Select
End Function

Function BGA_ConnectorGetRange CDecl (info As Byte Ptr, sender As Integer, index As Integer, prop As Integer) As Integer
    if index = 0 Then
        Function = 1
        Select case prop
            Case GFX_PROP_ENABLE
                ConnectorReturnBooleanRange(sender, index, prop, 0, 1)
            Case GFX_PROP_INPUT
                ConnectorReturnSimpleRange(sender, index, prop, 0, 3, 1)
            Case GFX_PROP_WIDTH
                ConnectorReturnSimpleRange(sender, index, prop, 320, 1024, 8)
            Case GFX_PROP_HEIGHT
                ConnectorReturnSimpleRange(sender, index, prop, 240, 768, 8)
            Case GFX_PROP_SIGNAL
                ConnectorReturnConstantRange(sender, index, prop, GFX_SIGNAL_INTEGRATED)
            Case GFX_PROP_CONNECTOR_TYPE
                ConnectorReturnConstantRange(sender, index, prop, GFX_CONNECTOR_HIDDEN)

            Case Else
                Function = 0
        End select
    Else
        Function = 0
    End If
End Function

Function BGA_EngineSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
    Function = 0
    If (index < 0) or (index > 3) Then Exit Function
    Select Case prop
      
        Case GFX_PROP_TRANSLATEX
            If value < 0 Then value = 0
            If value >= engines(index).width Then value = engines(index).width - 1
            engines(index).xoff = value
            If index = (connector.BitDepth \ 8) - 1 Then BGA_Write(bga_regs.INDEX_X_OFFSET, value)
        Case GFX_PROP_TRANSLATEY
            If value < 0 Then value = 0
            If value > engines(index).height Then value = engines(index).height
            engines(index).yoff = value
            If index = (connector.BitDepth \ 8) - 1 Then BGA_Write(bga_regs.INDEX_Y_OFFSET, value)            
        Case GFX_PROP_OPERATOR_INDEX
            engines(index).CurOpcode = value
        Case Else

    End Select
End Function

Function BGA_EngineGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
    Function = 0
    If (index < 0) or (index > 3) Then Exit Function
    Select Case prop
        'Case GFX_PROP_ENABLE
        Case GFX_PROP_INPUT
            Function = -1
        'Case GFX_PROP_WIDTH
        'Case GFX_PROP_HEIGHT
        'Case GFX_PROP_CLIP
        Case GFX_PROP_UNIT_WIDTH
            Function = 1
        Case GFX_PROP_UNIT_HEIGHT
            Function = 1
        Case GFX_PROP_TILESHEET
            Function = 0
        Case GFX_PROP_PALETTE
            If index = 0 Then
                Function = 2
            Else
                Function = 0
            End If
        Case GFX_PROP_BUFFER
            Function = 1
        'Case GFX_PROP_TRANSLATEX = 10            
        'Case GFX_PROP_TRANSLATEY = 11        
        Case GFX_PROP_STORE_WIDTH
            Function = 1
        Case GFX_PROP_STORE_HEIGHT
            Function = 1
        Case GFX_PROP_STORE_BITS
            Function = (index + 1) * 8
        Case GFX_PROP_SOURCE_WIDTH
            Function = 1
        Case GFX_PROP_SOURCE_HEIGHT
            Function = 1
            
        Case GFX_PROP_OPERATOR_INDEX, GFX_PROP_OPERATOR_OPCODE, GFX_PROP_OPERATOR_ARG_1, GFX_PROP_OPERATOR_ARG_2, GFX_PROP_OPERATOR_ARG_3
            Function = readopcodemap(engines(index).OpcodeMap, prop, engines(index).CurOpcode)

    End Select

End Function

Function BGA_EngineGetRange CDecl (info As Byte Ptr, sender As Integer, index As Integer, prop As Integer) As Integer
    Function = 0
    If (index < 0) or (index > 3) Then Exit Function
    Function = 1
    Select Case prop
        'Case GFX_PROP_ENABLE
        Case GFX_PROP_INPUT
            EngineReturnConstantRange(sender, index, prop, -1)
        'Case GFX_PROP_WIDTH
        'Case GFX_PROP_HEIGHT
        'Case GFX_PROP_CLIP
        Case GFX_PROP_UNIT_WIDTH
            EngineReturnConstantRange(sender, index, prop, 1)
        Case GFX_PROP_UNIT_HEIGHT
            EngineReturnConstantRange(sender, index, prop, 1)
        Case GFX_PROP_TILESHEET
            EngineReturnConstantRange(sender, index, prop, 0)
        Case GFX_PROP_PALETTE
            EngineReturnConstantRange(sender, index, prop, IIf(index = 0, 2, 0))
        Case GFX_PROP_BUFFER
            EngineReturnConstantRange(sender, index, prop, 1)
        'Case GFX_PROP_TRANSLATEX = 10
        'Case GFX_PROP_TRANSLATEY = 11
        Case GFX_PROP_STORE_WIDTH
            EngineReturnConstantRange(sender, index, prop, 1)
        Case GFX_PROP_STORE_HEIGHT = 13
            EngineReturnConstantRange(sender, index, prop, 1)
        Case GFX_PROP_STORE_BITS = 14
            EngineReturnConstantRange(sender, index, prop, 8 * (index + 1))
        Case GFX_PROP_SOURCE_HEIGHT
            EngineReturnConstantRange(sender, index, prop, 1)
        Case GFX_PROP_SOURCE_WIDTH
            EngineReturnConstantRange(sender, index, prop, 1)
        Case GFX_PROP_OPERATOR_INDEX, GFX_PROP_OPERATOR_OPCODE, GFX_PROP_OPERATOR_ARG_1, GFX_PROP_OPERATOR_ARG_2, GFX_PROP_OPERATOR_ARG_3
            Dim start As Integer, endval As Integer
            readopcodemaprange(engines(index).OpcodeMap, prop, engines(index).CurOpcode, start, endval)
            EngineReturnSimpleRange(sender, index, prop, start, endval, 1)
        Case Else
            Function = 0
    End Select

End Function

Function BGA_GLDispatch CDecl(ByVal info as Byte Ptr, ByVal buffer As Byte Ptr, ByVal length As Integer) As Integer
    If mglDispatchInstruction(buffer, length) = 0 Then
        if length = 8 Then
            'If CPtr(Short Ptr, buffer)[1] = 4000 Then
            '    If BGA_Backbuffer > BGA_Frontbuffer Then
            '        BGA_Write(bga_regs.INDEX_Y_OFFSET, connector.height)
            '    Else
            '        BGA_Write(bga_regs.INDEX_Y_OFFSET, 0)
            '    End If
            '    Dim tempptr As Byte Ptr
            '    tempptr = BGA_Frontbuffer
            '    BGA_Frontbuffer = BGA_Backbuffer
            '    BGA_Backbuffer = tempptr
            '    _gl_setoutput(BGA_Backbuffer, connector.width, connector.height, connector.bitdepth * connector.width / 8)
            'End If
        end if
        Function = 0
    Else
        Function = 1
    End if
End Function

Sub glBindBufferUDI CDecl Alias "glBindBufferUDI"(ByVal Target As Integer, ByVal Buffer As Integer)
    If target <> GL_BUFFER_2D Then Exit Sub
    If Buffer = 1 Then _gl_currentbuffer = _gl_backbuffer
    If Buffer = 2 Then _gl_currentbuffer = @_gl_pal18buffer
End Sub