' Summary: bga_io.bas
' Bochs Graphics Adapter access functions
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/bga_regs.bi"
#include "x86.bi"

' Function: BGA_Write
' Writes a BGA register
'
' In:
'     index    - register to access
'     contents - value to write
'
' Out:
'     none
'
Sub BGA_Write(ByVal index As Integer, ByVal contents As Unsigned Short)
    outportw(BGA_INDEX_PORT, index)
    outportw(BGA_DATA_PORT, contents)
End Sub

' Function: BGA_Read
' Writes a BGA register
'
' In:
'     index - register to access
'
' Out:
'     return - value of the register
'
Function BGA_Read(ByVal index As Integer) As Unsigned Short
    outportw(BGA_INDEX_PORT, index)
    Function = inportw(BGA_DATA_PORT)
End Function

