; Summary: font8_8.asm
; 8x8 monochrome bitmap fonts for rendering
;
; Author:
;     Marcel Sondaar
;     International Business Machines (public domain VGA fonts)
;
; License:
;     Public Domain
;

section .rodata
global font8x8_0000     ; Basic latin
global font8x8_0080     ; C0 / C1
global font8x8_00A0     ; Extended latin
global font8x8_0390     ; Greek
global font8x8_2500     ; Box drawing
global font8x8_2580     ; Block elements
global font8x8_3040     ; Hiragana

global font8x8_table

; Constant: font8x8_0000
; Contains an 8x8 font map for unicode points U+0000 - U+007F (basic latin)
font8x8_0000:       DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0000 (nul)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0001
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0002
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0003
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0004
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0005
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0006
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0007
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0008
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0009
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+000A
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+000B
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+000C
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+000D
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+000E
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+000F
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0010
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0011
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0012
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0013
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0014
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0015
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0016
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0017
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0018
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0019
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+001A
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+001B
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+001C
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+001D
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+001E
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+001F
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0020 (space)
                    DB 0x18, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x18, 0x00   ; U+0021 (!)
                    DB 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0022 (")
                    DB 0x36, 0x36, 0x7F, 0x36, 0x7F, 0x36, 0x36, 0x00   ; U+0023 (#)
                    DB 0x0C, 0x3E, 0x03, 0x1E, 0x30, 0x1F, 0x0C, 0x00   ; U+0024 ($)
                    DB 0x00, 0x63, 0x33, 0x18, 0x0C, 0x66, 0x63, 0x00   ; U+0025 (%)
                    DB 0x1C, 0x36, 0x1C, 0x6E, 0x3B, 0x33, 0x6E, 0x00   ; U+0026 (&)
                    DB 0x06, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0027 (')
                    DB 0x18, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x18, 0x00   ; U+0028 (()
                    DB 0x06, 0x0C, 0x18, 0x18, 0x18, 0x0C, 0x06, 0x00   ; U+0029 ())
                    DB 0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00   ; U+002A (*)
                    DB 0x00, 0x0C, 0x0C, 0x3F, 0x0C, 0x0C, 0x00, 0x00   ; U+002B (+)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x06   ; U+002C (,)
                    DB 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00   ; U+002D (-)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00   ; U+002E (.)
                    DB 0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x00   ; U+002F (/)
                    DB 0x3E, 0x63, 0x73, 0x7B, 0x6F, 0x67, 0x3E, 0x00   ; U+0030 (0)
                    DB 0x0C, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x3F, 0x00   ; U+0031 (1)
                    DB 0x1E, 0x33, 0x30, 0x1C, 0x06, 0x33, 0x3F, 0x00   ; U+0032 (2)
                    DB 0x1E, 0x33, 0x30, 0x1C, 0x30, 0x33, 0x1E, 0x00   ; U+0033 (3)
                    DB 0x38, 0x3C, 0x36, 0x33, 0x7F, 0x30, 0x78, 0x00   ; U+0034 (4)
                    DB 0x3F, 0x03, 0x1F, 0x30, 0x30, 0x33, 0x1E, 0x00   ; U+0035 (5)
                    DB 0x1C, 0x06, 0x03, 0x1F, 0x33, 0x33, 0x1E, 0x00   ; U+0036 (6)
                    DB 0x3F, 0x33, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x00   ; U+0037 (7)
                    DB 0x1E, 0x33, 0x33, 0x1E, 0x33, 0x33, 0x1E, 0x00   ; U+0038 (8)
                    DB 0x1E, 0x33, 0x33, 0x3E, 0x30, 0x18, 0x0E, 0x00   ; U+0039 (9)
                    DB 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x0C, 0x0C, 0x00   ; U+003A (:)
                    DB 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x0C, 0x0C, 0x06   ; U+003B (;)
                    DB 0x18, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x18, 0x00   ; U+003C (<)
                    DB 0x00, 0x00, 0x3F, 0x00, 0x00, 0x3F, 0x00, 0x00   ; U+003D (=)
                    DB 0x06, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x06, 0x00   ; U+003E (>)
                    DB 0x1E, 0x33, 0x30, 0x18, 0x0C, 0x00, 0x0C, 0x00   ; U+003F (?)
                    DB 0x3E, 0x63, 0x7B, 0x7B, 0x7B, 0x03, 0x1E, 0x00   ; U+0040 (@)
                    DB 0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00   ; U+0041 (A)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x66, 0x66, 0x3F, 0x00   ; U+0042 (B)
                    DB 0x3C, 0x66, 0x03, 0x03, 0x03, 0x66, 0x3C, 0x00   ; U+0043 (C)
                    DB 0x1F, 0x36, 0x66, 0x66, 0x66, 0x36, 0x1F, 0x00   ; U+0044 (D)
                    DB 0x7F, 0x46, 0x16, 0x1E, 0x16, 0x46, 0x7F, 0x00   ; U+0045 (E)
                    DB 0x7F, 0x46, 0x16, 0x1E, 0x16, 0x06, 0x0F, 0x00   ; U+0046 (F)
                    DB 0x3C, 0x66, 0x03, 0x03, 0x73, 0x66, 0x7C, 0x00   ; U+0047 (G)
                    DB 0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x00   ; U+0048 (H)
                    DB 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0049 (I)
                    DB 0x78, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1E, 0x00   ; U+004A (J)
                    DB 0x67, 0x66, 0x36, 0x1E, 0x36, 0x66, 0x67, 0x00   ; U+004B (K)
                    DB 0x0F, 0x06, 0x06, 0x06, 0x46, 0x66, 0x7F, 0x00   ; U+004C (L)
                    DB 0x63, 0x77, 0x7F, 0x7F, 0x6B, 0x63, 0x63, 0x00   ; U+004D (M)
                    DB 0x63, 0x67, 0x6F, 0x7B, 0x73, 0x63, 0x63, 0x00   ; U+004E (N)
                    DB 0x1C, 0x36, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00   ; U+004F (O)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x0F, 0x00   ; U+0050 (P)
                    DB 0x1E, 0x33, 0x33, 0x33, 0x3B, 0x1E, 0x38, 0x00   ; U+0051 (Q)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x36, 0x66, 0x67, 0x00   ; U+0052 (R)
                    DB 0x1E, 0x33, 0x07, 0x0E, 0x38, 0x33, 0x1E, 0x00   ; U+0053 (S)
                    DB 0x3F, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0054 (T)
                    DB 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x00   ; U+0055 (U)
                    DB 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00   ; U+0056 (V)
                    DB 0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00   ; U+0057 (W)
                    DB 0x63, 0x63, 0x36, 0x1C, 0x1C, 0x36, 0x63, 0x00   ; U+0058 (X)
                    DB 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x1E, 0x00   ; U+0059 (Y)
                    DB 0x7F, 0x63, 0x31, 0x18, 0x4C, 0x66, 0x7F, 0x00   ; U+005A (Z)
                    DB 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1E, 0x00   ; U+005B ([)
                    DB 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x40, 0x00   ; U+005C (\)
                    DB 0x1E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1E, 0x00   ; U+005D (])
                    DB 0x08, 0x1C, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00   ; U+005E (^)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF   ; U+005F (_)
                    DB 0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0060 (`)
                    DB 0x00, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x6E, 0x00   ; U+0061 (a)
                    DB 0x07, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x3B, 0x00   ; U+0062 (b)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x03, 0x33, 0x1E, 0x00   ; U+0063 (c)
                    DB 0x38, 0x30, 0x30, 0x3e, 0x33, 0x33, 0x6E, 0x00   ; U+0064 (d)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x3f, 0x03, 0x1E, 0x00   ; U+0065 (e)
                    DB 0x1C, 0x36, 0x06, 0x0f, 0x06, 0x06, 0x0F, 0x00   ; U+0066 (f)
                    DB 0x00, 0x00, 0x6E, 0x33, 0x33, 0x3E, 0x30, 0x1F   ; U+0067 (g)
                    DB 0x07, 0x06, 0x36, 0x6E, 0x66, 0x66, 0x67, 0x00   ; U+0068 (h)
                    DB 0x0C, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0069 (i)
                    DB 0x30, 0x00, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1E   ; U+006A (j)
                    DB 0x07, 0x06, 0x66, 0x36, 0x1E, 0x36, 0x67, 0x00   ; U+006B (k)
                    DB 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+006C (l)
                    DB 0x00, 0x00, 0x33, 0x7F, 0x7F, 0x6B, 0x63, 0x00   ; U+006D (m)
                    DB 0x00, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x00   ; U+006E (n)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x1E, 0x00   ; U+006F (o)
                    DB 0x00, 0x00, 0x3B, 0x66, 0x66, 0x3E, 0x06, 0x0F   ; U+0070 (p)
                    DB 0x00, 0x00, 0x6E, 0x33, 0x33, 0x3E, 0x30, 0x78   ; U+0071 (q)
                    DB 0x00, 0x00, 0x3B, 0x6E, 0x66, 0x06, 0x0F, 0x00   ; U+0072 (r)
                    DB 0x00, 0x00, 0x3E, 0x03, 0x1E, 0x30, 0x1F, 0x00   ; U+0073 (s)
                    DB 0x08, 0x0C, 0x3E, 0x0C, 0x0C, 0x2C, 0x18, 0x00   ; U+0074 (t)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x6E, 0x00   ; U+0075 (u)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00   ; U+0076 (v)
                    DB 0x00, 0x00, 0x63, 0x6B, 0x7F, 0x7F, 0x36, 0x00   ; U+0077 (w)
                    DB 0x00, 0x00, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x00   ; U+0078 (x)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x3E, 0x30, 0x1F   ; U+0079 (y)
                    DB 0x00, 0x00, 0x3F, 0x19, 0x0C, 0x26, 0x3F, 0x00   ; U+007A (z)
                    DB 0x38, 0x0C, 0x0C, 0x07, 0x0C, 0x0C, 0x38, 0x00   ; U+007B ({)
                    DB 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00   ; U+007C (|)
                    DB 0x07, 0x0C, 0x0C, 0x38, 0x0C, 0x0C, 0x07, 0x00   ; U+007D (})
                    DB 0x6E, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+007E (~)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+007F

; Constant: font8x8_0080
; Contains an 8x8 font map for unicode points U+0080 - U+009F (C1/C2 control)
font8x8_0080:
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0080
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0081
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0082
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0083
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0084
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0085
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0086
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0087
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0088
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0089
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+008A
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+008B
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+008C
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+008D
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+008E
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+008F
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0090
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0091
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0092
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0093
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0094
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0095
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0096
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0097
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0098
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0099
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+009A
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+009B
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+009C
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+009D
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+009E
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+009F

; Constant: font8x8_00A0
; Contains an 8x8 font map for unicode points U+00A0 - U+00FF (extended latin)
font8x8_00A0:       DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+00A0 (no break space)
                    DB 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00   ; U+00A1 (inverted !)
                    DB 0x18, 0x18, 0x7E, 0x03, 0x03, 0x7E, 0x18, 0x18   ; U+00A2 (dollarcents)
                    DB 0x1C, 0x36, 0x26, 0x0F, 0x06, 0x67, 0x3F, 0x00   ; U+00A3 (pound sterling)
                    DB 0x00, 0x00, 0x63, 0x3E, 0x36, 0x3E, 0x63, 0x00   ; U+00A4 (currency mark)
                    DB 0x33, 0x33, 0x1E, 0x3F, 0x0C, 0x3F, 0x0C, 0x0C   ; U+00A5 (yen)
                    DB 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00   ; U+00A6 (broken pipe)
                    DB 0x7C, 0xC6, 0x1C, 0x36, 0x36, 0x1C, 0x33, 0x1E   ; U+00A7 (paragraph)
                    DB 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+00A8 (diaeresis)
                    DB 0x3C, 0x42, 0x99, 0x85, 0x85, 0x99, 0x42, 0x3C   ; U+00A9 (copyright symbol)
                    DB 0x3C, 0x36, 0x36, 0x7C, 0x00, 0x00, 0x00, 0x00   ; U+00AA (superscript a)
                    DB 0x00, 0xCC, 0x66, 0x33, 0x66, 0xCC, 0x00, 0x00   ; U+00AB (<<)
                    DB 0x00, 0x00, 0x00, 0x3F, 0x30, 0x30, 0x00, 0x00   ; U+00AC (gun pointing left)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+00AD (soft hyphen)
                    DB 0x3C, 0x42, 0x9D, 0xA5, 0x9D, 0xA5, 0x42, 0x3C   ; U+00AE (registered symbol)
                    DB 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+00AF (macron)
                    DB 0x1C, 0x36, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00   ; U+00B0 (degree)
                    DB 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x7E, 0x00   ; U+00B1 (plusminus)
                    DB 0x1C, 0x30, 0x18, 0x0C, 0x3C, 0x00, 0x00, 0x00   ; U+00B2 (superscript 2)
                    DB 0x1C, 0x30, 0x18, 0x30, 0x1C, 0x00, 0x00, 0x00   ; U+00B2 (superscript 3)
                    DB 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+00B2 (aigu)
                    DB 0x00, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x06, 0x03   ; U+00B5 (mu)
                    DB 0xFE, 0xDB, 0xDB, 0xDE, 0xD8, 0xD8, 0xD8, 0x00   ; U+00B6 (pilcrow)
                    DB 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00   ; U+00B7 (central dot)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x1E   ; U+00B8 (cedille)
                    DB 0x08, 0x0C, 0x08, 0x1C, 0x00, 0x00, 0x00, 0x00   ; U+00B9 (superscript 1)
                    DB 0x1C, 0x36, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00   ; U+00BA (superscript 0)
                    DB 0x00, 0x33, 0x66, 0xCC, 0x66, 0x33, 0x00, 0x00   ; U+00BB (>>)
                    DB 0xC3, 0x63, 0x33, 0xBD, 0xEC, 0xF6, 0xF3, 0x03   ; U+00BC (1/4)
                    DB 0xC3, 0x63, 0x33, 0x7B, 0xCC, 0x66, 0x33, 0xF0   ; U+00BD (1/2)
                    DB 0x03, 0xC4, 0x63, 0xB4, 0xDB, 0xAC, 0xE6, 0x80   ; U+00BE (3/4)
                    DB 0x0C, 0x00, 0x0C, 0x06, 0x03, 0x33, 0x1E, 0x00   ; U+00BF (inverted ?)
                    DB 0x07, 0x00, 0x1C, 0x36, 0x63, 0x7F, 0x63, 0x00   ; U+00C0 (A grave)
                    DB 0x70, 0x00, 0x1C, 0x36, 0x63, 0x7F, 0x63, 0x00   ; U+00C1 (A aigu)
                    DB 0x1C, 0x36, 0x00, 0x3E, 0x63, 0x7F, 0x63, 0x00   ; U+00C2 (A circumflex)
                    DB 0x6E, 0x3B, 0x00, 0x3E, 0x63, 0x7F, 0x63, 0x00   ; U+00C3 (A ~)
                    DB 0x63, 0x1C, 0x36, 0x63, 0x7F, 0x63, 0x63, 0x00   ; U+00C4 (A umlaut)
                    DB 0x0C, 0x0C, 0x00, 0x1E, 0x33, 0x3F, 0x33, 0x00   ; U+00C5 (A ring)
                    DB 0x7C, 0x36, 0x33, 0x7F, 0x33, 0x33, 0x73, 0x00   ; U+00C6 (AE)
                    DB 0x1E, 0x33, 0x03, 0x33, 0x1E, 0x18, 0x30, 0x1E   ; U+00C7 (C cedille)
                    DB 0x07, 0x00, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00   ; U+00C8 (E grave)
                    DB 0x38, 0x00, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00   ; U+00C9 (E aigu)
                    DB 0x0C, 0x12, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00   ; U+00CA (E circumflex)
                    DB 0x36, 0x00, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00   ; U+00CB (E umlaut)
                    DB 0x07, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+00CC (I grave)
                    DB 0x38, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+00CD (I aigu)
                    DB 0x0C, 0x12, 0x00, 0x1E, 0x0C, 0x0C, 0x1E, 0x00   ; U+00CE (I circumflex)
                    DB 0x33, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+00CF (I umlaut)
                    DB 0x3F, 0x66, 0x6F, 0x6F, 0x66, 0x66, 0x3F, 0x00   ; U+00D0 (Eth)
                    DB 0x3F, 0x00, 0x33, 0x37, 0x3F, 0x3B, 0x33, 0x00   ; U+00D1 (N ~)
                    DB 0x0E, 0x00, 0x18, 0x3C, 0x66, 0x3C, 0x18, 0x00   ; U+00D2 (O grave)
                    DB 0x70, 0x00, 0x18, 0x3C, 0x66, 0x3C, 0x18, 0x00   ; U+00D3 (O aigu)
                    DB 0x3C, 0x66, 0x18, 0x3C, 0x66, 0x3C, 0x18, 0x00   ; U+00D4 (O circumflex)
                    DB 0x6E, 0x3B, 0x00, 0x3E, 0x63, 0x63, 0x3E, 0x00   ; U+00D5 (O ~)
                    DB 0xC3, 0x18, 0x3C, 0x66, 0x66, 0x3C, 0x18, 0x00   ; U+00D6 (O umlaut)
                    DB 0x00, 0x36, 0x1C, 0x08, 0x1C, 0x36, 0x00, 0x00   ; U+00D7 (multiplicative x)
                    DB 0x5C, 0x36, 0x73, 0x7B, 0x6F, 0x36, 0x1D, 0x00   ; U+00D8 (O stroke)
                    DB 0x0E, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00   ; U+00D9 (U grave)
                    DB 0x70, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00   ; U+00DA (U aigu)
                    DB 0x3C, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x00   ; U+00DB (U circumflex)
                    DB 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00   ; U+00DC (U umlaut)
                    DB 0x70, 0x00, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x00   ; U+00DD (Y aigu)
                    DB 0x0F, 0x06, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x0F   ; U+00DE (Thorn)
                    DB 0x00, 0x1E, 0x33, 0x1F, 0x33, 0x1F, 0x03, 0x03   ; U+00DF (beta)
                    DB 0x07, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00   ; U+00E0 (a grave)
                    DB 0x38, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00   ; U+00E1 (a aigu)
                    DB 0x7E, 0xC3, 0x3C, 0x60, 0x7C, 0x66, 0xFC, 0x00   ; U+00E2 (a circumflex)
                    DB 0x6E, 0x3B, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00   ; U+00E3 (a ~)
                    DB 0x33, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00   ; U+00E4 (a umlaut)
                    DB 0x0C, 0x0C, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00   ; U+00E5 (a ring)
                    DB 0x00, 0x00, 0xFE, 0x30, 0xFE, 0x33, 0xFE, 0x00   ; U+00E6 (ae)
                    DB 0x00, 0x00, 0x1E, 0x03, 0x03, 0x1E, 0x30, 0x1C   ; U+00E7 (c cedille)
                    DB 0x07, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x1E, 0x00   ; U+00E8 (e grave)
                    DB 0x38, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x1E, 0x00   ; U+00E9 (e aigu)
                    DB 0x7E, 0xC3, 0x3C, 0x66, 0x7E, 0x06, 0x3C, 0x00   ; U+00EA (e circumflex)
                    DB 0x33, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x1E, 0x00   ; U+00EB (e umlaut)
                    DB 0x07, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+00EC (i grave)
                    DB 0x1C, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+00ED (i augu)
                    DB 0x3E, 0x63, 0x1C, 0x18, 0x18, 0x18, 0x3C, 0x00   ; U+00EE (i circumflex)
                    DB 0x33, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+00EF (i umlaut)
                    DB 0x1B, 0x0E, 0x1B, 0x30, 0x3E, 0x33, 0x1E, 0x00   ; U+00F0 (eth)
                    DB 0x00, 0x1F, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x00   ; U+00F1 (n ~)
                    DB 0x00, 0x07, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00   ; U+00F2 (o grave)
                    DB 0x00, 0x38, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00   ; U+00F3 (o aigu)
                    DB 0x1E, 0x33, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00   ; U+00F4 (o circumflex)
                    DB 0x6E, 0x3B, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00   ; U+00F5 (o ~)
                    DB 0x00, 0x33, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00   ; U+00F6 (o umlaut)
                    DB 0x18, 0x18, 0x00, 0x7E, 0x00, 0x18, 0x18, 0x00   ; U+00F7 (division)
                    DB 0x00, 0x60, 0x3C, 0x76, 0x7E, 0x6E, 0x3C, 0x06   ; U+00F8 (o stroke)
                    DB 0x00, 0x07, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00   ; U+00F9 (u grave)
                    DB 0x00, 0x38, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00   ; U+00FA (u aigu)
                    DB 0x1E, 0x33, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00   ; U+00FB (u circumflex)
                    DB 0x00, 0x33, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00   ; U+00FC (u umlaut)
                    DB 0x00, 0x38, 0x00, 0x33, 0x33, 0x3E, 0x30, 0x1F   ; U+00FD (y aigu)
                    DB 0x00, 0x00, 0x06, 0x3E, 0x66, 0x3E, 0x06, 0x00   ; U+00FE (thorn)
                    DB 0x00, 0x33, 0x00, 0x33, 0x33, 0x3E, 0x30, 0x1F   ; U+00FF (y umlaut)



; Constant: font8x8_0390
; Contains an 8x8 font map for unicode points U+0390 - U+03C9 (greek characters)
font8x8_0390:       DB 0x2D, 0x00, 0x0C, 0x0C, 0x0C, 0x2C, 0x18, 0x00   ; U+0390 (iota with tonos and diaeresis)
                    DB 0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00   ; U+0391 (Alpha)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x66, 0x66, 0x3F, 0x00   ; U+0392 (Beta)
                    DB 0x3F, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00   ; U+0393 (Gamma)
                    DB 0x08, 0x1C, 0x1C, 0x36, 0x36, 0x63, 0x7F, 0x00   ; U+0394 (Delta)
                    DB 0x7F, 0x46, 0x16, 0x1E, 0x16, 0x46, 0x7F, 0x00   ; U+0395 (Epsilon)
                    DB 0x7F, 0x63, 0x31, 0x18, 0x4C, 0x66, 0x7F, 0x00   ; U+0396 (Zeta)
                    DB 0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x00   ; U+0397 (Eta)
                    DB 0x1C, 0x36, 0x63, 0x7F, 0x63, 0x36, 0x1C, 0x00   ; U+0398 (Theta)
                    DB 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0399 (Iota)
                    DB 0x67, 0x66, 0x36, 0x1E, 0x36, 0x66, 0x67, 0x00   ; U+039A (Kappa)
                    DB 0x08, 0x1C, 0x1C, 0x36, 0x36, 0x63, 0x63, 0x00   ; U+039B (Lambda)
                    DB 0x63, 0x77, 0x7F, 0x7F, 0x6B, 0x63, 0x63, 0x00   ; U+039C (Mu)
                    DB 0x63, 0x67, 0x6F, 0x7B, 0x73, 0x63, 0x63, 0x00   ; U+039D (Nu)
                    DB 0x7F, 0x63, 0x00, 0x3E, 0x00, 0x63, 0x7F, 0x00   ; U+039E (Xi)
                    DB 0x1C, 0x36, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00   ; U+039F (Omikron)
                    DB 0x7F, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00   ; U+03A0 (Pi)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x0F, 0x00   ; U+03A1 (Rho)
                    DB 0x00, 0x01, 0x02, 0x04, 0x4F, 0x90, 0xA0, 0x40   ; U+03A2
                    DB 0x7F, 0x63, 0x06, 0x0C, 0x06, 0x63, 0x7F, 0x00   ; U+03A3 (Sigma 2)
                    DB 0x3F, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+03A4 (Tau)
                    DB 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x1E, 0x00   ; U+03A5 (Upsilon)
                    DB 0x18, 0x7E, 0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x00   ; U+03A6 (Phi)
                    DB 0x63, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x63, 0x00   ; U+03A7 (Chi)
                    DB 0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x18, 0x3C, 0x00   ; U+03A8 (Psi)
                    DB 0x3E, 0x63, 0x63, 0x63, 0x36, 0x36, 0x77, 0x00   ; U+03A9 (Omega)
                    DB 0x33, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0399 (Iota with diaeresis)
                    DB 0x33, 0x00, 0x33, 0x33, 0x1E, 0x0C, 0x1E, 0x00   ; U+03A5 (Upsilon with diaeresis)
                    DB 0x70, 0x00, 0x6E, 0x3B, 0x13, 0x3B, 0x6E, 0x00   ; U+03AC (alpha aigu)
                    DB 0x38, 0x00, 0x1E, 0x03, 0x0E, 0x03, 0x1E, 0x00   ; U+03AD (epsilon aigu)
                    DB 0x38, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x30   ; U+03AE (eta aigu)
                    DB 0x38, 0x00, 0x0C, 0x0C, 0x0C, 0x2C, 0x18, 0x00   ; U+03AF (iota aigu)
                    DB 0x2D, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00   ; U+03B0 (upsilon with tonos and diaeresis)
                    DB 0x00, 0x00, 0x6E, 0x3B, 0x13, 0x3B, 0x6E, 0x00   ; U+03B1 (alpha)
                    DB 0x00, 0x1E, 0x33, 0x1F, 0x33, 0x1F, 0x03, 0x03   ; U+03B2 (beta)
                    DB 0x00, 0x00, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x00   ; U+03B3 (gamma)
                    DB 0x38, 0x0C, 0x18, 0x3E, 0x33, 0x33, 0x1E, 0x00   ; U+03B4 (delta)
                    DB 0x00, 0x00, 0x1E, 0x03, 0x0E, 0x03, 0x1E, 0x00   ; U+03B5 (epsilon)
                    DB 0x00, 0x3F, 0x06, 0x03, 0x03, 0x1E, 0x30, 0x1C   ; U+03B6 (zeta)
                    DB 0x00, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x30   ; U+03B7 (eta)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x3F, 0x33, 0x1E, 0x00   ; U+03B8 (theta)
                    DB 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x2C, 0x18, 0x00   ; U+03B9 (iota)
                    DB 0x00, 0x00, 0x33, 0x1B, 0x0F, 0x1B, 0x33, 0x00   ; U+03BA (kappa)
                    DB 0x00, 0x03, 0x06, 0x0C, 0x1C, 0x36, 0x63, 0x00   ; U+03BB (lambda)
                    DB 0x00, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x06, 0x03   ; U+03BC (mu)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00   ; U+03BD (nu)
                    DB 0x1E, 0x03, 0x0E, 0x03, 0x03, 0x1E, 0x30, 0x1C   ; U+03BE (xi)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x1E, 0x00   ; U+03BF (omikron)
                    DB 0x00, 0x00, 0x7F, 0x36, 0x36, 0x36, 0x36, 0x00   ; U+03C0 (pi)
                    DB 0x00, 0x00, 0x3C, 0x66, 0x66, 0x36, 0x06, 0x06   ; U+03C1 (rho)
                    DB 0x00, 0x00, 0x3E, 0x03, 0x03, 0x1E, 0x30, 0x1C   ; U+03C2 (sigma 1)
                    DB 0x00, 0x00, 0x7E, 0x1B, 0x1B, 0x1B, 0x0E, 0x00   ; U+03C3 (sigma 2)
                    DB 0x00, 0x00, 0x7E, 0x18, 0x18, 0x58, 0x30, 0x00   ; U+03C4 (tau)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00   ; U+03C5 (upsilon)
                    DB 0x00, 0x00, 0x76, 0xDB, 0xDB, 0x7E, 0x18, 0x00   ; U+03C6 (phi)
                    DB 0x00, 0x63, 0x36, 0x1C, 0x1C, 0x36, 0x63, 0x00   ; U+03C7 (chi)
                    DB 0x00, 0x00, 0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x00   ; U+03C8 (psi)
                    DB 0x00, 0x00, 0x36, 0x63, 0x6B, 0x7F, 0x36, 0x00   ; U+03C9 (omega)


                    
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00





; Constant: font8x8_2500
; Contains an 8x8 font map for unicode points U+2500 - U+257F (box drawing)
font8x8_2500:       DB 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00   ; U+2500 (thin horizontal)
                    DB 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00   ; U+2501 (thick horizontal)
                    DB 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08   ; U+2502 (thin vertical)
                    DB 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18   ; U+2503 (thich vertical)
                    DB 0x00, 0x00, 0x00, 0x00, 0xBB, 0x00, 0x00, 0x00   ; U+2504 (thin horizontal dashed)
                    DB 0x00, 0x00, 0x00, 0xBB, 0xBB, 0x00, 0x00, 0x00   ; U+2505 (thick horizontal dashed)
                    DB 0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08   ; U+2506 (thin vertical dashed)
                    DB 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18   ; U+2507 (thich vertical dashed)
                    DB 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00   ; U+2508 (thin horizontal dotted)
                    DB 0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00   ; U+2509 (thick horizontal dotted)
                    DB 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08   ; U+250A (thin vertical dotted)
                    DB 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18   ; U+250B (thich vertical dotted)
                    DB 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08   ; U+250C (down L, right L)
                    DB 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x08, 0x08, 0x08   ; U+250D (down L, right H)
                    DB 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18   ; U+250E (down H, right L)
                    DB 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18   ; U+250F (down H, right H)
                    DB 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08   ; U+2510 (down L, left L)
                    DB 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x08, 0x08, 0x08   ; U+2511 (down L, left H)
                    DB 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18   ; U+2512 (down H, left L)
                    DB 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18   ; U+2513 (down H, left H)
                    DB 0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00   ; U+2514 (up L, right L)
                    DB 0x08, 0x08, 0x08, 0xf8, 0xf8, 0x00, 0x00, 0x00   ; U+2515 (up L, right H)
                    DB 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00   ; U+2516 (up H, right L)
                    DB 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00   ; U+2517 (up H, right H)
                    DB 0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00   ; U+2518 (up L, left L)
                    DB 0x08, 0x08, 0x08, 0x0f, 0x0f, 0x00, 0x00, 0x00   ; U+2519 (up L, left H)
                    DB 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00   ; U+251A (up H, left L)
                    DB 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00   ; U+251B (up H, left H)
                    DB 0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08   ; U+251C (down L, right L, up L)
                    DB 0x08, 0x08, 0x08, 0xf8, 0xf8, 0x08, 0x08, 0x08   ; U+251D (down L, right H, up L)
                    DB 0x18, 0x18, 0x18, 0x18, 0xf8, 0x08, 0x08, 0x08   ; U+251E (down L, right L, up H)
                    DB 0x08, 0x08, 0x08, 0x08, 0xf8, 0x18, 0x18, 0x18   ; U+251F (down H, right L, up L)
                    DB 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18   ; U+2520 (down H, right L, up H)
                    DB 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x08, 0x08, 0x08   ; U+2521 (down L, right H, up H)
                    DB 0x08, 0x08, 0x08, 0xf8, 0xf8, 0x18, 0x18, 0x18   ; U+2522 (down H, right H, up L)
                    DB 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18   ; U+2523 (down H, right H, up H)
                    DB 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08   ; U+2524 (down L, left L, up L)
                    DB 0x08, 0x08, 0x08, 0x0f, 0x0f, 0x08, 0x08, 0x08   ; U+2525 (down L, left H, up L)
                    DB 0x18, 0x18, 0x18, 0x18, 0x1f, 0x08, 0x08, 0x08   ; U+2526 (down L, left L, up H)
                    DB 0x08, 0x08, 0x08, 0x08, 0x1f, 0x18, 0x18, 0x18   ; U+2527 (down H, left L, up L)
                    DB 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18   ; U+2528 (down H, left L, up H)
                    DB 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x08, 0x08, 0x08   ; U+2529 (down L, left H, up H)
                    DB 0x08, 0x08, 0x08, 0x1f, 0x1f, 0x18, 0x18, 0x18   ; U+252A (down H, left H, up L)
                    DB 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18   ; U+252B (down H, left H, up H)
                    DB 0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08   ; U+252C (down L, right L, left L)
                    DB 0x00, 0x00, 0x00, 0x0f, 0xff, 0x08, 0x08, 0x08   ; U+252D (down L, right L, left H)
                    DB 0x00, 0x00, 0x00, 0xf8, 0xff, 0x08, 0x08, 0x08   ; U+252E (down L, right H, left L)
                    DB 0x00, 0x00, 0x00, 0xff, 0xff, 0x08, 0x08, 0x08   ; U+252F (down L, right H, left H)
                    DB 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18   ; U+2530 (down H, right L, left L)
                    DB 0x00, 0x00, 0x00, 0x1f, 0xff, 0x18, 0x18, 0x18   ; U+2531 (down H, right L, left H)
                    DB 0x00, 0x00, 0x00, 0xf8, 0xff, 0x18, 0x18, 0x18   ; U+2532 (down H, right H, left L)
                    DB 0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18   ; U+2533 (down H, right H, left H)
                    DB 0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00   ; U+2534 (up L, right L, left L)
                    DB 0x08, 0x08, 0x08, 0x0f, 0xff, 0x00, 0x00, 0x00   ; U+2535 (up L, right L, left H)
                    DB 0x08, 0x08, 0x08, 0xf8, 0xff, 0x00, 0x00, 0x00   ; U+2536 (up L, right H, left L)
                    DB 0x08, 0x08, 0x08, 0xff, 0xff, 0x00, 0x00, 0x00   ; U+2537 (up L, right H, left H)
                    DB 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00   ; U+2538 (up H, right L, left L)
                    DB 0x18, 0x18, 0x18, 0x1f, 0xff, 0x00, 0x00, 0x00   ; U+2539 (up H, right L, left H)
                    DB 0x18, 0x18, 0x18, 0xf8, 0xff, 0x00, 0x00, 0x00   ; U+253A (up H, right H, left L)
                    DB 0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00   ; U+253B (up H, right H, left H)
                    DB 0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08   ; U+253C (up L, right L, left L, down L)
                    DB 0x08, 0x08, 0x08, 0x0f, 0xff, 0x08, 0x08, 0x08   ; U+253D (up L, right L, left H, down L)
                    DB 0x08, 0x08, 0x08, 0xf8, 0xff, 0x08, 0x08, 0x08   ; U+253E (up L, right H, left L, down L)
                    DB 0x08, 0x08, 0x08, 0xff, 0xff, 0x08, 0x08, 0x08   ; U+253F (up L, right H, left H, down L)
                    DB 0x18, 0x18, 0x18, 0x18, 0xff, 0x08, 0x08, 0x08   ; U+2540 (up H, right L, left L, down L)
                    DB 0x08, 0x08, 0x08, 0x08, 0xff, 0x18, 0x18, 0x18   ; U+2541 (up L, right L, left L, down H)
                    DB 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18   ; U+2542 (up H, right L, left L, down H)
                    DB 0x18, 0x18, 0x18, 0x1f, 0xff, 0x08, 0x08, 0x08   ; U+2543 (up H, right L, left H, down L)
                    DB 0x18, 0x18, 0x18, 0xf8, 0xff, 0x08, 0x08, 0x08   ; U+2544 (up H, right H, left L, down L)
                    DB 0x08, 0x08, 0x08, 0x1f, 0xff, 0x18, 0x18, 0x18   ; U+2545 (up L, right L, left H, down H)
                    DB 0x08, 0x08, 0x08, 0xf8, 0xff, 0x18, 0x18, 0x18   ; U+2546 (up L, right H, left L, down H)
                    DB 0x08, 0x08, 0x08, 0xff, 0xff, 0x18, 0x18, 0x18   ; U+2547 (up L, right H, left H, down H)
                    DB 0x18, 0x18, 0x18, 0xff, 0xff, 0x08, 0x08, 0x08   ; U+254B (up H, right H, left H, down L)
                    DB 0x18, 0x18, 0x18, 0xf8, 0xff, 0x18, 0x18, 0x18   ; U+254A (up H, right H, left L, down H)
                    DB 0x18, 0x18, 0x18, 0x1f, 0xff, 0x18, 0x18, 0x18   ; U+2549 (up H, right L, left H, down H)
                    DB 0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18   ; U+254B (up H, right H, left H, down H)
                    DB 0x00, 0x00, 0x00, 0x00, 0xE7, 0x00, 0x00, 0x00   ; U+254C (thin horizontal broken)
                    DB 0x00, 0x00, 0x00, 0xE7, 0xE7, 0x00, 0x00, 0x00   ; U+254D (thick horizontal broken)
                    DB 0x08, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x08   ; U+254E (thin vertical broken)
                    DB 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18   ; U+254F (thich vertical broken)
                    DB 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00   ; U+2550 (double horizontal)
                    DB 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14   ; U+2551 (double vertical)
                    DB 0x00, 0x00, 0x00, 0xF8, 0x08, 0xF8, 0x08, 0x08   ; U+2552 (down L, right D)
                    DB 0x00, 0x00, 0x00, 0x00, 0xFC, 0x14, 0x14, 0x14   ; U+2553 (down D, right L)
                    DB 0x00, 0x00, 0x00, 0xFC, 0x04, 0xF4, 0x14, 0x14   ; U+2554 (down D, right D)
                    DB 0x00, 0x00, 0x00, 0x0F, 0x08, 0x0F, 0x08, 0x08   ; U+2555 (down L, left D)
                    DB 0x00, 0x00, 0x00, 0x00, 0x1F, 0x14, 0x14, 0x14   ; U+2556 (down D, left L)
                    DB 0x00, 0x00, 0x00, 0x1F, 0x10, 0x17, 0x14, 0x14   ; U+2557 (down D, left D)
                    DB 0x08, 0x08, 0x08, 0xF8, 0x08, 0xF8, 0x00, 0x00   ; U+2558 (up L, right D)
                    DB 0x14, 0x14, 0x14, 0x14, 0xFC, 0x00, 0x00, 0x00   ; U+2559 (up D, right L)
                    DB 0x14, 0x14, 0x14, 0xF4, 0x04, 0xFC, 0x00, 0x00   ; U+255A (up D, right D)
                    DB 0x08, 0x08, 0x08, 0x0F, 0x08, 0x0F, 0x00, 0x00   ; U+255B (up L, left D)
                    DB 0x14, 0x14, 0x14, 0x14, 0x1F, 0x00, 0x00, 0x00   ; U+255C (up D, left L)
                    DB 0x14, 0x14, 0x14, 0x17, 0x10, 0x1F, 0x00, 0x00   ; U+255D (up D, left D)
                    DB 0x08, 0x08, 0x08, 0xF8, 0x08, 0xF8, 0x08, 0x08   ; U+255E (up L, down L, right D)
                    DB 0x14, 0x14, 0x14, 0x14, 0xF4, 0x14, 0x14, 0x14   ; U+255F (up D, down D, right L)
                    DB 0x14, 0x14, 0x14, 0xF4, 0x04, 0xF4, 0x14, 0x14   ; U+2560 (up D, down D, right D)
                    DB 0x08, 0x08, 0x08, 0x0F, 0x08, 0x0F, 0x08, 0x08   ; U+2561 (up L, down L, left D)
                    DB 0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x14, 0x14   ; U+2562 (up D, down D, left L)
                    DB 0x14, 0x14, 0x14, 0x17, 0x10, 0x17, 0x14, 0x14   ; U+2563 (up D, down D, left D)
                    DB 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x08, 0x08   ; U+2564 (left D, right D, down L)
                    DB 0x00, 0x00, 0x00, 0x00, 0xFF, 0x14, 0x14, 0x14   ; U+2565 (left L, right L, down D)
                    DB 0x00, 0x00, 0x00, 0xFF, 0x00, 0xF7, 0x14, 0x14   ; U+2566 (left D, right D, down D)
                    DB 0x08, 0x08, 0x08, 0xFF, 0x00, 0xFF, 0x00, 0x00   ; U+2567 (left D, right D, up L)
                    DB 0x14, 0x14, 0x14, 0x14, 0xFF, 0x00, 0x00, 0x00   ; U+2568 (left L, right L, up D)
                    DB 0x14, 0x14, 0x14, 0xF7, 0x00, 0xFF, 0x00, 0x00   ; U+2569 (left D, right D, up D)
                    DB 0x08, 0x08, 0x08, 0xFF, 0x08, 0xFF, 0x08, 0x08   ; U+256A (left D, right D, down L, up L)
                    DB 0x14, 0x14, 0x14, 0x14, 0xFF, 0x14, 0x14, 0x14   ; U+256B (left L, right L, down D, up D)
                    DB 0x14, 0x14, 0x14, 0xF7, 0x00, 0xF7, 0x14, 0x14   ; U+256C (left D, right D, down D, up D)
                    DB 0x00, 0x00, 0x00, 0x00, 0xE0, 0x10, 0x08, 0x08   ; U+256D (curve down-right)
                    DB 0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x08   ; U+256E (curve down-left)
                    DB 0x08, 0x08, 0x08, 0x04, 0x03, 0x00, 0x00, 0x00   ; U+256F (curve up-left)
                    DB 0x08, 0x08, 0x08, 0x10, 0xE0, 0x00, 0x00, 0x00   ; U+2570 (curve up-right)
                    DB 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01   ; U+2571 (diagonal bottom-left to top-right)
                    DB 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80   ; U+2572 (diagonal bottom-right to top-left)
                    DB 0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81   ; U+2573 (diagonal cross)
                    DB 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00   ; U+2574 (left L)
                    DB 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00   ; U+2575 (up L)
                    DB 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00   ; U+2576 (right L)
                    DB 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08   ; U+2577 (down L)
                    DB 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x00   ; U+2578 (left H)
                    DB 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00   ; U+2579 (up H)
                    DB 0x00, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0x00   ; U+257A (right H)
                    DB 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18   ; U+257B (down H)
                    DB 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00   ; U+257C (right H, left L)
                    DB 0x08, 0x08, 0x08, 0x08, 0x18, 0x18, 0x18, 0x18   ; U+257D (up L, down H)
                    DB 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00   ; U+257E (right L, left H)
                    DB 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x08, 0x08   ; U+257F (up H, down L)


; Constant: font8x8_2580
; Contains an 8x8 font map for unicode points U+2580 - U+259F (block elements)
font8x8_2580:       DB 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00   ; U+2580 (top half)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF   ; U+2581 (box 1/8)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF   ; U+2582 (box 2/8)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF   ; U+2583 (box 3/8)
                    DB 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF   ; U+2584 (bottom half)
                    DB 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   ; U+2585 (box 5/8)
                    DB 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   ; U+2586 (box 6/8)
                    DB 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   ; U+2587 (box 7/8)
                    DB 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   ; U+2588 (solid)
                    DB 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F   ; U+2589 (box 7/8)
                    DB 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F   ; U+258A (box 6/8)
                    DB 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F   ; U+258B (box 5/8)
                    DB 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F   ; U+258C (left half)
                    DB 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07   ; U+258D (box 3/8)
                    DB 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03   ; U+258E (box 2/8)
                    DB 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01   ; U+258F (box 1/8)
                    DB 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0   ; U+2590 (right half)
                    DB 0x55, 0x00, 0xAA, 0x00, 0x55, 0x00, 0xAA, 0x00   ; U+2591 (25% solid)
                    DB 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA   ; U+2592 (50% solid)
                    DB 0xFF, 0xAA, 0xFF, 0x55, 0xFF, 0xAA, 0xFF, 0x55   ; U+2593 (75% solid)
                    DB 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+2594 (box 1/8)
                    DB 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80   ; U+2595 (box 1/8)
                    DB 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F   ; U+2596 (box bottom left)
                    DB 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0   ; U+2597 (box bottom right)
                    DB 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00   ; U+2598 (box top left)
                    DB 0x0F, 0x0F, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF   ; U+2599 (boxes left and bottom)
                    DB 0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0, 0xF0   ; U+259A (boxes top-left and bottom right)
                    DB 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F   ; U+259B (boxes top and left)
                    DB 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xF0   ; U+259C (boxes top and right)
                    DB 0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00   ; U+259D (box top right)
                    DB 0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F   ; U+259E (boxes top right and bottom left)
                    DB 0xF0, 0xF0, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF   ; U+259F (boxes right and bottom)

; Contains an 8x8 font map for unicode points U+3040 - U+309F (Hiragana)
; Constant: font8x8_3040
font8x8_3040:
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+3040
                    DB 0x04, 0x3F, 0x04, 0x3C, 0x56, 0x4D, 0x26, 0x00   ; U+3041 (Hiragana a)
                    DB 0x04, 0x3F, 0x04, 0x3C, 0x56, 0x4D, 0x26, 0x00   ; U+3042 (Hiragana A)
                    DB 0x00, 0x00, 0x00, 0x11, 0x21, 0x25, 0x02, 0x00   ; U+3043 (Hiragana i)
                    DB 0x00, 0x01, 0x11, 0x21, 0x21, 0x25, 0x02, 0x00   ; U+3044 (Hiragana I)
                    DB 0x00, 0x1C, 0x00, 0x1C, 0x22, 0x20, 0x18, 0x00   ; U+3045 (Hiragana u)
                    DB 0x3C, 0x00, 0x3C, 0x42, 0x40, 0x20, 0x18, 0x00   ; U+3046 (Hiragana U)
                    DB 0x1C, 0x00, 0x3E, 0x10, 0x38, 0x24, 0x62, 0x00   ; U+3047 (Hiragana e)
                    DB 0x1C, 0x00, 0x3E, 0x10, 0x38, 0x24, 0x62, 0x00   ; U+3048 (Hiragana E)
                    DB 0x24, 0x4F, 0x04, 0x3C, 0x46, 0x45, 0x22, 0x00   ; U+3049 (Hiragana o)
                    DB 0x24, 0x4F, 0x04, 0x3C, 0x46, 0x45, 0x22, 0x00   ; U+304A (Hiragana O)
                    DB 0x04, 0x24, 0x4F, 0x54, 0x52, 0x12, 0x09, 0x00   ; U+304B (Hiragana KA)
                    DB 0x44, 0x24, 0x0F, 0x54, 0x52, 0x52, 0x09, 0x00   ; U+304C (Hiragana GA)
                    DB 0x08, 0x1F, 0x08, 0x3F, 0x1C, 0x02, 0x3C, 0x00   ; U+304D (Hiragana KI)
                    DB 0x44, 0x2F, 0x04, 0x1F, 0x0E, 0x01, 0x1E, 0x00   ; U+304E (Hiragana GI)
                    DB 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x00   ; U+304F (Hiragana KU)
                    DB 0x28, 0x44, 0x12, 0x21, 0x02, 0x04, 0x08, 0x00   ; U+3050 (Hiragana GU)
                    DB 0x00, 0x22, 0x79, 0x21, 0x21, 0x22, 0x10, 0x00   ; U+3051 (Hiragana KE)
                    DB 0x40, 0x22, 0x11, 0x3D, 0x11, 0x12, 0x08, 0x00   ; U+3052 (Hiragana GE)
                    DB 0x00, 0x00, 0x3C, 0x00, 0x02, 0x02, 0x3C, 0x00   ; U+3053 (Hiragana KO)
                    DB 0x20, 0x40, 0x16, 0x20, 0x01, 0x01, 0x0E, 0x00   ; U+3054 (Hiragana GO)
                    DB 0x10, 0x7E, 0x10, 0x3C, 0x02, 0x02, 0x1C, 0x00   ; U+3055 (Hiragana SA)
                    DB 0x24, 0x4F, 0x14, 0x2E, 0x01, 0x01, 0x0E, 0x00   ; U+3056 (Hiragana ZA)
                    DB 0x00, 0x02, 0x02, 0x02, 0x42, 0x22, 0x1C, 0x00   ; U+3057 (Hiragana SI)
                    DB 0x20, 0x42, 0x12, 0x22, 0x02, 0x22, 0x1C, 0x00   ; U+3058 (Hiragana ZI)
                    DB 0x10, 0x7E, 0x18, 0x14, 0x18, 0x10, 0x0C, 0x00   ; U+3059 (Hiragana SU)
                    DB 0x44, 0x2F, 0x06, 0x05, 0x06, 0x04, 0x03, 0x00   ; U+305A (Hiragana ZU)
                    DB 0x22, 0x7F, 0x22, 0x22, 0x1A, 0x02, 0x1C, 0x00   ; U+305B (Hiragana SE)
                    DB 0x80, 0x50, 0x3A, 0x17, 0x1A, 0x02, 0x1C, 0x00   ; U+305C (Hiragana ZE)
                    DB 0x1E, 0x08, 0x04, 0x7F, 0x08, 0x04, 0x38, 0x00   ; U+305D (Hiragana SO)
                    DB 0x4F, 0x24, 0x02, 0x7F, 0x08, 0x04, 0x38, 0x00   ; U+305E (Hiragana ZO)
                    DB 0x02, 0x0F, 0x02, 0x72, 0x02, 0x09, 0x71, 0x00   ; U+305F (Hiragana TA)
		    DB 0x42, 0x2F, 0x02, 0x72, 0x02, 0x09, 0x71, 0x00   ; U+3060 (Hiragana DA)
                    DB 0x08, 0x7E, 0x08, 0x3C, 0x40, 0x40, 0x38, 0x00   ; U+3061 (Hiragana TI)
                    DB 0x44, 0x2F, 0x04, 0x1E, 0x20, 0x20, 0x1C, 0x00   ; U+3062 (Hiragana DI)
                    DB 0x00, 0x00, 0x00, 0x1C, 0x22, 0x20, 0x1C, 0x00   ; U+3063 (Hiragana tu)
                    DB 0x00, 0x1C, 0x22, 0x41, 0x40, 0x20, 0x1C, 0x00   ; U+3064 (Hiragana TU)
                    DB 0x40, 0x20, 0x1E, 0x21, 0x20, 0x20, 0x1C, 0x00   ; U+3065 (Hiragana DU)
                    DB 0x00, 0x3E, 0x08, 0x04, 0x04, 0x04, 0x38, 0x00   ; U+3066 (Hiragana TE)
                    DB 0x00, 0x3E, 0x48, 0x24, 0x04, 0x04, 0x38, 0x00   ; U+3067 (Hiragana DE)
                    DB 0x04, 0x04, 0x08, 0x3C, 0x02, 0x02, 0x3C, 0x00   ; U+3068 (Hiragana TO)
                    DB 0x44, 0x24, 0x08, 0x3C, 0x02, 0x02, 0x3C, 0x00   ; U+3069 (Hiragana DO)
                    DB 0x32, 0x02, 0x27, 0x22, 0x72, 0x29, 0x11, 0x00   ; U+306A (Hiragana NA)
                    DB 0x00, 0x02, 0x7A, 0x02, 0x0A, 0x72, 0x02, 0x00   ; U+306B (Hiragana NI)
                    DB 0x08, 0x09, 0x3E, 0x4B, 0x65, 0x55, 0x22, 0x00   ; U+306C (Hiragana NU)
                    DB 0x04, 0x07, 0x34, 0x4C, 0x66, 0x54, 0x24, 0x00   ; U+306D (Hiragana NE)
                    DB 0x00, 0x00, 0x3C, 0x4A, 0x49, 0x45, 0x22, 0x00   ; U+306E (Hiragana NO)
                    DB 0x00, 0x22, 0x7A, 0x22, 0x72, 0x2A, 0x12, 0x00   ; U+306F (Hiragana HA)
                    DB 0x80, 0x51, 0x1D, 0x11, 0x39, 0x15, 0x09, 0x00   ; U+3070 (Hiragana BA)
                    DB 0x40, 0xB1, 0x5D, 0x11, 0x39, 0x15, 0x09, 0x00   ; U+3071 (Hiragana PA)
                    DB 0x00, 0x00, 0x13, 0x32, 0x51, 0x11, 0x0E, 0x00   ; U+3072 (Hiragana HI)
                    DB 0x40, 0x20, 0x03, 0x32, 0x51, 0x11, 0x0E, 0x00   ; U+3073 (Hiragana BI)
                    DB 0x40, 0xA0, 0x43, 0x32, 0x51, 0x11, 0x0E, 0x00   ; U+3074 (Hiragana PI)
                    DB 0x1C, 0x00, 0x08, 0x2A, 0x49, 0x10, 0x0C, 0x00   ; U+3075 (Hiragana HU)
                    DB 0x4C, 0x20, 0x08, 0x2A, 0x49, 0x10, 0x0C, 0x00   ; U+3076 (Hiragana BU)
                    DB 0x4C, 0xA0, 0x48, 0x0A, 0x29, 0x48, 0x0C, 0x00   ; U+3077 (Hiragana PU)
                    DB 0x00, 0x00, 0x04, 0x0A, 0x11, 0x20, 0x40, 0x00   ; U+3078 (Hiragana HE)
                    DB 0x20, 0x40, 0x14, 0x2A, 0x11, 0x20, 0x40, 0x00   ; U+3079 (Hiragana BE)
                    DB 0x20, 0x50, 0x24, 0x0A, 0x11, 0x20, 0x40, 0x00   ; U+307A (Hiragana PE)
                    DB 0x7D, 0x11, 0x7D, 0x11, 0x39, 0x55, 0x09, 0x00   ; U+307B (Hiragana HO)
                    DB 0x9D, 0x51, 0x1D, 0x11, 0x39, 0x55, 0x09, 0x00   ; U+307C (Hiragana BO)
                    DB 0x5D, 0xB1, 0x5D, 0x11, 0x39, 0x55, 0x09, 0x00   ; U+307D (Hiragana PO)
                    DB 0x7E, 0x08, 0x3E, 0x08, 0x1C, 0x2A, 0x04, 0x00   ; U+307E (Hiragana MA)
                    DB 0x00, 0x07, 0x24, 0x24, 0x7E, 0x25, 0x12, 0x00   ; U+307F (Hiragana MI)
                    DB 0x04, 0x0F, 0x64, 0x06, 0x05, 0x26, 0x3C, 0x00   ; U+3080 (Hiragana MU)
                    DB 0x00, 0x09, 0x3D, 0x4A, 0x4B, 0x45, 0x2A, 0x00   ; U+3081 (Hiragana ME)
                    DB 0x02, 0x0F, 0x02, 0x0F, 0x62, 0x42, 0x3C, 0x00   ; U+3082 (Hiragana MO)
                    DB 0x00, 0x00, 0x12, 0x1F, 0x22, 0x12, 0x04, 0x00   ; U+3083 (Hiragana ya)
                    DB 0x00, 0x12, 0x3F, 0x42, 0x42, 0x34, 0x04, 0x00   ; U+3084 (Hiragana YA)
                    DB 0x00, 0x00, 0x11, 0x3D, 0x53, 0x39, 0x11, 0x00   ; U+3085 (Hiragana yu)
                    DB 0x00, 0x11, 0x3D, 0x53, 0x51, 0x39, 0x11, 0x00   ; U+3086 (Hiragana YU)
                    DB 0x00, 0x08, 0x38, 0x08, 0x1C, 0x2A, 0x04, 0x00   ; U+3087 (Hiragana yo)
                    DB 0x08, 0x08, 0x38, 0x08, 0x1C, 0x2A, 0x04, 0x00   ; U+3088 (Hiragana YO)
                    DB 0x1E, 0x00, 0x02, 0x3A, 0x46, 0x42, 0x30, 0x00   ; U+3089 (Hiragana RA)
                    DB 0x00, 0x20, 0x22, 0x22, 0x2A, 0x24, 0x10, 0x00   ; U+308A (Hiragana RI)
                    DB 0x1F, 0x08, 0x3C, 0x42, 0x49, 0x54, 0x38, 0x00   ; U+308B (Hiragana RU)
                    DB 0x04, 0x07, 0x04, 0x0C, 0x16, 0x55, 0x24, 0x00   ; U+308C (Hiragana RE)
                    DB 0x3F, 0x10, 0x08, 0x3C, 0x42, 0x41, 0x30, 0x00   ; U+308D (Hiragana RO)
                    DB 0x00, 0x00, 0x08, 0x0E, 0x38, 0x4C, 0x2A, 0x00   ; U+308E (Hiragana wa)
                    DB 0x04, 0x07, 0x04, 0x3C, 0x46, 0x45, 0x24, 0x00   ; U+308F (Hiragana WA)
                    DB 0x0E, 0x08, 0x3C, 0x4A, 0x69, 0x55, 0x32, 0x00   ; U+3090 (Hiragana WI)
                    DB 0x06, 0x3C, 0x42, 0x39, 0x04, 0x36, 0x49, 0x00   ; U+3091 (Hiragana WE)
                    DB 0x04, 0x0F, 0x04, 0x6E, 0x11, 0x08, 0x70, 0x00   ; U+3092 (Hiragana WO)
                    DB 0x08, 0x08, 0x04, 0x0C, 0x56, 0x52, 0x21, 0x00   ; U+3093 (Hiragana N)
                    DB 0x40, 0x2E, 0x00, 0x3C, 0x42, 0x40, 0x38, 0x00   ; U+3094 (Hiragana VU)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+3095
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+3096
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+3097
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+3098
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+3099 (voiced combinator mark)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+309A (semivoiced combinator mark)
                    DB 0x40, 0x80, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00   ; U+309B (Hiragana voiced mark)
                    DB 0x40, 0xA0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+309C (Hiragana semivoiced mark)
                    DB 0x00, 0x00, 0x08, 0x08, 0x10, 0x30, 0x0C, 0x00   ; U+309D (Hiragana iteration mark)
                    DB 0x20, 0x40, 0x14, 0x24, 0x08, 0x18, 0x06, 0x00   ; U+309E (Hiragana voiced iteration mark)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+309F

                    
font8x8_4E00:       DB 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00   ; U+4E00 (CJK M One)
                    DB 0x7F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C, 0x00   ; U+4E01 (CJK MN Leaf)
                    DB 0x7F, 0x02, 0x1E, 0x10, 0x10, 0x10, 0x18, 0x00   ; U+4E02 (CJK MVS Obstruction of breath)
                    DB 0x04, 0x04, 0x7F, 0x04, 0x04, 0x24, 0x3C, 0x00   ; U+4E03 (CJK JU Seven)
                    DB 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7F, 0x00   ; U+4E04 (CJK LM Above)
                    DB 0x7F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00   ; U+4E05 (CJK ML Below)
                    DB 0x7F, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00   ; U+4E06 (CJK MH)
                    DB 0x7F, 0x02, 0x3E, 0x22, 0x22, 0x22, 0x11, 0x00   ; U+4E07 (CJK MS Ten thousand)
                    DB 0x08, 0x7F, 0x08, 0x0A, 0x0C, 0x0C, 0x33, 0x00   ; U+4E08 (CJK JK Height)
                    DB 0x7E, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x7F, 0x00   ; U+4E09 (CJK MMM Three)
                    DB 0x08, 0x08, 0x08, 0x38, 0x08, 0x08, 0x7F, 0x00   ; U+4E0A (CJK YM Above)
                    DB 0x7F, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x00   ; U+4E0B (CJK MY Below)
                    DB 0x7F, 0x14, 0x14, 0x14, 0x14, 0x12, 0x11, 0x00   ; U+4E0C (CJK ML Table)
                    DB 0x7F, 0x08, 0x1C, 0x2A, 0x08, 0x08, 0x08, 0x00   ; U+4E0D (CJK MF Not)
                    DB 0x04, 0x3C, 0x04, 0x1C, 0x10, 0x7F, 0x10, 0x00   ; U+4E0E (CJK YSM Bestow)
                    DB 0x7F, 0x08, 0x3A, 0x2A, 0x3E, 0x20, 0x30, 0x00   ; U+4E0F (CJK MLVS Invisible)                    

font8x8_4E20:       DB 0x14, 0x14, 0x77, 0x14, 0x77, 0x00, 0x3E, 0x00   ; U+4E20 (CJK LPM Hill)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x7F, 0x14, 0x77, 0x55, 0x77, 0x14, 0x12, 0x00   ; U+4E23 (CJK MLLS Zodiac cock)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x7F, 0x14, 0x55, 0x14, 0x7F, 0x01, 0x01, 0x00   ; U+4E25 (CJK MTCH Strict)
                    DB 0x22, 0x7F, 0x14, 0x55, 0x55, 0x14, 0x7F, 0x00   ; U+4E26 (CJK TTC Average)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00   ; U+4E28 (CJK XL Rod)
                    DB 0x20, 0x24, 0x24, 0x34, 0x2C, 0x24, 0x20, 0x00   ; U+4E29 (CJK VL Connect a vine)
                    DB 0x08, 0x14, 0x22, 0x49, 0x08, 0x08, 0x08, 0x00   ; U+4E2A (CJK OL Individual)
                    DB 0x41, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00   ; U+4E2B (CJK CL Bifurcation)
                    DB 0x10, 0x12, 0x14, 0x10, 0x18, 0x14, 0x12, 0x00   ; U+4E2C (CJK LIM Half a trunk)
                    DB 0x08, 0x7F, 0x49, 0x49, 0x7F, 0x08, 0x08, 0x00   ; U+4E2D (CJK L Middle)
                    DB 0x1F, 0x12, 0x17, 0x12, 0x17, 0x52, 0x62, 0x00   ; U+4E2E (CJK NQ Catch)
                    DB 0x68, 0x1C, 0x6B, 0x1C, 0x6B, 0x1C, 0x0B, 0x00   ; U+4E2F (CJK QJ Dense)
                    
font8x8_4E50:       DB 0x3F, 0x01, 0x09, 0x7F, 0x08, 0x2A, 0x49, 0x00   ; U+4E50 (CJK HVD Happy)
                    DB 0x7F, 0x08, 0x7A, 0x19, 0x28, 0x2A, 0x49, 0x00   ; U+4E51 (CJK OHHO Side by side)
                    DB 0x3E, 0x02, 0x3E, 0x22, 0x7F, 0x00, 0x06, 0x00   ; U+4E52 (CJK OMH Ping)
                    DB 0x3E, 0x02, 0x3E, 0x22, 0x7F, 0x00, 0x30, 0x00   ; U+4E53 (CJK OMI Pong)
                    DB 0x1C, 0x08, 0x3E, 0x22, 0x41, 0x14, 0x14, 0x00   ; U+4E54 (CJK HKLL Tall)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x3E, 0x20, 0x10, 0x08, 0x04, 0x42, 0x7F, 0x00   ; U+4E59 (CJK NU Second)
                    DB 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x7F, 0x00   ; U+4E5A (CJK LU Hidden)
                    DB 0x00, 0x3E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+4E5B (CJK MH KangXi Radical)
                    DB 0x04, 0x3F, 0x24, 0x34, 0x04, 0x44, 0x7C, 0x00   ; U+4E5C (CJK PN Squint)
                    DB 0x04, 0x04, 0x1F, 0x14, 0x12, 0x52, 0x71, 0x00   ; U+4E5D (CJK KN Nine)
                    DB 0x04, 0x7E, 0x01, 0x3C, 0x10, 0x08, 0x7C, 0x00   ; U+4E5E (CJK ON Beg)
                    DB 0x0A, 0x0A, 0x3F, 0x2A, 0x2A, 0x02, 0x7E, 0x00   ; U+4E5F (CJK PD)
                    

font8x8_4E80:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C, 0x00   ; U+4E85 (CJK LI Feathered stick)
                    DB 0x7F, 0x40, 0x20, 0x10, 0x10, 0x10, 0x18, 0x00   ; U+4E86 (CJK NN Finish)
                    DB 0x04, 0x7E, 0x49, 0x08, 0x08, 0x08, 0x08, 0x00   ; U+4E87 (CJK NN Kwukyel hammer)
                    DB 0x3E, 0x30, 0x14, 0x7F, 0x08, 0x08, 0x08, 0x00   ; U+4E88 (CJK NINN Me) 
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x00, 0x7F, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00   ; U+4E8C (CJK MM Two)
                    DB 0x3E, 0x00, 0x7F, 0x08, 0x08, 0x08, 0x08, 0x00   ; U+4E8D (CJK MMN To take small steps)
                    DB 0x3E, 0x08, 0x08, 0x7F, 0x08, 0x08, 0x08, 0x00   ; U+4E8E (CJK MD At)
                    DB 0x3E, 0x00, 0x7F, 0x04, 0x3C, 0x20, 0x30, 0x00   ; U+4E8F (CJK MMVS Fail)                    
                    DB 0x7F, 0x02, 0x7F, 0x02, 0x3E, 0x20, 0x38, 0x00   ; U+4E90 (CJK MKS At)
                    DB 0x3E, 0x00, 0x7F, 0x02, 0x22, 0x3E, 0x20, 0x00   ; U+4E91 (CJK MMI Cloud)
                    DB 0x7F, 0x02, 0x3E, 0x22, 0x3E, 0x20, 0x7F, 0x00   ; U+4E92 (CJK MVNM Mutually)
                    DB 0x3E, 0x00, 0x00, 0x7F, 0x22, 0x22, 0x21, 0x00   ; U+4E93 (CJK MML That)
                    DB 0x7F, 0x02, 0x02, 0x3F, 0x22, 0x22, 0x7F, 0x00   ; U+4E94 (CJK MDM Five)
                    DB 0x14, 0x14, 0x7F, 0x14, 0x7F, 0x14, 0x12, 0x00   ; U+4E95 (CJK TT Well)
                    DB 0x3E, 0x00, 0x7F, 0x00, 0x3E, 0x00, 0x7F, 0x00   ; U+4E96 (CJK MMMM Four)
                    DB 0x08, 0x2A, 0x3E, 0x00, 0x3E, 0x00, 0x7F, 0x00   ; U+4E97 (CJK UMM Harvest)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x3E, 0x14, 0x14, 0x55, 0x55, 0x14, 0x7F, 0x00   ; U+4E9A (CJK MTC Asia)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x7F, 0x14, 0x7F, 0x55, 0x7F, 0x14, 0x7F, 0x00   ; U+4E9C (CJK MLLM Come after)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x7F, 0x14, 0x77, 0x41, 0x77, 0x14, 0x7F, 0x00   ; U+4E9E (CJK MLLM Asia)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
            
font8x8_5160:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x0E, 0x08, 0x08, 0x14, 0x14, 0x22, 0x41, 0x00   ; U+5165 (CJK OH Enter)
                    DB 0x1D, 0x11, 0x11, 0x29, 0x45, 0x01, 0x7F, 0x00   ; U+5166 (CJK OV Destruction)
                    DB 0x08, 0x08, 0x7F, 0x49, 0x49, 0x55, 0x41, 0x00   ; U+5167 (CJK OB Inside)
                    DB 0x1C, 0x22, 0x5D, 0x08, 0x3E, 0x08, 0x3E, 0x00   ; U+5168 (CJK OMG Entire)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x1C, 0x10, 0x14, 0x14, 0x22, 0x22, 0x41, 0x00   ; U+516B (CJK HO Eight)
                    DB 0x08, 0x10, 0x22, 0x49, 0x24, 0x3E, 0x20, 0x00   ; U+516C (CJK CI Official)
                    DB 0x08, 0x08, 0x7F, 0x00, 0x14, 0x22, 0x41, 0x00   ; U+516D (CJK YC Six)
                    DB 0x14, 0x22, 0x7F, 0x02, 0x3E, 0x20, 0x30, 0x00   ; U+516E (CJK CMVS Exclamatory particle)
                    DB 0x22, 0x14, 0x00, 0x7F, 0x48, 0x68, 0x08, 0x00   ; U+516F (CJK CSL Kwukyel)
                    
font8x8_5340:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x08, 0x08, 0x7F, 0x08, 0x08, 0x08, 0x00   ; U+5341 (CJK J Ten)
                    DB 0x1F, 0x14, 0x14, 0x1F, 0x24, 0x24, 0x44, 0x00   ; U+5342 (CJK NJ Fly quickly)
                    DB 0x60, 0x1C, 0x0B, 0x08, 0x7F, 0x08, 0x08, 0x00   ; U+5343 (CJK HJ Thousand)
                    DB 0x10, 0x14, 0x14, 0x7F, 0x14, 0x14, 0x10, 0x00   ; U+5344 (CJK JJ Twenty)
                    DB 0x22, 0x2A, 0x2A, 0x7F, 0x2A, 0x2A, 0x21, 0x00   ; U+5345 (CJK TJ Thirty)
                    DB 0x02, 0x1F, 0x52, 0x61, 0x08, 0x7F, 0x08, 0x00   ; U+5346 (CJK KNJ Soldier)
                    DB 0x14, 0x13, 0x12, 0x7F, 0x12, 0x12, 0x12, 0x00   ; U+5347 (CJK HT Measuring unit)
                    DB 0x02, 0x3E, 0x09, 0x08, 0x7F, 0x08, 0x08, 0x00   ; U+5348 (CJK OJ Noon)
                    DB 0x08, 0x3E, 0x08, 0x22, 0x7F, 0x22, 0x21, 0x00   ; U+5349 (CJK JT Plants)
                    DB 0x6B, 0x08, 0x3E, 0x08, 0x7F, 0x08, 0x08, 0x00   ; U+534A (CJK FQ Half)
                    DB 0x08, 0x7F, 0x08, 0x22, 0x7F, 0x22, 0x3E, 0x00   ; U+534B (CJK JT Generation)
                    DB 0x55, 0x55, 0x55, 0x7F, 0x55, 0x55, 0x55, 0x00   ; U+534C (CJK TT Fourty)
                    DB 0x4F, 0x48, 0x48, 0x7F, 0x09, 0x09, 0x79, 0x00   ; U+534D (CJK NX Swastika)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
font8x8_53F0:       DB 0x04, 0x22, 0x7F, 0x40, 0x3E, 0x22, 0x3E, 0x00   ; U+53F0 (CJK IR Table)
                    DB 0x10, 0x10, 0x77, 0x15, 0x15, 0x57, 0x70, 0x00   ; U+53F1 (CJK RP Scold)
                    DB 0x08, 0x7F, 0x49, 0x7F, 0x18, 0x24, 0x42, 0x00   ; U+53F2 (CJK LK History)
                    DB 0x04, 0x7F, 0x04, 0x7A, 0x49, 0x48, 0x78, 0x00   ; U+53F3 (CJK KR Right)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00   
                    DB 0x7F, 0x01, 0x1D, 0x15, 0x1D, 0x01, 0x7F, 0x00   ; U+53F5 (CJK SR Can not)
                    DB 0x20, 0x2E, 0x2A, 0x7A, 0x2A, 0x2E, 0x20, 0x00   ; U+53F6 (CJK RJ Harmonize)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00   
                    DB 0x7F, 0x40, 0x4E, 0x40, 0x4E, 0x4A, 0x6E, 0x00   ; U+53F8 (CJK SMR Control)
                    DB 0x77, 0x45, 0x55, 0x27, 0x30, 0x48, 0x44, 0x00   ; U+53F9 (CJK RJ Sigh)
                    DB 0x30, 0x27, 0x25, 0x27, 0x30, 0x48, 0x44, 0x00   ; U+53FA (CJK RO Straw bag)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00   
                    DB 0x77, 0x45, 0x47, 0x50, 0x48, 0x44, 0x60, 0x00   ; U+53FC (CJK RSM Hold in mouth)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00   
                    DB 0x3E, 0x10, 0x08, 0x08, 0x1C, 0x14, 0x1C, 0x00   ; U+53FE (CJK NNR)
                    DB 0x00, 0x77, 0x25, 0x25, 0x27, 0x20, 0x70, 0x00   ; U+53FF (CJK RM)
                                        
                    
                    
font8x8_56D0:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x7F, 0x41, 0x41, 0x41, 0x41, 0x41, 0x7F, 0x00   ; U+56D7 (CJK BM Proud)
                    DB 0x7F, 0x41, 0x5D, 0x55, 0x5D, 0x45, 0x5D, 0x00   ; U+56D8 (CJK BRU Return)
                    DB 0x7F, 0x41, 0x4F, 0x49, 0x4F, 0x41, 0x7F, 0x00   ; U+56D9 (CJK WS)
                    DB 0x7F, 0x49, 0x49, 0x49, 0x55, 0x63, 0x7F, 0x00   ; U+56DA (CJK WO Prisoner)
                    DB 0x7F, 0x55, 0x55, 0x55, 0x73, 0x41, 0x7F, 0x00   ; U+56DB (CJK WC Four)
                    DB 0x7F, 0x45, 0x55, 0x5D, 0x51, 0x41, 0x7F, 0x00   ; U+56DC (CJK ?)
                    DB 0x7F, 0x41, 0x5D, 0x59, 0x7F, 0x49, 0x7F, 0x00   ; U+56DD (CJK WND Baby)
                    DB 0x7F, 0x41, 0x5D, 0x55, 0x5D, 0x41, 0x7F, 0x00   ; U+56DE (CJK WR Turn)
                    DB 0x04, 0x7F, 0x61, 0x55, 0x49, 0x57, 0x7F, 0x00   ; U+56DF (CJK HWK Skull)
                    
font8x8_5710:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x08, 0x3E, 0x08, 0x08, 0x08, 0x7F, 0x00   ; U+571F (CJK G Ground)

font8x8_5920:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x08, 0x7F, 0x08, 0x08, 0x14, 0x63, 0x00   ; U+5927 (CJK K Large)
                    DB 0x02, 0x0E, 0x08, 0x7F, 0x08, 0x14, 0x63, 0x00   ; U+5928 (CJK VK)
                    DB 0x7F, 0x08, 0x7F, 0x08, 0x08, 0x14, 0x63, 0x00   ; U+5929 (CJK MK Sky)
                    DB 0x08, 0x08, 0x7F, 0x08, 0x14, 0x22, 0x49, 0x00   ; U+592A (CJK KI Fat)
                    DB 0x08, 0x7F, 0x08, 0x7F, 0x08, 0x14, 0x63, 0x00   ; U+592B (CJK QO Husband)
                    DB 0x08, 0x3E, 0x28, 0x7F, 0x08, 0x14, 0x63, 0x00   ; U+592C (CJK DK Parted)
                    DB 0x30, 0x0F, 0x08, 0x7F, 0x08, 0x14, 0x63, 0x00   ; U+592D (CJK HK Young)
                    DB 0x08, 0x3E, 0x2A, 0x7F, 0x08, 0x14, 0x63, 0x00   ; U+592E (CJK LBK Centre)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
font8x8_5C00:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x08, 0x2A, 0x49, 0x08, 0x08, 0x0C, 0x00   ; U+5C0F (CJK NC Small)
                    
font8x8_5C70:       DB 0x14, 0x7F, 0x08, 0x2A, 0x3E, 0x08, 0x06, 0x00   ; U+5C70 (CJK TU disobedient)
                    DB 0x08, 0x08, 0x49, 0x49, 0x49, 0x49, 0x7F, 0x00   ; U+5C71 (CJK U Mountain)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x14, 0x22, 0x49, 0x08, 0x49, 0x7F, 0x00   ; U+5C73 (CJK OU)
                    DB 0x08, 0x2A, 0x3E, 0x08, 0x7F, 0x48, 0x64, 0x00   ; U+5C74 (CJK UKS Lofty)
                    DB 0x08, 0x2A, 0x3E, 0x00, 0x7E, 0x02, 0x01, 0x00   ; U+5C75 (CJK UM)
                    DB 0x08, 0x2A, 0x3E, 0x00, 0x7F, 0x48, 0x64, 0x00   ; U+5C76 (CJK USH Lofty)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
font8x8_5DD0:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x54, 0x54, 0x2A, 0x15, 0x2A, 0x54, 0x54, 0x00   ; U+5DDB (CJK VVV River)
                    DB 0x44, 0x44, 0x22, 0x11, 0x22, 0x44, 0x44, 0x00   ; U+5DDC (CJK VV River)
                    DB 0x22, 0x2A, 0x2A, 0x2A, 0x2A, 0x22, 0x21, 0x00   ; U+5DDD (CJK LLL River)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00                    
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x00, 0x3E, 0x08, 0x08, 0x08, 0x08, 0x7F, 0x00   ; U+5DE5 (CJK MLM Work)
                    DB 0x04, 0x7F, 0x04, 0x3C, 0x14, 0x12, 0x7F, 0x00   ; U+5DE6 (CJK KM Left)
                    DB 0x78, 0x10, 0x77, 0x42, 0x42, 0x57, 0x70, 0x00   ; U+5DE7 (CJK MMVS Clever)
                    DB 0x7F, 0x01, 0x3F, 0x21, 0x3F, 0x01, 0x7F, 0x00   ; U+5DE8 (CJK SS Large)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
              
font8x8_5E70:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x3E, 0x08, 0x08, 0x7F, 0x08, 0x08, 0x08, 0x00   ; U+5E72 (CJK MJ Oppose)
                    DB 0x3E, 0x08, 0x6B, 0x08, 0x7F, 0x08, 0x08, 0x00   ; U+5E73 (CJK MFJ Flat)
                    DB 0x02, 0x3F, 0x08, 0x0E, 0x0A, 0x7F, 0x08, 0x00   ; U+5E74 (CJK OQ Year)
                    DB 0x77, 0x22, 0x22, 0x7F, 0x22, 0x22, 0x22, 0x00   ; U+5E75 (CJK MJMJ Even level)
                    DB 0x36, 0x00, 0x7F, 0x22, 0x7F, 0x22, 0x21, 0x00   ; U+5E76 (CJK TT Combine)
                    DB 0x44, 0x22, 0x77, 0x22, 0x77, 0x22, 0x22, 0x00   ; U+5E77 (CJK YJYJ Combine)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x45, 0x22, 0x14, 0x08, 0x44, 0x7F, 0x00   ; U+5E7A (CJK VI One)
                    DB 0x74, 0x42, 0x54, 0x48, 0x44, 0x52, 0x5F, 0x00   ; U+5E7B (CJK VIS Illusion)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x7E, 0x02, 0x02, 0x02, 0x02, 0x01, 0x00   ; U+5E7F (CJK YH Wide)
                    
                    
                    
              
font8x8_65E0:       DB 0x3E, 0x08, 0x08, 0x7F, 0x18, 0x54, 0x73, 0x00   ; U+65E0 (CJK MKU Negative)
                    DB 0x3E, 0x04, 0x05, 0x7F, 0x14, 0x52, 0x71, 0x00   ; U+65E1 (CJK MVKU Choke)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x3E, 0x22, 0x22, 0x3E, 0x22, 0x22, 0x3E, 0x00   ; U+65E5 (CJK A Sun)
                    DB 0x3E, 0x22, 0x3E, 0x22, 0x3E, 0x00, 0x7F, 0x00   ; U+65E6 (CJK AM Dawn)
                    DB 0x79, 0x49, 0x49, 0x79, 0x49, 0x49, 0x79, 0x00   ; U+65E7 (CJK LA Old)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x3E, 0x22, 0x3E, 0x22, 0x3E, 0x08, 0x7F, 0x08   ; U+65E9 (CJK AJ Early)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x7F, 0x41, 0x5E, 0x52, 0x5E, 0x52, 0x5E, 0x00   ; U+65EC (CJK PA Period)
                    DB 0x72, 0x57, 0x76, 0x56, 0x75, 0x05, 0x79, 0x00   ; U+65ED (CJK KNA Rising sun)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
                    
                    
font8x8_6700:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x3E, 0x22, 0x3E, 0x22, 0x3E, 0x22, 0x21, 0x00   ; U+6708 (CJK B Moon)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x77, 0x55, 0x77, 0x55, 0x77, 0x55, 0x4D, 0x00   ; U+670B (CJK BB Friend)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
font8x8_6720:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x08, 0x7F, 0x1C, 0x2A, 0x49, 0x08, 0x00   ; U+6728 (CJK D Tree)
                    DB 0x08, 0x3E, 0x08, 0x1C, 0x2A, 0x49, 0x0C, 0x00   ; U+6729 (CJK DC Wait)
                    DB 0x08, 0x3E, 0x08, 0x7F, 0x14, 0x2A, 0x49, 0x00   ; U+672A (CJK JD Not yet)
                    DB 0x08, 0x7F, 0x08, 0x3E, 0x14, 0x2A, 0x49, 0x00   ; U+672B (CJK DJ End)
                    DB 0x08, 0x08, 0x7F, 0x1C, 0x2A, 0x5D, 0x08, 0x00   ; U+672C (CJK DM Origin)
                    DB 0x24, 0x24, 0x2F, 0x24, 0x2E, 0x35, 0x64, 0x00   ; U+672D (CJK DU Card)
                    DB 0x68, 0x08, 0x7F, 0x08, 0x2A, 0x2A, 0x69, 0x00   ; U+672E (CJK IJC Millet)
                    DB 0x68, 0x08, 0x7F, 0x1C, 0x2A, 0x49, 0x08, 0x00   ; U+672F (CJK ID Method)
                    
font8x8_6790:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x42, 0x37, 0x22, 0x77, 0x2A, 0x52, 0x52, 0x00   ; U+6796 (CJK DHK)
                    DB 0x22, 0x22, 0x77, 0x22, 0x77, 0x2A, 0x22, 0x00   ; U+6797 (CJK DD Forest)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x22, 0x72, 0x27, 0x72, 0x57, 0x2A, 0x52, 0x00   ; U+679D (CJK DJE Branch)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
font8x8_7510:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x14, 0x14, 0x7F, 0x14, 0x1C, 0x14, 0x1C, 0x00   ; U+7518 (CJK TM Sweetness)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x0A, 0x7F, 0x09, 0x3E, 0x08, 0x7F, 0x00   ; U+751F (CJK HQM Raw)                    
                    
font8x8_7530:       DB 0x7F, 0x49, 0x49, 0x7F, 0x49, 0x49, 0x7F, 0x00   ; U+7530 (CJK W Rice paddy)
                    DB 0x08, 0x08, 0x3E, 0x2A, 0x3E, 0x2A, 0x3E, 0x00   ; U+7531 (CJK LW Cause)
                    DB 0x3E, 0x2A, 0x3E, 0x2A, 0x3E, 0x08, 0x08, 0x00   ; U+7532 (CJK WL Shell)
                    DB 0x08, 0x3E, 0x2A, 0x3E, 0x2A, 0x3E, 0x08, 0x00   ; U+7533 (CJK LWL Report)
                    DB 0x08, 0x08, 0x3E, 0x2A, 0x3E, 0x22, 0x3E, 0x00   ; U+7534 (CJK LA Cockroach)
                    DB 0x04, 0x1F, 0x15, 0x1F, 0x15, 0x5F, 0x7C, 0x00   ; U+7535 (CJK LWU Lightning)
                    DB 0x30, 0x0C, 0x3E, 0x2A, 0x3E, 0x2A, 0x3E, 0x00   ; U+7536 (CJK HW)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x7F, 0x40, 0x5F, 0x55, 0x5F, 0x55, 0x5F, 0x00   ; U+7538 (CJK PW Suburbs)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
                    
                    
font8x8_7670:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00             
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00 
                    DB 0x04, 0x08, 0x3E, 0x22, 0x3E, 0x22, 0x3E, 0x00   ; U+767D (CJK HA White)
                    DB 0x3E, 0x08, 0x3E, 0x22, 0x3E, 0x22, 0x3E, 0x00   ; U+767E (CJK MA Hundred)
                    DB 0x12, 0x17, 0x15, 0x17, 0x15, 0x57, 0x70, 0x00   ; U+767F (CJK HAU)
                    
font8x8_7A70:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x7F, 0x41, 0x1C, 0x10, 0x14, 0x22, 0x00   ; U+7A74 (CJK JC Hole)
                    DB 0x08, 0x7F, 0x55, 0x00, 0x1E, 0x08, 0x3C, 0x00   ; U+7A75 (CJK JCN Deep hollow)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x08, 0x7F, 0x55, 0x00, 0x3E, 0x08, 0x7F, 0x00   ; U+7A7A (CJK JCM Sky)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    
font8x8_82B0:       DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x22, 0x7F, 0x22, 0x14, 0x73, 0x12, 0x72, 0x00   ; U+82B1 (CJK TOP Flower)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x22, 0x7F, 0x22, 0x08, 0x3A, 0x0A, 0x7F, 0x00   ; U+82B7 (CJK TYLM Angelica)
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                    DB 0x44, 0x2A, 0x11, 0x2A, 0x44, 0x2A, 0x11, 0x00
                                        
                    
                    
                    DB 0x00, 0x00, 0x38, 0x66, 0x06, 0x06, 0x07, 0x00   ; U+E541 (SGA A)
                    DB 0x00, 0x00, 0x0C, 0x0C, 0x18, 0x30, 0x7F, 0x00   ; U+E542 (SGA B)
                    DB 0x00, 0x00, 0x0C, 0x00, 0x0C, 0x30, 0x30, 0x00   ; U+E543 (SGA C)
                    DB 0x00, 0x00, 0x7F, 0x00, 0x03, 0x1C, 0x60, 0x00   ; U+E544 (SGA D)
                    DB 0x00, 0x00, 0x63, 0x03, 0x03, 0x03, 0x7F, 0x00   ; U+E545 (SGA E)
                    DB 0x00, 0x00, 0x00, 0xFF, 0x00, 0xDB, 0x00, 0x00   ; U+E546 (SGA F)
                    DB 0x00, 0x00, 0x30, 0x30, 0x3E, 0x30, 0x30, 0x00   ; U+E547 (SGA G)
                    DB 0x00, 0x00, 0x7E, 0x00, 0x7E, 0x18, 0x18, 0x00   ; U+E548 (SGA H)
                    DB 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00   ; U+E549 (SGA I)
                    DB 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00   ; U+E54A (SGA J)
                    DB 0x00, 0x00, 0x18, 0x18, 0x5A, 0x18, 0x18, 0x00   ; U+E54B (SGA K) 
                    DB 0x00, 0x00, 0x03, 0x33, 0x03, 0x33, 0x03, 0x00   ; U+E54C (SGA L)                    
                    DB 0x00, 0x00, 0x63, 0x60, 0x60, 0x60, 0x7F, 0x00   ; U+E54D (SGA M)
                    DB 0x00, 0x00, 0x66, 0x60, 0x30, 0x18, 0x0C, 0x00   ; U+E54E (SGA N)
                    DB 0x00, 0x00, 0x3C, 0x60, 0x30, 0x18, 0x0C, 0x00   ; U+E54F (SGA O)
                    DB 0x00, 0x00, 0x66, 0x60, 0x66, 0x06, 0x66, 0x00   ; U+E550 (SGA P)                    
                    DB 0x00, 0x00, 0x18, 0x00, 0x7E, 0x60, 0x7E, 0x00   ; U+E551 (SGA Q)
                    DB 0x00, 0x00, 0x00, 0x66, 0x00, 0x66, 0x00, 0x00   ; U+E552 (SGA R)
                    DB 0x00, 0x00, 0x0C, 0x0C, 0x3C, 0x30, 0x30, 0x00   ; U+E553 (SGA S)
                    DB 0x00, 0x00, 0x3C, 0x30, 0x30, 0x00, 0x30, 0x00   ; U+E554 (SGA T)
                    DB 0x00, 0x00, 0x00, 0x36, 0x00, 0x7F, 0x00, 0x00   ; U+E555 (SGA U)
                    DB 0x00, 0x00, 0x18, 0x18, 0x7E, 0x00, 0x7E, 0x00   ; U+E556 (SGA V)
                    DB 0x00, 0x00, 0x00, 0x18, 0x00, 0x66, 0x00, 0x00   ; U+E557 (SGA W)
                    DB 0x00, 0x00, 0x66, 0x30, 0x18, 0x0C, 0x06, 0x00   ; U+E558 (SGA X)
                    DB 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00   ; U+E559 (SGA Y)
                    DB 0x00, 0x00, 0x18, 0x3C, 0x66, 0x66, 0x66, 0x00   ; U+E55A (SGA Z)

                    
                    ; for later use
                    DB 0x1F, 0x33, 0x33, 0x5F, 0x63, 0xF3, 0x63, 0xE3   ; U+20A7 (Spanish Pesetas/Pt)
                    DB 0x70, 0xD8, 0x18, 0x3C, 0x18, 0x18, 0x1B, 0x0E   ; U+0192 (dutch florijn)
                    DB 0x3C, 0x36, 0x36, 0x7C, 0x00, 0x7E, 0x00, 0x00   ; U+ (underlined superscript a)
                    DB 0x1C, 0x36, 0x36, 0x1C, 0x00, 0x3E, 0x00, 0x00   ; U+ (underlined superscript 0)
                    DB 0x00, 0x00, 0x00, 0x3F, 0x03, 0x03, 0x00, 0x00   ; U+2310 (gun pointing right)
                    DB 0x30, 0x18, 0x0C, 0x18, 0x30, 0x00, 0x7E, 0x00   ; U+ (less than or equal)
                    DB 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x00, 0x7E, 0x00   ; U+ (greater than or equal)
                    DB 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+ (grave)
                    DB 0x0E, 0x00, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x00   ; U+ (Y grave)
                    DB 0x00, 0x07, 0x00, 0x33, 0x33, 0x3E, 0x30, 0x1F   ; U+ (y grave)
                    
                    
                    ; 16 blanks - keep them here as buffer for the graphics demo
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ;

; Variable: font8x8_table
; Lists the glyph block offsets with their lengths
;
; 8-byte units; 4-byte pointer; 2-byte unicode offset, 2-byte length
;
font8x8_table:      DD font8x8_0000
                    DW 0x0000, (font8x8_0390 - font8x8_0000) / 8
                    DD font8x8_0390
                    DW 0x0390, (font8x8_2500 - font8x8_0390) / 8
                    DD font8x8_2500
                    DW 0x2500, (font8x8_3040 - font8x8_2500) / 8
                    DD font8x8_3040
                    DW 0x3040, (font8x8_4E00 - font8x8_3040) / 8
                    DD font8x8_4E00
                    DW 0x4E00, 16
                    DD font8x8_4E20
                    DW 0x4E20, 16
                    DD font8x8_4E50 
                    DW 0x4E50, 16
                    DD font8x8_4E80 
                    DW 0x4E80, 32      
                    DD font8x8_5160 
                    DW 0x5160, 16      
                    DD font8x8_5340 
                    DW 0x5340, 16      
                    DD font8x8_53F0 
                    DW 0x53F0, 16      
                    DD font8x8_56D0 
                    DW 0x56D0, 16      
                    DD font8x8_5710 
                    DW 0x5710, 16      
                    DD font8x8_5920 
                    DW 0x5920, 16      
                    DD font8x8_5C00 
                    DW 0x5C00, 16      
                    DD font8x8_5C70 
                    DW 0x5C70, 16      
                    DD font8x8_5DD0 
                    DW 0x5DD0, 32      
                    DD font8x8_5E70 
                    DW 0x5E70, 16      
                    DD font8x8_65E0 
                    DW 0x65E0, 16      
                    DD font8x8_6700 
                    DW 0x6700, 16      
                    DD font8x8_6720 
                    DW 0x6720, 16      
                    DD font8x8_6790 
                    DW 0x6790, 16      
                    DD font8x8_7510 
                    DW 0x7510, 16      
                    DD font8x8_7530 
                    DW 0x7530, 16      
                    DD font8x8_7670 
                    DW 0x7670, 16      
                    DD font8x8_7A70 
                    DW 0x7A70, 16      
                    DD font8x8_82B0 
                    DW 0x82B0, 16      
                    
                    DD 0, 0, 0, 0
