' Summary: gma_core.bas
' Startup code for the Intel GMA chips
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/gfx.bi"
#include "mos/bga_regs.bi"
#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/pci.bi"
#include "mos.bi"
#include "x86.bi"

#include "GL/mgl.bi"
#include "GL/gl.bi"

#include "gma_state.bi"
#include "../vga_io.bi"

Declare Sub _gl_setoutput CDecl Alias "_gl_setoutput"(ByVal buffer As Byte Ptr, ByVal w As Integer, ByVal h As Integer, ByVal pitch As Integer)
Declare Sub _gl_inittextures CDecl Alias "_gl_inittextures" ()

Common Shared IGMA_framebuffer As Byte Ptr
Common Shared IGMA_mmio As Integer Ptr

Public Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + 2 * offset] = ch
        vram[lp * 2 - 1 + 2 * offset] = 7
    Next lp
End Sub

Sub modmain CDecl Alias "main" (argc As Integer, argv As Byte Ptr Ptr)

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HCF8, 8)
    'VGA RAM
    allocatepagetable(CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, -1))
    blockallocphys(32, CPtr(Byte Ptr, &HA0000), CPtr(Byte Ptr, &HA0000))

    _gl_inittextures

    glMatrixMode GL_PROJECTION
    glLoadIdentity
    glMatrixMode GL_MODELVIEW
    glLoadIdentity
    glColor3f 1, 1, 1

    ' setup code here
    Dim devid As Integer
    devid = DriverInit      ' initialize driver, get device ID

    ' Get device location
    Dim devloc As String
    Dim devmsg(0 to 1) As Integer
    devmsg(0) = 10
    devmsg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(devmsg(0))))

    ' wait for response
    Dim Location As String
    While Location = ""
        While drv_peekmessage() = 0
            Yield
        Wend

        Dim rs As String
        rs = space$(drv_peekmessage())
        Dim rv As Integer
        rv = drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))
        If rv = DRIVER_MGR * &H10000 Then
            location = rs
        End if
    Wend

    ' Todo: replace with a call to pciserv
    Dim bus as integer
    dim dev as integer
    dim dfn as integer
    bus = Valint("&H" & mid$(location,  5, 2))
    dev = Valint("&H" & mid$(location,  8, 2))
    dfn = Valint("&H" & mid$(location, 11, 2))

    Dim ioaddr As Integer
    Dim framebuffer As Byte Ptr
    Dim bar As Integer

    PrintString "PCI: " & hex$(bus) & ":" & hex$(dev) & ":" & hex$(dfn) & " " & hex$(pci_type1_readdword(bus,dev,dfn,0)), CPtr(Byte Ptr, &HB8000), 80
    PrintString location, CPtr(Byte Ptr, &HB8000), 320

    Dim i As Integer
    For i = &H10 to &H1C Step 4
        bar = pci_type1_readdword(bus, dev, dfn, i)
        PrintString "bar @ 0x" & hex$(i) & " = 0x" & hex$(bar), CPtr(Byte Ptr, &HB8000), 400 + 20 * (i - 16)
        If (Bar <> 0) And ((bar and &HFFFF0) = 0) And (framebuffer = CPtr(Byte Ptr, 0)) Then
            framebuffer = CPtr(Byte Ptr, (bar and &HFFFF0000))
        ElseIf ((bar and &H1) = 0) And ioaddr = 0 Then
            ioaddr = bar and &HFFFFFFF0
        End If
    Next i

    PrintString "fbaddr: " & hex$(framebuffer), CPtr(Byte Ptr, &HB8000), 240
    PrintString "ioaddr: " & hex$(ioaddr), CPtr(Byte Ptr, &HB8000), 280

    ' register driver in device manager
    drv_setname(0,1)
    dim msg(0 to 1) As integer
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), framebuffer)
    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), CPtr(Byte Ptr, ioaddr))
    IGMA_framebuffer = CPtr(Byte Ptr, &H60000000)
    BlockAllocPhysL(1, IGMA_framebuffer, framebuffer)
    IGMA_mmio = CPtr(Integer Ptr, &H70000000 + (ioaddr And &H3FFFFF))
    PrintString "mmio: " & hex$(IGMA_mmio), CPtr(Byte Ptr, &HB8000), 360
    BlockAllocPhysL(1, CPtr(Byte Ptr, IGMA_mmio), CPtr(Byte Ptr, ioaddr))

    _gl_setoutput(IGMA_framebuffer, 640, 480, 1024*4)

    For i = 0 to 1
        socket(i).height = 480
        socket(i).width = 640
        socket(i).os_l = 8
        socket(i).os_r = 8
        socket(i).os_t = 8
        socket(i).os_b = 8
        socket(i).blank_l = 8
        socket(i).blank_r = 8
        socket(i).blank_t = 8
        socket(i).blank_b = 8
        socket(i).input = 1
        socket(i).enabled = 0
    Next i

    ' Disable VGA mode
    IGMA_mmio[&H71400 \ 4] = IGMA_mmio[&H71400 \ 4] Or &H80000000
    ' Enable DSPA and DSPB
    IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or &H80000000
    'IGMA_mmio[&H71180 \ 4] = IGMA_mmio[&H71180 \ 4] Or &H80000000

    IGMA_mmio[&H70188 \ 4] = 1024*4
    IGMA_mmio[&H70184 \ 4] = 0
    IGMA_mmio[&H71188 \ 4] = 1024*4
    IGMA_mmio[&H71184 \ 4] = 0


    Dim driver As GFXDRIVER2
    driver.Connectors = 2 ' or at least, the hardware is present
    ' 14 = 2 pipes that can do N8, B5G6R5, B8G8R8X8, R8G8B8X8, B10G10R10X2, R10G10B10X2 and R16G16B16X16 each,
    '  2 cursors
    ' 12 formats of overlay (4x YUV 4:2:2, 4x 8:8:8:8, 2x 10:10:10:2, indexed, 1x 5:6:5)
    ' --
    ' 28 engines available :o
    driver.Engines = 28
    driver.setconnectorstate = @IGMA_ConnectorSetState
    driver.getconnectorstate = @IGMA_ConnectorGetState
    driver.getconnectorrange = @IGMA_ConnectorGetRange
    driver.setenginestate = @IGMA_EngineSetState
    driver.getenginestate = @IGMA_EngineGetState
    driver.getenginerange = @IGMA_EngineGetRange
    driver.gldispatch = @IGMA_GLDispatch

    graphicsmain2(driver, CPtr(Byte Ptr, 0))

End Sub

