' Summary: gma_socket.bas
' The connector controls for the GMA chips
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "gma_state.bi"
#include "mos/gfx.bi"
#include "swgl/glbuffer.bi"

Dim Shared socket(0 to 1) As IGMA_socket

Function IGMA_ConnectorSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
    Function = 0
    If index < 0 Or index > 1 Then exit function
    Select Case prop

        Case GFX_PROP_ENABLE
            If value <> 0 Then

                IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] And &HC3FFFFFF

                Select case socket(index).input
                    Case 0
                        IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or (2 SHL 26)
                    Case 1
                        IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or (5 SHL 26)
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b5g6r5
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b5g6r5
                    Case 2
                        IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or (6 SHL 26)
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8x8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8a8
                    Case 3
                        IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or (8 SHL 26)
                    Case 4
                        IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or (10 SHL 26)
                    Case 5
                        IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or (12 SHL 26)
                    Case 6
                        IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or (14 SHL 26)
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_r8g8b8x8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_r8g8b8a8

                End Select

                _gl_setoutput(IGMA_framebuffer, socket(index).width, socket(index).height, 640*2)

                IGMA_mmio[&H70188 \ 4] = 1024*4
                IGMA_mmio[&H70184 \ 4] = 0

                IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] Or &H80000000

                socket(index).enabled = 1
            Else
                socket(index).enabled = 0
                IGMA_mmio[&H70180 \ 4] = IGMA_mmio[&H70180 \ 4] And &H7FFFFFFF
            End If

        Case GFX_PROP_INPUT
            If value < 0 Then Exit Function
            If value > 6 Then Exit Function
            If socket(index).enabled > 0 Then Exit Function
            socket(index).input = value

        ' Todo: Check all settings for sanity

        Case GFX_PROP_WIDTH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).width = value

        Case GFX_PROP_HEIGHT
            If socket(index).enabled > 0 Then Exit Function
            socket(index).height = value

        Case GFX_PROP_VGA_H_FRONT_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_r = value - (value mod 8) - socket(index).os_r

        Case GFX_PROP_VGA_H_BACK_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_l = value - (value Mod 8) - socket(index).os_l

        Case GFX_PROP_VGA_H_SYNC
            If socket(index).enabled > 0 Then Exit Function
            socket(index).h_sync = value - (value Mod 8)

        Case GFX_PROP_VGA_V_FRONT_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_b = value - socket(index).os_b

        case GFX_PROP_VGA_V_BACK_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_t = value - socket(index).os_t

        case GFX_PROP_VGA_V_SYNC
            If socket(index).enabled > 0 Then Exit Function
            socket(index).v_sync = value

    End Select
End Function

Function IGMA_ConnectorGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
    Function = 0
    if index <> 0 Then exit function
    Select Case prop
        Case GFX_PROP_ENABLE
            Function = socket(index).enabled
        Case GFX_PROP_INPUT
            Function = socket(index).input
        Case GFX_PROP_WIDTH
            Function = socket(index).width
        Case GFX_PROP_HEIGHT
            Function = socket(index).height

        Case GFX_PROP_SIGNAL
            Function = GFX_SIGNAL_RGBHV
        Case GFX_PROP_CONNECTOR_TYPE
            Function = GFX_CONNECTOR_VGA
        Case Else
    End Select
End Function

Function IGMA_ConnectorGetRange CDecl (info As Byte Ptr, source As Integer, index As Integer, prop As Integer) As Integer
    if index = 0 Then
        Function = 1
        Select case prop
            Case GFX_PROP_ENABLE
                ConnectorReturnBooleanRange(source, index, prop, 0, 1)
            Case GFX_PROP_INPUT
                ConnectorReturnSimpleRange(source, index, prop, 0, 6, 1)
            Case GFX_PROP_WIDTH
                ConnectorReturnSimpleRange(source, index, prop, 320, 1024, 8)
            Case GFX_PROP_HEIGHT
                ConnectorReturnSimpleRange(source, index, prop, 240, 768, 8)
            Case GFX_PROP_SIGNAL
                ConnectorReturnConstantRange(source, index, prop, GFX_SIGNAL_RGBHV)
            Case GFX_PROP_CONNECTOR_TYPE
                ConnectorReturnConstantRange(source, index, prop, GFX_CONNECTOR_VGA)

            Case Else
                Function = 0
        End select
    Else
        Function = 0
    End If
End Function

