' Summary: mach64_core.bas
' Startup code for ATI Mach64-based cores
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/gfx.bi"
#include "mos/bga_regs.bi"
#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/pci.bi"
#include "mos.bi"
#include "x86.bi"

#include "GL/mgl.bi"
#include "GL/gl.bi"

#include "mach64_state.bi"

Declare Sub _gl_setoutput CDecl Alias "_gl_setoutput"(ByVal buffer As Byte Ptr, ByVal w As Integer, ByVal h As Integer, ByVal pitch As Integer)
Declare Sub _gl_inittextures CDecl Alias "_gl_inittextures" ()

Common Shared Mach64_framebuffer As Byte Ptr
Common Shared Mach64_mmio As Integer Ptr
Common Shared Mach64_portbase As Integer

Sub modmain CDecl Alias "main" (argc As Integer, argv As Byte Ptr Ptr)

    'I/O permission bitmap
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HCF8, 8)

    _gl_inittextures

    glMatrixMode GL_PROJECTION
    glLoadIdentity
    glMatrixMode GL_MODELVIEW
    glLoadIdentity
    glColor3f 1, 1, 1

    ' setup code here
    Dim devid As Integer
    devid = DriverInit      ' initialize driver, get device ID

    ' Get device location
    Dim devloc As String
    Dim devmsg(0 to 1) As Integer
    devmsg(0) = 10
    devmsg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(devmsg(0))))

    ' wait for response
    Dim Location As String
    While Location = ""
        While drv_peekmessage() = 0
            Yield
        Wend

        Dim rs As String
        rs = space$(drv_peekmessage())
        Dim rv As Integer
        rv = drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))
        If rv = DRIVER_MGR * &H10000 Then
            location = rs
        End if
    Wend

    ' Todo: replace with a call to pciserv
    Dim bus as integer
    dim dev as integer
    dim dfn as integer
    bus = Valint("&H" & mid$(location,  5, 2))
    dev = Valint("&H" & mid$(location,  8, 2))
    dfn = Valint("&H" & mid$(location, 11, 2))

    Dim portbase As Integer
    Dim mmiobase As Byte Ptr
    Dim framebuffer As Byte Ptr
    Dim bar As Integer, barmask As Integer

    Dim i As Integer
    For i = 5 to 0 step -1
        barmask = PCI_bar_readmask(bus, dev, dfn, i)
        bar = PCI_bar_readaddress(bus, dev, dfn, i)
        If (barmask and &H1) = 1 Then
            portbase = bar and &HFFF8&
        Elseif ((barmask and &HFFFF0) = 0) And (framebuffer = 0) then
            framebuffer = CPtr(Byte Ptr, bar And &HFFFFFFF0)
        Else
            mmiobase = CPtr(Byte Ptr, bar And &HFFFFFFF0)
        End If
    Next i
    
    Portalloc(portbase, 256)
    Mach64_portbase = portbase

    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), framebuffer)
    Mach64_framebuffer = CPtr(Byte Ptr, &H60000000)
    BlockAllocPhysL(1, Mach64_framebuffer, framebuffer)

    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), mmiobase)
    Mach64_mmio = CPtr(Integer Ptr, &H61000000)
    BlockAllocPhysL(1, CPtr(Byte Ptr, Mach64_mmio), mmiobase)

    ' register driver in device manager
    drv_setname(0,1)
    dim msg(0 to 1) As integer
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    _gl_setoutput(Mach64_framebuffer, 640, 480, 640*4)

    For i = 0 to 1
        socket(i).height = 480
        socket(i).width = 640
        socket(i).os_l = 8
        socket(i).os_r = 8
        socket(i).os_t = 8
        socket(i).os_b = 8
        socket(i).blank_l = 8
        socket(i).blank_r = 8
        socket(i).blank_t = 8
        socket(i).blank_b = 8
        socket(i).input = 2
        socket(i).enabled = 0
    Next i

    Dim driver As GFXDRIVER2
    driver.Connectors = 1
    driver.Engines = 3 ' 8bpp, 16bpp, 32bpp
    driver.setconnectorstate = @Mach64_ConnectorSetState
    driver.getconnectorstate = @Mach64_ConnectorGetState
    driver.getconnectorrange = @Mach64_ConnectorGetRange
    driver.setenginestate = @Mach64_EngineSetState
    driver.getenginestate = @Mach64_EngineGetState
    driver.getenginerange = @Mach64_EngineGetRange
    driver.gldispatch = @Mach64_GLDispatch

    graphicsmain2(driver, CPtr(Byte Ptr, 0))

End Sub

