' Summary: mach64_socket.bas
' The connector controls for ATI Mach64-based cores
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mach64_state.bi"
#include "x86.bi"
#include "mos/gfx.bi"
#include "mos/mach64_id.bi"
#include "swgl/glbuffer.bi"

Dim Shared socket(0 to 1) As Mach64_socket

Extern _gl_writebuffer alias "_gl_writebuffer" As Sub CDecl(ByVal x As Integer, ByVal y As Integer, ByVal w As Integer, ByVal h As Integer, ByVal fmt As Integer, ByVal type As Integer, ByVal pixels As Byte Ptr, ByVal dest As Byte Ptr)
Extern _gl_fillbuffer alias "_gl_fillbuffer" As Sub CDecl(ByVal x As Integer, ByVal y As Integer, ByVal w As Integer, ByVal h As Integer, ByVal r As Byte, ByVal g As Byte, ByVal b As Byte, ByVal a As Byte, ByVal dest As Byte Ptr)

Function Mach64_ConnectorSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
    Function = 0
    If index <> 0 Then exit function
    Select Case prop

        Case GFX_PROP_ENABLE
            Dim prevvalue as unsigned integer
            prevvalue = inportd(Mach64_portbase + mach64_regs.CRTC_GEN_CNTL)
            prevvalue = Mach64_crtc_gen_cntl.CRTC_EXT_DISP_EN Or _
                        Mach64_crtc_gen_cntl.CRTC_EN Or _
                        Mach64_crtc_gen_cntl.CRTC_VGA_LINEAR Or _
                        (prevvalue And Mach64_crtc_gen_cntl.CRTC_FIFO_LWM_MASK) Or _
                        Mach64_crtc_gen_cntl.CRTC_CNT_EN
            If value <> 0 Then

                Dim actualmode As Integer
                actualmode = socket(index).input ' or the cursor's input
                
                Dim dacctl As Integer
                dacctl = inportd(Mach64_portbase + mach64_regs.DAC_CNTL)

                Select Case actualmode
                    case 0
                        prevvalue = prevvalue or Mach64_crtc_gen_cntl.CRTC_BPP_8
                        dacctl = dacctl Or &H10
                        _gl_setoutput(Mach64_framebuffer, socket(index).width, socket(index).height, socket(index).width)
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8x8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8a8
                        outportd(Mach64_portbase + Mach64_regs.DSP_CONFIG, 512 Or (6 * &H10000) Or (6 * &H100000))
                        outportd(Mach64_portbase + Mach64_regs.DSP_ON_OFF, 30 Or (34 * &H10000))

                    case 1
                        prevvalue = prevvalue or Mach64_crtc_gen_cntl.CRTC_BPP_16
                        dacctl = dacctl and (not &H10)
                        _gl_setoutput(Mach64_framebuffer, socket(index).width, socket(index).height, socket(index).width * 2)
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b5g6r5
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b5g6r5
                        outportd(Mach64_portbase + Mach64_regs.DSP_CONFIG, &H278 Or (6 * &H10000) Or (4 * &H100000))
                        outportd(Mach64_portbase + Mach64_regs.DSP_ON_OFF, &H56 Or (&H4A * &H10000))

                    case 2
                        dacctl = dacctl and (not &H10)
                        prevvalue = prevvalue or Mach64_crtc_gen_cntl.CRTC_BPP_32
                        _gl_setoutput(Mach64_framebuffer, socket(index).width, socket(index).height, socket(index).width * 4)
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8x8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8a8
                        outportd(Mach64_portbase + Mach64_regs.DSP_CONFIG, &H278 Or (6 * &H10000) Or (4 * &H100000))
                        outportd(Mach64_portbase + Mach64_regs.DSP_ON_OFF, &H56 Or (&H4A * &H10000))

                End Select

                ' Horizontal timing
                outportd(Mach64_portbase + mach64_regs.CRTC_H_TOTAL_DISP, ((816/8)-1) + &H10000 * ((640/8)-1) )
                outportd(Mach64_portbase + mach64_regs.CRTC_H_SYNC_STRT_WID, ((640/8+48/8)-1) + &H10000 * ((96/8)-1) )

                ' Vertical timing (524 lines)
                outportd(Mach64_portbase + mach64_regs.CRTC_V_TOTAL_DISP, (524-1) + &H10000 * (480-1) )
                outportd(Mach64_portbase + mach64_regs.CRTC_V_SYNC_STRT_WID, (480+11-1) + &H10000 * (2-1) )

                ' interrupt stuffs
                outportd(Mach64_portbase + mach64_regs.CRTC_VLINE_CRNT_VLINE, (480+11-1) + &H10000 * 0)
            
                ' virtual width and offset
                outportd(Mach64_portbase + mach64_regs.CRTC_OFF_PITCH, &H400000 * 80) ' virtual width = 640 pixels, offset = 0
            
                ' overscan
                outportd(Mach64_portbase + mach64_regs.OVR_WID_LEFT_RIGHT, &H10001)
                outportd(Mach64_portbase + mach64_regs.OVR_WID_TOP_BOTTOM, &H80008)
            
                ' DAC
                outportb(Mach64_portbase + mach64_regs.DAC_MASK, &HFF)
                outportd(Mach64_portbase + mach64_regs.DAC_CNTL, dacctl)

                ' enable CRTC
                outportd(Mach64_portbase + mach64_regs.CRTC_GEN_CNTL, prevvalue)

                socket(index).enabled = 1
            Else
                outportd(Mach64_portbase + mach64_regs.CRTC_GEN_CNTL, prevvalue and (not Mach64_crtc_gen_cntl.CRTC_EN) )
                socket(index).enabled = 0
            End If

        Case GFX_PROP_INPUT
            If value < 0 Then Exit Function
            If value > 2 Then Exit Function
            If socket(index).enabled > 0 Then Exit Function
            socket(index).input = value

        ' Todo: Check all settings for sanity

        Case GFX_PROP_WIDTH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).width = value

        Case GFX_PROP_HEIGHT
            If socket(index).enabled > 0 Then Exit Function
            socket(index).height = value

        Case GFX_PROP_VGA_H_FRONT_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_r = value - (value mod 8) - socket(index).os_r

        Case GFX_PROP_VGA_H_BACK_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_l = value - (value Mod 8) - socket(index).os_l

        Case GFX_PROP_VGA_H_SYNC
            If socket(index).enabled > 0 Then Exit Function
            socket(index).h_sync = value - (value Mod 8)

        Case GFX_PROP_VGA_V_FRONT_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_b = value - socket(index).os_b

        case GFX_PROP_VGA_V_BACK_PORCH
            If socket(index).enabled > 0 Then Exit Function
            socket(index).blank_t = value - socket(index).os_t

        case GFX_PROP_VGA_V_SYNC
            If socket(index).enabled > 0 Then Exit Function
            socket(index).v_sync = value

    End Select
End Function

Function Mach64_ConnectorGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
    Function = 0
    if index <> 0 Then exit function
    Select Case prop
        Case GFX_PROP_ENABLE
            Function = socket(index).enabled
        Case GFX_PROP_INPUT
            Function = socket(index).input
        Case GFX_PROP_WIDTH
            Function = socket(index).width
        Case GFX_PROP_HEIGHT
            Function = socket(index).height

        Case GFX_PROP_SIGNAL
            Function = GFX_SIGNAL_RGBHV
        Case GFX_PROP_CONNECTOR_TYPE
            Function = GFX_CONNECTOR_VGA
        Case Else
    End Select
End Function

Function Mach64_ConnectorGetRange CDecl (info As Byte Ptr, source As Integer, index As Integer, prop As Integer) As Integer
    if index = 0 Then
        Function = 1
        Select case prop
            Case GFX_PROP_ENABLE
                ConnectorReturnBooleanRange(source, index, prop, 0, 1)
            Case GFX_PROP_INPUT
                ConnectorReturnSimpleRange(source, index, prop, 0, 2, 1)
            Case GFX_PROP_WIDTH
                ConnectorReturnSimpleRange(source, index, prop, 320, 1024, 8)
            Case GFX_PROP_HEIGHT
                ConnectorReturnSimpleRange(source, index, prop, 240, 768, 8)
            Case GFX_PROP_SIGNAL
                ConnectorReturnConstantRange(source, index, prop, GFX_SIGNAL_RGBHV)
            Case GFX_PROP_CONNECTOR_TYPE
                ConnectorReturnConstantRange(source, index, prop, GFX_CONNECTOR_VGA)

            Case Else
                Function = 0
        End select
    Else
        Function = 0
    End If
End Function

