/**
 * Summary: umach_core.c
 * Mach64 graphics driver main entrypoints
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#define UDI_VERSION 0x101
#define UDI_GFX_VERSION 0x101
#define UDI_PHYSIO_VERSION 0x101
#define UDI_PCI_VERSION 0x101
#include <udi.h>
#include <udi_gfx.h>
#include <udi_physio.h>
#include <udi_pci.h>
#include "umach_common.h"

int sprintf(char *, const char *, ...);

void bochs_puts(const char *);

static void mach64_gfx_bind_req_1(udi_cb_t *gcb, udi_pio_handle_t new_pio_handle);
static void mach64_gfx_bind_req_2(udi_cb_t *gcb, udi_buf_t *new_buf, udi_status_t status, udi_ubit16_t result);
static void mach64_gfx_bind_req_3(udi_cb_t *gcb, udi_pio_handle_t new_pio_handle);
static void mach64_gfx_bind_req_4(udi_cb_t *gcb, udi_buf_t *new_buf, udi_status_t status, udi_ubit16_t result);
static void mach64_gfx_bind_req_5(udi_cb_t *gcb, udi_pio_handle_t new_pio_handle);
static void mach64_gfx_bind_req_6(udi_cb_t *gcb, udi_buf_t *new_buf, udi_status_t status, udi_ubit16_t result);

udi_pio_trans_t trans_get_regs[] = 
        {{UDI_PIO_LOAD_IMM | 0, 1, 0x0000},                 // R0 = 0        
         {UDI_PIO_IN | UDI_PIO_SCRATCH | 0, 2, 0x00A0},     // [R0] = dword PIO(BUS_CTL)
         {UDI_PIO_LOAD_IMM | 0, 1, 0x0004},                 // R0 = 4        
         {UDI_PIO_IN | UDI_PIO_SCRATCH | 0, 2, 0x00AC},     // [R0] = dword PIO(EXT_MEM_CTL)
         {UDI_PIO_LOAD_IMM | 0, 1, 0x0008},                 // R0 = 8        
         {UDI_PIO_IN | UDI_PIO_SCRATCH | 0, 2, 0x00B0},     // [R0] = dword PIO(MEM_CTL)
         
         {UDI_PIO_LOAD_IMM | 1, 1, 2 << 2},                 // R1 = index 2, read
         {UDI_PIO_LOAD_IMM | 0, 1, 0x000C},                 // R0 = 12
         {UDI_PIO_LOAD_IMM | 2, 1, 0x000C},                 // R2 = 12
         
         {UDI_PIO_LABEL, 0, 1},
         {UDI_PIO_CSKIP | 2, 1, UDI_PIO_NZ},                // Skip...
         {UDI_PIO_END_IMM, 1, 0},                           //    if R2 zero, stop.         
         {UDI_PIO_OUT | UDI_PIO_DIRECT | 1, 0, 0x0091},     // PIO(CLOCK_CNTL_ADDR) = R1
         {UDI_PIO_IN | UDI_PIO_SCRATCH | 0, 0, 0x0092},     // [R0] = PIO(CLOCK_CNTL_DATA)
         {UDI_PIO_ADD_IMM | 0, 0, 1},                       // R0++
         {UDI_PIO_ADD_IMM | 1, 0, 1 << 2},                  // R1 points to next ADDR index
         {UDI_PIO_ADD_IMM | 2, 0, -1},                      // R2--
         {UDI_PIO_BRANCH, 0, 1}                             // goto L1
        };

udi_pio_trans_t trans_enable_aperture[] = 
        {{UDI_PIO_IN | UDI_PIO_DIRECT | 0, 2, 0x00A0},      // R0 = BUS_CTL
         {UDI_PIO_LOAD_IMM | 1, 1, 0x0010},                 // R1 = BUS_APER_REG_DIS
         {UDI_PIO_OR | 0, 2, 1},                            // R0 = BUS_CTL | BUS_APER_REG_DIS
         {UDI_PIO_OUT | UDI_PIO_DIRECT | 0, 2, 0x00A0},     // BUS_CTL = R0
         {UDI_PIO_END_IMM, 1, 0}
        };
        
udi_pio_trans_t trans_write_string[] = 
        {{UDI_PIO_LOAD_IMM | 0, 1, 0x0000},                 // R0 = 0
         {UDI_PIO_LOAD_IMM | 1, 1, 0x0000},                 // R1 = 0
         {UDI_PIO_LOAD_IMM | 7, 1, 0x1F00},                 // R7 = white on blue
         {UDI_PIO_LABEL, 0, 1},
         {UDI_PIO_LOAD | UDI_PIO_MEM | 0, 0, 2},            // R2 = byte [R0]
         {UDI_PIO_CSKIP | 2, 1, UDI_PIO_NZ},                // Skip...
         {UDI_PIO_END_IMM, 1, 0},                           //    if zero, stop.
         {UDI_PIO_OR | 2, 1, 7},                            // R2 |= R7
         {UDI_PIO_OUT_IND | 2, 1, 1},                       // word [R1] = R2
         {UDI_PIO_ADD_IMM | 0, 1, 1},                       // R0++
         {UDI_PIO_ADD_IMM | 1, 1, 8},                       // R1 += 8    ; mach64 memory goes in 64-bit chunks. For text that means Char-Attr-Font-5x unused
         {UDI_PIO_BRANCH, 0, 1}                             // goto L1
        };
        
void mach64_gfx_bind_req(udi_gfx_bind_cb_t * cb)
{
    udi_pio_map(&mach64_gfx_bind_req_1, UDI_GCB(cb), UDI_PCI_BAR_1, 0x000, 0x400, &(trans_enable_aperture[0]), 5, 0, 0, 0);
}

void mach64_gfx_bind_req_1(udi_cb_t *gcb, udi_pio_handle_t new_pio_handle)
{ 
    
    bochs_puts("[ > mach64_gfx_bind_req_1]");
    udi_pio_trans(&mach64_gfx_bind_req_2, gcb, new_pio_handle, 0, NULL, NULL);
}

void mach64_gfx_bind_req_2(udi_cb_t *gcb, udi_buf_t *new_buf, udi_status_t status, udi_ubit16_t result)
{
    udi_assert(new_buf == NULL);
    udi_assert(status == 0);
    udi_assert(result == 0);
    bochs_puts("[ > mach64_gfx_bind_req]");

    udi_pio_map(&mach64_gfx_bind_req_3, gcb, UDI_PCI_BAR_2, 0xC00, 0x400, &(trans_get_regs[0]), 18, 0, 0, 0);
    bochs_puts("[ < mach64_gfx_bind_req]");
}

void mach64_gfx_bind_req_3(udi_cb_t *gcb, udi_pio_handle_t new_pio_handle)
{
    bochs_puts("[ > mach64_gfx_bind_req_1]");
    udi_pio_trans(&mach64_gfx_bind_req_4, gcb, new_pio_handle, 0, NULL, NULL);
}

void mach64_gfx_bind_req_4(udi_cb_t *gcb, udi_buf_t *new_buf, udi_status_t status, udi_ubit16_t result)
{

    udi_assert(new_buf == NULL);
    udi_assert(status == 0);
    udi_assert(result == 0);
    bochs_puts("[ > mach64_gfx_bind_req_2]");

    udi_pio_map(&mach64_gfx_bind_req_5, gcb, UDI_PCI_BAR_0, 0, 4096, &(trans_write_string[0]), 12, 0, 0, 0);
}

void mach64_gfx_bind_req_5(udi_cb_t *gcb, udi_pio_handle_t new_pio_handle)
{
    bochs_puts("[ > mach64_gfx_bind_req_3]");
    char string[128];
    udi_ubit32_t * scratch = (udi_ubit32_t *)gcb->scratch;
    udi_ubit8_t * bscratch = (udi_ubit8_t *)gcb->scratch;
    sprintf(string, "Mach64 bus:0x%x emem 0x%x, mem 0x%x, pll %x %x %x %x", scratch[0], scratch[1], scratch[2], 
            (udi_ubit32_t)bscratch[12], (udi_ubit32_t)bscratch[13], (udi_ubit32_t)bscratch[14], (udi_ubit32_t)bscratch[15]);
    udi_pio_trans(&mach64_gfx_bind_req_6, gcb, new_pio_handle, 0, NULL, string);    
}

void mach64_gfx_bind_req_6(udi_cb_t *gcb, udi_buf_t *new_buf, udi_status_t status, udi_ubit16_t result)
{
    while (gcb) { } 
    
    bochs_puts("[ > mach64_gfx_bind_req_4]");
    udi_assert(status == UDI_OK);
    udi_assert(result == 0);
    udi_assert(new_buf == NULL);
    udi_gfx_bind_ack(UDI_MCB(gcb, udi_gfx_bind_cb_t), 1, 1, UDI_OK);
    bochs_puts("[ < mach64_gfx_bind_req_4]");
    
    // fool GCC noreturn warning
    while(status != 0x55) 
    { 
        status ^= 0x10;
    }
}

// UDI structures: metalanguage entry
const udi_gfx_provider_ops_t mach64_gfx_provider_ops = {
    NULL, //&mach64_channel_event_ind,
    &mach64_gfx_bind_req,
    NULL, //&mach64_gfx_unbind_req,
    NULL, //&mach64_gfx_set_connector_req,
    NULL, //&mach64_gfx_set_engine_req,
    NULL, //&mach64_gfx_get_connector_req,
    NULL, //&mach64_gfx_get_engine_req,
    NULL, //&mach64_gfx_range_connector_req,
    NULL, //&mach64_gfx_range_engine_req,
    NULL, 
    NULL, 
    NULL, 
    NULL,
    NULL, 
    NULL 
};

// meta init
#define GFX_OPS_IDX       1
// fixme: is this the correct way?
#define MACH64_GFX_META  1
static const udi_ops_init_t mach64_ops_init_list[] = {
    {
        // should be the bus driver metalanguage
        0,
        0,
        0,
        0,
        (udi_ops_vector_t *)(void*)&mach64_gfx_provider_ops,
        NULL   // todo: op_flags 
    },
    {
        GFX_OPS_IDX,                // todo: correct?
        MACH64_GFX_META,            // meta index [from udiprops.txt]
        UDI_GFX_PROVIDER_OPS_NUM,   // type of channel end
        0,                          // todo: no channel context
        (udi_ops_vector_t *)(void*)&mach64_gfx_provider_ops,
        NULL   // todo: op_flags 
    },
    {
        0,  /* Terminator */
        0,
        0,
        0,
        NULL,
        NULL
    }
};

const udi_init_t udi_init_info = 
{
    NULL,               // todo: primary init
    NULL,               // todo: secondary init
    mach64_ops_init_list,
    NULL,               // todo: cb init list
    NULL,               // todo: gcb_init_list
    NULL                // todo: cb_select_list
};

