
#define UDI_VERSION 0x101
#include <udi.h>
#include "udi_env.h"
#include "gfx_provider.h"
#include <mos/event.h>
#include <mos.h>
#include <x86.h>
#include <mos/driver.h>
#include <mos/drivercom.h>
#include "umach_common.h"

static unsigned char * vram = (unsigned char *)0xA0000;
static unsigned char * console = (unsigned char *)0xB8000;

void bochs_puts(const char * s);
void bochs_putu(uint32_t i);
static void bochs_putc(const char c);

static void bochs_putc(const char c)
{
    *console++ = c;
    *console++ = 5;
    outportb(0xE9, c);
}

void bochs_puts(const char * s)
{
    while (*s)
    {
        bochs_putc(*s);
        s++;
    }
}

void bochs_putu(uint32_t i)
{
    if (i == 0)
    {
        bochs_putc('0');
    }
    else
    {
        int j = i & 0xf;
        int k = i >> 4;
        if (k > 0) bochs_putu(k);
        const char * digits = "0123456789ABCDEF";
        bochs_putc(digits[j]);
    }
}

uint32_t proto_ids[] = {0x00030004, 0};

static int udi_reply_supports(void * custom, unsigned int sender, unsigned int bytes, unsigned char * data)
{
    bochs_puts("[incoming queryinterfaces]");
    if (data) { }
    if (bytes) { }
    
    int sendsize = 0;
    uint32_t * senddata = (uint32_t *) custom;
    uint32_t * counter = senddata;
    while (*counter)
    {
        counter++;
        sendsize++;
    }
    bochs_puts("[outgoing queryinterfaces]");
    drv_sendmessage(sender, sendsize * 4, (char *) senddata);
    
    return 0;
}

static int udi_error_event(unsigned int sender, unsigned int bytes, unsigned char * data)
{
    bochs_puts("[unknown message: ");
    bochs_putu(sender);
    bochs_puts("x");
    bochs_putu(bytes);
    bochs_puts(": ");
    for (int i = 0; i < bytes; i++)
    {
        bochs_putu(data[i]);
        bochs_puts(":");
    }
    
    return 1;
}

int main(void)
{
    
    allocateiobitmap(0, 0xE000, (void *) -1);
    portalloc(0xCF8, 8);
    portalloc(0xE8, 4);
    
    blockallocphys(32, vram, vram);
    
    int devno = DriverInit();
    drv_setname(0,1);
    
    bochs_putu(0xabcd1234);
    
    bochs_puts(" - udimain.c\r\n [");    
    mos_region_t * region = _mos_region_enter();
    bochs_puts("region");
        
    // register PIO ranges
    _udi_init_pci(devno);
            
    // register incoming events
    //MOS_EVENTHANDLER * queryhandler = mos_eventhandles->sys_trees[1].handles;    
    //queryhandler->data = proto_ids;
    //queryhandler->callback = &udi_reply_supports;
    mos_resize_insert(mos_eventhandles, 0x00010000, &udi_reply_supports, proto_ids);
    mos_eventhandles->errorhandler = &udi_error_event;
    bochs_puts(" queryhandler");
    
    // register metalanguage
    udienv_register_gfx_provider(mos_eventhandles, &mach64_gfx_provider_ops, region);
    bochs_puts(" register_gfx");
    
    
    
    // initialisation complete
    int initok_msg[2] = {7, devno};
    drv_sendmessage(0x00010000 + 0, 8, (char *) &(initok_msg[0]) );
    bochs_puts(" UDI live]\r\n");
    
        
    mos_eventloop();
    
    udi_assert(1 == 0);
}

