/* Summary: opcode_lfb.c
 * Contains opcode maps for various linear framebuffer mode
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Educational Purposes>
 */

#define UDI_GFX_VERSION 0x101
#define UDI_VERSION 0x101
#include <udi_gfx.h>
#include "opcodetool.h"

static const int gfx_opcode_b8g8r8x8[40] =
    {UDI_GFX_OPERATOR_RGB,    1,  2,  3,
     UDI_GFX_OPERATOR_SEG,    4, 16,  8,
     UDI_GFX_OPERATOR_SEG,    4,  8,  8,
     UDI_GFX_OPERATOR_SEG,    4,  0,  8,
     UDI_GFX_OPERATOR_BUFFER, 5,  6, 32,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_CUSTOM + 0, 0,
     UDI_GFX_OPERATOR_MAD,    7,  8,  9,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_SOURCE_WIDTH, 0,
     UDI_GFX_OPERATOR_Y,      0,  0,  0,
     UDI_GFX_OPERATOR_X,      0,  0,  0};
     
const UDIOpcodeMap opcodemap_b8g8r8x8 = {10, gfx_opcode_b8g8r8x8};

static const int gfx_opcode_r8g8b8x8[40] =
    {UDI_GFX_OPERATOR_RGB,    1,  2,  3,
     UDI_GFX_OPERATOR_SEG,    4,  0,  8,
     UDI_GFX_OPERATOR_SEG,    4,  8,  8,
     UDI_GFX_OPERATOR_SEG,    4, 16,  8,
     UDI_GFX_OPERATOR_BUFFER, 5,  6, 32,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_CUSTOM + 0, 0,
     UDI_GFX_OPERATOR_MAD,    7,  8,  9,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_SOURCE_WIDTH, 0,
     UDI_GFX_OPERATOR_Y,      0,  0,  0,
     UDI_GFX_OPERATOR_X,      0,  0,  0};

const UDIOpcodeMap opcodemap_r8g8b8x8 = {10, gfx_opcode_r8g8b8x8};

static const int gfx_opcode_b8g8r8[40] =
    {UDI_GFX_OPERATOR_RGB,    1,  2,  3,
     UDI_GFX_OPERATOR_SEG,    4, 16,  8,
     UDI_GFX_OPERATOR_SEG,    4,  8,  8,
     UDI_GFX_OPERATOR_SEG,    4,  0,  8,
     UDI_GFX_OPERATOR_BUFFER, 5,  6, 24,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_CUSTOM + 0, 0,
     UDI_GFX_OPERATOR_MAD,    7,  8,  9,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_SOURCE_WIDTH, 0,
     UDI_GFX_OPERATOR_Y,      0,  0,  0,
     UDI_GFX_OPERATOR_X,      0,  0,  0};
     
const UDIOpcodeMap opcodemap_b8g8r8 = {10, gfx_opcode_b8g8r8};

static const int gfx_opcode_r8g8b8[40] =
    {UDI_GFX_OPERATOR_RGB,    1,  2,  3,
     UDI_GFX_OPERATOR_SEG,    4,  0,  8,
     UDI_GFX_OPERATOR_SEG,    4,  8,  8,
     UDI_GFX_OPERATOR_SEG,    4, 16,  8,
     UDI_GFX_OPERATOR_BUFFER, 5,  6, 24,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_CUSTOM + 0, 0,
     UDI_GFX_OPERATOR_MAD,    7,  8,  9,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_SOURCE_WIDTH, 0,
     UDI_GFX_OPERATOR_Y,      0,  0,  0,
     UDI_GFX_OPERATOR_X,      0,  0,  0};

const UDIOpcodeMap opcodemap_r8g8b8 = {10, gfx_opcode_r8g8b8};

static const int gfx_opcode_b5g6r5[64] =
    {UDI_GFX_OPERATOR_RGB,    5,  3,  1,
     UDI_GFX_OPERATOR_FRC,    2, 13, 15,
     UDI_GFX_OPERATOR_SEG,    7,  0,  5,
     UDI_GFX_OPERATOR_FRC,    4, 13, 14,
     UDI_GFX_OPERATOR_SEG,    7,  5,  6,
     UDI_GFX_OPERATOR_FRC,    6, 13, 15,
     UDI_GFX_OPERATOR_SEG,    7, 11,  5,
     UDI_GFX_OPERATOR_BUFFER, 8,  9, 16,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_CUSTOM + 0, 0,
     UDI_GFX_OPERATOR_MAD,   10, 11, 12,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_SOURCE_WIDTH, 0,
     UDI_GFX_OPERATOR_Y,      0,  0,  0,
     UDI_GFX_OPERATOR_X,      0,  0,  0,
     UDI_GFX_OPERATOR_CONST,255,  0,  0,
     UDI_GFX_OPERATOR_CONST, 63,  0,  0,
     UDI_GFX_OPERATOR_CONST, 31,  0,  0};
     
const UDIOpcodeMap opcodemap_b5g6r5 = {16, gfx_opcode_b5g6r5};

static const int gfx_opcode_b5g5r5[60] =
    {UDI_GFX_OPERATOR_RGB,    5,  3,  1,
     UDI_GFX_OPERATOR_FRC,    2, 13, 14,
     UDI_GFX_OPERATOR_SEG,    7,  0,  5,
     UDI_GFX_OPERATOR_FRC,    4, 13, 14,
     UDI_GFX_OPERATOR_SEG,    7,  5,  6,
     UDI_GFX_OPERATOR_FRC,    6, 13, 14,
     UDI_GFX_OPERATOR_SEG,    7, 11,  5,
     UDI_GFX_OPERATOR_BUFFER, 8,  9, 16,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_CUSTOM + 0, 0,
     UDI_GFX_OPERATOR_MAD,   10, 11, 12,
     UDI_GFX_OPERATOR_ATTR,   0, UDI_GFX_PROP_SOURCE_WIDTH, 0,
     UDI_GFX_OPERATOR_Y,      0,  0,  0,
     UDI_GFX_OPERATOR_X,      0,  0,  0,
     UDI_GFX_OPERATOR_CONST,255,  0,  0,
     UDI_GFX_OPERATOR_CONST, 31,  0,  0};
     
const UDIOpcodeMap opcodemap_b5g5r5 = {15, gfx_opcode_b5g5r5};
