/* Summary: opcode_tool.h
 * Contains read functionality for opcode maps
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Educational Purposes>
 */

#define UDI_GFX_VERSION 0x101
#define UDI_VERSION 0x101
#include <udi_gfx.h>
#include "opcodetool.h"

int readopcodemap(const UDIOpcodeMap * map, int prop, int index)
{
    if (index < 0) return 0;
    if (index >= map->opcodes) return 0;

    switch (prop)
    {
        case UDI_GFX_PROP_OPERATOR_INDEX:
            return index;
        case UDI_GFX_PROP_OPERATOR_OPCODE:
            return map->opcodelist[4*index + 0];
        case UDI_GFX_PROP_OPERATOR_ARG_1:
            return map->opcodelist[4*index + 1];
        case UDI_GFX_PROP_OPERATOR_ARG_2:
            return map->opcodelist[4*index + 2];
        case UDI_GFX_PROP_OPERATOR_ARG_3:
            return map->opcodelist[4*index + 3];
        default:
            return 0;
    }
}

void readopcodemaprange(const UDIOpcodeMap * map, int prop, int index, int * start, int * end)
{
    if (!start) return;
    if (!end) return;

    *start = 0;
    *end = 0;

    if (index < 0) return;
    if (index >= map->opcodes) return;

    switch (prop)
    {
        case UDI_GFX_PROP_OPERATOR_INDEX:
            *start = 0;
            *end = map->opcodes - 1;
            break;
            
        case UDI_GFX_PROP_OPERATOR_OPCODE:
        case UDI_GFX_PROP_OPERATOR_ARG_1:
        case UDI_GFX_PROP_OPERATOR_ARG_2:
        case UDI_GFX_PROP_OPERATOR_ARG_3:
            *start = readopcodemap(map, prop, index);
            *end = *start;
            break;
		default:
			return;
    }
}
