/* Summary: opcodetool.h
 * Defines utilities for implementing the UDI opcode maps
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Educational Purposes>
 *
 *
 * Note that all default opcode sets expect custom properties to be
 * assigned to the following offsets relative to the start of the custom
 * property set:
 *    +0 - (current) framebuffer
 *    +1 - (current) palette
 *
 * If there are more buffers/patterns involved in rendering, then these
 * opcodes do not suffice and need to be customized, in which case the
 * mapping to properties can be adapted as well.
 */

#define CUSTOM_GFX_PROP_FRAMEBUFFER 1024
#define CUSTOM_GFX_PROP_PALETTE 1025

typedef struct UDIOpcodeMap
{
    int opcodes;
    const int * opcodelist;
} UDIOpcodeMap;

extern const UDIOpcodeMap opcodemap_r8g8b8x8;
extern const UDIOpcodeMap opcodemap_b8g8r8x8;
extern const UDIOpcodeMap opcodemap_r8g8b8;
extern const UDIOpcodeMap opcodemap_b8g8r8;
extern const UDIOpcodeMap opcodemap_b5g6r5;
extern const UDIOpcodeMap opcodemap_b5g5r5;


int readopcodemap(const UDIOpcodeMap * map, int prop, int index);
void readopcodemaprange(const UDIOpcodeMap * map, int prop, int index, int * start, int * end);


